/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protege.action;

import edu.stanford.smi.protege.action.ExportToCsvUtil;
import edu.stanford.smi.protege.model.Cls;
import edu.stanford.smi.protege.model.Frame;
import edu.stanford.smi.protege.model.Instance;
import edu.stanford.smi.protege.model.KnowledgeBase;
import edu.stanford.smi.protege.model.Slot;
import edu.stanford.smi.protege.resource.Icons;
import edu.stanford.smi.protege.server.metaproject.Operation;
import edu.stanford.smi.protege.server.metaproject.impl.UnbackedOperationImpl;
import edu.stanford.smi.protege.ui.ExportConfigurationPanel;
import edu.stanford.smi.protege.ui.ProjectManager;
import edu.stanford.smi.protege.util.FileUtilities;
import edu.stanford.smi.protege.util.FrameWithBrowserText;
import edu.stanford.smi.protege.util.Log;
import edu.stanford.smi.protege.util.ModalDialog;
import edu.stanford.smi.protege.util.StandardAction;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.io.BufferedWriter;
import java.io.File;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.logging.Level;
import javax.swing.Icon;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExportToCsvAction
extends StandardAction {
    private static final long serialVersionUID = 8536785619825508769L;
    public static final Operation EXPORT_TO_CSV_OPERATION = new UnbackedOperationImpl("ExportToCSV", null);
    private static final char NEW_LINE = '\n';
    private static final char QUOTE_CHAR = '\"';
    private KnowledgeBase kb;
    private Collection<Instance> instancesToExport = new ArrayList<Instance>();
    private File exportFile;
    private Collection<Slot> slotsToExport = new ArrayList<Slot>();
    private String exportMetadataText;
    private boolean exportHeader;
    private boolean exportTypes;
    private boolean exportMetadata;
    private boolean exportSuperclass;
    private boolean exportCompletedSuccessul = false;
    private ExportConfigurationPanel exportConfigurationPanel;

    public ExportToCsvAction(KnowledgeBase knowledgeBase) {
        this(knowledgeBase, "Export Slot Values to file", Icons.getQueryExportIcon());
    }

    protected ExportToCsvAction(KnowledgeBase knowledgeBase, String string, Icon icon) {
        super(string, icon);
        this.kb = knowledgeBase;
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        this.exportCompletedSuccessul = false;
        this.exportConfigurationPanel = this.getExportConfigurationPanel();
        this.exportConfigurationPanel.setPossibleSlots(this.getSlotsToExport());
        this.exportConfigurationPanel.setExportMetadata(this.exportMetadataText);
        this.exportConfigurationPanel.setInitialExportClasses(this.getInitialExportClses());
        int n = ModalDialog.showDialog(this.getParentComponent(), this.exportConfigurationPanel.getConfigPanel(), "Export configuration", 11);
        if (n == 4) {
            return;
        }
        this.exportFile = this.exportConfigurationPanel.getExportedFile();
        this.slotsToExport = this.exportConfigurationPanel.getExportedSlots();
        this.exportHeader = this.exportConfigurationPanel.isExportHeaderEnabled();
        this.exportTypes = this.exportConfigurationPanel.isExportTypesEnabled();
        this.exportSuperclass = this.exportConfigurationPanel.isExportSuperclassEnabled();
        this.exportMetadata = this.exportConfigurationPanel.isExportMetadataEnabled();
        this.setSlotsDelimiter(this.exportConfigurationPanel.getSlotDelimiter());
        this.setSlotValuesDelimiter(this.exportConfigurationPanel.getSlotValuesDelimiter());
        this.setExportBrowserText(this.exportConfigurationPanel.isExportBrowserTextEnabled());
        this.setExportMetadata(this.exportConfigurationPanel.isExportMetadataEnabled());
        this.setExportSuperclass(this.exportConfigurationPanel.isExportSuperclassEnabled());
        this.setExportMetadata(this.exportConfigurationPanel.getExportMetadataText());
        this.exportCompletedSuccessul = this.export();
        String string = this.exportCompletedSuccessul ? "Query results exported successfully to:\n" + this.exportFile.getAbsolutePath() : "There were errors at saving query results.\nPlease consult the console for more details.";
        ModalDialog.showMessageDialog(this.getParentComponent(), string, this.exportCompletedSuccessul ? "Export successful" : "Errors at export");
    }

    public boolean export() {
        boolean bl = false;
        try {
            BufferedWriter bufferedWriter = FileUtilities.createBufferedWriter(this.exportFile);
            if (bufferedWriter == null) {
                Log.getLogger().log(Level.WARNING, "Unable to open output file " + this.exportFile + ".");
            } else {
                this.printResults(bufferedWriter, this.getInstancesToExport(), this.slotsToExport);
                bl = true;
            }
        }
        catch (Exception exception) {
            Log.getLogger().log(Level.WARNING, "Errors at writing out query results file " + this.exportFile + ".", exception);
        }
        return bl;
    }

    protected void printResults(Writer writer, Collection<Instance> collection, Collection<Slot> collection2) {
        PrintWriter printWriter = new PrintWriter(writer);
        if (this.exportHeader) {
            this.printHeader(printWriter, collection2);
        }
        for (Instance instance : collection) {
            this.printInstance(printWriter, instance);
        }
        if (this.exportMetadata) {
            this.printMetadata(printWriter);
        }
        printWriter.close();
    }

    private void printMetadata(PrintWriter printWriter) {
        if (this.exportMetadataText == null || this.exportMetadataText.length() == 0) {
            return;
        }
        printWriter.println();
        printWriter.println();
        printWriter.println(this.getQuotedValule(this.exportMetadataText));
    }

    protected void printHeader(PrintWriter printWriter, Collection<Slot> collection) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("Instance");
        stringBuffer.append(this.getSlotsDelimiter());
        if (this.exportTypes) {
            stringBuffer.append("Type(s)");
            stringBuffer.append(this.getSlotsDelimiter());
        }
        if (this.exportSuperclass) {
            stringBuffer.append("Superclass(es)");
            stringBuffer.append(this.getSlotsDelimiter());
        }
        Iterator<Slot> iterator = collection.iterator();
        while (iterator.hasNext()) {
            Slot slot;
            Slot slot2 = slot = iterator.next();
            stringBuffer.append(this.getExportName(slot2));
            stringBuffer.append(this.getSlotsDelimiter());
        }
        printWriter.println(stringBuffer.toString());
    }

    protected void printInstance(PrintWriter printWriter, Instance instance) {
        Iterator<Cls> iterator;
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.getExportName(instance));
        if (this.exportTypes) {
            stringBuffer.append(ExportToCsvUtil.getSlotsDelimiter());
            iterator = instance.getDirectTypes();
            Iterator object2 = iterator.iterator();
            while (object2.hasNext()) {
                Cls cls = (Cls)object2.next();
                stringBuffer.append(this.getExportName(cls));
                if (!object2.hasNext()) continue;
                stringBuffer.append(this.getSlotValuesDelimiter());
            }
        }
        if (this.exportSuperclass) {
            stringBuffer.append(ExportToCsvUtil.getSlotsDelimiter());
            iterator = this.getSuperclassesToExport(instance).iterator();
            while (iterator.hasNext()) {
                Cls cls = iterator.next();
                stringBuffer.append(this.getExportName(cls));
                if (!iterator.hasNext()) continue;
                stringBuffer.append(this.getSlotValuesDelimiter());
            }
        }
        if (!this.slotsToExport.isEmpty()) {
            for (Slot slot : this.slotsToExport) {
                stringBuffer.append(this.getSlotsDelimiter());
                stringBuffer.append(this.getSlotValuesExportString(instance, slot));
            }
        }
        printWriter.println(stringBuffer.toString());
    }

    protected String getSlotValuesExportString(Instance instance, Slot slot) {
        StringBuffer stringBuffer = new StringBuffer();
        Collection collection = instance.getOwnSlotValues(slot);
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            Object e = iterator.next();
            if (e instanceof Frame) {
                Frame frame = (Frame)e;
                stringBuffer.append(this.getExportName(frame));
            } else {
                stringBuffer.append(this.getExportDataValueName(e));
            }
            if (!iterator.hasNext()) continue;
            stringBuffer.append(this.getSlotValuesDelimiter());
        }
        return this.getQuotedValule(stringBuffer.toString());
    }

    protected String getQuotedValule(String string) {
        if (string == null || string.length() == 0) {
            return string;
        }
        StringBuffer stringBuffer = new StringBuffer(string);
        for (int i = 0; i < stringBuffer.length(); ++i) {
            if (stringBuffer.charAt(i) != '\"') continue;
            stringBuffer.insert(i, '\"');
            ++i;
        }
        stringBuffer.insert(0, '\"');
        stringBuffer.insert(stringBuffer.length(), '\"');
        return stringBuffer.toString();
    }

    protected String getExportName(Frame frame) {
        return this.getQuotedValule(this.isExportBrowserTextEnabled() ? frame.getBrowserText() : frame.getName());
    }

    protected String getExportDataValueName(Object object) {
        return object.toString();
    }

    protected ExportConfigurationPanel getExportConfigurationPanel() {
        if (this.exportConfigurationPanel != null) {
            return this.exportConfigurationPanel;
        }
        this.exportConfigurationPanel = new ExportConfigurationPanel(this.kb);
        return this.exportConfigurationPanel;
    }

    protected Collection<Cls> getSuperclassesToExport(Instance instance) {
        ArrayList<Cls> arrayList = new ArrayList<Cls>();
        if (!(instance instanceof Cls)) {
            return arrayList;
        }
        Cls cls = (Cls)instance;
        return cls.getDirectSuperclasses();
    }

    protected Component getParentComponent() {
        return ProjectManager.getProjectManager().getCurrentProjectView();
    }

    protected Collection<Cls> getInitialExportClses() {
        return new ArrayList<Cls>();
    }

    public KnowledgeBase getKnowledgeBase() {
        return this.kb;
    }

    public Collection<Instance> getInstancesToExport() {
        return this.instancesToExport;
    }

    public void setInstancesToExport(Collection<Instance> collection) {
        this.instancesToExport = collection;
    }

    public void setFramesWithBrowserTextToExport(Collection<FrameWithBrowserText> collection) {
        this.instancesToExport = new ArrayList<Instance>();
        for (FrameWithBrowserText frameWithBrowserText : collection) {
            Frame frame = frameWithBrowserText.getFrame();
            if (!(frame instanceof Instance)) continue;
            this.instancesToExport.add((Instance)frame);
        }
    }

    public File getExportFile() {
        return this.exportFile;
    }

    public void setExportFile(File file) {
        this.exportFile = file;
    }

    public Collection<Slot> getSlotsToExport() {
        return this.slotsToExport;
    }

    public void setSlotsToExport(Collection<Slot> collection) {
        this.slotsToExport = collection;
    }

    public void setExportMetadata(String string) {
        this.exportMetadataText = string;
    }

    public String getExportMetadata() {
        return this.exportMetadataText;
    }

    public boolean isExportHeader() {
        return this.exportHeader;
    }

    public void setExportHeader(boolean bl) {
        this.exportHeader = bl;
    }

    public boolean isExportTypes() {
        return this.exportTypes;
    }

    public void setExportTypes(boolean bl) {
        this.exportTypes = bl;
    }

    public boolean isExportMetadata() {
        return this.exportMetadata;
    }

    public void setExportMetadata(boolean bl) {
        this.exportMetadata = bl;
        ExportToCsvUtil.setExportMetadata(bl);
    }

    public void setExportSuperclass(boolean bl) {
        this.exportSuperclass = bl;
        ExportToCsvUtil.setExportSuperclass(bl);
    }

    public boolean isExportSuperclass() {
        return this.exportSuperclass;
    }

    public String getSlotValuesDelimiter() {
        return ExportToCsvUtil.getSlotValuesDelimiter();
    }

    public void setSlotValuesDelimiter(String string) {
        ExportToCsvUtil.setSlotValuesDelimiter(string);
    }

    public String getSlotsDelimiter() {
        return ExportToCsvUtil.getSlotsDelimiter();
    }

    public void setSlotsDelimiter(String string) {
        ExportToCsvUtil.setSlotsDelimiter(string);
    }

    public boolean isExportBrowserTextEnabled() {
        return ExportToCsvUtil.isExportBrowserTextEnabled();
    }

    public void setExportBrowserText(boolean bl) {
        ExportToCsvUtil.setExportBrowserText(bl);
    }

    public boolean exportCompletedSuccessful() {
        return this.exportCompletedSuccessul;
    }
}

