/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protege.code.generator.wrapping;

import edu.stanford.smi.protege.code.generator.wrapping.AbstractWrappedInstance;
import edu.stanford.smi.protege.model.Cls;
import edu.stanford.smi.protege.model.Instance;
import edu.stanford.smi.protege.model.KnowledgeBase;
import edu.stanford.smi.protege.util.Log;
import java.lang.reflect.Constructor;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OntologyJavaMappingUtil {
    private static final Class<?>[] CONSTRUCTOR_PARAMETERS = new Class[]{Instance.class};
    private static Map<String, Entry> ontologyClassNameMap = new HashMap<String, Entry>();
    private static Map<Class<?>, Entry> interfaceMap = new HashMap();
    private static Map<Class<?>, Entry> implementationMap = new HashMap();

    public static void add(String string, Class<?> clazz, Class<?> clazz2) {
        Entry entry = new Entry(string, clazz, clazz2);
        ontologyClassNameMap.put(string, entry);
        interfaceMap.put(clazz, entry);
        implementationMap.put(clazz2, entry);
    }

    public static <X> X createObjectAs(KnowledgeBase knowledgeBase, String string, Class<? extends X> clazz) {
        if (string != null && knowledgeBase.getInstance(string) != null) {
            return null;
        }
        Entry entry = interfaceMap.get(clazz);
        if (entry == null) {
            return null;
        }
        String string2 = entry.getOntologyClassName();
        Cls cls = knowledgeBase.getCls(string2);
        Instance instance = cls.createDirectInstance(string);
        return OntologyJavaMappingUtil.createJavaObject(OntologyJavaMappingUtil.getJavaImplementation(entry.getJavaImplementation(), clazz), instance);
    }

    public static <X> X createObject(KnowledgeBase knowledgeBase, String string, String string2, Class<? extends X> clazz) {
        if (string != null && knowledgeBase.getFrame(string) != null) {
            return null;
        }
        Cls cls = knowledgeBase.getCls(string2);
        if (cls == null) {
            return null;
        }
        String string3 = clazz.getSimpleName();
        Cls cls2 = knowledgeBase.getCls(string3);
        if (string3 == null) {
            return null;
        }
        if (!cls.equals(string3) && !cls.hasSuperclass(cls2)) {
            return null;
        }
        Entry entry = ontologyClassNameMap.get(string2);
        if (entry != null) {
            return OntologyJavaMappingUtil.createJavaObject(OntologyJavaMappingUtil.getJavaImplementation(entry.getJavaImplementation(), clazz), cls.createDirectInstance(string));
        }
        for (Cls cls3 : cls.getSuperclasses()) {
            Entry entry2 = ontologyClassNameMap.get(cls3.getName());
            if (entry2 == null) continue;
            Instance instance = cls.createDirectInstance(string);
            return OntologyJavaMappingUtil.createJavaObject(OntologyJavaMappingUtil.getJavaImplementation(entry2.getJavaImplementation(), clazz), instance);
        }
        return null;
    }

    private static <X> X createJavaObject(Class<? extends X> clazz, Instance instance) {
        if (clazz == null || instance == null) {
            return null;
        }
        X x = null;
        try {
            Constructor<X> constructor = clazz.getConstructor(CONSTRUCTOR_PARAMETERS);
            x = constructor.newInstance(instance);
        }
        catch (Exception exception) {
            Log.getLogger().log(Level.SEVERE, "Creating Java Object failed. (Java Impl Class: " + clazz + ", Wrapped Protege instance: " + instance + ")", exception);
        }
        return x;
    }

    public static <X> X getJavaObjectAs(KnowledgeBase knowledgeBase, String string, Class<? extends X> clazz) {
        Instance instance = knowledgeBase.getInstance(string);
        if (instance == null) {
            return null;
        }
        Entry entry = interfaceMap.get(clazz);
        if (entry == null) {
            return null;
        }
        return OntologyJavaMappingUtil.createJavaObject(OntologyJavaMappingUtil.getJavaImplementation(entry.getJavaImplementation(), clazz), instance);
    }

    public static <X> X getSpecificObject(KnowledgeBase knowledgeBase, Instance instance, Class<? extends X> clazz) {
        if (instance == null) {
            return null;
        }
        Class<?> clazz2 = OntologyJavaMappingUtil.getJavaImplementation(instance.getDirectType());
        if (clazz2 == null) {
            return null;
        }
        return OntologyJavaMappingUtil.createJavaObject(OntologyJavaMappingUtil.getJavaImplementation(clazz2, clazz), instance);
    }

    public static boolean canAs(Object object, Class<?> clazz) {
        if (clazz.isAssignableFrom(object.getClass())) {
            return true;
        }
        if (!(object instanceof AbstractWrappedInstance)) {
            return false;
        }
        Instance instance = ((AbstractWrappedInstance)object).getWrappedProtegeInstance();
        Class<?> clazz2 = OntologyJavaMappingUtil.getJavaImplementation(instance.getDirectType());
        if (clazz2 == null) {
            return false;
        }
        return clazz.isAssignableFrom(clazz2);
    }

    public static <X> X as(Object object, Class<? extends X> clazz) {
        if (clazz.isAssignableFrom(object.getClass())) {
            return clazz.cast(object);
        }
        if (!(object instanceof AbstractWrappedInstance)) {
            return null;
        }
        Instance instance = ((AbstractWrappedInstance)object).getWrappedProtegeInstance();
        return OntologyJavaMappingUtil.getSpecificObject(instance.getKnowledgeBase(), instance, clazz);
    }

    private static Class<?> getJavaImplementation(Cls cls) {
        if (cls == null) {
            return null;
        }
        Entry entry = ontologyClassNameMap.get(cls.getName());
        if (entry != null) {
            return entry.getJavaImplementation();
        }
        for (Cls cls2 : cls.getSuperclasses()) {
            Entry entry2 = ontologyClassNameMap.get(cls2.getName());
            if (entry2 == null) continue;
            return entry2.getJavaImplementation();
        }
        return null;
    }

    private static <X> Class<X> getJavaImplementation(Class<?> clazz, Class<? extends X> clazz2) {
        return clazz2.isAssignableFrom(clazz) ? clazz : null;
    }

    public static void dispose() {
        implementationMap.clear();
        interfaceMap.clear();
        ontologyClassNameMap.clear();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class Entry {
        private String ontologyClassName;
        private Class<?> javaInterface;
        private Class<?> javaImplementation;

        public Entry(String string, Class<?> clazz, Class<?> clazz2) {
            this.ontologyClassName = string;
            this.javaInterface = clazz;
            this.javaImplementation = clazz2;
        }

        public String getOntologyClassName() {
            return this.ontologyClassName;
        }

        public Class<?> getJavaInterface() {
            return this.javaInterface;
        }

        public Class<?> getJavaImplementation() {
            return this.javaImplementation;
        }
    }
}

