/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protege.model;

import edu.stanford.smi.protege.event.FacetListener;
import edu.stanford.smi.protege.model.DefaultInstance;
import edu.stanford.smi.protege.model.Facet;
import edu.stanford.smi.protege.model.FacetConstraint;
import edu.stanford.smi.protege.model.Frame;
import edu.stanford.smi.protege.model.FrameID;
import edu.stanford.smi.protege.model.KnowledgeBase;
import edu.stanford.smi.protege.model.Slot;
import edu.stanford.smi.protege.model.ValueType;
import edu.stanford.smi.protege.resource.Icons;
import edu.stanford.smi.protege.util.CollectionUtilities;
import edu.stanford.smi.protege.util.Log;
import java.util.Collection;
import java.util.LinkedHashSet;
import javax.swing.Icon;

public class DefaultFacet
extends DefaultInstance
implements Facet {
    private static final long serialVersionUID = 1557703868805025229L;
    private FacetConstraint _constraint;

    public DefaultFacet(KnowledgeBase knowledgeBase, FrameID frameID) {
        super(knowledgeBase, frameID);
    }

    public DefaultFacet() {
    }

    public void addFacetListener(FacetListener facetListener) {
        this.getDefaultKnowledgeBase().addFacetListener(this, facetListener);
    }

    public boolean areValidValues(Frame frame, Slot slot, Collection collection) {
        boolean bl = true;
        if (this._constraint != null) {
            Collection collection2 = frame.getOwnSlotFacetValues(slot, this);
            bl = this._constraint.areValidValues(frame, slot, collection, collection2);
        }
        return bl;
    }

    public Slot getAssociatedSlot() {
        return this.getDefaultKnowledgeBase().getAssociatedSlot(this);
    }

    public FacetConstraint getConstraint() {
        return this._constraint;
    }

    public String getInvalidValuesText(Frame frame, Slot slot, Collection collection) {
        String string = null;
        if (this._constraint != null) {
            Collection collection2 = frame.getOwnSlotFacetValues(slot, this);
            string = this._constraint.getInvalidValuesText(frame, slot, collection, collection2);
        }
        return string;
    }

    public String getInvalidValueText(Frame frame, Slot slot, Object object) {
        String string = null;
        if (this._constraint != null) {
            Collection collection = frame.getOwnSlotFacetValues(slot, this);
            string = this._constraint.getInvalidValueText(frame, slot, object, collection);
        }
        return string;
    }

    public ValueType getValueType() {
        Slot slot = this.getAssociatedSlot();
        if (slot == null) {
            Log.getLogger().warning("Cannot find associated slot of " + this + ". Assuming value type is " + ValueType.ANY);
            return ValueType.ANY;
        }
        return slot.getValueType();
    }

    public boolean getAllowsMultipleValues() {
        Slot slot = this.getAssociatedSlot();
        if (slot == null) {
            Log.getLogger().warning("Cannot find associated slot of " + this + ". Assuming cardinality is multiple");
            return true;
        }
        return this.getAssociatedSlot().getAllowsMultipleValues();
    }

    public boolean isValidValue(Frame frame, Slot slot, Object object) {
        boolean bl = true;
        if (this._constraint != null) {
            Collection collection = frame.getOwnSlotFacetValues(slot, this);
            bl = this._constraint.isValidValue(frame, slot, object, collection);
        }
        return bl;
    }

    public void removeFacetListener(FacetListener facetListener) {
        this.getDefaultKnowledgeBase().removeFacetListener(this, facetListener);
    }

    public void setAssociatedSlot(Slot slot) {
        this.getDefaultKnowledgeBase().setAssociatedSlot(this, slot);
    }

    public void setConstraint(FacetConstraint facetConstraint) {
        this._constraint = facetConstraint;
    }

    public Collection resolveValues(Collection linkedHashSet, Collection collection) {
        LinkedHashSet linkedHashSet2;
        if (CollectionUtilities.equalsList(linkedHashSet, collection)) {
            linkedHashSet2 = linkedHashSet;
        } else if (this._constraint == null) {
            if (this.getAllowsMultipleValues()) {
                linkedHashSet2 = new LinkedHashSet();
                linkedHashSet2.addAll(linkedHashSet);
                linkedHashSet2.addAll(collection);
            } else {
                linkedHashSet2 = linkedHashSet;
            }
        } else {
            linkedHashSet2 = this._constraint.resolve(linkedHashSet, collection);
        }
        return linkedHashSet2;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("Facet(");
        stringBuffer.append(this.getName());
        stringBuffer.append(")");
        return stringBuffer.toString();
    }

    public Icon getIcon() {
        return Icons.getFacetIcon(!this.isEditable(), !this.isVisible());
    }

    public Facet rename(String string) {
        return (Facet)super.rename(string);
    }
}

