/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protege.model;

import edu.stanford.smi.protege.event.FrameListener;
import edu.stanford.smi.protege.model.Facet;
import edu.stanford.smi.protege.model.Frame;
import edu.stanford.smi.protege.model.FrameID;
import edu.stanford.smi.protege.model.KnowledgeBase;
import edu.stanford.smi.protege.model.Localizable;
import edu.stanford.smi.protege.model.Project;
import edu.stanford.smi.protege.model.Reference;
import edu.stanford.smi.protege.model.Slot;
import edu.stanford.smi.protege.model.ValueType;
import edu.stanford.smi.protege.util.Assert;
import edu.stanford.smi.protege.util.CollectionUtilities;
import edu.stanford.smi.protege.util.Log;
import edu.stanford.smi.protege.util.SystemUtilities;
import java.io.Serializable;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.swing.Icon;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class DefaultFrame
implements Frame,
Localizable,
Serializable {
    private static final long serialVersionUID = -894053746814542694L;
    private static final char SPECIAL_NAME_CHAR = ':';
    private transient KnowledgeBase knowledgeBase;
    private FrameID id;
    private static final int READONLY_MASK = 1;
    private static final int INCLUDED_MASK = 2;
    private static final int DELETING_MASK = 4;
    private static final int DELETED_MASK = 8;
    private int state;

    protected DefaultFrame() {
    }

    DefaultFrame(KnowledgeBase knowledgeBase, FrameID frameID) {
        if (frameID == null) {
            Log.getLogger().severe("null frame id");
        }
        this.knowledgeBase = knowledgeBase;
        this.id = frameID;
    }

    public URI getDefiningProjectURI() {
        return null;
    }

    @Override
    public FrameID getFrameID() {
        return this.id;
    }

    @Override
    public boolean isDeleted() {
        return this.getState(8);
    }

    @Override
    public void markDeleted(boolean bl) {
        this.setState(8, bl);
    }

    private void setState(int n, boolean bl) {
        this.state = bl ? (this.state |= n) : (this.state &= ~n);
    }

    private boolean getState(int n) {
        return (this.state & n) != 0;
    }

    @Override
    public boolean isBeingDeleted() {
        return this.getState(4);
    }

    @Override
    public void markDeleting() {
        this.setState(4, true);
    }

    @Override
    public boolean isValid() {
        return !this.isDeleted();
    }

    public boolean equals(Object object) {
        boolean bl = false;
        if (object instanceof DefaultFrame) {
            DefaultFrame defaultFrame = (DefaultFrame)object;
            bl = DefaultFrame.equals(this.id, defaultFrame.id) && this.knowledgeBase == defaultFrame.knowledgeBase;
        }
        return bl;
    }

    public final int hashCode() {
        return this.id.hashCode();
    }

    @Override
    public void addFrameListener(FrameListener frameListener) {
        this.getDefaultKnowledgeBase().addFrameListener(this, frameListener);
    }

    @Override
    public boolean addOwnFacetValue(Slot slot, Facet facet, Object object) {
        Assert.fail("not implemented");
        return false;
    }

    @Override
    public void addOwnSlotValue(Slot slot, Object object) {
        this.getDefaultKnowledgeBase().addOwnSlotValue(this, slot, object);
    }

    @Override
    public boolean areValidOwnSlotValues(Slot slot, Collection collection) {
        return this.getDefaultKnowledgeBase().areValidOwnSlotValues(this, slot, collection);
    }

    private static int compareStrings(String string, String string2) {
        int n;
        if (string != null && string.length() != 0 && string.charAt(0) == '\'') {
            string = string.substring(1);
        }
        if (string2 != null && string2.length() != 0 && string2.charAt(0) == '\'') {
            string2 = string2.substring(1);
        }
        if ((n = string.compareToIgnoreCase(string2)) == 0) {
            n = string.compareTo(string2);
        }
        return n;
    }

    @Override
    public int compareTo(Frame frame) {
        String string = this.getBrowserText();
        String string2 = frame.getBrowserText();
        int n = DefaultFrame.isSpecialName(string) ? (DefaultFrame.isSpecialName(string2) ? DefaultFrame.compareStrings(string, string2) : 1) : (DefaultFrame.isSpecialName(string2) ? -1 : DefaultFrame.compareStrings(string, string2));
        if (n == 0) {
            n = DefaultFrame.compareStrings(this.getName(), frame.getName());
        }
        return n;
    }

    private static boolean isSpecialName(String string) {
        return string.length() > 0 && string.charAt(0) == ':';
    }

    public static boolean equals(Object object, Object object2) {
        return SystemUtilities.equals(object, object2);
    }

    private static void deepCopyFrameBindingValues(Collection collection, Frame frame, Slot slot, Map map) {
        KnowledgeBase knowledgeBase = frame.getKnowledgeBase();
        ArrayList<Frame> arrayList = new ArrayList<Frame>();
        for (Frame frame2 : collection) {
            Frame frame3 = (Frame)map.get(frame2);
            if (frame3 == null) {
                frame3 = frame2.deepCopy(knowledgeBase, map);
            }
            arrayList.add(frame3);
        }
        frame.setOwnSlotValues(slot, arrayList);
    }

    private void copyOwnSlot(DefaultFrame defaultFrame, Slot slot, Map map, boolean bl) {
        Slot slot2 = (Slot)map.get(slot);
        Assert.assertNotNull("copy slot", slot2);
        this.copyOwnSlotValues(defaultFrame, slot2, slot, map, bl);
    }

    private void copyOwnSlots(DefaultFrame defaultFrame, Map map, boolean bl) {
        for (Slot slot : this.getDefaultKnowledgeBase().getOwnSlots(this)) {
            if (slot.isSystem()) continue;
            this.copyOwnSlot(defaultFrame, slot, map, bl);
        }
    }

    private void copyOwnSlotValues(Frame frame, Slot slot, Slot slot2, Map map, boolean bl) {
        ValueType valueType = this.getOwnSlotValueType(slot2);
        List list = this.getDirectOwnSlotValues(slot2);
        if (bl && (valueType == ValueType.INSTANCE || valueType == ValueType.CLS)) {
            DefaultFrame.deepCopyFrameBindingValues(list, frame, slot, map);
        } else {
            frame.setOwnSlotValues(slot, list);
        }
    }

    @Override
    public Frame copy(KnowledgeBase knowledgeBase, Map map, boolean bl) {
        Assert.assertNotNull("knowledge base", knowledgeBase);
        Assert.assertNotNull("value map", map);
        DefaultFrame defaultFrame = (DefaultFrame)map.get(this);
        Assert.assertNotNull(null, defaultFrame);
        this.copyOwnSlots(defaultFrame, map, bl);
        return defaultFrame;
    }

    @Override
    public void delete() {
        this.getDefaultKnowledgeBase().deleteFrame(this);
    }

    protected KnowledgeBase getDefaultKnowledgeBase() {
        return this.knowledgeBase;
    }

    @Override
    public Collection getDocumentation() {
        return this.getDefaultKnowledgeBase().getDocumentation(this);
    }

    @Override
    public String getInvalidOwnSlotValuesText(Slot slot, Collection collection) {
        return this.getDefaultKnowledgeBase().getInvalidOwnSlotValuesText(this, slot, collection);
    }

    @Override
    public String getInvalidOwnSlotValueText(Slot slot, Object object) {
        return this.getDefaultKnowledgeBase().getInvalidOwnSlotValueText(this, slot, object);
    }

    @Override
    public final KnowledgeBase getKnowledgeBase() {
        return this.knowledgeBase;
    }

    @Override
    public void localize(KnowledgeBase knowledgeBase) {
        this.knowledgeBase = knowledgeBase;
        this.id.localize(knowledgeBase);
    }

    @Override
    public String getName() {
        return this.getFrameID().getName();
    }

    @Override
    public boolean getOwnSlotAllowsMultipleValues(Slot slot) {
        return this.getDefaultKnowledgeBase().getOwnSlotAllowsMultipleValues(this, slot);
    }

    @Override
    public Collection getOwnSlotAndSubslotValues(Slot slot) {
        return this.getDefaultKnowledgeBase().getOwnSlotAndSubslotValues(this, slot);
    }

    @Override
    public Collection getOwnSlotDefaultValues(Slot slot) {
        return this.getDefaultKnowledgeBase().getOwnSlotDefaultValues(this, slot);
    }

    @Override
    public Collection getOwnSlotFacets(Slot slot) {
        return this.getDefaultKnowledgeBase().getOwnSlotFacets(this, slot);
    }

    @Override
    public Collection getOwnSlotFacetValues(Slot slot, Facet facet) {
        return this.getDefaultKnowledgeBase().getOwnSlotFacetValues(this, slot, facet);
    }

    @Override
    public Collection<Slot> getOwnSlots() {
        return this.getDefaultKnowledgeBase().getOwnSlots(this);
    }

    @Override
    public Object getDirectOwnSlotValue(Slot slot) {
        return this.getDefaultKnowledgeBase().getDirectOwnSlotValue(this, slot);
    }

    @Override
    public List getDirectOwnSlotValues(Slot slot) {
        return this.getDefaultKnowledgeBase().getDirectOwnSlotValues(this, slot);
    }

    @Override
    public Object getOwnSlotValue(Slot slot) {
        return this.getDefaultKnowledgeBase().getOwnSlotValue(this, slot);
    }

    @Override
    public int getOwnSlotValueCount(Slot slot) {
        return this.getDefaultKnowledgeBase().getOwnSlotValueCount(this, slot);
    }

    @Override
    public Collection getOwnSlotValues(Slot slot) {
        return this.getDefaultKnowledgeBase().getOwnSlotValues(this, slot);
    }

    @Override
    public ValueType getOwnSlotValueType(Slot slot) {
        return this.getDefaultKnowledgeBase().getOwnSlotValueType(this, slot);
    }

    @Override
    public Project getProject() {
        return this.knowledgeBase.getProject();
    }

    @Override
    public Collection<Reference> getReferences() {
        return this.getReferences(0);
    }

    @Override
    public Collection<Reference> getReferences(int n) {
        return this.getDefaultKnowledgeBase().getReferences(this, n);
    }

    @Override
    public boolean hasOwnSlot(Slot slot) {
        return this.getDefaultKnowledgeBase().hasOwnSlot(this, slot);
    }

    @Override
    public boolean isEditable() {
        return !this.getState(1) && !this.isIncluded() && !this.isInReadonlyProject();
    }

    private boolean isInReadonlyProject() {
        return this.getProject() != null && this.getProject().isReadonly();
    }

    @Override
    public boolean isIncluded() {
        return this.getState(2) || this.isSystem();
    }

    @Override
    public boolean isSystem() {
        return this.knowledgeBase.getSystemFrames().isSystem(this);
    }

    @Override
    public boolean isValidOwnSlotValue(Slot slot, Object object) {
        return this.getDefaultKnowledgeBase().isValidOwnSlotValue(this, slot, object);
    }

    @Override
    public boolean isVisible() {
        return !this.getProject().isHidden(this);
    }

    @Override
    public void moveDirectOwnSlotValue(Slot slot, int n, int n2) {
        this.getDefaultKnowledgeBase().moveDirectOwnSlotValue(this, slot, n, n2);
    }

    @Override
    public void removeFrameListener(FrameListener frameListener) {
        this.getDefaultKnowledgeBase().removeFrameListener(this, frameListener);
    }

    @Override
    public void removeOwnSlotValue(Slot slot, Object object) {
        this.getDefaultKnowledgeBase().removeOwnSlotValue(this, slot, object);
    }

    @Override
    public void setDocumentation(String string) {
        this.getDefaultKnowledgeBase().setDocumentation((Frame)this, string);
    }

    @Override
    public void setDocumentation(Collection collection) {
        this.getDefaultKnowledgeBase().setDocumentation((Frame)this, collection);
    }

    @Override
    public void setEditable(boolean bl) {
        this.setState(1, !bl);
    }

    @Override
    public void setIncluded(boolean bl) {
        this.setState(2, bl);
    }

    @Override
    public void setOwnFacetValue(Slot slot, Facet facet, Object object) {
        Assert.fail("not implemented");
    }

    @Override
    public void setOwnFacetValues(Slot slot, Facet facet, Collection collection) {
        Assert.fail("not implemented");
    }

    @Override
    public void setOwnSlotValue(Slot slot, Object object) {
        this.setOwnSlotValues(slot, CollectionUtilities.createCollection(object));
    }

    @Override
    public void setDirectOwnSlotValue(Slot slot, Object object) {
        this.setDirectOwnSlotValues(slot, CollectionUtilities.createCollection(object));
    }

    @Override
    public void setDirectOwnSlotValues(Slot slot, Collection collection) {
        this.getDefaultKnowledgeBase().setDirectOwnSlotValues(this, slot, collection);
    }

    @Override
    public void setOwnSlotValues(Slot slot, Collection collection) {
        this.getDefaultKnowledgeBase().setOwnSlotValues(this, slot, collection);
    }

    public void setSystem(boolean bl) {
    }

    @Override
    public void setVisible(boolean bl) {
        this.getProject().setHidden(this, !bl);
        this.getDefaultKnowledgeBase().notifyVisibilityChanged(this);
    }

    @Override
    public Icon getIcon() {
        return null;
    }

    @Override
    public Frame rename(String string) {
        return this.getKnowledgeBase().rename(this, string);
    }

    @Override
    public void assertFrameName() {
        this.getKnowledgeBase().assertFrameName(this);
    }
}

