/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protege.model.framestore;

import edu.stanford.smi.protege.event.ClsEvent;
import edu.stanford.smi.protege.event.ClsListener;
import edu.stanford.smi.protege.event.FacetEvent;
import edu.stanford.smi.protege.event.FacetListener;
import edu.stanford.smi.protege.event.FrameEvent;
import edu.stanford.smi.protege.event.FrameListener;
import edu.stanford.smi.protege.event.InstanceEvent;
import edu.stanford.smi.protege.event.InstanceListener;
import edu.stanford.smi.protege.event.KnowledgeBaseEvent;
import edu.stanford.smi.protege.event.KnowledgeBaseListener;
import edu.stanford.smi.protege.event.ServerProjectEvent;
import edu.stanford.smi.protege.event.ServerProjectListener;
import edu.stanford.smi.protege.event.ServerProjectNotificationEvent;
import edu.stanford.smi.protege.event.ServerProjectSessionClosedEvent;
import edu.stanford.smi.protege.event.ServerProjectStatusChangeEvent;
import edu.stanford.smi.protege.event.SlotEvent;
import edu.stanford.smi.protege.event.SlotListener;
import edu.stanford.smi.protege.event.TransactionEvent;
import edu.stanford.smi.protege.event.TransactionListener;
import edu.stanford.smi.protege.model.Cls;
import edu.stanford.smi.protege.model.Facet;
import edu.stanford.smi.protege.model.Frame;
import edu.stanford.smi.protege.model.FrameID;
import edu.stanford.smi.protege.model.Instance;
import edu.stanford.smi.protege.model.KnowledgeBase;
import edu.stanford.smi.protege.model.SimpleInstance;
import edu.stanford.smi.protege.model.Slot;
import edu.stanford.smi.protege.model.framestore.ModificationFrameStore;
import edu.stanford.smi.protege.server.RemoteSession;
import edu.stanford.smi.protege.server.framestore.ServerFrameStore;
import edu.stanford.smi.protege.server.framestore.ServerSessionLost;
import edu.stanford.smi.protege.util.AbstractEvent;
import edu.stanford.smi.protege.util.ArrayListMultiMap;
import edu.stanford.smi.protege.util.Assert;
import edu.stanford.smi.protege.util.Log;
import java.awt.EventQueue;
import java.lang.reflect.InvocationTargetException;
import java.rmi.ConnectException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EventListener;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.SwingUtilities;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EventDispatchFrameStore
extends ModificationFrameStore {
    private static transient Logger log = Log.getLogger(EventDispatchFrameStore.class);
    public static final int DELAY_MSEC = 5000;
    private Map<Class<?>, Map<Object, Collection<EventListener>>> _listeners = new HashMap();
    private Thread _eventThread;
    private KnowledgeBase kb;
    private boolean passThrough = false;
    private List<AbstractEvent> savedEvents = new ArrayList<AbstractEvent>();
    private ArrayListMultiMap<RemoteSession, AbstractEvent> transactedEvents = new ArrayListMultiMap();

    public EventDispatchFrameStore(KnowledgeBase knowledgeBase) {
        this.kb = knowledgeBase;
    }

    @Override
    public void reinitialize() {
    }

    @Override
    public void close() {
        super.close();
        this.stopEventThread();
        this._listeners = null;
    }

    public void setPassThrough(boolean bl) {
        this.passThrough = bl;
    }

    private List<AbstractEvent> getDispatchableEvents() {
        ArrayList<AbstractEvent> arrayList = new ArrayList<AbstractEvent>();
        for (AbstractEvent abstractEvent : this.getDelegate().getEvents()) {
            Collection collection;
            RemoteSession remoteSession;
            if (this.passThrough) {
                this.savedEvents.add(abstractEvent);
            }
            if (abstractEvent.isHiddenByTransaction() && !this.isMyEvent(abstractEvent)) {
                remoteSession = abstractEvent.getSession();
                this.transactedEvents.addValue(remoteSession, abstractEvent);
                if (!log.isLoggable(Level.FINER)) continue;
                log.finer("Dispatch for " + abstractEvent + " deferred until " + remoteSession + "s transaction closes.");
                continue;
            }
            if (abstractEvent instanceof TransactionEvent && ((TransactionEvent)abstractEvent).getEventType() == 702 && (collection = this.transactedEvents.removeKey((Object)(remoteSession = abstractEvent.getSession()))) != null && ((TransactionEvent)abstractEvent).isCommitted().booleanValue()) {
                if (log.isLoggable(Level.FINER)) {
                    log.finer("Committing " + collection.size() + " events for session " + remoteSession);
                }
                arrayList.addAll(collection);
            }
            arrayList.add(abstractEvent);
            if (!log.isLoggable(Level.FINER)) continue;
            log.finer("Event being dispatched now: " + abstractEvent);
        }
        return arrayList;
    }

    private boolean isMyEvent(AbstractEvent abstractEvent) {
        RemoteSession remoteSession = ServerFrameStore.getCurrentSession();
        RemoteSession remoteSession2 = abstractEvent.getSession();
        if (remoteSession == null) {
            return remoteSession2 == null;
        }
        return remoteSession.equals(remoteSession2);
    }

    @Override
    public List<AbstractEvent> getEvents() {
        if (this.passThrough) {
            this.dispatchEvents();
            List<AbstractEvent> list = this.savedEvents;
            this.savedEvents = new ArrayList<AbstractEvent>();
            return list;
        }
        return new ArrayList<AbstractEvent>();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void setPollForEvents(boolean bl) {
        if (bl) {
            if (this._eventThread != null) throw new IllegalStateException("Already polling");
            this.startEventThread();
            return;
        } else {
            this.stopEventThread();
        }
    }

    private void startEventThread() {
        this._eventThread = new Thread("EventDispatchFrameStoreHandler.startEventThread"){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            public void run() {
                while (true) {
                    try {
                        while (true) {
                            KnowledgeBase knowledgeBase = EventDispatchFrameStore.this.kb;
                            synchronized (knowledgeBase) {
                                if (EventDispatchFrameStore.this._eventThread != this) {
                                    return;
                                }
                            }
                            EventDispatchFrameStore.this.flushEvents();
                            knowledgeBase = EventDispatchFrameStore.this.kb;
                            synchronized (knowledgeBase) {
                                EventDispatchFrameStore.this.kb.wait(5000L);
                            }
                        }
                    }
                    catch (Exception exception) {
                        Log.getLogger().warning(exception.toString());
                        log.log(Level.FINE, "Exception caught", exception);
                        continue;
                    }
                    break;
                }
            }
        };
        this._eventThread.setPriority(1);
        this._eventThread.setDaemon(true);
        this._eventThread.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void stopEventThread() {
        this._eventThread = null;
        KnowledgeBase knowledgeBase = this.kb;
        synchronized (knowledgeBase) {
            this.kb.notifyAll();
        }
    }

    public void flushEvents() throws InterruptedException {
        try {
            if (EventQueue.isDispatchThread()) {
                this.dispatchEvents();
            } else {
                SwingUtilities.invokeAndWait(new Runnable(){

                    public void run() {
                        EventDispatchFrameStore.this.dispatchEvents();
                    }
                });
            }
        }
        catch (InvocationTargetException invocationTargetException) {
            Log.getLogger().warning("Exception caught " + invocationTargetException);
        }
    }

    private void dispatchEvents() {
        this.dispatchEvents(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void dispatchEvents(boolean bl) {
        try {
            KnowledgeBase knowledgeBase = this.kb;
            synchronized (knowledgeBase) {
                List<AbstractEvent> list = this.getDispatchableEvents();
                if (!list.isEmpty()) {
                    this.dispatchEvents(list, bl);
                }
            }
        }
        catch (Throwable throwable) {
            Throwable throwable2;
            do {
                if (!(throwable2 instanceof ServerSessionLost) && !(throwable2 instanceof ConnectException)) continue;
                log.warning("Knowledge base has been disconnected from the server");
                this.kb.getProject().postProjectEvent(5);
                return;
            } while ((throwable2 = throwable2.getCause()) != null);
        }
    }

    private void dispatchEvents(Collection<AbstractEvent> collection, boolean bl) {
        for (AbstractEvent object : collection) {
            try {
                this.dispatchEvent(object);
            }
            catch (Throwable abstractEvent) {
                if (bl) continue;
                if (log.isLoggable(Level.FINE)) {
                    log.log(Level.FINE, "Exception caught", abstractEvent);
                }
                Log.getLogger().warning("Exception caught " + abstractEvent.toString());
                Log.getLogger().warning("use fine logging for more details");
            }
        }
        for (AbstractEvent abstractEvent : collection) {
            KnowledgeBaseEvent knowledgeBaseEvent;
            if (!(abstractEvent instanceof KnowledgeBaseEvent) || (knowledgeBaseEvent = (KnowledgeBaseEvent)abstractEvent).getEventType() != 101) continue;
            this.replaceListeners(knowledgeBaseEvent.getFrame(), knowledgeBaseEvent.getNewFrame());
        }
    }

    private void dispatchEvent(AbstractEvent abstractEvent) {
        if (abstractEvent instanceof KnowledgeBaseEvent) {
            this.dispatchKbEvent((KnowledgeBaseEvent)abstractEvent);
        } else if (abstractEvent instanceof ClsEvent) {
            this.dispatchClsEvent((ClsEvent)abstractEvent);
            this.dispatchClsEventToSubclasses((ClsEvent)abstractEvent);
        } else if (abstractEvent instanceof SlotEvent) {
            this.dispatchSlotEvent((SlotEvent)abstractEvent);
        } else if (abstractEvent instanceof FacetEvent) {
            this.dispatchFacetEvent((FacetEvent)abstractEvent);
        } else if (abstractEvent instanceof InstanceEvent) {
            this.dispatchInstanceEvent((InstanceEvent)abstractEvent);
        } else if (abstractEvent instanceof FrameEvent) {
            this.dispatchFrameEvent((FrameEvent)abstractEvent);
            this.dispatchFrameEventAsClsFacetEvent((FrameEvent)abstractEvent);
        } else if (abstractEvent instanceof TransactionEvent) {
            this.dispatchTransactionEvent((TransactionEvent)abstractEvent);
        } else if (abstractEvent instanceof ServerProjectEvent) {
            this.dispatchServerEvent((ServerProjectEvent)((Object)abstractEvent));
        } else {
            throw new RuntimeException("unknown event type: " + abstractEvent);
        }
    }

    private void dispatchServerEvent(ServerProjectEvent serverProjectEvent) {
        for (EventListener eventListener : this.getListeners(ServerProjectListener.class, serverProjectEvent.getSource())) {
            ServerProjectListener serverProjectListener = (ServerProjectListener)eventListener;
            if (serverProjectEvent instanceof ServerProjectNotificationEvent) {
                serverProjectListener.projectNotificationReceived((ServerProjectNotificationEvent)serverProjectEvent);
                continue;
            }
            if (serverProjectEvent instanceof ServerProjectStatusChangeEvent) {
                serverProjectListener.projectStatusChanged((ServerProjectStatusChangeEvent)serverProjectEvent);
                continue;
            }
            if (!(serverProjectEvent instanceof ServerProjectSessionClosedEvent)) continue;
            serverProjectListener.beforeProjectSessionClosed((ServerProjectSessionClosedEvent)serverProjectEvent);
        }
    }

    private void dispatchTransactionEvent(TransactionEvent transactionEvent) {
        block4: for (TransactionListener transactionListener : this.getListeners(TransactionListener.class, transactionEvent.getSource())) {
            switch (transactionEvent.getEventType()) {
                case 701: {
                    transactionListener.transactionBegin(transactionEvent);
                    continue block4;
                }
                case 702: {
                    transactionListener.transactionEnded(transactionEvent);
                    continue block4;
                }
            }
            Log.getLogger().warning("bad event: " + transactionEvent);
        }
    }

    private void dispatchKbEvent(KnowledgeBaseEvent knowledgeBaseEvent) {
        block14: for (KnowledgeBaseListener knowledgeBaseListener : this.getListeners(KnowledgeBaseListener.class, knowledgeBaseEvent.getSource())) {
            switch (knowledgeBaseEvent.getEventType()) {
                case 601: {
                    knowledgeBaseListener.clsCreated(knowledgeBaseEvent);
                    continue block14;
                }
                case 602: {
                    knowledgeBaseListener.clsDeleted(knowledgeBaseEvent);
                    continue block14;
                }
                case 603: {
                    knowledgeBaseListener.slotCreated(knowledgeBaseEvent);
                    continue block14;
                }
                case 604: {
                    knowledgeBaseListener.slotDeleted(knowledgeBaseEvent);
                    continue block14;
                }
                case 605: {
                    knowledgeBaseListener.facetCreated(knowledgeBaseEvent);
                    continue block14;
                }
                case 606: {
                    knowledgeBaseListener.facetDeleted(knowledgeBaseEvent);
                    continue block14;
                }
                case 607: {
                    knowledgeBaseListener.instanceCreated(knowledgeBaseEvent);
                    continue block14;
                }
                case 608: {
                    knowledgeBaseListener.instanceDeleted(knowledgeBaseEvent);
                    continue block14;
                }
                case 101: {
                    knowledgeBaseListener.frameNameChanged(knowledgeBaseEvent);
                    continue block14;
                }
                case 610: {
                    knowledgeBaseListener.defaultClsMetaClsChanged(knowledgeBaseEvent);
                    continue block14;
                }
                case 611: {
                    knowledgeBaseListener.defaultSlotMetaClsChanged(knowledgeBaseEvent);
                    continue block14;
                }
                case 612: {
                    knowledgeBaseListener.defaultFacetMetaClsChanged(knowledgeBaseEvent);
                    continue block14;
                }
            }
            Log.getLogger().warning("bad event: " + knowledgeBaseEvent);
        }
    }

    private void dispatchClsEvent(ClsEvent clsEvent) {
        block15: for (ClsListener clsListener : this.getListeners(ClsListener.class, clsEvent.getSource())) {
            switch (clsEvent.getEventType()) {
                case 301: {
                    clsListener.directSuperclassAdded(clsEvent);
                    continue block15;
                }
                case 302: {
                    clsListener.directSuperclassRemoved(clsEvent);
                    continue block15;
                }
                case 303: {
                    clsListener.directSubclassAdded(clsEvent);
                    continue block15;
                }
                case 304: {
                    clsListener.directSubclassRemoved(clsEvent);
                    continue block15;
                }
                case 305: {
                    clsListener.directInstanceAdded(clsEvent);
                    continue block15;
                }
                case 306: {
                    clsListener.directInstanceRemoved(clsEvent);
                    continue block15;
                }
                case 307: {
                    clsListener.directSubclassMoved(clsEvent);
                    continue block15;
                }
                case 308: {
                    clsListener.templateSlotAdded(clsEvent);
                    continue block15;
                }
                case 309: {
                    clsListener.templateSlotRemoved(clsEvent);
                    continue block15;
                }
                case 310: {
                    clsListener.templateSlotValueChanged(clsEvent);
                    continue block15;
                }
                case 311: {
                    clsListener.templateFacetAdded(clsEvent);
                    continue block15;
                }
                case 312: {
                    clsListener.templateFacetRemoved(clsEvent);
                    continue block15;
                }
                case 313: {
                    clsListener.templateFacetValueChanged(clsEvent);
                    continue block15;
                }
            }
            Log.getLogger().severe("bad event: " + clsEvent);
        }
    }

    private void dispatchClsEventToSubclasses(ClsEvent clsEvent) {
        if (EventDispatchFrameStore.doDispatchToSubclasses(clsEvent)) {
            for (Cls cls : this.getListenedToSubclasses(ClsListener.class, clsEvent.getCls())) {
                ClsEvent clsEvent2 = new ClsEvent(cls, clsEvent.getEventType(), clsEvent.getArgument1(), clsEvent.getArgument2());
                this.dispatchClsEvent(clsEvent2);
            }
        }
    }

    private static boolean doDispatchToSubclasses(ClsEvent clsEvent) {
        int n = clsEvent.getEventType();
        return n == 310 || n == 313 || n == 308 || n == 309;
    }

    private void dispatchFrameEventAsClsFacetEvent(FrameEvent frameEvent) {
        Slot slot;
        Iterator iterator;
        Facet facet = EventDispatchFrameStore.getFacet(frameEvent);
        if (facet != null && (iterator = (slot = (Slot)frameEvent.getFrame()).getDirectDomain().iterator()).hasNext()) {
            Cls cls = (Cls)iterator.next();
            ClsEvent clsEvent = new ClsEvent(cls, 313, (Object)slot, (Object)facet);
            this.dispatchClsEvent(clsEvent);
            this.dispatchClsEventToSubclasses(clsEvent);
        }
    }

    private static Facet getFacet(FrameEvent frameEvent) {
        Facet facet = null;
        if (frameEvent.getFrame() instanceof Slot && frameEvent.getEventType() == 110) {
            Slot slot = frameEvent.getSlot();
            facet = slot.getAssociatedFacet();
        }
        return facet;
    }

    private void dispatchSlotEvent(SlotEvent slotEvent) {
        block9: for (SlotListener slotListener : this.getListeners(SlotListener.class, slotEvent.getSource())) {
            int n = slotEvent.getEventType();
            switch (n) {
                case 401: {
                    slotListener.templateSlotClsAdded(slotEvent);
                    continue block9;
                }
                case 402: {
                    slotListener.templateSlotClsRemoved(slotEvent);
                    continue block9;
                }
                case 405: {
                    slotListener.directSubslotAdded(slotEvent);
                    continue block9;
                }
                case 406: {
                    slotListener.directSubslotRemoved(slotEvent);
                    continue block9;
                }
                case 409: {
                    slotListener.directSubslotMoved(slotEvent);
                    continue block9;
                }
                case 407: {
                    slotListener.directSuperslotAdded(slotEvent);
                    continue block9;
                }
                case 408: {
                    slotListener.directSuperslotRemoved(slotEvent);
                    continue block9;
                }
            }
            Assert.fail("bad type: " + n);
        }
    }

    private void dispatchFacetEvent(FacetEvent facetEvent) {
        block4: for (FacetListener facetListener : this.getListeners(FacetListener.class, facetEvent.getSource())) {
            int n = facetEvent.getEventType();
            switch (n) {
                case 501: {
                    facetListener.frameSlotReferenceAdded(facetEvent);
                    continue block4;
                }
                case 502: {
                    facetListener.frameSlotReferenceRemoved(facetEvent);
                    continue block4;
                }
            }
            Assert.fail("bad type: " + n + " " + facetListener);
        }
    }

    private void dispatchInstanceEvent(InstanceEvent instanceEvent) {
        block4: for (InstanceListener instanceListener : this.getListeners(InstanceListener.class, instanceEvent.getSource())) {
            int n = instanceEvent.getEventType();
            switch (n) {
                case 202: {
                    instanceListener.directTypeAdded(instanceEvent);
                    continue block4;
                }
                case 203: {
                    instanceListener.directTypeRemoved(instanceEvent);
                    continue block4;
                }
            }
            Assert.fail("bad type: " + n + " " + instanceListener);
        }
    }

    private void dispatchFrameEvent(FrameEvent frameEvent) {
        block12: for (FrameListener frameListener : this.getListeners(FrameListener.class, frameEvent.getSource())) {
            switch (frameEvent.getEventType()) {
                case 101: {
                    frameListener.nameChanged(frameEvent);
                    continue block12;
                }
                case 103: {
                    frameListener.visibilityChanged(frameEvent);
                    continue block12;
                }
                case 105: {
                    frameListener.browserTextChanged(frameEvent);
                    continue block12;
                }
                case 106: {
                    frameListener.ownSlotAdded(frameEvent);
                    continue block12;
                }
                case 107: {
                    frameListener.ownSlotRemoved(frameEvent);
                    continue block12;
                }
                case 108: {
                    frameListener.ownFacetAdded(frameEvent);
                    continue block12;
                }
                case 109: {
                    frameListener.ownFacetRemoved(frameEvent);
                    continue block12;
                }
                case 110: {
                    frameListener.ownSlotValueChanged(frameEvent);
                    continue block12;
                }
                case 111: {
                    frameListener.ownFacetValueChanged(frameEvent);
                    continue block12;
                }
                case 102: {
                    frameListener.deleted(frameEvent);
                    continue block12;
                }
            }
            Log.getLogger().severe("bad event: " + frameEvent);
        }
    }

    public Collection<EventListener> getListeners(Class<?> clazz, Object object) {
        Collection<EventListener> collection = null;
        Map<Object, Collection<EventListener>> map = this._listeners.get(clazz);
        if (map != null) {
            Collection<EventListener> collection2 = map.get(object);
            collection = EventDispatchFrameStore.addListeners(collection2, collection);
            Collection<EventListener> collection3 = map.get(null);
            collection = EventDispatchFrameStore.addListeners(collection3, collection);
        }
        if (collection == null) {
            return Collections.emptyList();
        }
        return collection;
    }

    private static Collection<EventListener> addListeners(Collection<EventListener> collection, Collection<EventListener> collection2) {
        if (collection != null) {
            if (collection2 == null) {
                collection2 = new ArrayList<EventListener>(collection);
            } else {
                collection2.addAll(collection);
            }
        }
        return collection2;
    }

    public void clearListeners() {
        this._listeners.clear();
    }

    private void removeListeners(Class<?> clazz, Frame frame) {
        Map<Object, Collection<EventListener>> map = this._listeners.get(clazz);
        if (map != null) {
            map.remove(frame);
        }
    }

    private void removeClsListeners(Cls cls) {
        this.removeListeners(ClsListener.class, cls);
        this.removeInstanceListeners(cls);
    }

    private void removeSlotListeners(Slot slot) {
        this.removeListeners(SlotListener.class, slot);
        this.removeInstanceListeners(slot);
    }

    private void removeFacetListeners(Facet facet) {
        this.removeListeners(FacetListener.class, facet);
        this.removeInstanceListeners(facet);
    }

    private void removeSimpleInstanceListeners(SimpleInstance simpleInstance) {
        this.removeInstanceListeners(simpleInstance);
    }

    private void removeInstanceListeners(Instance instance) {
        this.removeListeners(InstanceListener.class, instance);
        this.removeFrameListeners(instance);
    }

    private void removeFrameListeners(Frame frame) {
        this.removeListeners(FrameListener.class, frame);
    }

    public void notifyInstancesOfBrowserTextChange(Cls cls) {
        Collection<Instance> collection = this.getListenedToInstances(FrameListener.class, cls);
        for (Frame frame : collection) {
            FrameEvent frameEvent = new FrameEvent(frame, 105);
            this.dispatchFrameEvent(frameEvent);
        }
    }

    private Collection<Cls> getListenedToSubclasses(Class<?> clazz, Cls cls) {
        HashSet<Cls> hashSet = new HashSet<Cls>();
        Map<Object, Collection<EventListener>> map = this._listeners.get(clazz);
        if (map != null) {
            Set<Object> set = map.keySet();
            for (Object object : set) {
                Cls cls2;
                if (!(object instanceof Cls) || !this.getSuperclasses(cls2 = (Cls)object).contains(cls)) continue;
                hashSet.add(cls2);
            }
        }
        return hashSet;
    }

    private Collection<Instance> getListenedToInstances(Class<?> clazz, Cls cls) {
        HashSet<Instance> hashSet = new HashSet<Instance>();
        Map<Object, Collection<EventListener>> map = this._listeners.get(clazz);
        if (map != null) {
            Set<Object> set = map.keySet();
            for (Object object : set) {
                Instance instance;
                if (!(object instanceof Instance) || !(instance = (Instance)object).hasType(cls)) continue;
                hashSet.add(instance);
            }
        }
        return hashSet;
    }

    public void addListener(Class<?> clazz, Object object, EventListener eventListener) {
        Collection<EventListener> collection;
        Map<Object, Collection<EventListener>> map = this._listeners.get(clazz);
        if (map == null) {
            map = new HashMap<Object, Collection<EventListener>>();
            this._listeners.put(clazz, map);
        }
        if ((collection = map.get(object)) == null) {
            collection = new ArrayList<EventListener>();
            map.put(object, collection);
        }
        collection.add(eventListener);
    }

    public void removeListener(Class<?> clazz, Object object, EventListener eventListener) {
        Collection<EventListener> collection;
        Map<Object, Collection<EventListener>> map = this._listeners.get(clazz);
        if (map != null && (collection = map.get(object)) != null) {
            collection.remove(eventListener);
        }
    }

    @Override
    public void addDirectSuperclass(Cls cls, Cls cls2) {
        this.getDelegate().addDirectSuperclass(cls, cls2);
        this.dispatchEvents();
    }

    @Override
    public void addDirectSuperslot(Slot slot, Slot slot2) {
        this.getDelegate().addDirectSuperslot(slot, slot2);
        this.dispatchEvents();
    }

    @Override
    public void addDirectTemplateSlot(Cls cls, Slot slot) {
        this.getDelegate().addDirectTemplateSlot(cls, slot);
        this.dispatchEvents();
    }

    @Override
    public void addDirectType(Instance instance, Cls cls) {
        this.getDelegate().addDirectType(instance, cls);
        this.dispatchEvents();
    }

    @Override
    public boolean beginTransaction(String string) {
        boolean bl = this.getDelegate().beginTransaction(string);
        this.dispatchEvents();
        return bl;
    }

    @Override
    public boolean commitTransaction() {
        boolean bl = this.getDelegate().commitTransaction();
        this.dispatchEvents();
        return bl;
    }

    @Override
    public Cls createCls(FrameID frameID, Collection collection, Collection collection2, boolean bl) {
        Cls cls = this.getDelegate().createCls(frameID, collection, collection2, bl);
        this.dispatchEvents();
        return cls;
    }

    @Override
    public Facet createFacet(FrameID frameID, Collection collection, boolean bl) {
        Facet facet = this.getDelegate().createFacet(frameID, collection, bl);
        this.dispatchEvents();
        return facet;
    }

    @Override
    public SimpleInstance createSimpleInstance(FrameID frameID, Collection collection, boolean bl) {
        SimpleInstance simpleInstance = this.getDelegate().createSimpleInstance(frameID, collection, bl);
        this.dispatchEvents();
        return simpleInstance;
    }

    @Override
    public Slot createSlot(FrameID frameID, Collection collection, Collection collection2, boolean bl) {
        Slot slot = this.getDelegate().createSlot(frameID, collection, collection2, bl);
        this.dispatchEvents();
        return slot;
    }

    @Override
    public void deleteCls(Cls cls) {
        this.getDelegate().deleteCls(cls);
        this.removeClsListeners(cls);
        this.dispatchEvents();
    }

    @Override
    public void deleteFacet(Facet facet) {
        this.getDelegate().deleteFacet(facet);
        this.removeFacetListeners(facet);
        this.dispatchEvents();
    }

    @Override
    public void deleteSimpleInstance(SimpleInstance simpleInstance) {
        this.getDelegate().deleteSimpleInstance(simpleInstance);
        this.removeSimpleInstanceListeners(simpleInstance);
        this.dispatchEvents();
    }

    @Override
    public void deleteSlot(Slot slot) {
        this.getDelegate().deleteSlot(slot);
        this.removeSlotListeners(slot);
        this.dispatchEvents();
    }

    @Override
    public void moveDirectOwnSlotValue(Frame frame, Slot slot, int n, int n2) {
        this.getDelegate().moveDirectOwnSlotValue(frame, slot, n, n2);
        this.dispatchEvents();
    }

    @Override
    public void moveDirectSubclass(Cls cls, Cls cls2, int n) {
        this.getDelegate().moveDirectSubclass(cls, cls2, n);
        this.dispatchEvents();
    }

    @Override
    public void moveDirectSubslot(Slot slot, Slot slot2, int n) {
        this.getDelegate().moveDirectSubslot(slot, slot2, n);
        this.dispatchEvents();
    }

    @Override
    public void moveDirectTemplateSlot(Cls cls, Slot slot, int n) {
        this.getDelegate().moveDirectTemplateSlot(cls, slot, n);
        this.dispatchEvents();
    }

    @Override
    public void moveDirectType(Instance instance, Cls cls, int n) {
        this.getDelegate().moveDirectType(instance, cls, n);
        this.dispatchEvents();
    }

    @Override
    public void removeDirectSuperclass(Cls cls, Cls cls2) {
        this.getDelegate().removeDirectSuperclass(cls, cls2);
        this.dispatchEvents();
    }

    @Override
    public void removeDirectSuperslot(Slot slot, Slot slot2) {
        this.getDelegate().removeDirectSuperslot(slot, slot2);
        this.dispatchEvents();
    }

    @Override
    public void removeDirectTemplateFacetOverrides(Cls cls, Slot slot) {
        this.getDelegate().removeDirectTemplateFacetOverrides(cls, slot);
        this.dispatchEvents();
    }

    @Override
    public void removeDirectTemplateSlot(Cls cls, Slot slot) {
        this.getDelegate().removeDirectTemplateSlot(cls, slot);
        this.dispatchEvents();
    }

    @Override
    public void removeDirectType(Instance instance, Cls cls) {
        this.getDelegate().removeDirectType(instance, cls);
        this.dispatchEvents();
    }

    @Override
    public boolean rollbackTransaction() {
        boolean bl = this.getDelegate().rollbackTransaction();
        this.dispatchEvents();
        return bl;
    }

    @Override
    public void setDirectOwnSlotValues(Frame frame, Slot slot, Collection collection) {
        this.getDelegate().setDirectOwnSlotValues(frame, slot, collection);
        this.dispatchEvents();
    }

    @Override
    public void setDirectTemplateFacetValues(Cls cls, Slot slot, Facet facet, Collection collection) {
        this.getDelegate().setDirectTemplateFacetValues(cls, slot, facet, collection);
        this.dispatchEvents();
    }

    @Override
    public void setDirectTemplateSlotValues(Cls cls, Slot slot, Collection collection) {
        this.getDelegate().setDirectTemplateSlotValues(cls, slot, collection);
        this.dispatchEvents();
    }

    @Override
    public void replaceFrame(Frame frame, Frame frame2) {
        this.getDelegate().replaceFrame(frame, frame2);
        this.dispatchEvents();
    }

    private void replaceListeners(Frame frame, Frame frame2) {
        for (Map<Object, Collection<EventListener>> map : this._listeners.values()) {
            Collection<EventListener> collection = map.remove(frame);
            if (collection == null) continue;
            Collection<EventListener> collection2 = map.get(frame2);
            if (collection2 != null) {
                collection.addAll(collection2);
            }
            map.put(frame2, collection);
        }
    }

    public void printListenersByHashCode(int n) {
        System.out.println("Printing out FrameListeners that have hash code " + n);
        for (Map.Entry<Object, Collection<EventListener>> entry : this._listeners.get(FrameListener.class).entrySet()) {
            Object object = entry.getKey();
            Collection<EventListener> collection = entry.getValue();
            for (EventListener eventListener : collection) {
                if (eventListener.hashCode() != n) continue;
                System.out.println("Found listener " + eventListener + " at " + object);
            }
        }
    }

    public void dumpListeners(Level level) {
        if (!log.isLoggable(level)) {
            return;
        }
        log.log(level, "-----------------------printing listeners======================");
        for (Map<Object, Collection<EventListener>> map : this._listeners.values()) {
            for (Map.Entry<Object, Collection<EventListener>> entry : map.entrySet()) {
                log.log(level, "listeners for object " + entry.getKey());
                for (EventListener eventListener : entry.getValue()) {
                    log.log(level, "\t" + eventListener);
                }
            }
        }
    }
}

