/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protege.server.framestore;

import edu.stanford.smi.protege.model.Cls;
import edu.stanford.smi.protege.model.Facet;
import edu.stanford.smi.protege.model.Frame;
import edu.stanford.smi.protege.model.FrameID;
import edu.stanford.smi.protege.model.Model;
import edu.stanford.smi.protege.model.SimpleInstance;
import edu.stanford.smi.protege.model.Slot;
import edu.stanford.smi.protege.model.framestore.FrameStoreAdapter;
import edu.stanford.smi.protege.server.RemoteSession;
import edu.stanford.smi.protege.server.framestore.ServerFrameStore;
import edu.stanford.smi.protege.server.framestore.background.CacheRequestReason;
import edu.stanford.smi.protege.server.framestore.background.FrameCalculator;
import java.util.Collection;
import java.util.List;

public class FrameCalculatorFrameStore
extends FrameStoreAdapter {
    private FrameCalculator frameCalculator;

    public FrameCalculatorFrameStore(FrameCalculator frameCalculator) {
        this.frameCalculator = frameCalculator;
    }

    public FrameCalculator getFrameCalculator() {
        return this.frameCalculator;
    }

    public List getDirectTemplateSlotValues(Cls cls, Slot slot) {
        RemoteSession remoteSession = ServerFrameStore.getCurrentSession();
        this.frameCalculator.addRequest(cls, remoteSession, CacheRequestReason.USER_REQUESTED_FRAME_VALUES);
        return this.getDelegate().getDirectTemplateSlotValues(cls, slot);
    }

    public List getDirectTemplateFacetValues(Cls cls, Slot slot, Facet facet) {
        RemoteSession remoteSession = ServerFrameStore.getCurrentSession();
        this.frameCalculator.addRequest(cls, remoteSession, CacheRequestReason.USER_REQUESTED_FRAME_VALUES);
        return this.getDelegate().getDirectTemplateFacetValues(cls, slot, facet);
    }

    public Frame getFrame(String string) {
        Frame frame = this.getDelegate().getFrame(string);
        RemoteSession remoteSession = ServerFrameStore.getCurrentSession();
        if (frame != null) {
            this.frameCalculator.addRequest(frame, remoteSession, CacheRequestReason.USER_NAME_REQUEST);
        }
        return frame;
    }

    public int getDirectOwnSlotValuesCount(Frame frame, Slot slot) {
        RemoteSession remoteSession = ServerFrameStore.getCurrentSession();
        if (slot.getFrameID().equals(Model.SlotID.DIRECT_INSTANCES)) {
            this.frameCalculator.addRequest(frame, remoteSession, CacheRequestReason.USER_REQUESTED_FRAME_VALUES);
        }
        return this.getDelegate().getDirectOwnSlotValuesCount(frame, slot);
    }

    public List getDirectOwnSlotValues(Frame frame, Slot slot) {
        List list;
        block2: {
            RemoteSession remoteSession;
            block3: {
                list = this.getDelegate().getDirectOwnSlotValues(frame, slot);
                remoteSession = ServerFrameStore.getCurrentSession();
                if (this.frameCalculator.isDisabled(remoteSession)) break block2;
                this.frameCalculator.addRequest(frame, remoteSession, CacheRequestReason.USER_REQUESTED_FRAME_VALUES);
                if (!slot.getFrameID().equals(Model.SlotID.DIRECT_SUBCLASSES)) break block3;
                for (Object e : list) {
                    if (!(e instanceof Frame)) continue;
                    this.frameCalculator.addRequest((Frame)e, remoteSession, CacheRequestReason.SUBCLASS);
                }
                break block2;
            }
            if (!slot.getFrameID().equals(Model.SlotID.DIRECT_INSTANCES)) break block2;
            for (Object e : list) {
                if (!(e instanceof Frame)) continue;
                this.frameCalculator.addRequest((Frame)e, remoteSession, CacheRequestReason.DIRECT_INSTANCES);
            }
        }
        return list;
    }

    public Facet createFacet(FrameID frameID, Collection collection, boolean bl) {
        Facet facet = this.getDelegate().createFacet(frameID, collection, bl);
        RemoteSession remoteSession = ServerFrameStore.getCurrentSession();
        this.frameCalculator.addRequest(facet, remoteSession, CacheRequestReason.NEW_FRAME);
        return facet;
    }

    public Slot createSlot(FrameID frameID, Collection collection, Collection collection2, boolean bl) {
        Slot slot = this.getDelegate().createSlot(frameID, collection, collection2, bl);
        RemoteSession remoteSession = ServerFrameStore.getCurrentSession();
        this.frameCalculator.addRequest(slot, remoteSession, CacheRequestReason.NEW_FRAME);
        return slot;
    }

    public Cls createCls(FrameID frameID, Collection collection, Collection collection2, boolean bl) {
        Cls cls = this.getDelegate().createCls(frameID, collection, collection2, bl);
        RemoteSession remoteSession = ServerFrameStore.getCurrentSession();
        this.frameCalculator.addRequest(cls, remoteSession, CacheRequestReason.NEW_FRAME);
        return cls;
    }

    public SimpleInstance createSimpleInstance(FrameID frameID, Collection collection, boolean bl) {
        SimpleInstance simpleInstance = this.getDelegate().createSimpleInstance(frameID, collection, bl);
        RemoteSession remoteSession = ServerFrameStore.getCurrentSession();
        this.frameCalculator.addRequest(simpleInstance, remoteSession, CacheRequestReason.NEW_FRAME);
        return simpleInstance;
    }
}

