/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protege.server.framestore.background;

import edu.stanford.smi.protege.model.Cls;
import edu.stanford.smi.protege.model.Facet;
import edu.stanford.smi.protege.model.Frame;
import edu.stanford.smi.protege.model.KnowledgeBase;
import edu.stanford.smi.protege.model.Model;
import edu.stanford.smi.protege.model.Slot;
import edu.stanford.smi.protege.model.framestore.FrameStore;
import edu.stanford.smi.protege.model.framestore.Sft;
import edu.stanford.smi.protege.server.RemoteSession;
import edu.stanford.smi.protege.server.Server;
import edu.stanford.smi.protege.server.ServerProject;
import edu.stanford.smi.protege.server.framestore.Registration;
import edu.stanford.smi.protege.server.framestore.ServerFrameStore;
import edu.stanford.smi.protege.server.framestore.ServerSessionLost;
import edu.stanford.smi.protege.server.framestore.background.CacheRequestReason;
import edu.stanford.smi.protege.server.framestore.background.ClientAndFrame;
import edu.stanford.smi.protege.server.framestore.background.FrameCalculatorStats;
import edu.stanford.smi.protege.server.framestore.background.ServerCacheStateMachine;
import edu.stanford.smi.protege.server.framestore.background.ServerCachedState;
import edu.stanford.smi.protege.server.framestore.background.WorkInfo;
import edu.stanford.smi.protege.util.Log;
import edu.stanford.smi.protege.util.transaction.cache.CacheResult;
import edu.stanford.smi.protege.util.transaction.cache.serialize.CacheAbortComplete;
import edu.stanford.smi.protege.util.transaction.cache.serialize.CacheCompleted;
import edu.stanford.smi.protege.util.transaction.cache.serialize.CacheRead;
import edu.stanford.smi.protege.util.transaction.cache.serialize.CacheStartComplete;
import edu.stanford.smi.protege.util.transaction.cache.serialize.SerializedCacheUpdate;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.logging.Level;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FrameCalculator {
    private static transient Logger log = Log.getLogger(FrameCalculator.class);
    public static long WAIT_FOR_OVERLOADED_CLIENT = 300L;
    public static long MAX_WORKINFO_QUEUE = 15000L;
    private FrameStore fs;
    private final Object kbLock;
    private ServerFrameStore server;
    private RemoteSession effectiveClient;
    FrameCalculatorThread innerThread;
    private Object requestLock = new Object();
    private SortedSet<WorkInfo> requests = new TreeSet<WorkInfo>();
    private Map<ClientAndFrame, WorkInfo> requestMap = new HashMap<ClientAndFrame, WorkInfo>();
    private ServerCacheStateMachine machine = null;
    private Map<RemoteSession, Registration> sessionMap;
    private static boolean disabled = false;
    private Set<RemoteSession> disabledSessions = new HashSet<RemoteSession>();
    private FrameCalculatorStatsImpl stats = new FrameCalculatorStatsImpl();
    private long startOfLockHeldTime;

    public FrameCalculator(FrameStore frameStore, ServerCacheStateMachine serverCacheStateMachine, Object object, ServerFrameStore serverFrameStore, Map<RemoteSession, Registration> map) {
        this.fs = frameStore;
        this.machine = serverCacheStateMachine;
        this.kbLock = object;
        this.server = serverFrameStore;
        this.sessionMap = map;
        this.innerThread = new FrameCalculatorThread();
        this.innerThread.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setStateMachine(ServerCacheStateMachine serverCacheStateMachine) {
        Object object = this.requestLock;
        synchronized (object) {
            this.machine = serverCacheStateMachine;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doWork(WorkInfo workInfo) throws ServerSessionLost {
        Set set;
        Frame frame = workInfo.getFrame();
        this.effectiveClient = workInfo.getClient();
        ServerFrameStore.setCurrentSession(this.effectiveClient);
        if (log.isLoggable(Level.FINE)) {
            this.letOtherThreadsRun();
            set = this.kbLock;
            synchronized (set) {
                log.fine("Precalculating " + this.fs.getFrameName(frame) + "/" + frame.getFrameID());
            }
            this.afterKbLockHeld();
        }
        try {
            Object object;
            Sft sft;
            this.stats.startWork();
            this.letOtherThreadsRun();
            set = this.kbLock;
            synchronized (set) {
                if (this.server.inTransaction()) {
                    if (log.isLoggable(Level.FINE)) {
                        log.fine("\tbut transaction in progress");
                    }
                    workInfo.setTargetFullCache(false);
                } else {
                    this.insertValueUpdate(frame, new CacheStartComplete<RemoteSession, Sft, List>());
                }
            }
            this.afterKbLockHeld();
            set = null;
            List list = null;
            this.letOtherThreadsRun();
            Object object2 = this.kbLock;
            synchronized (object2) {
                this.checkAbilityToGenerateFullCache(workInfo);
                set = this.fs.getOwnSlots(frame);
            }
            this.afterKbLockHeld();
            for (Iterator iterator : set) {
                this.letOtherThreadsRun();
                Object object3 = this.kbLock;
                synchronized (object3) {
                    this.checkAbilityToGenerateFullCache(workInfo);
                    sft = new Sft((Slot)((Object)iterator), null, false);
                    if (iterator.getFrameID().equals(Model.SlotID.DIRECT_INSTANCES) && workInfo.skipDirectInstances()) {
                        object = CacheResult.getInvalid();
                        this.insertValueUpdate(frame, new CacheRead<RemoteSession, Sft, List>(this.effectiveClient, sft, (CacheResult<List>)object));
                    } else {
                        list = this.fs.getDirectOwnSlotValues(frame, (Slot)((Object)iterator));
                        if (list != null && !list.isEmpty()) {
                            object = new CacheResult<List>(list, true);
                            this.insertValueUpdate(frame, new CacheRead<RemoteSession, Sft, List>(this.effectiveClient, sft, (CacheResult<List>)object));
                        }
                    }
                    this.addFollowedExprs(frame, (Slot)((Object)iterator), list);
                }
                this.afterKbLockHeld();
            }
            if (frame instanceof Cls) {
                Iterator iterator;
                object2 = (Cls)frame;
                this.letOtherThreadsRun();
                iterator = this.kbLock;
                synchronized (iterator) {
                    this.checkAbilityToGenerateFullCache(workInfo);
                    set = this.fs.getTemplateSlots((Cls)object2);
                }
                this.afterKbLockHeld();
                for (Object object3 : set) {
                    Iterator iterator2;
                    this.letOtherThreadsRun();
                    object = this.kbLock;
                    synchronized (object) {
                        this.checkAbilityToGenerateFullCache(workInfo);
                        sft = new Sft((Slot)object3, null, true);
                        list = this.fs.getDirectTemplateSlotValues((Cls)object2, (Slot)object3);
                        if (list != null && !list.isEmpty()) {
                            iterator2 = new CacheResult<List>(list, true);
                            this.insertValueUpdate(frame, new CacheRead<RemoteSession, Sft, List>(this.effectiveClient, sft, (CacheResult<List>)((Object)iterator2)));
                        }
                    }
                    this.afterKbLockHeld();
                    this.letOtherThreadsRun();
                    iterator2 = this.kbLock;
                    synchronized (iterator2) {
                        this.checkAbilityToGenerateFullCache(workInfo);
                        object = this.fs.getTemplateFacets((Cls)object2, (Slot)object3);
                    }
                    this.afterKbLockHeld();
                    iterator2 = object.iterator();
                    while (iterator2.hasNext()) {
                        Facet facet = (Facet)iterator2.next();
                        this.letOtherThreadsRun();
                        Object object4 = this.kbLock;
                        synchronized (object4) {
                            this.checkAbilityToGenerateFullCache(workInfo);
                            sft = new Sft((Slot)object3, facet, true);
                            list = this.fs.getDirectTemplateFacetValues((Cls)object2, (Slot)object3, facet);
                            if (list != null && !list.isEmpty()) {
                                CacheResult<List> cacheResult = new CacheResult<List>(list, true);
                                this.insertValueUpdate(frame, new CacheRead<RemoteSession, Sft, List>(this.effectiveClient, sft, cacheResult));
                            }
                        }
                        this.afterKbLockHeld();
                    }
                }
            }
            this.letOtherThreadsRun();
            object2 = this.kbLock;
            synchronized (object2) {
                if (workInfo.isTargetFullCache() && !this.server.inTransaction()) {
                    this.insertValueUpdate(frame, new CacheCompleted<RemoteSession, Sft, List>());
                } else if (workInfo.isTargetFullCache()) {
                    this.insertValueUpdate(frame, new CacheAbortComplete<RemoteSession, Sft, List>());
                }
            }
            this.afterKbLockHeld();
        }
        catch (Throwable throwable) {
            Log.getLogger().log(Level.SEVERE, "Exception caught caching frame values", throwable);
            workInfo.setTargetFullCache(false);
            this.insertValueUpdate(frame, new CacheAbortComplete<RemoteSession, Sft, List>());
        }
        finally {
            this.stats.completeWork();
        }
    }

    private void checkAbilityToGenerateFullCache(WorkInfo workInfo) {
        if (this.server.inTransaction() && workInfo.isTargetFullCache()) {
            if (log.isLoggable(Level.FINE)) {
                log.fine("Found transaction in progress - can't complete cache for frame " + workInfo.getFrame());
            }
            workInfo.setTargetFullCache(false);
            this.insertValueUpdate(workInfo.getFrame(), new CacheAbortComplete<RemoteSession, Sft, List>());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addFollowedExprs(Frame frame, Slot slot, List list) {
        Object object = this.requestLock;
        synchronized (object) {
            if (this.machine == null) {
                return;
            }
            WorkInfo workInfo = this.requestMap.get(new ClientAndFrame(this.effectiveClient, frame));
            if (workInfo == null) {
                return;
            }
            for (ServerCachedState serverCachedState : workInfo.getStates()) {
                if (log.isLoggable(Level.FINER)) {
                    log.finer("Following expr " + frame + " with slot " + slot + " in state " + serverCachedState);
                }
                for (Object e : list) {
                    Frame frame2;
                    ServerCachedState serverCachedState2;
                    if (!(e instanceof Frame) || (serverCachedState2 = this.machine.nextState(serverCachedState, frame, slot, frame2 = (Frame)e)) == null) continue;
                    WorkInfo workInfo2 = this.addRequest(frame2, this.effectiveClient, serverCachedState2, CacheRequestReason.STATE_MACHINE, true);
                    if (workInfo2 != null) {
                        workInfo2.setClient(workInfo.getClient());
                    }
                    if (!log.isLoggable(Level.FINE)) continue;
                    log.fine("Added cache request frame for state transition " + frame + " x " + serverCachedState + " -> " + frame2 + " x " + serverCachedState2);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public WorkInfo addRequest(Frame frame, RemoteSession remoteSession, CacheRequestReason cacheRequestReason) {
        Object object = this.requestLock;
        synchronized (object) {
            return this.addRequest(frame, remoteSession, this.machine == null ? null : this.machine.getInitialState(), cacheRequestReason, false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public WorkInfo addRequest(Frame frame, RemoteSession remoteSession, ServerCachedState serverCachedState, CacheRequestReason cacheRequestReason, boolean bl) {
        if (this.inFrameCalculatorThread() && !bl) {
            return null;
        }
        if (this.isDisabled(remoteSession)) {
            return null;
        }
        if (cacheRequestReason != CacheRequestReason.PRELOAD && cacheRequestReason != CacheRequestReason.IMMEDIATE_PRELOAD && this.sessionMap.get(remoteSession).getBandWidthPolicy().stopSending()) {
            return null;
        }
        if (frame.getKnowledgeBase() == null) {
            log.log(Level.WARNING, "Non-localized frame being added to the FrameCalculator", new Exception());
        }
        Object object = this.requestLock;
        synchronized (object) {
            ClientAndFrame clientAndFrame = new ClientAndFrame(remoteSession, frame);
            WorkInfo workInfo = this.requestMap.get(clientAndFrame);
            if (workInfo == null) {
                if (log.isLoggable(Level.FINE)) {
                    log.fine("Added " + frame.getFrameID() + " in state " + serverCachedState + " with reason " + (Object)((Object)cacheRequestReason) + " to head of frames to precalculate");
                }
                workInfo = new WorkInfo();
                workInfo.setClient(remoteSession);
                workInfo.setFrame(frame);
                this.requestMap.put(clientAndFrame, workInfo);
            } else {
                if (log.isLoggable(Level.FINE)) {
                    log.fine("Updating state for " + frame.getFrameID() + " to include " + serverCachedState);
                }
                this.requests.remove(workInfo);
            }
            workInfo.addState(serverCachedState);
            workInfo.addReason(cacheRequestReason);
            workInfo.setNewest();
            this.requests.add(workInfo);
            this.requestLock.notify();
            return workInfo;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeRequest(WorkInfo workInfo) {
        Object object = this.requestLock;
        synchronized (object) {
            this.requests.remove(workInfo);
            this.requestMap.remove(new ClientAndFrame(workInfo.getClient(), workInfo.getFrame()));
        }
    }

    private void insertValueUpdate(Frame frame, SerializedCacheUpdate<RemoteSession, Sft, List> serializedCacheUpdate) {
        Registration registration;
        if (log.isLoggable(Level.FINEST)) {
            log.finest("For frame " + frame.getName() + " inserted value update " + serializedCacheUpdate);
        }
        if ((registration = this.sessionMap.get(this.effectiveClient)) == null) {
            return;
        }
        registration.getBandWidthPolicy().addItemToWaitList();
        this.server.updateEvents(this.effectiveClient);
        this.server.addReadUpdate(this.effectiveClient, frame, serializedCacheUpdate);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deregister(RemoteSession remoteSession) {
        Object object = this.requestLock;
        synchronized (object) {
            ArrayList<WorkInfo> arrayList = new ArrayList<WorkInfo>();
            for (WorkInfo workInfo : this.requests) {
                if (!workInfo.getClient().equals(remoteSession)) continue;
                arrayList.add(workInfo);
            }
            for (WorkInfo workInfo : arrayList) {
                this.requests.remove(workInfo);
                this.requestMap.remove(workInfo.getClientAndFrame());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isDisabled(RemoteSession remoteSession) {
        Object object = this.requestLock;
        synchronized (object) {
            return disabled || remoteSession == null || this.sessionMap.get(remoteSession) == null || this.disabledSessions.contains(remoteSession);
        }
    }

    public static void setDisabled(boolean bl) {
        disabled = bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean setDisabled(boolean bl, RemoteSession remoteSession) {
        Object object = this.requestLock;
        synchronized (object) {
            boolean bl2 = this.disabledSessions.contains(remoteSession);
            if (bl) {
                this.disabledSessions.add(remoteSession);
            } else {
                this.disabledSessions.remove(remoteSession);
            }
            return bl2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FrameCalculatorStats getStats() {
        HashMap<RemoteSession, Integer> hashMap = new HashMap<RemoteSession, Integer>();
        Object object = this.requestLock;
        synchronized (object) {
            for (WorkInfo workInfo : this.requests) {
                RemoteSession remoteSession = workInfo.getClient();
                Integer n = (Integer)hashMap.get(remoteSession);
                if (n == null) {
                    hashMap.put(remoteSession, 1);
                    continue;
                }
                hashMap.put(remoteSession, n + 1);
            }
        }
        this.stats.setPreCacheBackLog(hashMap);
        return this.stats;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void logRequests() {
        block19: {
            if (log.isLoggable(Level.FINE)) {
                try {
                    if (log.isLoggable(Level.FINER)) {
                        TreeSet<WorkInfo> treeSet;
                        Iterator iterator = this.requestLock;
                        synchronized (iterator) {
                            treeSet = new TreeSet<WorkInfo>(this.requests);
                        }
                        log.fine("Request queue has size " + treeSet.size());
                        for (WorkInfo workInfo : treeSet) {
                            log.finer("Request for frame" + workInfo.getFrame());
                            log.finer("\tClient = " + workInfo.getClient());
                            log.finer("\tStates = " + workInfo.getStates());
                            log.finer("\tReasons = " + workInfo.getReasons());
                        }
                        break block19;
                    }
                    EnumMap<CacheRequestReason, Integer> enumMap = new EnumMap<CacheRequestReason, Integer>(CacheRequestReason.class);
                    HashMap<ServerCachedState, Integer> hashMap = new HashMap<ServerCachedState, Integer>();
                    for (CacheRequestReason object3 : CacheRequestReason.values()) {
                        enumMap.put(object3, 0);
                    }
                    Object object = this.requestLock;
                    synchronized (object) {
                        log.fine("Request queue has size " + this.requests.size());
                        for (WorkInfo workInfo : this.requests) {
                            for (Object object2 : workInfo.getStates()) {
                                Integer n = (Integer)hashMap.get(object2);
                                if (n == null) {
                                    n = 0;
                                }
                                hashMap.put((ServerCachedState)object2, n + 1);
                            }
                        }
                        for (WorkInfo workInfo : this.requests) {
                            for (Object object2 : workInfo.getReasons()) {
                                enumMap.put((CacheRequestReason)((Object)object2), (Integer)enumMap.get(object2) + 1);
                            }
                        }
                    }
                    for (Object object4 : hashMap.keySet()) {
                        if (hashMap.get(object4) == null) continue;
                        log.fine("\tCount for state " + object4 + " = " + hashMap.get(object4));
                    }
                    for (CacheRequestReason cacheRequestReason : CacheRequestReason.values()) {
                        if ((Integer)enumMap.get((Object)cacheRequestReason) == 0) continue;
                        log.fine("\tCount for reason " + cacheRequestReason + " = " + enumMap.get((Object)cacheRequestReason));
                    }
                }
                catch (Throwable throwable) {
                    log.log(Level.FINE, "Could not log requests", throwable);
                }
            }
        }
    }

    public Object getRequestLock() {
        return this.requestLock;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean inFrameCalculatorThread() {
        Object object = this.requestLock;
        synchronized (object) {
            if (this.innerThread == null) {
                return false;
            }
            return Thread.currentThread().equals(this.innerThread);
        }
    }

    private void letOtherThreadsRun() {
        if (log.isLoggable(Level.FINE)) {
            this.startOfLockHeldTime = System.currentTimeMillis();
        }
        this.server.letOtherThreadsRun();
    }

    private void afterKbLockHeld() {
        if (log.isLoggable(Level.FINE)) {
            log.fine("Knowledge Base Lock held for " + (System.currentTimeMillis() - this.startOfLockHeldTime));
        }
    }

    private WorkInfo getWorkInfo() {
        Object object = this.requestLock;
        synchronized (object) {
            block5: while (true) {
                while (true) {
                    ArrayList<WorkInfo> arrayList = new ArrayList<WorkInfo>();
                    for (WorkInfo workInfo : this.requests) {
                        if (workInfo.expired()) {
                            arrayList.add(workInfo);
                            continue;
                        }
                        if (!workInfo.getReasons().contains((Object)CacheRequestReason.PRELOAD) && !workInfo.getReasons().contains((Object)CacheRequestReason.IMMEDIATE_PRELOAD) && this.sessionMap.get(workInfo.getClient()).getBandWidthPolicy().stopSending()) continue;
                        return workInfo;
                    }
                    for (WorkInfo workInfo : arrayList) {
                        this.removeRequest(workInfo);
                    }
                    try {
                        if (this.requests.isEmpty()) {
                            this.requestLock.wait();
                            continue block5;
                        }
                        this.requestLock.wait(WAIT_FOR_OVERLOADED_CLIENT);
                        continue block5;
                    }
                    catch (InterruptedException interruptedException) {
                        log.log(Level.WARNING, "Unexpected interrupt", interruptedException);
                        continue;
                    }
                    break;
                }
            }
        }
    }

    public static FrameCalculator getFrameCalculator(KnowledgeBase knowledgeBase) {
        ServerProject serverProject = Server.getInstance().getServerProject(knowledgeBase.getProject());
        if (serverProject == null) {
            return null;
        }
        ServerFrameStore serverFrameStore = (ServerFrameStore)serverProject.getDomainKbFrameStore(null);
        return serverFrameStore.getFrameCalculator();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class FrameCalculatorStatsImpl
    implements FrameCalculatorStats,
    Serializable {
        private static final long serialVersionUID = -573113660316027300L;
        private long startWorkTime;
        private long workUnits = 0L;
        private long totalWorkTime = 0L;
        private Map<RemoteSession, Integer> preCacheBacklog;

        private void startWork() {
            this.startWorkTime = System.currentTimeMillis();
        }

        private void completeWork() {
            this.totalWorkTime = this.totalWorkTime + System.currentTimeMillis() - this.startWorkTime;
            ++this.workUnits;
        }

        @Override
        public Map<RemoteSession, Integer> getPreCacheBacklog() {
            return this.preCacheBacklog;
        }

        public void setPreCacheBackLog(Map<RemoteSession, Integer> map) {
            this.preCacheBacklog = map;
        }

        @Override
        public long getPrecalculateTime() {
            return this.workUnits == 0L ? 0L : this.totalWorkTime / this.workUnits;
        }
    }

    private class FrameCalculatorThread
    extends Thread {
        public FrameCalculatorThread() {
            super("Frame Pre-Calculation Thread");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            while (true) {
                try {
                    while (true) {
                        WorkInfo workInfo = FrameCalculator.this.getWorkInfo();
                        long l = System.currentTimeMillis();
                        FrameCalculator.this.doWork(workInfo);
                        Object object = FrameCalculator.this.requestLock;
                        synchronized (object) {
                            FrameCalculator.this.removeRequest(workInfo);
                        }
                        if (!log.isLoggable(Level.FINE)) continue;
                        log.fine("work on frame " + workInfo.getFrame() + " took " + (System.currentTimeMillis() - l));
                        FrameCalculator.this.logRequests();
                    }
                }
                catch (Throwable throwable) {
                    Log.getLogger().log(Level.SEVERE, "Exception caught in background frame value evaluator", throwable);
                    continue;
                }
                break;
            }
        }
    }
}

