/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protege.storage.clips;

import edu.stanford.smi.protege.util.FileUtilities;
import edu.stanford.smi.protege.util.Log;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;

public class ClipsUtil {
    public static final String TOP_LEVEL_SLOT_CLASS = ":CLIPS_TOP_LEVEL_SLOT_CLASS";
    public static final String FALSE = "FALSE";
    public static final String TRUE = "TRUE";
    private static char REAL_SPACE = (char)32;
    private static char FAKE_SPACE = (char)94;

    private static String replace(String string, char c, char c2) {
        String string2;
        int n = string.indexOf(c);
        if (n == -1) {
            string2 = string;
        } else {
            StringBuffer stringBuffer = new StringBuffer(string);
            int n2 = n;
            while (n2 != -1) {
                stringBuffer.setCharAt(n2, c2);
                n2 = string.indexOf(c, n2 + 1);
            }
            string2 = stringBuffer.toString();
        }
        return string2.intern();
    }

    public static String toExternalString(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append('\"');
        block6: for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            switch (c) {
                case '\n': {
                    stringBuffer.append("\\n");
                    continue block6;
                }
                case '\r': {
                    continue block6;
                }
                case '\"': {
                    stringBuffer.append("\\\"");
                    continue block6;
                }
                case '\\': {
                    stringBuffer.append("\\\\");
                    continue block6;
                }
                default: {
                    stringBuffer.append(c);
                }
            }
        }
        stringBuffer.append('\"');
        return stringBuffer.toString();
    }

    public static String toExternalSymbol(String string) {
        String string2;
        try {
            string2 = URLEncoder.encode(string, FileUtilities.getWriteEncoding());
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            string2 = string;
            Log.getLogger().warning(unsupportedEncodingException.getMessage());
        }
        return string2;
    }

    public static String toInternalString(String string) {
        String string2;
        if (string.charAt(0) == '\"') {
            int n = string.length();
            int n2 = 0;
            char[] cArray = new char[n];
            for (int i = 1; i < n - 1; ++i) {
                int n3 = string.charAt(i);
                if (n3 == 92) {
                    if ((n3 = string.charAt(++i)) == 110) {
                        n3 = 10;
                    } else if (n3 == 114) continue;
                }
                cArray[n2] = n3;
                ++n2;
            }
            string2 = new String(cArray, 0, n2);
        } else {
            string2 = string;
        }
        return string2.intern();
    }

    public static String toInternalSymbol(String string) {
        String string2 = ClipsUtil.replace(string, FAKE_SPACE, REAL_SPACE);
        try {
            string2 = URLDecoder.decode(string2, FileUtilities.getReadEncoding()).intern();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return string2.intern();
    }
}

