/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protege.storage.clips;

import edu.stanford.smi.protege.model.KnowledgeBaseSourcesEditor;
import edu.stanford.smi.protege.storage.clips.ClipsKnowledgeBaseFactory;
import edu.stanford.smi.protege.util.FileField;
import edu.stanford.smi.protege.util.PropertyList;
import java.awt.BorderLayout;
import java.awt.Component;
import java.net.URI;
import javax.swing.Box;
import javax.swing.JComponent;
import javax.swing.JPanel;

public class FileSourcesPanel
extends KnowledgeBaseSourcesEditor {
    private static final long serialVersionUID = -6725659436464810319L;
    private FileField _clsesField;
    private FileField _instancesField;

    public FileSourcesPanel(String string, PropertyList propertyList) {
        super(string, propertyList);
        Box box = Box.createVerticalBox();
        box.add(this.createClsesField());
        box.add(this.createInstancesField());
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.add((Component)box, "North");
        this.add(jPanel);
    }

    public URI getProjectURI() {
        return null;
    }

    public void saveContents() {
        String string = this.getBaseFile(this._clsesField);
        String string2 = this.getBaseFile(this._instancesField);
        ClipsKnowledgeBaseFactory.setSourceFiles(this.getSources(), string, string2);
    }

    public boolean validateContents() {
        return true;
    }

    protected JComponent createClsesField() {
        String string = ClipsKnowledgeBaseFactory.getClsesSourceFile(this.getSources());
        this._clsesField = new FileField("Classes file name", string, ".pont", "Ontology");
        return this._clsesField;
    }

    protected JComponent createInstancesField() {
        String string = ClipsKnowledgeBaseFactory.getInstancesSourceFile(this.getSources());
        this._instancesField = new FileField("Instances file name", string, ".pins", "Instances");
        return this._instancesField;
    }

    public void onProjectPathChange(String string, String string2) {
        super.onProjectPathChange(string, string2);
        if (string2 != null) {
            this.updatePath(this._clsesField, string2, ".pont");
            this.updatePath(this._instancesField, string2, ".pins");
        }
    }
}

