/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protege.storage.database;

import edu.stanford.smi.protege.model.Cls;
import edu.stanford.smi.protege.model.Facet;
import edu.stanford.smi.protege.model.Frame;
import edu.stanford.smi.protege.model.FrameFactory;
import edu.stanford.smi.protege.model.FrameID;
import edu.stanford.smi.protege.model.KnowledgeBase;
import edu.stanford.smi.protege.model.Model;
import edu.stanford.smi.protege.model.Reference;
import edu.stanford.smi.protege.model.Slot;
import edu.stanford.smi.protege.model.framestore.MergingNarrowFrameStore;
import edu.stanford.smi.protege.model.framestore.NarrowFrameStore;
import edu.stanford.smi.protege.model.framestore.ReferenceImpl;
import edu.stanford.smi.protege.model.framestore.Sft;
import edu.stanford.smi.protege.server.RemoteSession;
import edu.stanford.smi.protege.storage.database.AbstractDatabaseFrameDb;
import edu.stanford.smi.protege.storage.database.DatabaseUtils;
import edu.stanford.smi.protege.util.Log;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultDatabaseFrameDb
extends AbstractDatabaseFrameDb {
    private static final String FRAME_COLUMN = "frame";
    private static final String FRAME_TYPE_COLUMN = "frame_type";
    private static final String SLOT_COLUMN = "slot";
    private static final String FACET_COLUMN = "facet";
    private static final String IS_TEMPLATE_COLUMN = "is_template";
    private static final String VALUE_INDEX_COLUMN = "value_index";
    private static final String VALUE_TYPE_COLUMN = "value_type";
    private static final String SHORT_VALUE_COLUMN = "short_value";
    private static final String LONG_VALUE_COLUMN = "long_value";
    private static boolean _isModifiable = true;
    private static int lastReturnedFrameID;
    private String _referencesText;
    private String _matchingReferencesText;
    private String _removeValueText;
    private String _removeValuesText;
    private String _addValuesText;
    private String _maxIndexText;
    private String _framesText;
    private String _framesWithAnyValueText;
    private String _valuesText;
    private String _valuesCountText;
    private String _frameValuesText;
    private String _allFrameValuesText;
    private String _longValueText;
    private PreparedStatement _addValuesBatchStmt;
    private int _addValuesBatchCounter;
    private static final int MAX_BATCH = 1000;
    private static final Map slotToFacetsCacheMap;
    private static final int LOOP_SIZE = 1000;
    private int loopcount;
    private int nFrames;
    private long previousTime;
    private String replaceFrameTypeCommand;
    private String _matchingFramesCommandForSwizzle;
    private String _updateValueTypeCommandForSwizzle;
    private String _countFramesText;
    private String _getFramesText;
    private String _getFrameFromIdText;
    private String _updateFrameFieldText;
    private String _updateSlotFieldText;
    private String _updateFacetFieldText;
    private String _replaceNameText;
    private String _matchingFramesCommandForRename;
    private String _updateValueFieldTextForRename;

    @Override
    public Set getClosure(Frame frame, Slot slot, Facet facet, boolean bl) {
        throw new UnsupportedOperationException();
    }

    public String getTable() {
        return this._table;
    }

    public static void setModifiable(boolean bl) {
        _isModifiable = bl;
    }

    public void ensureEmptyTableExists() throws SQLException {
        this.dropTableIfItExists();
        this.createTable();
    }

    private void dropTableIfItExists() {
        try {
            this.getCurrentConnection().closeStatements();
            String string = "DROP TABLE " + this._table;
            this.executeUpdate(string);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void createTable() throws SQLException {
        String string = "CREATE TABLE " + this._table + " (";
        string = string + "frame " + this.getFrameDataType() + " NOT NULL, ";
        string = string + "frame_type " + this.getFrameTypeDataType() + " NOT NULL, ";
        string = string + "slot " + this.getFrameDataType() + " NOT NULL, ";
        string = string + "facet " + this.getFrameDataType() + " NOT NULL, ";
        string = string + "is_template " + this.getIsTemplateDataType() + " NOT NULL, ";
        string = string + "value_index " + this.getValueIndexDataType() + " NOT NULL, ";
        string = string + "value_type " + this.getFrameTypeDataType() + " NOT NULL, ";
        string = string + "short_value " + this.getShortValueDataType() + ", ";
        string = string + "long_value " + this.getLongValueDataType();
        string = string + ")";
        if (this.checkMySQLBug()) {
            string = string + " ENGINE = INNODB DEFAULT CHARACTER SET 'utf8'";
        }
        try {
            this.executeUpdate(string);
            if (log.isLoggable(Level.FINE)) {
                log.fine("Created table with command '" + string + "'");
            }
            this.createIndices();
        }
        catch (SQLException sQLException) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("Failed to create table on database ");
            stringBuffer.append(this.getCurrentConnection().getDatabaseProductName());
            stringBuffer.append(" with command '");
            stringBuffer.append(string);
            stringBuffer.append("' :");
            stringBuffer.append(sQLException.getMessage());
            Log.getLogger().warning(stringBuffer.toString());
            throw sQLException;
        }
    }

    private String getFrameDataType() throws SQLException {
        String string = this.getCurrentConnection().getFrameNameType();
        return string;
    }

    private String getFrameTypeDataType() throws SQLException {
        return this.getCurrentConnection().getSmallIntTypeName();
    }

    private String getIsTemplateDataType() throws SQLException {
        return this.getCurrentConnection().getBitTypeName();
    }

    private String getValueIndexDataType() throws SQLException {
        return this.getCurrentConnection().getIntegerTypeName();
    }

    private String getShortValueDataType() throws SQLException {
        return this.getCurrentConnection().getShortValueType();
    }

    private String getLongValueDataType() throws SQLException {
        return this.getCurrentConnection().getLongvarcharTypeName();
    }

    public boolean checkMySQLBug() {
        try {
            if (this.getCurrentConnection().isMySql() && this.getCurrentConnection().getDatabaseMajorVersion() == 5) {
                if (log.isLoggable(Level.FINE)) {
                    log.fine("Found mysql 5.0 - correcting for mysql bug 16121.");
                }
                return true;
            }
        }
        catch (Exception exception) {
            Log.getLogger().log(Level.WARNING, "Exception caught checking database version", exception);
            Log.getLogger().warning("Unable to check database version with this jdbc driver");
            Log.getLogger().warning("If this database is mysql 5 then protege will perform incorrectly");
        }
        return false;
    }

    private void createIndices() throws SQLException {
        log.info("Creating database indicies:");
        LapTimer lapTimer = new LapTimer();
        String string = "CREATE INDEX " + this._table + "_I1 ON " + this._table;
        string = string + " (frame, slot, facet, is_template, value_index)";
        this.executeUpdate(string);
        if (log.isLoggable(Level.FINE)) {
            log.fine("\t..._I1 created (" + lapTimer.lap() / 1000L + "s).");
        }
        string = "CREATE INDEX " + this._table + "_I2 ON " + this._table;
        string = string + " (short_value)";
        this.executeUpdate(string);
        if (log.isLoggable(Level.FINE)) {
            log.fine("\t..._I2 created (" + lapTimer.lap() / 1000L + "s).");
        }
        string = "CREATE INDEX " + this._table + "_I4 ON " + this._table;
        string = string + " (slot, frame_type)";
        this.executeUpdate(string);
        if (log.isLoggable(Level.FINE)) {
            log.fine("\t..._I4 created (" + lapTimer.lap() / 1000L + "s).");
        }
        if (this.needsIndexOnLowerValue()) {
            log.info("\t..._I3 created (" + lapTimer.lap() / 1000L + "s).");
            this.createIndexOnLowerValue();
            if (log.isLoggable(Level.FINE)) {
                log.fine("\t..._IV created (" + lapTimer.lap() / 1000L + "s).");
            }
        } else if (log.isLoggable(Level.FINE)) {
            log.info("\t..._I3 created (" + lapTimer.lap() / 1000L + "s).");
        }
        log.info("All database indexes created (" + lapTimer.total() / 1000L + "s).");
    }

    private boolean needsIndexOnLowerValue() throws SQLException {
        return !this.getCurrentConnection().supportsCaseInsensitiveMatches() && this.getCurrentConnection().supportsIndexOnFunction();
    }

    private void createIndexOnLowerValue() throws SQLException {
        String string = "CREATE INDEX " + this._table + "_IV ON " + this._table + "(LOWER(" + SHORT_VALUE_COLUMN + "))";
        this.executeUpdate(string);
    }

    @Override
    public void deleteFrame(Frame frame) {
        DefaultDatabaseFrameDb.checkModifiability();
        try {
            this.deleteFrameSQL(frame);
        }
        catch (SQLException sQLException) {
            throw this.createRuntimeException(sQLException);
        }
    }

    private void deleteFrameSQL(Frame frame) throws SQLException {
        String string = "DELETE FROM " + this._table + " WHERE " + FRAME_COLUMN + " = ?";
        PreparedStatement preparedStatement = this.getCurrentConnection().getPreparedStatement(string);
        DefaultDatabaseFrameDb.setFrame(preparedStatement, 1, frame);
        DefaultDatabaseFrameDb.executeUpdate(preparedStatement);
        String string2 = "DELETE FROM " + this._table;
        string2 = string2 + " WHERE short_value = ? AND value_type = ?";
        PreparedStatement preparedStatement2 = this.getCurrentConnection().getPreparedStatement(string2);
        this.setShortValue(preparedStatement2, 1, 2, frame);
        DefaultDatabaseFrameDb.executeUpdate(preparedStatement2);
        if (frame instanceof Slot) {
            String string3 = "DELETE FROM " + this._table + " WHERE " + SLOT_COLUMN + " = ?";
            PreparedStatement preparedStatement3 = this.getCurrentConnection().getPreparedStatement(string3);
            DefaultDatabaseFrameDb.setFrame(preparedStatement3, 1, frame);
            DefaultDatabaseFrameDb.executeUpdate(preparedStatement3);
        } else if (frame instanceof Facet) {
            String string4 = "DELETE FROM " + this._table + " WHERE " + FACET_COLUMN + " = ?";
            PreparedStatement preparedStatement4 = this.getCurrentConnection().getPreparedStatement(string4);
            DefaultDatabaseFrameDb.setFrame(preparedStatement4, 1, frame);
            DefaultDatabaseFrameDb.executeUpdate(preparedStatement4);
        }
    }

    @Override
    public Set<Reference> getReferences(Object object) {
        try {
            return this.getReferencesSQL(object);
        }
        catch (SQLException sQLException) {
            throw this.createRuntimeException(sQLException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Set<Reference> getReferencesSQL(Object object) throws SQLException {
        if (this._referencesText == null) {
            this._referencesText = "SELECT short_value, frame, frame_type, slot, facet, is_template";
            this._referencesText = this._referencesText + " FROM " + this._table;
            this._referencesText = this._referencesText + " WHERE short_value = ?";
            this._referencesText = this._referencesText + " AND value_type = ?";
        }
        PreparedStatement preparedStatement = this.getCurrentConnection().getPreparedStatement(this._referencesText);
        this.setShortValue(preparedStatement, 1, 2, object);
        HashSet<Reference> hashSet = new HashSet<Reference>();
        ResultSet resultSet = DefaultDatabaseFrameDb.executeQuery(preparedStatement);
        try {
            while (resultSet.next()) {
                Object object2;
                boolean bl = true;
                if (object instanceof String) {
                    object2 = resultSet.getString(1);
                    bl = object.toString().equals(object2);
                }
                if (!bl) continue;
                object2 = this.getFrame(resultSet, 2, 3);
                Slot slot = this.getSlot(resultSet, 4);
                Facet facet = this.getFacet(resultSet, 5);
                boolean bl2 = DefaultDatabaseFrameDb.getIsTemplate(resultSet, 6);
                hashSet.add(new ReferenceImpl((Frame)object2, slot, facet, bl2));
            }
        }
        finally {
            resultSet.close();
        }
        return hashSet;
    }

    @Override
    public Set<Reference> getMatchingReferences(String string, int n) {
        try {
            return this.getMatchingReferencesSQL(string, n);
        }
        catch (SQLException sQLException) {
            throw this.createRuntimeException(sQLException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Set<Reference> getMatchingReferencesSQL(String string, int n) throws SQLException {
        if (this._matchingReferencesText == null) {
            this._matchingReferencesText = "SELECT frame, frame_type, slot, facet";
            this._matchingReferencesText = this._matchingReferencesText + ", is_template";
            this._matchingReferencesText = this._matchingReferencesText + " FROM " + this._table;
            this._matchingReferencesText = this._matchingReferencesText + " WHERE value_type = " + DatabaseUtils.getStringValueType();
            this._matchingReferencesText = this._matchingReferencesText + " AND " + this.getShortValueMatchColumn();
            this._matchingReferencesText = this._matchingReferencesText + " LIKE '";
        }
        String string2 = this._matchingReferencesText + this.getMatchString(string) + "' " + this.getEscapeClause();
        HashSet<Reference> hashSet = new HashSet<Reference>();
        ResultSet resultSet = this.executeQuery(string2, n);
        try {
            while (resultSet.next()) {
                Frame frame = this.getFrame(resultSet, 1, 2);
                Slot slot = this.getSlot(resultSet, 3);
                Facet facet = this.getFacet(resultSet, 4);
                boolean bl = DefaultDatabaseFrameDb.getIsTemplate(resultSet, 5);
                hashSet.add(new ReferenceImpl(frame, slot, facet, bl));
            }
        }
        finally {
            resultSet.close();
        }
        return hashSet;
    }

    @Override
    public void removeValue(Frame frame, Slot slot, Facet facet, boolean bl, Object object) {
        DefaultDatabaseFrameDb.checkModifiability();
        try {
            this.removeValueSQL(frame, slot, facet, bl, object);
        }
        catch (SQLException sQLException) {
            throw this.createRuntimeException(sQLException);
        }
    }

    private void removeValueSQL(Frame frame, Slot slot, Facet facet, boolean bl, Object object) throws SQLException {
        if (this._removeValueText == null) {
            this._removeValueText = "DELETE FROM " + this._table;
            this._removeValueText = this._removeValueText + " WHERE frame = ?";
            this._removeValueText = this._removeValueText + " AND slot = ?";
            this._removeValueText = this._removeValueText + " AND facet = ?";
            this._removeValueText = this._removeValueText + " AND is_template = ?";
            this._removeValueText = this._removeValueText + " AND short_value = ?";
            this._removeValueText = this._removeValueText + " AND value_type = ?";
        }
        PreparedStatement preparedStatement = this.getCurrentConnection().getPreparedStatement(this._removeValueText);
        DefaultDatabaseFrameDb.setFrame(preparedStatement, 1, frame);
        DefaultDatabaseFrameDb.setSlot(preparedStatement, 2, slot);
        DefaultDatabaseFrameDb.setFacet(preparedStatement, 3, facet);
        DefaultDatabaseFrameDb.setIsTemplate(preparedStatement, 4, bl);
        this.setShortValue(preparedStatement, 5, 6, object);
        DefaultDatabaseFrameDb.executeUpdate(preparedStatement);
    }

    public void removeValues(Frame frame, Slot slot, Facet facet, boolean bl) {
        DefaultDatabaseFrameDb.checkModifiability();
        try {
            this.removeValuesSQL(frame, slot, facet, bl);
        }
        catch (SQLException sQLException) {
            throw this.createRuntimeException(sQLException);
        }
    }

    private void removeValuesSQL(Frame frame, Slot slot, Facet facet, boolean bl) throws SQLException {
        if (this._removeValuesText == null) {
            this._removeValuesText = "DELETE FROM " + this._table;
            this._removeValuesText = this._removeValuesText + " WHERE frame = ?";
            this._removeValuesText = this._removeValuesText + " AND slot = ?";
            this._removeValuesText = this._removeValuesText + " AND facet = ?";
            this._removeValuesText = this._removeValuesText + " AND is_template = ?";
        }
        PreparedStatement preparedStatement = this.getCurrentConnection().getPreparedStatement(this._removeValuesText);
        DefaultDatabaseFrameDb.setFrame(preparedStatement, 1, frame);
        DefaultDatabaseFrameDb.setSlot(preparedStatement, 2, slot);
        DefaultDatabaseFrameDb.setFacet(preparedStatement, 3, facet);
        DefaultDatabaseFrameDb.setIsTemplate(preparedStatement, 4, bl);
        DefaultDatabaseFrameDb.executeUpdate(preparedStatement);
    }

    @Override
    public void addValues(Frame frame, Slot slot, Facet facet, boolean bl, Collection collection) {
        try {
            int n = this.getMaxIndex(frame, slot, facet, bl);
            this.addValuesSQL(frame, slot, facet, bl, collection, n + 1);
        }
        catch (SQLException sQLException) {
            throw this.createRuntimeException(sQLException);
        }
    }

    private PreparedStatement getAddValuesStatement() throws SQLException {
        if (this._addValuesText == null) {
            this._addValuesText = "INSERT INTO " + this._table;
            this._addValuesText = this._addValuesText + " (frame, frame_type, slot, facet, is_template, ";
            this._addValuesText = this._addValuesText + "value_index, short_value, long_value, value_type)";
            this._addValuesText = this._addValuesText + " VALUES(?, ?, ?, ?, ?, ?, ?, ?, ?)";
        }
        return this.getCurrentConnection().getPreparedStatement(this._addValuesText);
    }

    private void addValuesSQL(Frame frame, Slot slot, Facet facet, boolean bl, Collection collection, int n) throws SQLException {
        PreparedStatement preparedStatement = this.getAddValuesStatement();
        boolean bl2 = collection.size() > 1 && this.getCurrentConnection().supportsBatch();
        DefaultDatabaseFrameDb.setFrame(preparedStatement, 1, 2, frame, this._frameFactory);
        DefaultDatabaseFrameDb.setSlot(preparedStatement, 3, slot);
        DefaultDatabaseFrameDb.setFacet(preparedStatement, 4, facet);
        DefaultDatabaseFrameDb.setIsTemplate(preparedStatement, 5, bl);
        for (Object e : collection) {
            if (DefaultDatabaseFrameDb.isNullValue(e)) {
                Log.getLogger().warning("Skiping null value");
                continue;
            }
            DefaultDatabaseFrameDb.setValueIndex(preparedStatement, 6, n);
            this.setValue(preparedStatement, 7, 8, 9, e);
            if (bl2) {
                preparedStatement.addBatch();
            } else {
                DefaultDatabaseFrameDb.executeUpdate(preparedStatement);
            }
            ++n;
        }
        if (bl2) {
            preparedStatement.executeBatch();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int getMaxIndex(Frame frame, Slot slot, Facet facet, boolean bl) throws SQLException {
        if (this._maxIndexText == null) {
            this._maxIndexText = "SELECT MAX(value_index)";
            this._maxIndexText = this._maxIndexText + " FROM " + this._table;
            this._maxIndexText = this._maxIndexText + " WHERE frame = ?";
            this._maxIndexText = this._maxIndexText + " AND slot = ? ";
            this._maxIndexText = this._maxIndexText + " AND facet = ? ";
            this._maxIndexText = this._maxIndexText + " AND is_template = ? ";
        }
        PreparedStatement preparedStatement = this.getCurrentConnection().getPreparedStatement(this._maxIndexText);
        DefaultDatabaseFrameDb.setFrame(preparedStatement, 1, frame);
        DefaultDatabaseFrameDb.setSlot(preparedStatement, 2, slot);
        DefaultDatabaseFrameDb.setFacet(preparedStatement, 3, facet);
        DefaultDatabaseFrameDb.setIsTemplate(preparedStatement, 4, bl);
        int n = -1;
        ResultSet resultSet = DefaultDatabaseFrameDb.executeQuery(preparedStatement);
        try {
            if (resultSet.next()) {
                n = resultSet.getInt(1);
            }
        }
        finally {
            resultSet.close();
        }
        return n;
    }

    @Override
    public void moveValue(Frame frame, Slot slot, Facet facet, boolean bl, int n, int n2) {
        DefaultDatabaseFrameDb.checkModifiability();
        List list = this.getValues(frame, slot, facet, bl);
        Object e = list.remove(n);
        list.add(n2, e);
        this.setValues(frame, slot, facet, bl, list);
    }

    @Override
    public Set<Frame> getMatchingFrames(Slot slot, Facet facet, boolean bl, String string, int n) {
        try {
            return this.getMatchingFramesSQL(slot, facet, bl, string, n);
        }
        catch (SQLException sQLException) {
            throw this.createRuntimeException(sQLException);
        }
    }

    private String getShortValueMatchColumn() throws SQLException {
        String string = this.getCurrentConnection().supportsCaseInsensitiveMatches() ? SHORT_VALUE_COLUMN : "LOWER(short_value)";
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Set<Frame> getMatchingFramesSQL(Slot slot, Facet facet, boolean bl, String string, int n) throws SQLException {
        String string2 = "SELECT frame, frame_type, slot, facet, is_template";
        string2 = string2 + " FROM " + this._table;
        string2 = string2 + " WHERE value_type = " + DatabaseUtils.getStringValueType();
        string2 = string2 + " AND (" + this.getShortValueMatchColumn() + " LIKE '" + this.getMatchString(string) + "' " + this.getEscapeClause();
        string2 = string2 + " OR long_value LIKE '" + this.getMatchString(string) + "' " + this.getEscapeClause() + " )";
        HashSet<Frame> hashSet = new HashSet<Frame>();
        ResultSet resultSet = this.executeQuery(string2);
        try {
            while (resultSet.next()) {
                Frame frame = this.getFrame(resultSet, 1, 2);
                String string3 = resultSet.getString(3);
                String string4 = resultSet.getString(4);
                boolean bl2 = resultSet.getBoolean(5);
                if (!DefaultDatabaseFrameDb.equals(string3, slot) || !DefaultDatabaseFrameDb.equals(string4, facet) || bl2 != bl) continue;
                hashSet.add(frame);
                if (--n != 0) continue;
                break;
            }
        }
        finally {
            resultSet.close();
        }
        return hashSet;
    }

    private static boolean equals(String string, Frame frame) {
        if (frame == null) {
            return string.equals("");
        }
        return frame.getName().equals(string);
    }

    private String getMatchString(String string) throws SQLException {
        return DatabaseUtils.getMatchString(string, this.getCurrentConnection().getEscapeCharacter());
    }

    private String getEscapeClause() throws SQLException {
        return this.getCurrentConnection().getEscapeClause();
    }

    public Set getFrames(Slot slot, Facet facet, boolean bl, Object object) {
        try {
            return this.getFramesSQL(slot, facet, bl, object);
        }
        catch (SQLException sQLException) {
            throw this.createRuntimeException(sQLException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Set getFramesSQL(Slot slot, Facet facet, boolean bl, Object object) throws SQLException {
        if (this._framesText == null) {
            this._framesText = "SELECT short_value, frame, frame_type FROM " + this._table;
            this._framesText = this._framesText + " WHERE slot = ?";
            this._framesText = this._framesText + " AND facet = ?";
            this._framesText = this._framesText + " AND is_template = ?";
            this._framesText = this._framesText + " AND short_value = ?";
            this._framesText = this._framesText + " AND value_type = ?";
        }
        PreparedStatement preparedStatement = this.getCurrentConnection().getPreparedStatement(this._framesText);
        DefaultDatabaseFrameDb.setSlot(preparedStatement, 1, slot);
        DefaultDatabaseFrameDb.setFacet(preparedStatement, 2, facet);
        DefaultDatabaseFrameDb.setIsTemplate(preparedStatement, 3, bl);
        this.setShortValue(preparedStatement, 4, 5, object);
        HashSet<Object> hashSet = new HashSet<Object>();
        ResultSet resultSet = DefaultDatabaseFrameDb.executeQuery(preparedStatement);
        try {
            while (resultSet.next()) {
                Object object2;
                boolean bl2 = true;
                if (object instanceof String) {
                    object2 = resultSet.getString(1);
                    bl2 = object.equals(object2);
                }
                if (!bl2) continue;
                object2 = this.getFrame(resultSet, 2, 3);
                hashSet.add(object2);
            }
        }
        finally {
            resultSet.close();
        }
        return hashSet;
    }

    public Set getFramesWithAnyValue(Slot slot, Facet facet, boolean bl) {
        try {
            return this.getFramesWithAnyValueSQL(slot, facet, bl);
        }
        catch (SQLException sQLException) {
            throw this.createRuntimeException(sQLException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Set getFramesWithAnyValueSQL(Slot slot, Facet facet, boolean bl) throws SQLException {
        if (this._framesWithAnyValueText == null) {
            this._framesWithAnyValueText = "SELECT frame, frame_type FROM " + this._table;
            this._framesWithAnyValueText = this._framesWithAnyValueText + " WHERE slot = ?";
            this._framesWithAnyValueText = this._framesWithAnyValueText + " AND facet = ?";
            this._framesWithAnyValueText = this._framesWithAnyValueText + " AND is_template = ?";
        }
        PreparedStatement preparedStatement = this.getCurrentConnection().getPreparedStatement(this._framesWithAnyValueText);
        DefaultDatabaseFrameDb.setSlot(preparedStatement, 1, slot);
        DefaultDatabaseFrameDb.setFacet(preparedStatement, 2, facet);
        DefaultDatabaseFrameDb.setIsTemplate(preparedStatement, 3, bl);
        HashSet<Frame> hashSet = new HashSet<Frame>();
        ResultSet resultSet = DefaultDatabaseFrameDb.executeQuery(preparedStatement);
        try {
            while (resultSet.next()) {
                Frame frame = this.getFrame(resultSet, 1, 2);
                hashSet.add(frame);
            }
        }
        finally {
            resultSet.close();
        }
        return hashSet;
    }

    @Override
    public void setValues(Frame frame, Slot slot, Facet facet, boolean bl, Collection collection) {
        DefaultDatabaseFrameDb.checkModifiability();
        try {
            this.removeValuesSQL(frame, slot, facet, bl);
            this.addValuesSQL(frame, slot, facet, bl, collection, 0);
        }
        catch (SQLException sQLException) {
            throw this.createRuntimeException(sQLException);
        }
    }

    @Override
    public List getValues(Frame frame, Slot slot, Facet facet, boolean bl) {
        List list;
        try {
            list = this.getValuesSQL(frame, slot, facet, bl);
        }
        catch (SQLException sQLException) {
            throw this.createRuntimeException(sQLException);
        }
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List getValuesSQL(Frame frame, Slot slot, Facet facet, boolean bl) throws SQLException {
        if (this._valuesText == null) {
            this._valuesText = "SELECT short_value, value_type, value_index";
            this._valuesText = this._valuesText + " FROM " + this._table;
            this._valuesText = this._valuesText + " WHERE frame = ?";
            this._valuesText = this._valuesText + " AND slot = ?";
            this._valuesText = this._valuesText + " AND facet = ?";
            this._valuesText = this._valuesText + " AND is_template = ?";
            this._valuesText = this._valuesText + " ORDER BY value_index";
        }
        PreparedStatement preparedStatement = this.getCurrentConnection().getPreparedStatement(this._valuesText);
        DefaultDatabaseFrameDb.setFrame(preparedStatement, 1, frame);
        DefaultDatabaseFrameDb.setSlot(preparedStatement, 2, slot);
        DefaultDatabaseFrameDb.setFacet(preparedStatement, 3, facet);
        DefaultDatabaseFrameDb.setIsTemplate(preparedStatement, 4, bl);
        ArrayList<Object> arrayList = new ArrayList<Object>();
        ResultSet resultSet = DefaultDatabaseFrameDb.executeQuery(preparedStatement);
        try {
            while (resultSet.next()) {
                int n;
                Object object = this.getShortValue(resultSet, 1, 2);
                if (object == null && (object = this.getLongValue(frame, slot, facet, bl, n = DefaultDatabaseFrameDb.getIndex(resultSet, 3))) == null) {
                    object = "";
                }
                arrayList.add(object);
            }
        }
        finally {
            resultSet.close();
        }
        return arrayList;
    }

    @Override
    public int getValuesCount(Frame frame, Slot slot, Facet facet, boolean bl) {
        int n = 0;
        try {
            n = this.getValuesCountSQL(frame, slot, facet, bl);
        }
        catch (SQLException sQLException) {
            throw this.createRuntimeException(sQLException);
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int getValuesCountSQL(Frame frame, Slot slot, Facet facet, boolean bl) throws SQLException {
        if (this._valuesCountText == null) {
            this._valuesCountText = "SELECT COUNT(*) ";
            this._valuesCountText = this._valuesCountText + " FROM " + this._table;
            this._valuesCountText = this._valuesCountText + " WHERE frame = ?";
            this._valuesCountText = this._valuesCountText + " AND slot = ?";
            this._valuesCountText = this._valuesCountText + " AND facet = ?";
            this._valuesCountText = this._valuesCountText + " AND is_template = ?";
        }
        PreparedStatement preparedStatement = this.getCurrentConnection().getPreparedStatement(this._valuesCountText);
        DefaultDatabaseFrameDb.setFrame(preparedStatement, 1, frame);
        DefaultDatabaseFrameDb.setSlot(preparedStatement, 2, slot);
        DefaultDatabaseFrameDb.setFacet(preparedStatement, 3, facet);
        DefaultDatabaseFrameDb.setIsTemplate(preparedStatement, 4, bl);
        int n = 0;
        ResultSet resultSet = DefaultDatabaseFrameDb.executeQuery(preparedStatement);
        try {
            while (resultSet.next()) {
                n = resultSet.getInt(1);
            }
        }
        finally {
            resultSet.close();
        }
        return n;
    }

    public Map<Frame, Map<Sft, List>> getFrameValues() {
        try {
            return this.getFrameValuesSQL();
        }
        catch (SQLException sQLException) {
            throw this.createRuntimeException(sQLException);
        }
    }

    @Override
    public Map<Sft, List> getFrameValues(Frame frame) {
        try {
            return this.getFrameValuesSQL(frame);
        }
        catch (SQLException sQLException) {
            throw this.createRuntimeException(sQLException);
        }
    }

    private static String getValue(FrameID frameID) {
        return DatabaseUtils.getValue(frameID);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<Sft, List> getFrameValuesSQL(Frame frame) throws SQLException {
        if (this._frameValuesText == null) {
            this._frameValuesText = "SELECT frame, slot, ";
            this._frameValuesText = this._frameValuesText + "facet, is_template, ";
            this._frameValuesText = this._frameValuesText + "short_value, value_type, value_index";
            this._frameValuesText = this._frameValuesText + " FROM " + this._table;
            this._frameValuesText = this._frameValuesText + " WHERE frame = ?";
            this._frameValuesText = this._frameValuesText + " AND slot <> '" + DefaultDatabaseFrameDb.getValue(Model.SlotID.DIRECT_INSTANCES) + "'";
            this._frameValuesText = this._frameValuesText + " ORDER BY frame, slot, facet, is_template, value_index";
        }
        PreparedStatement preparedStatement = this.getCurrentConnection().getPreparedStatement(this._frameValuesText);
        DefaultDatabaseFrameDb.setFrame(preparedStatement, 1, frame);
        HashMap<Sft, List> hashMap = new HashMap<Sft, List>();
        ResultSet resultSet = DefaultDatabaseFrameDb.executeQuery(preparedStatement);
        try {
            while (resultSet.next()) {
                int n;
                Slot slot = this.getSlot(resultSet, 2);
                Facet facet = this.getFacet(resultSet, 3);
                boolean bl = DefaultDatabaseFrameDb.getIsTemplate(resultSet, 4);
                Object object = this.getShortValue(resultSet, 5, 6);
                if (object == null && (object = this.getLongValue(frame, slot, facet, bl, n = DefaultDatabaseFrameDb.getIndex(resultSet, 7))) == null) {
                    object = "";
                }
                DefaultDatabaseFrameDb.addToMap(hashMap, slot, facet, bl, object);
            }
        }
        finally {
            resultSet.close();
        }
        return hashMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<Frame, Map<Sft, List>> getFrameValuesSQL() throws SQLException {
        if (this._allFrameValuesText == null) {
            this._allFrameValuesText = "SELECT frame, frame_type";
            this._allFrameValuesText = this._allFrameValuesText + ", slot, facet, is_template";
            this._allFrameValuesText = this._allFrameValuesText + ", short_value, value_type, value_index";
            this._allFrameValuesText = this._allFrameValuesText + ", long_value";
            this._allFrameValuesText = this._allFrameValuesText + " FROM " + this._table;
            this._allFrameValuesText = this._allFrameValuesText + " ORDER BY slot, facet, is_template, value_index";
        }
        PreparedStatement preparedStatement = this.getCurrentConnection().getPreparedStatement(this._allFrameValuesText);
        HashMap<Frame, Map<Sft, List>> hashMap = new HashMap<Frame, Map<Sft, List>>();
        ResultSet resultSet = DefaultDatabaseFrameDb.executeQuery(preparedStatement);
        try {
            while (resultSet.next()) {
                Frame frame = this.getFrame(resultSet, 1, 2);
                Slot slot = this.getSlot(resultSet, 3);
                Facet facet = this.getFacet(resultSet, 4);
                boolean bl = DefaultDatabaseFrameDb.getIsTemplate(resultSet, 5);
                Object object = this.getShortValue(resultSet, 6, 7);
                if (object == null && (object = DefaultDatabaseFrameDb.getLongValue(resultSet, 9)) == null) {
                    object = "";
                }
                DefaultDatabaseFrameDb.addToMap(hashMap, frame, slot, facet, bl, object);
            }
        }
        finally {
            resultSet.close();
        }
        return hashMap;
    }

    private static void addToMap(Map<Sft, List> map, Slot slot, Facet facet, boolean bl, Object object) {
        Sft sft = new Sft(slot, facet, bl);
        ArrayList<Object> arrayList = map.get(sft);
        if (arrayList == null) {
            arrayList = new ArrayList<Object>();
            map.put(sft, arrayList);
        }
        arrayList.add(object);
    }

    private static void addToMap(Map<Frame, Map<Sft, List>> map, Frame frame, Slot slot, Facet facet, boolean bl, Object object) {
        Map<Sft, List> map2 = map.get(frame);
        if (map2 == null) {
            map2 = DefaultDatabaseFrameDb.createInitialMap(frame);
            map.put(frame, map2);
        }
        DefaultDatabaseFrameDb.addToMap(map2, slot, facet, bl, object);
    }

    private static Map<Sft, List> createInitialMap(Frame frame) {
        HashMap<Sft, List> hashMap = new HashMap<Sft, List>();
        if (frame instanceof Cls) {
            Slot slot = frame.getKnowledgeBase().getSystemFrames().getDirectInstancesSlot();
            hashMap.put(new Sft(slot, null, false), new ArrayList());
        }
        return hashMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object getLongValue(Frame frame, Slot slot, Facet facet, boolean bl, int n) throws SQLException {
        if (this._longValueText == null) {
            this._longValueText = "SELECT long_value";
            this._longValueText = this._longValueText + " FROM " + this._table;
            this._longValueText = this._longValueText + " WHERE frame = ?";
            this._longValueText = this._longValueText + " AND slot = ?";
            this._longValueText = this._longValueText + " AND facet = ?";
            this._longValueText = this._longValueText + " AND is_template = ?";
            this._longValueText = this._longValueText + " AND value_index = ?";
        }
        PreparedStatement preparedStatement = this.getCurrentConnection().getPreparedStatement(this._longValueText);
        DefaultDatabaseFrameDb.setFrame(preparedStatement, 1, frame);
        DefaultDatabaseFrameDb.setSlot(preparedStatement, 2, slot);
        DefaultDatabaseFrameDb.setFacet(preparedStatement, 3, facet);
        DefaultDatabaseFrameDb.setIsTemplate(preparedStatement, 4, bl);
        DefaultDatabaseFrameDb.setValueIndex(preparedStatement, 5, n);
        Object object = null;
        ResultSet resultSet = DefaultDatabaseFrameDb.executeQuery(preparedStatement);
        try {
            if (resultSet.next()) {
                object = DefaultDatabaseFrameDb.getLongValue(resultSet, 1);
            }
        }
        finally {
            resultSet.close();
        }
        return object;
    }

    private static void setFrame(PreparedStatement preparedStatement, int n, Frame frame) throws SQLException {
        DatabaseUtils.setFrame(preparedStatement, n, frame);
    }

    private static void setFrame(PreparedStatement preparedStatement, int n, int n2, Frame frame, FrameFactory frameFactory) throws SQLException {
        DatabaseUtils.setFrame(preparedStatement, n, n2, frame, frameFactory);
    }

    private static void setSlot(PreparedStatement preparedStatement, int n, Slot slot) throws SQLException {
        DatabaseUtils.setSlot(preparedStatement, n, slot);
    }

    private static void setFacet(PreparedStatement preparedStatement, int n, Facet facet) throws SQLException {
        DatabaseUtils.setFacet(preparedStatement, n, facet);
    }

    private static void setIsTemplate(PreparedStatement preparedStatement, int n, boolean bl) throws SQLException {
        DatabaseUtils.setIsTemplate(preparedStatement, n, bl);
    }

    private void setShortValue(PreparedStatement preparedStatement, int n, int n2, Object object) throws SQLException {
        DatabaseUtils.setShortValue(preparedStatement, n, n2, object, this._frameFactory);
    }

    private void setValue(PreparedStatement preparedStatement, int n, int n2, int n3, Object object) throws SQLException {
        DatabaseUtils.setValue(preparedStatement, n, n2, n3, object, this.getCurrentConnection().getMaxVarcharSize(), this._frameFactory);
    }

    private static void setValueIndex(PreparedStatement preparedStatement, int n, int n2) throws SQLException {
        DatabaseUtils.setValueIndex(preparedStatement, n, n2);
    }

    private Frame getFrame(ResultSet resultSet, int n, int n2) throws SQLException {
        return DatabaseUtils.getFrame(resultSet, n, n2, this._frameFactory, this._isInclude);
    }

    private Slot getSlot(ResultSet resultSet, int n) throws SQLException {
        return DatabaseUtils.getSlot(resultSet, n, this._frameFactory, this._isInclude);
    }

    private Facet getFacet(ResultSet resultSet, int n) throws SQLException {
        return DatabaseUtils.getFacet(resultSet, n, this._frameFactory, this._isInclude);
    }

    private static int getIndex(ResultSet resultSet, int n) throws SQLException {
        return DatabaseUtils.getIndex(resultSet, n);
    }

    private static boolean getIsTemplate(ResultSet resultSet, int n) throws SQLException {
        return DatabaseUtils.getIsTemplate(resultSet, n);
    }

    private Object getShortValue(ResultSet resultSet, int n, int n2) throws SQLException {
        return DatabaseUtils.getShortValue(resultSet, n, n2, this._frameFactory, 0, this._isInclude);
    }

    private static Object getLongValue(ResultSet resultSet, int n) throws SQLException {
        return DatabaseUtils.getLongValue(resultSet, n);
    }

    protected void beginBatch() throws SQLException {
        this._addValuesBatchStmt = this.getAddValuesStatement();
        this.getCurrentConnection().setAutoCommit(false);
        this._addValuesBatchCounter = 0;
    }

    protected void endBatch() throws SQLException {
        if (this._addValuesBatchCounter > 0) {
            this.executeBatch();
        }
        this._addValuesBatchStmt = null;
        this.getCurrentConnection().setAutoCommit(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void overwriteKB(KnowledgeBase knowledgeBase, boolean bl) throws SQLException {
        slotToFacetsCacheMap.clear();
        try {
            this.ensureEmptyTableExists();
            boolean bl2 = knowledgeBase.setCallCachingEnabled(false);
            if (bl) {
                this.beginBatch();
                this.saveFrames(knowledgeBase);
                this.endBatch();
            }
            knowledgeBase.setCallCachingEnabled(bl2);
        }
        finally {
            slotToFacetsCacheMap.clear();
        }
    }

    protected void saveFrames(KnowledgeBase knowledgeBase) throws SQLException {
        this.nFrames = knowledgeBase.getFrameCount();
        this.loopcount = 0;
        this.previousTime = System.currentTimeMillis();
        MergingNarrowFrameStore mergingNarrowFrameStore = MergingNarrowFrameStore.get(knowledgeBase);
        NarrowFrameStore narrowFrameStore = null;
        if (mergingNarrowFrameStore != null) {
            narrowFrameStore = mergingNarrowFrameStore.getActiveFrameStore();
        }
        if (this.nFrames > 1000) {
            Log.getLogger().info("Getting " + this.nFrames + " frames, please be patient, " + new Date());
        }
        Collection<Frame> collection = narrowFrameStore == null ? knowledgeBase.getFrames() : narrowFrameStore.getFrames();
        for (Frame frame : collection) {
            this.printTraceMessage();
            this.saveDirectOwnSlotValues(frame, narrowFrameStore);
            if (!(frame instanceof Cls)) continue;
            Cls cls = (Cls)frame;
            this.saveDirectTemplateSlotInformation(cls, narrowFrameStore);
        }
    }

    private void printTraceMessage() {
        ++this.loopcount;
        if (this.loopcount % 1000 == 0) {
            long l = System.currentTimeMillis();
            long l2 = (l - this.previousTime) / 1000L;
            this.previousTime = l;
            System.gc();
            Runtime runtime = Runtime.getRuntime();
            String string = this.loopcount + "/" + this.nFrames;
            string = string + ", " + new Date();
            string = string + ", delta=" + l2;
            string = string + ", mem(f/t/m)=" + runtime.freeMemory() / 1000L;
            string = string + "/" + runtime.totalMemory() / 1000L;
            string = string + "/" + runtime.maxMemory() / 1000L;
            Log.getLogger().info(string);
        }
    }

    protected void saveValues(Frame frame, Slot slot, Facet facet, boolean bl, Collection collection) throws SQLException {
        DefaultDatabaseFrameDb.setFrame(this._addValuesBatchStmt, 1, 2, frame, this._frameFactory);
        DefaultDatabaseFrameDb.setSlot(this._addValuesBatchStmt, 3, slot);
        DefaultDatabaseFrameDb.setFacet(this._addValuesBatchStmt, 4, facet);
        DefaultDatabaseFrameDb.setIsTemplate(this._addValuesBatchStmt, 5, bl);
        boolean bl2 = DefaultDatabaseFrameDb.locationIsSystem(frame, slot, facet);
        int n = 0;
        for (Object e : collection) {
            if (bl2 && DefaultDatabaseFrameDb.valueIsSystem(e)) continue;
            DefaultDatabaseFrameDb.setValueIndex(this._addValuesBatchStmt, 6, n);
            this.setValue(this._addValuesBatchStmt, 7, 8, 9, e);
            this.addBatch();
            ++n;
        }
    }

    private static boolean locationIsSystem(Frame frame, Slot slot, Facet facet) {
        boolean bl;
        boolean bl2 = bl = frame.isSystem() && slot.isSystem();
        if (bl && facet != null) {
            bl = facet.isSystem();
        }
        return bl;
    }

    private static boolean valueIsSystem(Object object) {
        boolean bl = true;
        if (object instanceof Frame) {
            Frame frame = (Frame)object;
            bl = frame.isSystem();
        }
        return bl;
    }

    private void addBatch() throws SQLException {
        this._addValuesBatchStmt.addBatch();
        ++this._addValuesBatchCounter;
        if (this._addValuesBatchCounter == 1000) {
            this.executeBatch();
        }
    }

    private void executeBatch() throws SQLException {
        this._addValuesBatchStmt.executeBatch();
        this._addValuesBatchCounter = 0;
        this.getCurrentConnection().commit();
    }

    private void saveDirectOwnSlotValues(Frame frame, NarrowFrameStore narrowFrameStore) throws SQLException {
        for (Slot slot : frame.getOwnSlots()) {
            List list = narrowFrameStore == null ? frame.getDirectOwnSlotValues(slot) : narrowFrameStore.getValues(frame, slot, null, false);
            this.saveValues(frame, slot, null, false, list);
        }
    }

    private void saveDirectTemplateSlotInformation(Cls cls, NarrowFrameStore narrowFrameStore) throws SQLException {
        for (Slot slot : cls.getTemplateSlots()) {
            List list = narrowFrameStore == null ? cls.getDirectTemplateSlotValues(slot) : narrowFrameStore.getValues(cls, slot, null, true);
            this.saveValues(cls, slot, null, true, list);
            this.saveDirectTemplateFacetValues(cls, slot, narrowFrameStore);
        }
    }

    private void saveDirectTemplateFacetValues(Cls cls, Slot slot, NarrowFrameStore narrowFrameStore) throws SQLException {
        for (Facet facet : DefaultDatabaseFrameDb.getTemplateFacets(cls, slot)) {
            List list = narrowFrameStore == null ? cls.getDirectTemplateFacetValues(slot, facet) : narrowFrameStore.getValues(cls, slot, facet, true);
            this.saveValues(cls, slot, facet, true, list);
        }
    }

    private static Collection getTemplateFacets(Cls cls, Slot slot) {
        Collection<Facet> collection = (Collection<Facet>)slotToFacetsCacheMap.get(slot);
        if (collection == null) {
            collection = cls.getTemplateFacets(slot);
            slotToFacetsCacheMap.put(slot, collection);
        }
        return collection;
    }

    @Override
    public boolean beginTransaction(String string) {
        DefaultDatabaseFrameDb.checkModifiability();
        return super.beginTransaction(string);
    }

    @Override
    public boolean commitTransaction() {
        DefaultDatabaseFrameDb.checkModifiability();
        return super.commitTransaction();
    }

    @Override
    public boolean rollbackTransaction() {
        DefaultDatabaseFrameDb.checkModifiability();
        return super.rollbackTransaction();
    }

    private static void checkModifiability() {
        if (!_isModifiable) {
            throw new IllegalStateException("Database is not modifiable");
        }
    }

    @Override
    public void replaceFrame(Frame frame) {
        try {
            int n = DatabaseUtils.valueType(frame, this._frameFactory);
            this.replaceFrameTypeSQL(frame, n);
            this.replaceValueTypeSQL(frame, n);
        }
        catch (SQLException sQLException) {
            throw this.createRuntimeException(sQLException);
        }
    }

    private void replaceFrameTypeSQL(Frame frame, int n) throws SQLException {
        if (this.replaceFrameTypeCommand == null) {
            this.replaceFrameTypeCommand = "UPDATE " + this._table + " SET " + FRAME_TYPE_COLUMN + " = ?";
            this.replaceFrameTypeCommand = this.replaceFrameTypeCommand + " WHERE frame = ?";
        }
        PreparedStatement preparedStatement = this.getCurrentConnection().getPreparedStatement(this.replaceFrameTypeCommand);
        DatabaseUtils.setValueType(preparedStatement, 1, n);
        DatabaseUtils.setFrame(preparedStatement, 2, frame);
        DefaultDatabaseFrameDb.executeUpdate(preparedStatement);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void replaceValueTypeSQL(Frame frame, int n) throws SQLException {
        if (this._matchingFramesCommandForSwizzle == null) {
            this._matchingFramesCommandForSwizzle = "SELECT frame, slot, facet, is_template, value_index, short_value FROM " + this._table + " WHERE " + SHORT_VALUE_COLUMN + " = ?  AND " + VALUE_TYPE_COLUMN + " >= " + 5;
        }
        if (this._updateValueTypeCommandForSwizzle == null) {
            this._updateValueTypeCommandForSwizzle = "UPDATE " + this._table + " SET " + VALUE_TYPE_COLUMN + " = ? " + " WHERE " + FRAME_COLUMN + " = ? " + " AND " + SLOT_COLUMN + " = ? AND " + FACET_COLUMN + " = ? AND " + IS_TEMPLATE_COLUMN + " = ?" + " AND " + VALUE_INDEX_COLUMN + " = ?";
        }
        PreparedStatement preparedStatement = this.getCurrentConnection().getPreparedStatement(this._matchingFramesCommandForSwizzle);
        DefaultDatabaseFrameDb.setFrame(preparedStatement, 1, frame);
        ResultSet resultSet = DefaultDatabaseFrameDb.executeQuery(preparedStatement);
        try {
            while (resultSet.next()) {
                if (!frame.getName().equals(resultSet.getString(6))) continue;
                PreparedStatement preparedStatement2 = this.getCurrentConnection().getPreparedStatement(this._updateValueTypeCommandForSwizzle);
                preparedStatement2.setInt(1, n);
                preparedStatement2.setString(2, resultSet.getString(1));
                preparedStatement2.setString(3, resultSet.getString(2));
                preparedStatement2.setString(4, resultSet.getString(3));
                preparedStatement2.setBoolean(5, resultSet.getBoolean(4));
                preparedStatement2.setInt(6, resultSet.getInt(5));
                DefaultDatabaseFrameDb.executeUpdate(preparedStatement2);
            }
        }
        finally {
            resultSet.close();
        }
    }

    @Override
    public int getClsCount() {
        return this.countUniqueFrames(this._frameFactory.getClsJavaClassIds());
    }

    @Override
    public int getSlotCount() {
        return this.countUniqueFrames(this._frameFactory.getSlotJavaClassIds());
    }

    @Override
    public int getFacetCount() {
        return this.countUniqueFrames(this._frameFactory.getFacetJavaClassIds());
    }

    @Override
    public int getFrameCount() {
        return this.countUniqueFrames();
    }

    public Set getFrames() {
        if (log.isLoggable(Level.FINE)) {
            log.fine("Calling get frames...");
        }
        Set set = null;
        try {
            set = this.getFramesSQL();
        }
        catch (SQLException sQLException) {
            throw this.createRuntimeException(sQLException);
        }
        return set;
    }

    @Override
    public int getSimpleInstanceCount() {
        return this.countUniqueFrames(this._frameFactory.getSimpleInstanceJavaClassIds());
    }

    private int countUniqueFrames(Collection collection) {
        int n = -1;
        try {
            n = this.countFramesSQL(collection);
        }
        catch (SQLException sQLException) {
            throw this.createRuntimeException(sQLException);
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int countFramesSQL(Collection collection) throws SQLException {
        Object object2;
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("SELECT COUNT(*) FROM " + this._table);
        stringBuffer.append(" WHERE slot = '" + DefaultDatabaseFrameDb.getValue(Model.SlotID.NAME));
        stringBuffer.append("' AND facet = ''");
        stringBuffer.append(" AND is_template = ?");
        stringBuffer.append(" AND (");
        boolean bl = true;
        for (Object object2 : collection) {
            if (bl) {
                bl = false;
            } else {
                stringBuffer.append(" OR ");
            }
            stringBuffer.append("frame_type = ");
            stringBuffer.append((Integer)object2);
        }
        stringBuffer.append(")");
        object2 = this.getCurrentConnection().getPreparedStatement(stringBuffer.toString());
        DefaultDatabaseFrameDb.setIsTemplate((PreparedStatement)object2, 1, false);
        int n = -1;
        ResultSet resultSet = DefaultDatabaseFrameDb.executeQuery((PreparedStatement)object2);
        try {
            while (resultSet.next()) {
                n = resultSet.getInt(1);
            }
        }
        finally {
            resultSet.close();
        }
        return n;
    }

    private int countUniqueFrames() {
        int n = -1;
        try {
            n = this.countFramesSQL();
        }
        catch (SQLException sQLException) {
            throw this.createRuntimeException(sQLException);
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int countFramesSQL() throws SQLException {
        if (this._countFramesText == null) {
            this._countFramesText = "SELECT COUNT(*) FROM " + this._table;
            this._countFramesText = this._countFramesText + " WHERE slot = '" + DefaultDatabaseFrameDb.getValue(Model.SlotID.NAME) + "'";
            this._countFramesText = this._countFramesText + " AND facet = ''";
            this._countFramesText = this._countFramesText + " AND is_template = ?";
        }
        PreparedStatement preparedStatement = this.getCurrentConnection().getPreparedStatement(this._countFramesText);
        DefaultDatabaseFrameDb.setIsTemplate(preparedStatement, 1, false);
        int n = -1;
        ResultSet resultSet = DefaultDatabaseFrameDb.executeQuery(preparedStatement);
        try {
            while (resultSet.next()) {
                n = resultSet.getInt(1);
            }
        }
        finally {
            resultSet.close();
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Set getFramesSQL() throws SQLException {
        if (this._getFramesText == null) {
            this._getFramesText = "SELECT DISTINCT frame, frame_type";
            this._getFramesText = this._getFramesText + " FROM " + this._table;
        }
        PreparedStatement preparedStatement = this.getCurrentConnection().getPreparedStatement(this._getFramesText);
        HashSet<Frame> hashSet = new HashSet<Frame>();
        ResultSet resultSet = DefaultDatabaseFrameDb.executeQuery(preparedStatement);
        try {
            while (resultSet.next()) {
                Frame frame = this.getFrame(resultSet, 1, 2);
                hashSet.add(frame);
            }
        }
        finally {
            resultSet.close();
        }
        return hashSet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Frame getFrame(FrameID frameID) {
        Frame frame;
        block7: {
            frame = null;
            if (this._getFrameFromIdText == null) {
                this._getFrameFromIdText = "SELECT DISTINCT frame, frame_type FROM " + this._table + " WHERE " + FRAME_COLUMN + " = ?";
            }
            try {
                if (frameID == null) break block7;
                PreparedStatement preparedStatement = this.getCurrentConnection().getPreparedStatement(this._getFrameFromIdText);
                DatabaseUtils.setFrameId(preparedStatement, 1, frameID);
                ResultSet resultSet = DefaultDatabaseFrameDb.executeQuery(preparedStatement);
                try {
                    while (resultSet.next()) {
                        frame = this.getFrame(resultSet, 1, 2);
                    }
                }
                finally {
                    resultSet.close();
                }
            }
            catch (SQLException sQLException) {
                this.createRuntimeException(sQLException);
            }
        }
        return frame;
    }

    @Override
    public NarrowFrameStore getDelegate() {
        return null;
    }

    @Override
    public void replaceFrame(Frame frame, Frame frame2) {
        try {
            PreparedStatement preparedStatement;
            if (this._updateFrameFieldText == null) {
                this._updateFrameFieldText = "UPDATE " + this._table + " SET " + FRAME_COLUMN + " = ? WHERE ";
                this._updateFrameFieldText = this._updateFrameFieldText + FRAME_COLUMN + " = ?";
            }
            PreparedStatement preparedStatement2 = this.getCurrentConnection().getPreparedStatement(this._updateFrameFieldText);
            DefaultDatabaseFrameDb.setFrame(preparedStatement2, 1, frame2);
            DefaultDatabaseFrameDb.setFrame(preparedStatement2, 2, frame);
            DefaultDatabaseFrameDb.executeUpdate(preparedStatement2);
            if (frame2 instanceof Slot) {
                if (this._updateSlotFieldText == null) {
                    this._updateSlotFieldText = "UPDATE " + this._table + " SET " + SLOT_COLUMN + " = ? WHERE ";
                    this._updateSlotFieldText = this._updateSlotFieldText + SLOT_COLUMN + " = ?";
                }
                preparedStatement = this.getCurrentConnection().getPreparedStatement(this._updateSlotFieldText);
                DefaultDatabaseFrameDb.setFrame(preparedStatement, 1, frame2);
                DefaultDatabaseFrameDb.setFrame(preparedStatement, 2, frame);
                DefaultDatabaseFrameDb.executeUpdate(preparedStatement);
            }
            if (frame2 instanceof Facet) {
                if (this._updateFacetFieldText == null) {
                    this._updateFacetFieldText = "UPDATE " + this._table + " SET " + FACET_COLUMN + " = ? WHERE ";
                    this._updateFacetFieldText = this._updateFacetFieldText + FACET_COLUMN + " = ?";
                }
                preparedStatement = this.getCurrentConnection().getPreparedStatement(this._updateFacetFieldText);
                DefaultDatabaseFrameDb.setFrame(preparedStatement, 1, frame2);
                DefaultDatabaseFrameDb.setFrame(preparedStatement, 2, frame);
                DefaultDatabaseFrameDb.executeUpdate(preparedStatement);
            }
            this.replaceFrameShortValueField(frame, frame2);
            if (this._replaceNameText == null) {
                this._replaceNameText = "UPDATE " + this._table + " SET " + SHORT_VALUE_COLUMN + " = ?," + VALUE_TYPE_COLUMN + " = ? WHERE ";
                this._replaceNameText = this._replaceNameText + FRAME_COLUMN + " = ? AND ";
                this._replaceNameText = this._replaceNameText + SLOT_COLUMN + " = '" + DefaultDatabaseFrameDb.getValue(Model.SlotID.NAME) + "'";
            }
            preparedStatement = this.getCurrentConnection().getPreparedStatement(this._replaceNameText);
            this.setShortValue(preparedStatement, 1, 2, frame2.getFrameID().getName());
            DefaultDatabaseFrameDb.setFrame(preparedStatement, 3, frame2);
            DefaultDatabaseFrameDb.executeUpdate(preparedStatement);
            frame.markDeleted(true);
        }
        catch (SQLException sQLException) {
            this.createRuntimeException(sQLException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void replaceFrameShortValueField(Frame frame, Frame frame2) throws SQLException {
        if (this._matchingFramesCommandForRename == null) {
            this._matchingFramesCommandForRename = "SELECT frame, slot, facet, is_template, value_index, short_value FROM " + this._table + " WHERE " + SHORT_VALUE_COLUMN + " = ?  AND " + VALUE_TYPE_COLUMN + " >= " + 5;
        }
        if (this._updateValueFieldTextForRename == null) {
            this._updateValueFieldTextForRename = "UPDATE " + this._table + " SET " + SHORT_VALUE_COLUMN + " = ? " + " WHERE " + FRAME_COLUMN + " = ? " + " AND " + SLOT_COLUMN + " = ? AND " + FACET_COLUMN + " = ? AND " + IS_TEMPLATE_COLUMN + " = ?" + " AND " + VALUE_INDEX_COLUMN + " = ?";
        }
        PreparedStatement preparedStatement = this.getCurrentConnection().getPreparedStatement(this._matchingFramesCommandForRename);
        DefaultDatabaseFrameDb.setFrame(preparedStatement, 1, frame);
        ResultSet resultSet = DefaultDatabaseFrameDb.executeQuery(preparedStatement);
        try {
            while (resultSet.next()) {
                if (!frame.getName().equals(resultSet.getString(6))) continue;
                PreparedStatement preparedStatement2 = this.getCurrentConnection().getPreparedStatement(this._updateValueFieldTextForRename);
                DefaultDatabaseFrameDb.setFrame(preparedStatement2, 1, frame2);
                preparedStatement2.setString(2, resultSet.getString(1));
                preparedStatement2.setString(3, resultSet.getString(2));
                preparedStatement2.setString(4, resultSet.getString(3));
                preparedStatement2.setBoolean(5, resultSet.getBoolean(4));
                preparedStatement2.setInt(6, resultSet.getInt(5));
                DefaultDatabaseFrameDb.executeUpdate(preparedStatement2);
            }
        }
        finally {
            resultSet.close();
        }
    }

    @Override
    public void reinitialize() {
    }

    @Override
    public boolean setCaching(RemoteSession remoteSession, boolean bl) {
        return false;
    }

    public String toString() {
        return "DefaultDatabaseFrameDb(" + this.getName() + ")";
    }

    static {
        slotToFacetsCacheMap = new HashMap();
    }

    private class LapTimer {
        private final long start;
        private long lapStart;

        public LapTimer() {
            this.lapStart = this.start = System.currentTimeMillis();
        }

        public long lap() {
            long l = System.currentTimeMillis();
            long l2 = l - this.lapStart;
            this.lapStart = l;
            return l2;
        }

        public long total() {
            return System.currentTimeMillis() - this.start;
        }
    }
}

