/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protege.ui;

import edu.stanford.smi.protege.model.Project;
import edu.stanford.smi.protege.model.WidgetDescriptor;
import edu.stanford.smi.protege.ui.ProjectView;
import edu.stanford.smi.protege.ui.TabRenderer;
import edu.stanford.smi.protege.util.ComponentFactory;
import edu.stanford.smi.protege.widget.TabWidget;
import edu.stanford.smi.protege.widget.WidgetUtilities;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.Icon;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class ViewSelector
extends JComponent {
    private static final long serialVersionUID = 296789933860074572L;
    private JComboBox combobox;
    private ProjectView projectView;
    private ItemListener itemListener = this.createChangeViewAction();
    private JToolBar toolBar;
    private ButtonGroup buttonGroup = new ButtonGroup();
    private Map descriptorToButtonMap = new HashMap();

    public ViewSelector(ProjectView projectView) {
        this.projectView = projectView;
        this.setLayout(new FlowLayout(0));
        this.combobox = ComponentFactory.createComboBox();
        ComboBoxModel comboBoxModel = this.createModel();
        this.combobox.setModel(comboBoxModel);
        this.combobox.addItemListener(this.itemListener);
        this.setOpaque(false);
        this.combobox.setRenderer(new TabRenderer(projectView));
        this.combobox.setPreferredSize(new Dimension(150, 10));
        Box box = Box.createHorizontalBox();
        box.add(ComponentFactory.createLabel("View:"));
        box.add(Box.createHorizontalStrut(2));
        box.add(this.combobox);
        box.add(Box.createHorizontalStrut(3));
        this.toolBar = ComponentFactory.createToolBar();
        this.addButtonsToToolbar();
        box.add(this.toolBar);
        this.add(box);
        projectView.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                TabWidget tabWidget = ViewSelector.this.projectView.getSelectedTab();
                if (tabWidget != null) {
                    ViewSelector.this.setSelection(tabWidget);
                }
            }
        });
    }

    private void addButtonsToToolbar() {
        for (WidgetDescriptor widgetDescriptor : this.getCurrentDescriptors()) {
            this.addButtonForExistingTab(widgetDescriptor);
        }
    }

    public void reload() {
        this.descriptorToButtonMap.clear();
        this.buttonGroup = new ButtonGroup();
        this.toolBar.removeAll();
        this.addButtonsToToolbar();
    }

    private ComboBoxModel createModel() {
        Project project = this.projectView.getProject();
        Collection<WidgetDescriptor> collection = project.getTabWidgetDescriptors();
        ArrayList arrayList = new ArrayList();
        arrayList.addAll(this.getCurrentDescriptors());
        arrayList.addAll(this.getPotentialDescriptors(collection));
        return new DefaultComboBoxModel<Object>(arrayList.toArray());
    }

    private Collection getCurrentDescriptors() {
        ArrayList<WidgetDescriptor> arrayList = new ArrayList<WidgetDescriptor>();
        for (TabWidget tabWidget : this.projectView.getTabs()) {
            WidgetDescriptor widgetDescriptor = tabWidget.getDescriptor();
            arrayList.add(widgetDescriptor);
        }
        return arrayList;
    }

    private Collection getPotentialDescriptors(Collection collection) {
        ArrayList<WidgetDescriptor> arrayList = new ArrayList<WidgetDescriptor>();
        for (WidgetDescriptor widgetDescriptor : collection) {
            String string = widgetDescriptor.getWidgetClassName();
            TabWidget tabWidget = this.projectView.getTabByClassName(string);
            if (tabWidget != null) continue;
            ArrayList arrayList2 = new ArrayList();
            if (!WidgetUtilities.isSuitableTab(string, this.projectView.getProject(), arrayList2)) continue;
            arrayList.add(widgetDescriptor);
        }
        return arrayList;
    }

    private ItemListener createChangeViewAction() {
        return new ItemListener(){

            public void itemStateChanged(ItemEvent itemEvent) {
                if (itemEvent.getStateChange() == 1) {
                    WidgetDescriptor widgetDescriptor = (WidgetDescriptor)itemEvent.getItem();
                    ViewSelector.this.showView(widgetDescriptor);
                }
            }
        };
    }

    private void showView(WidgetDescriptor widgetDescriptor) {
        AbstractButton abstractButton = (AbstractButton)this.descriptorToButtonMap.get(widgetDescriptor);
        if (abstractButton == null) {
            abstractButton = this.addButton(widgetDescriptor.getWidgetClassName());
        }
        abstractButton.doClick();
    }

    public void addButtonForExistingTab(WidgetDescriptor widgetDescriptor) {
        TabWidget tabWidget = this.projectView.getTabByClassName(widgetDescriptor.getWidgetClassName());
        AbstractButton abstractButton = this.addButton(tabWidget);
        if (this.projectView.getSelectedTab() == tabWidget) {
            abstractButton.setSelected(true);
        }
    }

    public AbstractButton addButton(String string) {
        WidgetDescriptor widgetDescriptor = this.projectView.getProject().getTabWidgetDescriptor(string);
        widgetDescriptor.setVisible(true);
        TabWidget tabWidget = this.projectView.addTab(widgetDescriptor);
        return this.addButton(tabWidget);
    }

    private AbstractButton addButton(final TabWidget tabWidget) {
        Icon icon = tabWidget.getIcon();
        AbstractAction abstractAction = new AbstractAction(tabWidget.getLabel(), icon){
            private static final long serialVersionUID = -6284395473725147927L;

            public void actionPerformed(ActionEvent actionEvent) {
                ViewSelector.this.projectView.setSelectedTab(tabWidget);
            }
        };
        JToggleButton jToggleButton = ComponentFactory.addToggleToolBarButton(this.toolBar, abstractAction);
        if (icon == null) {
            jToggleButton.setText(tabWidget.getLabel());
        }
        this.descriptorToButtonMap.put(tabWidget.getDescriptor(), jToggleButton);
        this.buttonGroup.add(jToggleButton);
        jToggleButton.setRolloverEnabled(false);
        jToggleButton.setBorderPainted(true);
        this.toolBar.setRollover(false);
        return jToggleButton;
    }

    private void setSelection(TabWidget tabWidget) {
        this.combobox.removeItemListener(this.itemListener);
        this.combobox.setSelectedItem(tabWidget.getDescriptor());
        this.combobox.addItemListener(this.itemListener);
        AbstractButton abstractButton = (AbstractButton)this.descriptorToButtonMap.get(tabWidget.getDescriptor());
        if (abstractButton != null) {
            abstractButton.setSelected(true);
        }
    }
}

