/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protege.ui;

import edu.stanford.smi.protege.resource.Icons;
import edu.stanford.smi.protege.resource.LocalizedText;
import edu.stanford.smi.protege.resource.ResourceKey;
import edu.stanford.smi.protege.ui.ProjectManager;
import edu.stanford.smi.protege.util.ApplicationProperties;
import edu.stanford.smi.protege.util.Log;
import edu.stanford.smi.protege.util.SystemUtilities;
import edu.stanford.smi.protege.util.URIUtilities;
import edu.stanford.smi.protege.util.WaitCursor;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.geom.Rectangle2D;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.DefaultListModel;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.ToolTipManager;
import javax.swing.border.TitledBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class WelcomeDialog
extends JDialog {
    private static final long serialVersionUID = 3986911949227734433L;
    JButton cancelButton;
    JButton faqButton;
    JButton newButton;
    JButton openOtherButton;
    JButton openRecentButton;
    JButton topicsButton;
    JButton tutorialButton;
    JButton usersGuideButton;
    JPanel helpButtonsPanel;
    JPanel projectsPanel;
    JLabel protegeIconLabel;
    List projectURIs;
    ProjectList projectList;

    public WelcomeDialog(Frame frame, String string, boolean bl) {
        super(frame, string, bl);
        try {
            this.setDefaultCloseOperation(2);
            this.setSize(500, 300);
            this.projectURIs = new ArrayList(ApplicationProperties.getMRUProjectList());
            this.initializeUI();
        }
        catch (Exception exception) {
            Log.getLogger().severe(Log.toString(exception));
        }
    }

    private void initializeUI() {
        this.buildProjectsPanel();
        this.buildHelpPanel();
        Container container = this.getContentPane();
        container.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        this.protegeIconLabel = new JLabel(Icons.getLogo());
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = new Insets(7, 0, 0, 0);
        gridBagConstraints.anchor = 10;
        container.add((Component)this.protegeIconLabel, gridBagConstraints);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridheight = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(7, 2, 0, 0);
        gridBagConstraints.anchor = 23;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        container.add((Component)this.projectsPanel, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        container.add((Component)this.helpButtonsPanel, gridBagConstraints);
        this.cancelButton = WelcomeDialog.createButton(ResourceKey.CANCEL_BUTTON_LABEL, Icons.getCancelIcon());
        this.cancelButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                WelcomeDialog.this.closeButton_actionPerformed(actionEvent);
            }
        });
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = new Insets(11, 0, 7, 0);
        gridBagConstraints.anchor = 10;
        container.add((Component)this.cancelButton, gridBagConstraints);
        this.getRootPane().setDefaultButton(this.cancelButton);
    }

    private void buildProjectsPanel() {
        this.projectsPanel = new JPanel(new GridBagLayout());
        this.projectsPanel.setBorder(WelcomeDialog.createBorder(ResourceKey.WELCOME_DIALOG_OPEN_RECENT_PROJECT_TITLE));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        this.initializeList();
        JScrollPane jScrollPane = new JScrollPane(this.projectList);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 4;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(0, 2, 5, 2);
        gridBagConstraints.anchor = 23;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.projectsPanel.add((Component)jScrollPane, gridBagConstraints);
        this.openRecentButton = WelcomeDialog.createButton(ResourceKey.WELCOME_DIALOG_OPEN);
        this.openRecentButton.setMnemonic(LocalizedText.getMnemonic(ResourceKey.WELCOME_DIALOG_OPEN));
        WelcomeDialog.setToolTipText(this.openRecentButton, ResourceKey.WELCOME_DIALOG_OPEN_TOOLTIP);
        this.openRecentButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                WelcomeDialog.this.openButton_actionPerformed(actionEvent);
            }
        });
        if (this.projectList.getModel().getSize() == 0) {
            this.openRecentButton.setEnabled(false);
        }
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 0, 5, 0);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        this.projectsPanel.add((Component)this.openRecentButton, gridBagConstraints);
        this.openOtherButton = WelcomeDialog.createButton(ResourceKey.WELCOME_DIALOG_OPEN_OTHER, Icons.getOpenProjectIcon());
        this.openOtherButton.setMnemonic(LocalizedText.getMnemonic(ResourceKey.WELCOME_DIALOG_OPEN_OTHER));
        WelcomeDialog.setToolTipText(this.openOtherButton, ResourceKey.WELCOME_DIALOG_OPEN_OTHER_TOOLTIP);
        this.openOtherButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                WelcomeDialog.this.openOtherButton_actionPerformed(actionEvent);
            }
        });
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        this.projectsPanel.add((Component)this.openOtherButton, gridBagConstraints);
        JLabel jLabel = new JLabel("");
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.weighty = 1.0;
        this.projectsPanel.add((Component)jLabel, gridBagConstraints);
        this.newButton = WelcomeDialog.createButton(ResourceKey.WELCOME_DIALOG_NEW, Icons.getNewProjectIcon());
        this.newButton.setMnemonic(LocalizedText.getMnemonic(ResourceKey.WELCOME_DIALOG_NEW));
        WelcomeDialog.setToolTipText(this.newButton, ResourceKey.WELCOME_DIALOG_NEW_TOOLTIP);
        this.newButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                WelcomeDialog.this.newButton_actionPerformed(actionEvent);
            }
        });
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.weighty = 0.0;
        this.projectsPanel.add((Component)this.newButton, gridBagConstraints);
    }

    private void buildHelpPanel() {
        this.helpButtonsPanel = new JPanel();
        this.helpButtonsPanel.setLayout(new BoxLayout(this.helpButtonsPanel, 3));
        this.helpButtonsPanel.setBorder(WelcomeDialog.createBorder(ResourceKey.WELCOME_DIALOG_HELP_TITLE));
        Dimension dimension = new Dimension(0, 5);
        this.tutorialButton = WelcomeDialog.createButton(ResourceKey.WELCOME_DIALOG_GETTING_STARTED);
        this.tutorialButton.setMnemonic(LocalizedText.getMnemonic(ResourceKey.WELCOME_DIALOG_GETTING_STARTED));
        this.tutorialButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                WelcomeDialog.tutorialButton_actionPerformed(actionEvent);
            }
        });
        this.helpButtonsPanel.add(this.tutorialButton);
        this.helpButtonsPanel.add(Box.createRigidArea(dimension));
        this.faqButton = WelcomeDialog.createButton(ResourceKey.WELCOME_DIALOG_FAQ);
        this.faqButton.setMnemonic(LocalizedText.getMnemonic(ResourceKey.WELCOME_DIALOG_FAQ));
        this.faqButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                WelcomeDialog.faqButton_actionPerformed(actionEvent);
            }
        });
        this.helpButtonsPanel.add(this.faqButton);
        this.helpButtonsPanel.add(Box.createRigidArea(dimension));
        this.usersGuideButton = WelcomeDialog.createButton(ResourceKey.WELCOME_DIALOG_USERS_GUIDE);
        this.usersGuideButton.setMnemonic(LocalizedText.getMnemonic(ResourceKey.WELCOME_DIALOG_USERS_GUIDE));
        this.usersGuideButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                WelcomeDialog.usersGuideButton_actionPerformed(actionEvent);
            }
        });
        this.helpButtonsPanel.add(this.usersGuideButton);
        this.helpButtonsPanel.add(Box.createRigidArea(dimension));
        this.topicsButton = WelcomeDialog.createButton(ResourceKey.WELCOME_DIALOG_ALL_TOPICS);
        this.topicsButton.setMnemonic(LocalizedText.getMnemonic(ResourceKey.WELCOME_DIALOG_ALL_TOPICS));
        this.topicsButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                WelcomeDialog.topicsButton_actionPerformed(actionEvent);
            }
        });
        this.helpButtonsPanel.add(this.topicsButton);
        this.equalizeHelpButtons();
    }

    private static JButton createButton(ResourceKey resourceKey) {
        return new JButton(LocalizedText.getText(resourceKey));
    }

    private static JButton createButton(ResourceKey resourceKey, Icon icon) {
        return new JButton(LocalizedText.getText(resourceKey), icon);
    }

    private static TitledBorder createBorder(ResourceKey resourceKey) {
        String string = LocalizedText.getText(resourceKey);
        return new TitledBorder(BorderFactory.createEtchedBorder(), string);
    }

    private static void setToolTipText(AbstractButton abstractButton, ResourceKey resourceKey) {
        String string = LocalizedText.getText(resourceKey);
        abstractButton.setToolTipText(string);
    }

    private void initializeList() {
        DefaultListModel<String> defaultListModel = new DefaultListModel<String>();
        for (int i = 0; i < this.projectURIs.size(); ++i) {
            URI uRI = (URI)this.projectURIs.get(i);
            String string = URIUtilities.getName(uRI);
            defaultListModel.addElement(string);
        }
        this.projectList = new ProjectList(defaultListModel);
        this.projectList.setSelectionMode(0);
        if (this.projectList.getModel().getSize() != 0) {
            this.projectList.setSelectedIndex(0);
        }
        this.projectList.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                if (listSelectionEvent.getValueIsAdjusting()) {
                    return;
                }
            }
        });
        this.projectList.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent mouseEvent) {
                if (mouseEvent.getClickCount() == 2) {
                    int n = WelcomeDialog.this.projectList.locationToIndex(mouseEvent.getPoint());
                    WelcomeDialog.this.doOpenProject(n);
                }
            }
        });
    }

    private void doOpenProject(int n) {
        if (n >= 0) {
            URI uRI = (URI)this.projectURIs.get(n);
            WaitCursor waitCursor = new WaitCursor(this.getRootPane());
            this.setVisible(false);
            ProjectManager.getProjectManager().loadProject(uRI);
            ApplicationProperties.addProjectToMRUList(uRI);
            waitCursor.hide();
        }
    }

    public void newButton_actionPerformed(ActionEvent actionEvent) {
        boolean bl = ProjectManager.getProjectManager().createNewProjectRequest();
        if (bl) {
            this.setVisible(false);
        }
    }

    public void openButton_actionPerformed(ActionEvent actionEvent) {
        int n = this.projectList.getSelectedIndex();
        this.doOpenProject(n);
    }

    public void openOtherButton_actionPerformed(ActionEvent actionEvent) {
        boolean bl = ProjectManager.getProjectManager().openProjectRequest(this);
        if (bl) {
            this.setVisible(false);
        }
    }

    private static void faqButton_actionPerformed(ActionEvent actionEvent) {
        SystemUtilities.showHTML(ApplicationProperties.getFAQURLString());
    }

    private static void topicsButton_actionPerformed(ActionEvent actionEvent) {
        SystemUtilities.showHTML(ApplicationProperties.getAllHelpURLString());
    }

    private static void tutorialButton_actionPerformed(ActionEvent actionEvent) {
        SystemUtilities.showHTML(ApplicationProperties.getGettingStartedURLString());
    }

    private static void usersGuideButton_actionPerformed(ActionEvent actionEvent) {
        SystemUtilities.showHTML(ApplicationProperties.getUsersGuideURLString());
    }

    public void closeButton_actionPerformed(ActionEvent actionEvent) {
        this.setVisible(false);
    }

    private void equalizeHelpButtons() {
        String[] stringArray = new String[]{this.faqButton.getText(), this.topicsButton.getText(), this.tutorialButton.getText(), this.usersGuideButton.getText()};
        Dimension dimension = new Dimension(0, 0);
        Rectangle2D rectangle2D = null;
        FontMetrics fontMetrics = this.faqButton.getFontMetrics(this.faqButton.getFont());
        Graphics graphics = this.getGraphics();
        for (int i = 0; i < stringArray.length; ++i) {
            rectangle2D = fontMetrics.getStringBounds(stringArray[i], graphics);
            dimension.width = Math.max(dimension.width, (int)rectangle2D.getWidth());
            dimension.height = Math.max(dimension.height, (int)rectangle2D.getHeight());
        }
        Insets insets = this.faqButton.getBorder().getBorderInsets(this.faqButton);
        dimension.width += insets.left + insets.right;
        dimension.height += insets.top + insets.bottom;
        this.faqButton.setPreferredSize((Dimension)dimension.clone());
        this.topicsButton.setPreferredSize((Dimension)dimension.clone());
        this.tutorialButton.setPreferredSize((Dimension)dimension.clone());
        this.usersGuideButton.setPreferredSize((Dimension)dimension.clone());
        this.faqButton.setMaximumSize((Dimension)dimension.clone());
        this.topicsButton.setMaximumSize((Dimension)dimension.clone());
        this.tutorialButton.setMaximumSize((Dimension)dimension.clone());
        this.usersGuideButton.setMaximumSize((Dimension)dimension.clone());
    }

    private class ProjectList
    extends JList {
        private static final long serialVersionUID = 8193202451714386857L;

        ProjectList(DefaultListModel defaultListModel) {
            this.setModel(defaultListModel);
            ToolTipManager.sharedInstance().registerComponent(this);
        }

        public String getToolTipText(MouseEvent mouseEvent) {
            String string = null;
            int n = this.locationToIndex(mouseEvent.getPoint());
            if (n >= 0) {
                string = WelcomeDialog.this.projectURIs.get(n).toString();
            }
            return string;
        }
    }
}

