/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protege.util;

import edu.stanford.smi.protege.plugin.PluginUtilities;
import edu.stanford.smi.protege.util.ComponentUtilities;
import edu.stanford.smi.protege.util.Log;
import edu.stanford.smi.protege.util.SystemUtilities;
import edu.stanford.smi.protege.util.URIUtilities;
import java.awt.Frame;
import java.awt.Rectangle;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.security.AccessControlException;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Properties;
import java.util.StringTokenizer;

public class ApplicationProperties {
    public static final String FILE_NAME = "protege.properties";
    public static final String NEXT_FRAME_NUMBER = "next_frame_number";
    public static final String APPLICATION_INSTALL_DIRECTORY = "protege.dir";
    public static final String LAST_FILE_DIRECTORY = "filechooser.last_directory";
    public static final String LAST_LOADED_URI = "projectchooser.last_uri";
    public static final String CURRENT_WORKING_DIRECTORY = "user.dir";
    public static final String USERS_HOME_DIRECTORY = "user.home";
    public static final String PROPERTIES_IN_USER_HOME = "protege.properties.in.user.home";
    public static final String EXTRA_MANIFEST_PATH = "protege.plugin.manifest";
    public static final String MRU_PROJECTS = "history.projects.reopen";
    public static final String WELCOME_DIALOG = "ui.welcomedialog.show";
    public static final String WELCOME_DIALOG_START_IN_SERVER_PANEL = "ui.welcomedialog.start.in.server.panel";
    public static final String MAIN_FRAME_RECTANGLE = "mainframe.rectangle";
    public static final String LOOK_AND_FEEL = "swing.defaultlaf";
    public static final String BROWSER = "browser.html";
    private static final String AUTOSYNCHRONIZE_PROPERTY = "trees.autosynchronize";
    private static final String PRETTY_PRINT_SLOT_WIDGET_LABELS = "labels.pretty_print";
    public static final String LOG_FILE_PROPERTY = "java.util.logging.config.file";
    public static final String LOG_DEBUG_PROPERTY = "log.config.debug";
    public static final String REMOTE_CLIENT_PRELOAD = "remote.client.preload";
    public static final String URL_CONNECT_TIMEOUT = "url.connect.timeout";
    public static final String URL_CONNECT_READ_TIMEOUT = "url.connect.read.timeout";
    public static final String SORT_CLASS_TREE = "ui.sort.class.tree";
    public static final String SORT_SLOTS_TREE = "ui.sort.slot.tree";
    private static final Properties PROPERTIES = new Properties();
    private static File _propertyFile;
    private static final int num_MRUProjects = 10;
    private static List _mruProjectList;

    public static void setLookAndFeel(String string) {
        ApplicationProperties.setProperty(LOOK_AND_FEEL, string);
    }

    public static String getLookAndFeelClassName() {
        String string = ApplicationProperties.getApplicationOrSystemProperty(LOOK_AND_FEEL);
        if (string == null) {
            string = "com.jgoodies.looks.plastic.PlasticLookAndFeel";
        }
        return string;
    }

    private static void loadMRUProjectList() {
        String string = PROPERTIES.getProperty(MRU_PROJECTS);
        if (string != null) {
            StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
            for (int i = 0; i < 10 && stringTokenizer.hasMoreElements(); ++i) {
                String string2 = (String)stringTokenizer.nextElement();
                URI uRI = URIUtilities.createURI(string2);
                try {
                    File file = new File(uRI);
                    if (!file.exists()) continue;
                    _mruProjectList.add(uRI);
                    continue;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    if (uRI.getScheme().equals("rmi")) continue;
                    _mruProjectList.add(uRI);
                }
            }
        } else {
            URI uRI;
            String string3;
            char c = File.separatorChar;
            if (PluginUtilities.isPluginAvailable("edu.stanford.smi.protege.collab.projectPlugin.ProtegeCollabGUIProjectPlugin")) {
                string3 = ApplicationProperties.getApplicationDirectory().getPath() + c + "examples" + c + "collaborativePizza" + c + "collaborativePizza.owl.pprj";
                uRI = URIUtilities.createURI(string3);
                ApplicationProperties.addProjectToMRUList(uRI);
            }
            if (PluginUtilities.isOWLAvailable()) {
                string3 = ApplicationProperties.getApplicationDirectory().getPath() + c + "examples" + c + "pizza" + c + "pizza.owl.pprj";
                uRI = URIUtilities.createURI(string3);
                ApplicationProperties.addProjectToMRUList(uRI);
                string3 = ApplicationProperties.getApplicationDirectory().getPath() + c + "examples" + c + "sqwrl" + c + "SQWRLExamples.pprj";
                uRI = URIUtilities.createURI(string3);
                ApplicationProperties.addProjectToMRUList(uRI);
            }
            string3 = ApplicationProperties.getApplicationDirectory().getPath() + c + "examples" + c + "newspaper" + c + "newspaper.pprj";
            uRI = URIUtilities.createURI(string3);
            ApplicationProperties.addProjectToMRUList(uRI);
        }
    }

    public static void addProjectToMRUList(URI uRI) {
        if (uRI != null && !uRI.getScheme().equals("rmi")) {
            uRI = URIUtilities.normalize(uRI);
            _mruProjectList.remove(uRI);
            _mruProjectList.add(0, uRI);
            if (_mruProjectList.size() > 10) {
                _mruProjectList.remove(10);
            }
            ApplicationProperties.saveMRUProjectList();
        }
    }

    public static void flush() {
        try {
            if (_propertyFile != null) {
                FileOutputStream fileOutputStream = new FileOutputStream(_propertyFile);
                PROPERTIES.store(fileOutputStream, "Protege Properties");
                ((OutputStream)fileOutputStream).close();
            }
        }
        catch (IOException iOException) {
            Log.getLogger().warning(iOException.toString());
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
    }

    private static File getPropertiesDirectory() {
        String string;
        boolean bl = Boolean.getBoolean(PROPERTIES_IN_USER_HOME);
        File file = bl ? ((string = SystemUtilities.getSystemProperty(USERS_HOME_DIRECTORY)) == null ? null : new File(string)) : ApplicationProperties.getApplicationDirectory();
        return file;
    }

    public static File getLogFileDirectory() {
        File file = ApplicationProperties.getPropertiesDirectory();
        if (file != null) {
            file = new File(file, "logs");
            file.mkdir();
        }
        return file;
    }

    public static File getApplicationDirectory() {
        String string = SystemUtilities.getSystemProperty(APPLICATION_INSTALL_DIRECTORY);
        if (string == null) {
            string = SystemUtilities.getSystemProperty(CURRENT_WORKING_DIRECTORY);
        }
        return string == null ? null : new File(string);
    }

    public static String getExtraManifestPath() {
        String string = SystemUtilities.getSystemProperty(EXTRA_MANIFEST_PATH);
        if (string != null && string.length() > 1 && string.charAt(0) == '\"') {
            string = string.substring(1, string.length() - 1);
        }
        return string;
    }

    public static int getIntegerProperty(String string, int n) {
        int n2 = n;
        String string2 = PROPERTIES.getProperty(string);
        if (string2 != null) {
            try {
                n2 = Integer.parseInt(string2);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return n2;
    }

    public static boolean getBooleanProperty(String string, boolean bl) {
        boolean bl2 = bl;
        String string2 = PROPERTIES.getProperty(string);
        if (string2 != null) {
            try {
                bl2 = Boolean.valueOf(string2);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return bl2;
    }

    public static List getMRUProjectList() {
        return new ArrayList(_mruProjectList);
    }

    public static int getOldNextFrameNumber() {
        String string = PROPERTIES.getProperty(NEXT_FRAME_NUMBER, "0");
        int n = Integer.parseInt(string);
        return n;
    }

    public static String getBrowser() {
        String string = PROPERTIES.getProperty(BROWSER);
        if (string != null && string.length() == 0) {
            string = null;
        }
        return string;
    }

    private static Rectangle getRectangle(String string) {
        Rectangle rectangle = null;
        String string2 = PROPERTIES.getProperty(string);
        if (string2 != null) {
            rectangle = ApplicationProperties.parseRectangle(string2);
        }
        return rectangle;
    }

    public static Properties getApplicationProperties() {
        return PROPERTIES;
    }

    public static String getApplicationOrSystemProperty(String string) {
        return ApplicationProperties.getApplicationOrSystemProperty(string, null);
    }

    public static String getApplicationOrSystemProperty(String string, String string2) {
        String string3 = PROPERTIES.getProperty(string);
        if (string3 == null) {
            try {
                string3 = System.getProperty(string);
            }
            catch (AccessControlException accessControlException) {
                // empty catch block
            }
        }
        if (string3 == null) {
            string3 = string2;
        }
        return string3;
    }

    public static String getString(String string) {
        return ApplicationProperties.getString(string, null);
    }

    public static String getString(String string, String string2) {
        return PROPERTIES.getProperty(string, string2);
    }

    private static Rectangle parseRectangle(String string) {
        int[] nArray = new int[4];
        StringTokenizer stringTokenizer = new StringTokenizer(string);
        for (int i = 0; stringTokenizer.hasMoreTokens() && i < nArray.length; ++i) {
            String string2 = stringTokenizer.nextToken();
            nArray[i] = Integer.parseInt(string2);
        }
        return new Rectangle(nArray[0], nArray[1], nArray[2], nArray[3]);
    }

    public static void recordMainFrameProperties(Frame frame) {
        ApplicationProperties.saveRectangle(MAIN_FRAME_RECTANGLE, frame.getBounds());
    }

    public static void restoreMainFrameProperties(Frame frame) {
        Rectangle rectangle = ApplicationProperties.getRectangle(MAIN_FRAME_RECTANGLE);
        if (rectangle == null) {
            frame.setSize(ComponentUtilities.getDefaultMainFrameSize());
            ComponentUtilities.center(frame);
        } else {
            frame.setBounds(rectangle);
        }
    }

    private static void saveMRUProjectList() {
        StringBuffer stringBuffer = new StringBuffer();
        int n = _mruProjectList.size();
        for (int i = 0; i < n; ++i) {
            stringBuffer.append(_mruProjectList.get(i));
            stringBuffer.append(",");
        }
        stringBuffer.setLength(stringBuffer.length() - 1);
        ApplicationProperties.setProperty(MRU_PROJECTS, stringBuffer.toString());
    }

    private static void setProperty(String string, String string2) {
        try {
            if (string2 == null) {
                PROPERTIES.remove(string);
            } else {
                PROPERTIES.setProperty(string, string2);
            }
            ApplicationProperties.flush();
        }
        catch (Exception exception) {
            Log.getLogger().warning(Log.toString(exception));
        }
    }

    private static void saveRectangle(String string, Rectangle rectangle) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(String.valueOf(rectangle.x));
        stringBuffer.append(" ");
        stringBuffer.append(String.valueOf(rectangle.y));
        stringBuffer.append(" ");
        stringBuffer.append(String.valueOf(rectangle.width));
        stringBuffer.append(" ");
        stringBuffer.append(String.valueOf(rectangle.height));
        ApplicationProperties.setProperty(string, stringBuffer.toString());
    }

    public static void setInt(String string, int n) {
        ApplicationProperties.setProperty(string, String.valueOf(n));
    }

    public static void setBoolean(String string, boolean bl) {
        ApplicationProperties.setProperty(string, String.valueOf(bl));
    }

    public static void setString(String string, String string2) {
        ApplicationProperties.setProperty(string, string2);
    }

    public static boolean getWelcomeDialogShow() {
        String string = ApplicationProperties.getString(WELCOME_DIALOG, "true");
        return string.equalsIgnoreCase("true");
    }

    public static void setUserName(String string) {
        ApplicationProperties.setProperty("user.name", string);
    }

    public static void setWelcomeDialogShow(boolean bl) {
        ApplicationProperties.setBoolean(WELCOME_DIALOG, bl);
    }

    public static boolean isAutosynchronizingClsTrees() {
        return ApplicationProperties.getBooleanProperty(AUTOSYNCHRONIZE_PROPERTY, true);
    }

    public static void setAutosynchronizingClsTrees(boolean bl) {
        ApplicationProperties.setBoolean(AUTOSYNCHRONIZE_PROPERTY, bl);
    }

    public static String getGettingStartedURLString() {
        return "http://protege.stanford.edu/doc/tutorial/get_started/table_of_content.html";
    }

    public static String getFAQURLString() {
        return "http://protege.stanford.edu/doc/faq.html";
    }

    public static String getUsersGuideURLString() {
        return "http://protegewiki.stanford.edu/index.php/PrF_UG";
    }

    public static String getAllHelpURLString() {
        return "http://protege.stanford.edu/doc/users.html";
    }

    public static String getOntology101URLString() {
        return "http://protege.stanford.edu/publications/ontology_development/ontology101.html";
    }

    public static String getHowToCiteProtegeURLString() {
        return "http://protegewiki.stanford.edu/wiki/HowToCiteProtege";
    }

    public static String getUserName() {
        return ApplicationProperties.getApplicationOrSystemProperty("user.name");
    }

    public static Locale getLocale() {
        String string = ApplicationProperties.getApplicationOrSystemProperty("user.language");
        String string2 = ApplicationProperties.getApplicationOrSystemProperty("user.country");
        return new Locale(string, string2);
    }

    public static void setLocale(Locale locale) {
        ApplicationProperties.setProperty("user.language", locale.getLanguage());
        ApplicationProperties.setProperty("user.country", locale.getCountry());
    }

    public static boolean getPrettyPrintSlotWidgetLabels() {
        return ApplicationProperties.getBooleanProperty(PRETTY_PRINT_SLOT_WIDGET_LABELS, true);
    }

    public static void setPrettyPrintSlotWidgetLabels(boolean bl) {
        ApplicationProperties.setBoolean(PRETTY_PRINT_SLOT_WIDGET_LABELS, bl);
    }

    public static File getLastFileDirectory() {
        String string = ApplicationProperties.getString(LAST_FILE_DIRECTORY);
        if (string == null) {
            string = ApplicationProperties.getApplicationOrSystemProperty(USERS_HOME_DIRECTORY);
        }
        return new File(string);
    }

    public static void setLastFileDirectory(File file) {
        ApplicationProperties.setString(LAST_FILE_DIRECTORY, file.getPath());
    }

    public static URI getLastLoadeURI() {
        URI uRI = null;
        String string = ApplicationProperties.getString(LAST_LOADED_URI);
        if (string != null) {
            try {
                uRI = new URI(string);
            }
            catch (URISyntaxException uRISyntaxException) {
                // empty catch block
            }
        }
        return uRI;
    }

    public static void setLastLoadedURI(URI uRI) {
        ApplicationProperties.setString(LAST_LOADED_URI, uRI.toString());
    }

    public static int getUrlConnectTimeout() {
        int n = 15;
        String string = ApplicationProperties.getApplicationOrSystemProperty(URL_CONNECT_TIMEOUT, "15");
        try {
            n = Integer.parseInt(string);
        }
        catch (NumberFormatException numberFormatException) {
            Log.getLogger().warning("Error parsing " + string + " to an int. Cannot set URL connect timeout. Use default value (15 sec).");
        }
        return n;
    }

    public static void setUrlConnectTimeout(int n) {
        ApplicationProperties.setInt(URL_CONNECT_TIMEOUT, n);
    }

    public static int getUrlConnectReadTimeout() {
        int n = 15;
        String string = ApplicationProperties.getApplicationOrSystemProperty(URL_CONNECT_READ_TIMEOUT, "15");
        try {
            n = Integer.parseInt(string);
        }
        catch (NumberFormatException numberFormatException) {
            Log.getLogger().warning("Error parsing " + string + " to an int. Cannot set URL read connect timeout. Use default value (15 sec).");
        }
        return n;
    }

    public static void setUrlConnectReadTimeout(int n) {
        ApplicationProperties.setInt(URL_CONNECT_READ_TIMEOUT, n);
    }

    public static void setSortClassTreeOption(boolean bl) {
        ApplicationProperties.setBoolean(SORT_CLASS_TREE, bl);
    }

    public static void setSortSlotTreeOption(boolean bl) {
        ApplicationProperties.setBoolean(SORT_SLOTS_TREE, bl);
    }

    public static boolean getSortClassTreeOption() {
        return ApplicationProperties.getBooleanProperty(SORT_CLASS_TREE, true);
    }

    public static boolean getSortSlotTreeOption() {
        return ApplicationProperties.getBooleanProperty(SORT_SLOTS_TREE, true);
    }

    static {
        _mruProjectList = new ArrayList(10);
        try {
            _propertyFile = new File(ApplicationProperties.getPropertiesDirectory(), FILE_NAME);
            FileInputStream fileInputStream = new FileInputStream(_propertyFile);
            PROPERTIES.load(fileInputStream);
            ((InputStream)fileInputStream).close();
            ApplicationProperties.loadMRUProjectList();
        }
        catch (IOException iOException) {
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
    }
}

