/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protege.util;

import edu.stanford.smi.protege.model.Cls;
import edu.stanford.smi.protege.model.Frame;
import edu.stanford.smi.protege.model.Instance;
import edu.stanford.smi.protege.model.KnowledgeBase;
import edu.stanford.smi.protege.model.KnowledgeBaseFactory;
import edu.stanford.smi.protege.model.ModelUtilities;
import edu.stanford.smi.protege.model.Slot;
import edu.stanford.smi.protege.model.WidgetDescriptor;
import edu.stanford.smi.protege.plugin.ProjectFixupPlugin;
import edu.stanford.smi.protege.resource.Files;
import edu.stanford.smi.protege.resource.Text;
import edu.stanford.smi.protege.storage.clips.ClipsKnowledgeBaseFactory;
import edu.stanford.smi.protege.util.Assert;
import edu.stanford.smi.protege.util.FileUtilities;
import edu.stanford.smi.protege.util.Log;
import edu.stanford.smi.protege.util.SystemUtilities;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class Frames1_8_BackwardsCompatibilityProjectFixups
implements ProjectFixupPlugin {
    private static final String MIN_VERSION = "1.9";

    private static void addWidgetDescriptor(Instance instance, String string) {
        Object object;
        Object object2;
        Instance instance2 = (Instance)ModelUtilities.getDirectOwnSlotValue(instance, "property_list");
        Iterator iterator = ModelUtilities.getDirectOwnSlotValues(instance2, "properties").iterator();
        boolean bl = false;
        while (iterator.hasNext() && !bl) {
            object2 = (Instance)iterator.next();
            object = (String)ModelUtilities.getDirectOwnSlotValue((Frame)object2, "name");
            if (!((String)object).equals(string)) continue;
            bl = true;
        }
        if (!bl) {
            object2 = instance.getKnowledgeBase();
            object = WidgetDescriptor.create((KnowledgeBase)object2);
            ModelUtilities.setOwnSlotValue(((WidgetDescriptor)object).getInstance(), "name", string);
            ModelUtilities.addOwnSlotValue(instance2, "properties", ((WidgetDescriptor)object).getInstance());
        }
    }

    public static void fix(KnowledgeBase knowledgeBase) {
        if (Frames1_8_BackwardsCompatibilityProjectFixups.shouldUpdate(knowledgeBase)) {
            Log.getLogger().info("Backwards compatibility fixup for frames project file");
            Frames1_8_BackwardsCompatibilityProjectFixups.updateStandardForms(knowledgeBase);
        }
    }

    private static boolean shouldUpdate(KnowledgeBase knowledgeBase) {
        return !Frames1_8_BackwardsCompatibilityProjectFixups.isCurrentBuild(knowledgeBase) && !Frames1_8_BackwardsCompatibilityProjectFixups.isOwl(knowledgeBase);
    }

    private static boolean isOwl(KnowledgeBase knowledgeBase) {
        Slot slot;
        Instance instance = knowledgeBase.getInstance("PROJECT");
        String string = (String)instance.getOwnSlotValue(slot = knowledgeBase.getSlot("default_cls_metaclass"));
        return string.contains("owl:") || string.contains("/owl#");
    }

    private static Instance getClsWidgetInstance(String string, KnowledgeBase knowledgeBase) {
        Instance instance = null;
        List list = ModelUtilities.getDirectOwnSlotValues(Frames1_8_BackwardsCompatibilityProjectFixups.getProjectInstance(knowledgeBase), "customized_instance_widgets");
        for (Instance instance2 : list) {
            String string2 = (String)ModelUtilities.getDirectOwnSlotValue(instance2, "name");
            if (!string.equals(string2)) continue;
            instance = instance2;
            break;
        }
        return instance;
    }

    private static KnowledgeBaseFactory getFactory(KnowledgeBase knowledgeBase) {
        KnowledgeBaseFactory knowledgeBaseFactory = null;
        Instance instance = Frames1_8_BackwardsCompatibilityProjectFixups.getProjectInstance(knowledgeBase);
        Instance instance2 = (Instance)ModelUtilities.getDirectOwnSlotValue(instance, "sources");
        for (Instance instance3 : ModelUtilities.getDirectOwnSlotValues(instance2, "properties")) {
            String string = (String)ModelUtilities.getDirectOwnSlotValue(instance3, "name");
            if (!string.equals("factory_class_name")) continue;
            String string2 = (String)ModelUtilities.getDirectOwnSlotValue(instance3, "string_value");
            knowledgeBaseFactory = (KnowledgeBaseFactory)SystemUtilities.newInstance(string2);
            break;
        }
        return knowledgeBaseFactory;
    }

    private static Instance getProjectInstance(KnowledgeBase knowledgeBase) {
        Instance instance = knowledgeBase.getInstance("PROJECT");
        Assert.assertNotNull("instance", instance);
        return instance;
    }

    private static KnowledgeBase getTemplateKnowledgeBase(KnowledgeBase knowledgeBase) {
        ArrayList arrayList = new ArrayList();
        Reader reader = Files.getSystemClsesReader();
        KnowledgeBaseFactory knowledgeBaseFactory = Frames1_8_BackwardsCompatibilityProjectFixups.getFactory(knowledgeBase);
        String string = knowledgeBaseFactory == null ? (String)null : knowledgeBaseFactory.getProjectFilePath();
        Reader reader2 = string == null ? Files.getSystemInstancesReader() : FileUtilities.getResourceReader(knowledgeBaseFactory.getClass(), string);
        return new ClipsKnowledgeBaseFactory().loadKnowledgeBase(reader, reader2, arrayList);
    }

    private static boolean isClsMetaclass(Instance instance) {
        boolean bl = false;
        Instance instance2 = (Instance)ModelUtilities.getDirectOwnSlotValue(instance, "property_list");
        for (Instance instance3 : ModelUtilities.getDirectOwnSlotValues(instance2, "properties")) {
            String string = (String)ModelUtilities.getDirectOwnSlotValue(instance3, "name");
            if (!string.equals(":DIRECT-TEMPLATE-SLOTS")) continue;
            bl = true;
            break;
        }
        return bl;
    }

    private static boolean isCurrentBuild(KnowledgeBase knowledgeBase) {
        String string = Text.getVersion();
        String string2 = knowledgeBase.getBuildString();
        return string2 == null || string.compareTo(MIN_VERSION) >= 0;
    }

    private static boolean isSlotMetaclass(Instance instance) {
        boolean bl = false;
        Instance instance2 = (Instance)ModelUtilities.getDirectOwnSlotValue(instance, "property_list");
        for (Instance instance3 : ModelUtilities.getDirectOwnSlotValues(instance2, "properties")) {
            String string = (String)ModelUtilities.getDirectOwnSlotValue(instance3, "name");
            if (!string.equals(":SLOT-VALUE-TYPE")) continue;
            bl = true;
            break;
        }
        return bl;
    }

    private static boolean replaceFormWidget(String string, KnowledgeBase knowledgeBase, KnowledgeBase knowledgeBase2) {
        Instance instance;
        Instance instance2;
        Instance instance3 = Frames1_8_BackwardsCompatibilityProjectFixups.getClsWidgetInstance(string, knowledgeBase2);
        Instance instance4 = Frames1_8_BackwardsCompatibilityProjectFixups.getClsWidgetInstance(string, knowledgeBase);
        if (instance4 == null) {
            instance2 = knowledgeBase.getCls("Widget");
            instance4 = knowledgeBase.createInstance(null, (Cls)instance2);
            ModelUtilities.setOwnSlotValue(instance4, "name", string);
            instance = Frames1_8_BackwardsCompatibilityProjectFixups.getProjectInstance(knowledgeBase);
            ModelUtilities.addOwnSlotValue(instance, "customized_instance_widgets", instance4);
        }
        instance2 = (Instance)ModelUtilities.getDirectOwnSlotValue(instance3, "property_list");
        instance = (Instance)instance2.deepCopy(knowledgeBase, null);
        ModelUtilities.setOwnSlotValue(instance4, "property_list", instance);
        return instance3 != null;
    }

    private static void updateStandardForms(KnowledgeBase knowledgeBase) {
        KnowledgeBase knowledgeBase2 = Frames1_8_BackwardsCompatibilityProjectFixups.getTemplateKnowledgeBase(knowledgeBase);
        Instance instance = Frames1_8_BackwardsCompatibilityProjectFixups.getProjectInstance(knowledgeBase2);
        for (Instance instance2 : ModelUtilities.getDirectOwnSlotValues(instance, "customized_instance_widgets")) {
            String string = (String)ModelUtilities.getDirectOwnSlotValue(instance2, "name");
            boolean bl = Frames1_8_BackwardsCompatibilityProjectFixups.replaceFormWidget(string, knowledgeBase, knowledgeBase2);
            if (bl) continue;
            if (Frames1_8_BackwardsCompatibilityProjectFixups.isClsMetaclass(instance2)) {
                Frames1_8_BackwardsCompatibilityProjectFixups.addWidgetDescriptor(instance2, ":DIRECT-TYPE");
                continue;
            }
            if (!Frames1_8_BackwardsCompatibilityProjectFixups.isSlotMetaclass(instance2)) continue;
            Frames1_8_BackwardsCompatibilityProjectFixups.addWidgetDescriptor(instance2, ":DIRECT-TEMPLATE-SLOTS");
            Frames1_8_BackwardsCompatibilityProjectFixups.addWidgetDescriptor(instance2, ":SLOT-CONSTRAINTS");
            Frames1_8_BackwardsCompatibilityProjectFixups.addWidgetDescriptor(instance2, ":DIRECT-SUBSLOTS");
            Frames1_8_BackwardsCompatibilityProjectFixups.addWidgetDescriptor(instance2, ":DIRECT-SUPERSLOTS");
            Frames1_8_BackwardsCompatibilityProjectFixups.addWidgetDescriptor(instance2, ":DIRECT-DOMAIN");
            Frames1_8_BackwardsCompatibilityProjectFixups.addWidgetDescriptor(instance2, ":SLOT-INVERSE");
            Frames1_8_BackwardsCompatibilityProjectFixups.addWidgetDescriptor(instance2, ":SLOT-VALUES");
            Frames1_8_BackwardsCompatibilityProjectFixups.addWidgetDescriptor(instance2, ":SLOT-MINIMUM-CARDINALITY");
            Frames1_8_BackwardsCompatibilityProjectFixups.addWidgetDescriptor(instance2, ":ASSOCIATED-FACET");
        }
    }

    public void fixProject(KnowledgeBase knowledgeBase) {
        Frames1_8_BackwardsCompatibilityProjectFixups.fix(knowledgeBase);
    }

    public String getName() {
        return "Frames 1.8 Project Backwards Compatibility Fix";
    }

    public void dispose() {
    }
}

