/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protege.util.transaction.cache.impl;

import edu.stanford.smi.protege.util.transaction.cache.Cache;
import edu.stanford.smi.protege.util.transaction.cache.CacheResult;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReadUncommittedCache<S, V, R>
implements Cache<S, V, R> {
    private Map<S, Set<V>> transactedModifications = new HashMap<S, Set<V>>();
    private Cache<S, V, R> delegate;

    public ReadUncommittedCache(Cache<S, V, R> cache) {
        this.delegate = cache;
    }

    @Override
    public CacheResult<R> readCache(S s, V v) {
        return this.delegate.readCache(s, v);
    }

    @Override
    public void updateCache(S s, V v) {
        this.delegate.updateCache(s, v);
    }

    @Override
    public void updateCache(S s, V v, R r) {
        this.delegate.updateCache(s, v, r);
    }

    @Override
    public void modifyCache(S s, V v) {
        if (this.delegate.getTransactionNesting(s) > 0) {
            this.transactedModifications.get(s).add(v);
        }
        this.delegate.modifyCache(s, v);
    }

    @Override
    public void modifyCache(S s, V v, R r) {
        if (this.delegate.getTransactionNesting(s) > 0) {
            this.transactedModifications.get(s).add(v);
        }
        this.delegate.modifyCache(s, v, r);
    }

    @Override
    public void invalidate(S s) {
        this.delegate.invalidate(s);
    }

    @Override
    public boolean isInvalid() {
        return this.delegate.isInvalid();
    }

    @Override
    public void startCompleteCache() {
        this.delegate.startCompleteCache();
    }

    @Override
    public void finishCompleteCache() {
        this.delegate.finishCompleteCache();
    }

    @Override
    public void abortCompleteCache() {
        this.delegate.abortCompleteCache();
    }

    @Override
    public boolean isCacheComplete() {
        return this.delegate.isCacheComplete();
    }

    @Override
    public void beginTransaction(S s) {
        if (this.delegate.getTransactionNesting(s) == 0) {
            this.transactedModifications.put(s, new HashSet());
        }
        this.delegate.beginTransaction(s);
    }

    @Override
    public void commitTransaction(S s) {
        this.delegate.commitTransaction(s);
        if (this.delegate.getTransactionNesting(s) == 0) {
            this.transactedModifications.remove(s);
        }
    }

    @Override
    public void rollbackTransaction(S s) {
        this.delegate.rollbackTransaction(s);
        for (V v : this.transactedModifications.get(s)) {
            this.delegate.modifyCache(s, v);
        }
        if (this.delegate.getTransactionNesting(s) == 0) {
            this.transactedModifications.remove(s);
        } else {
            this.transactedModifications.get(s).clear();
        }
    }

    @Override
    public int getTransactionNesting(S s) {
        return this.delegate.getTransactionNesting(s);
    }

    @Override
    public void flush() {
        this.myFlush();
        this.delegate.flush();
    }

    private void myFlush() {
        this.transactedModifications.clear();
    }

    @Override
    public int getCacheId() {
        return this.delegate.getCacheId();
    }
}

