/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protege.widget;

import edu.stanford.smi.protege.model.Cls;
import edu.stanford.smi.protege.model.Instance;
import edu.stanford.smi.protege.resource.Icons;
import edu.stanford.smi.protege.ui.ClsInverseRelationshipPanel;
import edu.stanford.smi.protege.ui.ClsesPanel;
import edu.stanford.smi.protege.ui.DirectInstancesList;
import edu.stanford.smi.protege.ui.DirectTypesList;
import edu.stanford.smi.protege.ui.FrameRenderer;
import edu.stanford.smi.protege.ui.InstanceDisplay;
import edu.stanford.smi.protege.util.CollectionUtilities;
import edu.stanford.smi.protege.util.ComponentFactory;
import edu.stanford.smi.protege.util.Selectable;
import edu.stanford.smi.protege.util.SelectionEvent;
import edu.stanford.smi.protege.util.SelectionListener;
import edu.stanford.smi.protege.widget.AbstractTabWidget;
import edu.stanford.smi.protege.widget.ClsesAndInstancesTabDirectInstancesListDragSourceListener;
import edu.stanford.smi.protege.widget.InstanceClsesTreeTarget;
import java.awt.dnd.DragSource;
import java.awt.dnd.DropTarget;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.util.Collection;
import javax.swing.JComponent;
import javax.swing.JSplitPane;

public class ClsesAndInstancesTab
extends AbstractTabWidget {
    private static final long serialVersionUID = -918873507158261898L;
    private InstanceDisplay _instanceDisplay;
    private ClsesPanel _clsesPanel;
    private DirectInstancesList _directInstancesList;
    private DirectTypesList _directTypesList;
    private ClsInverseRelationshipPanel _inverseRelationshipPanel;
    private boolean _isUpdating;

    private JComponent createClsControlPanel() {
        JSplitPane jSplitPane = this.createTopBottomSplitPane("ClsesAndInstancesTab.left, top_bottom", 400);
        jSplitPane.setTopComponent(this.createClsesPanel());
        jSplitPane.setBottomComponent(this.createInverseRelationshipPanel());
        return jSplitPane;
    }

    private JComponent createClsesPanel() {
        this._clsesPanel = new ClsesPanel(this.getProject());
        FrameRenderer frameRenderer = FrameRenderer.createInstance();
        frameRenderer.setDisplayDirectInstanceCount(true);
        this._clsesPanel.setRenderer(frameRenderer);
        this._clsesPanel.addSelectionListener(new SelectionListener(){

            public void selectionChanged(SelectionEvent selectionEvent) {
                ClsesAndInstancesTab.this.transmitClsSelection();
            }
        });
        this._clsesPanel.getClsesTree().addFocusListener(new FocusAdapter(){

            public void focusGained(FocusEvent focusEvent) {
                ClsesAndInstancesTab.this.transmitClsSelection();
            }
        });
        return this._clsesPanel;
    }

    private JComponent createClsSplitter() {
        JSplitPane jSplitPane = this.createLeftRightSplitPane("ClsesAndInstancesTab.left_right", 250);
        jSplitPane.setLeftComponent(this.createClsControlPanel());
        jSplitPane.setRightComponent(this.createInstanceSplitter());
        return jSplitPane;
    }

    private JComponent createDirectInstancesList() {
        this._directInstancesList = new DirectInstancesList(this.getProject());
        this._directInstancesList.addSelectionListener(new SelectionListener(){

            public void selectionChanged(SelectionEvent selectionEvent) {
                if (!ClsesAndInstancesTab.this._isUpdating) {
                    ClsesAndInstancesTab.this._isUpdating = true;
                    Collection collection = ClsesAndInstancesTab.this._directInstancesList.getSelection();
                    Instance instance = collection.size() == 1 ? (Instance)CollectionUtilities.getFirstItem(collection) : null;
                    ClsesAndInstancesTab.this._instanceDisplay.setInstance(instance);
                    ClsesAndInstancesTab.this._directTypesList.setInstance(instance);
                    ClsesAndInstancesTab.this._isUpdating = false;
                }
            }
        });
        this.setInstanceSelectable((Selectable)((Object)this._directInstancesList.getDragComponent()));
        return this._directInstancesList;
    }

    private JComponent createInstanceDisplay() {
        this._instanceDisplay = new InstanceDisplay(this.getProject());
        return this._instanceDisplay;
    }

    private JComponent createInstancesPanel() {
        JSplitPane jSplitPane = ComponentFactory.createTopBottomSplitPane();
        jSplitPane.setTopComponent(this.createDirectInstancesList());
        jSplitPane.setBottomComponent(this.createDirectTypesList());
        return jSplitPane;
    }

    protected JComponent createDirectTypesList() {
        this._directTypesList = new DirectTypesList(this.getProject());
        return this._directTypesList;
    }

    private JComponent createInstanceSplitter() {
        JSplitPane jSplitPane = this.createLeftRightSplitPane("ClsesAndInstancesTab.right.left_right", 200);
        jSplitPane.setLeftComponent(this.createInstancesPanel());
        jSplitPane.setRightComponent(this.createInstanceDisplay());
        return jSplitPane;
    }

    private JComponent createInverseRelationshipPanel() {
        this._inverseRelationshipPanel = new ClsInverseRelationshipPanel(this.getProject());
        this._inverseRelationshipPanel.addSelectionListener(new SelectionListener(){

            public void selectionChanged(SelectionEvent selectionEvent) {
                Collection collection = ClsesAndInstancesTab.this._inverseRelationshipPanel.getSelection();
                if (collection.size() == 1) {
                    Cls cls = (Cls)collection.iterator().next();
                    ClsesAndInstancesTab.this._clsesPanel.setDisplayParent(cls);
                }
            }
        });
        return this._inverseRelationshipPanel;
    }

    public void initialize() {
        this.setIcon(Icons.getClsAndInstanceIcon());
        this.setLabel("Classes & Instances");
        this.add(this.createClsSplitter());
        this.setupDragAndDrop();
        this.transmitClsSelection();
        this.setClsTree(this._clsesPanel.getClsesTree());
    }

    private void setupDragAndDrop() {
        DragSource.getDefaultDragSource().createDefaultDragGestureRecognizer(this._directInstancesList, 3, new ClsesAndInstancesTabDirectInstancesListDragSourceListener());
        new DropTarget(this._clsesPanel.getDropComponent(), 3, new InstanceClsesTreeTarget());
    }

    private void transmitClsSelection() {
        Collection collection = this._clsesPanel.getSelection();
        Instance instance = null;
        Cls cls = null;
        Cls cls2 = null;
        if (collection.size() == 1 && (instance = (Instance)CollectionUtilities.getFirstItem(collection)) instanceof Cls) {
            cls = (Cls)instance;
            cls2 = this._clsesPanel.getDisplayParent();
        }
        this._inverseRelationshipPanel.setCls(cls, cls2);
        this._directInstancesList.setClses(collection);
        this._directInstancesList.clearSelection();
        this._instanceDisplay.setInstance(cls);
    }
}

