/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protege.widget;

import edu.stanford.smi.protege.model.Cls;
import edu.stanford.smi.protege.model.Facet;
import edu.stanford.smi.protege.model.KnowledgeBase;
import edu.stanford.smi.protege.model.Slot;
import edu.stanford.smi.protege.model.ValueType;
import edu.stanford.smi.protege.model.WidgetDescriptor;
import edu.stanford.smi.protege.plugin.PluginUtilities;
import edu.stanford.smi.protege.util.CollectionUtilities;
import edu.stanford.smi.protege.util.Log;
import edu.stanford.smi.protege.util.StringUtilities;
import edu.stanford.smi.protege.util.SystemUtilities;
import edu.stanford.smi.protege.widget.WidgetMapper;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.logging.Level;
import java.util.logging.Logger;

public class DefaultWidgetMapper
implements WidgetMapper {
    private Logger log = Log.getLogger(DefaultWidgetMapper.class);
    private static final String METHOD_NAME = "isSuitable";
    private static final Class[] METHOD_ARG_CLASSES = new Class[]{Cls.class, Slot.class, Facet.class};
    private KnowledgeBase _knowledgeBase;

    public DefaultWidgetMapper(KnowledgeBase knowledgeBase) {
        this._knowledgeBase = knowledgeBase;
    }

    public WidgetDescriptor createWidgetDescriptor(Cls cls, Slot slot, Facet facet) {
        WidgetDescriptor widgetDescriptor = WidgetDescriptor.create(this._knowledgeBase);
        String string = this.getDefaultWidgetClassName(cls, slot, facet);
        widgetDescriptor.setWidgetClassName(string);
        widgetDescriptor.setName(slot.getName());
        return widgetDescriptor;
    }

    public String getDefaultWidgetClassName(Cls cls, Slot slot, Facet facet) {
        Object object;
        boolean bl = cls.getTemplateSlotAllowsMultipleValues(slot);
        ValueType valueType = cls.getTemplateSlotValueType(slot);
        Cls cls2 = null;
        if (valueType == ValueType.INSTANCE && (object = cls.getTemplateSlotAllowedClses(slot)).size() == 1) {
            cls2 = (Cls)CollectionUtilities.getFirstItem(object);
        }
        if ((object = PluginUtilities.getDefaultWidgetClassName(bl, valueType, cls2, slot)) != null && !this.isSuitable(cls, slot, facet, (String)object)) {
            object = PluginUtilities.getDefaultWidgetClassName(bl, valueType, cls2);
        }
        return object;
    }

    public Collection getSuitableWidgetClassNames(Cls cls, Slot slot, Facet facet) {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (String string : PluginUtilities.getAvailableSlotWidgetClassNames()) {
            if (!this.isSuitable(cls, slot, facet, string)) continue;
            arrayList.add(string);
        }
        return arrayList;
    }

    public boolean isSuitable(Cls cls, Slot slot, Facet facet, String string) {
        boolean bl;
        try {
            Class clazz = SystemUtilities.forName(string);
            if (clazz == null) {
                bl = false;
                Log.getLogger().warning("Invalid widget class name: " + string);
            } else {
                Method method = clazz.getMethod(METHOD_NAME, METHOD_ARG_CLASSES);
                Boolean bl2 = (Boolean)method.invoke(null, cls, slot, facet);
                bl = bl2;
            }
        }
        catch (Exception exception) {
            this.log.log(Level.WARNING, "Could not verify isSuitable for widget: " + string + " class: " + cls + " slot: " + slot, exception);
            bl = false;
        }
        return bl;
    }

    public boolean isSuitableWidget(Cls cls, Slot slot, Facet facet, WidgetDescriptor widgetDescriptor) {
        return this.isSuitable(cls, slot, facet, widgetDescriptor.getWidgetClassName());
    }

    public String toString() {
        return StringUtilities.getClassName(this);
    }
}

