/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protege.widget;

import edu.stanford.smi.protege.model.Slot;
import edu.stanford.smi.protege.model.WidgetDescriptor;
import edu.stanford.smi.protege.ui.FrameRenderer;
import edu.stanford.smi.protege.ui.WidgetClassNameRenderer;
import edu.stanford.smi.protege.util.AbstractValidatableComponent;
import edu.stanford.smi.protege.util.ComponentFactory;
import edu.stanford.smi.protege.util.ComponentUtilities;
import edu.stanford.smi.protege.util.PropertyList;
import edu.stanford.smi.protege.widget.FormWidget;
import edu.stanford.smi.protege.widget.WidgetDescriptorEditor;
import java.awt.BorderLayout;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Collections;
import javax.swing.JComponent;
import javax.swing.JTable;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableModel;

public class FormWidgetConfigurationWidgetsTab
extends AbstractValidatableComponent {
    private static final long serialVersionUID = -6726240065845038813L;
    private FormWidget _formWidget;
    private JTable _table;

    public FormWidgetConfigurationWidgetsTab(FormWidget formWidget) {
        this._formWidget = formWidget;
        this.setLayout(new BorderLayout());
        this.add(this.createTableComponent());
    }

    private JComponent createTableComponent() {
        this._table = ComponentFactory.createTable(null);
        this._table.setModel(this.createTableModel());
        ComponentUtilities.addColumn(this._table, FrameRenderer.createInstance());
        ComponentUtilities.addColumn(this._table, new WidgetClassNameRenderer(), new WidgetDescriptorEditor(this._formWidget));
        return ComponentFactory.createScrollPane(this._table);
    }

    private TableModel createTableModel() {
        PropertyList propertyList = this._formWidget.getPropertyList();
        DefaultTableModel defaultTableModel = new DefaultTableModel();
        defaultTableModel.addColumn("Slot");
        defaultTableModel.addColumn("Widget");
        ArrayList arrayList = new ArrayList(this._formWidget.getCls().getVisibleTemplateSlots());
        Collections.sort(arrayList);
        for (Slot slot : arrayList) {
            String string;
            Rectangle rectangle = null;
            WidgetDescriptor widgetDescriptor = propertyList.getWidgetDescriptor(slot.getName());
            String string2 = string = widgetDescriptor == null ? (String)null : widgetDescriptor.getWidgetClassName();
            if (string == null) {
                string = WidgetClassNameRenderer.NONE;
            } else {
                rectangle = widgetDescriptor.getBounds();
            }
            defaultTableModel.addRow(new Object[]{slot, string, rectangle});
        }
        return defaultTableModel;
    }

    public void saveContents() {
        int n = this._table.getRowCount();
        TableModel tableModel = this._table.getModel();
        for (int i = 0; i < n; ++i) {
            Slot slot = (Slot)tableModel.getValueAt(i, 0);
            String string = (String)tableModel.getValueAt(i, 1);
            if (string.equals(WidgetClassNameRenderer.NONE)) {
                string = null;
            }
            this._formWidget.replaceWidget(slot, string);
        }
    }

    public boolean validateContents() {
        return true;
    }
}

