/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protege.server.metaproject;

import edu.stanford.smi.protege.model.KnowledgeBase;
import edu.stanford.smi.protege.model.Project;
import edu.stanford.smi.protege.server.RemoteProjectManager;
import edu.stanford.smi.protege.server.RemoteServer;
import edu.stanford.smi.protege.server.RemoteSession;
import edu.stanford.smi.protege.server.Server;
import edu.stanford.smi.protege.server.Server_Test;
import edu.stanford.smi.protege.test.APITestCase;
import edu.stanford.smi.protege.util.Log;
import edu.stanford.smi.protege.util.SystemUtilities;
import java.rmi.Naming;
import java.rmi.NotBoundException;
import java.rmi.RemoteException;
import java.util.Collection;
import java.util.logging.Logger;

public class ReadPolicy_Test
extends APITestCase {
    private Logger log = Log.getLogger(ReadPolicy_Test.class);
    public static final String USER1 = "Natasha Noy";
    public static final String PASSWORD1 = "natalia";
    public static final String USER2 = "Tania Tudorache";
    public static final String PASSWORD2 = "tania";
    public static final String USER3 = "Timothy Redmond";
    public static final String PASSWORD3 = "troglodyte";
    public static final String META_PROJECT = "Metaproject";
    public static final String NEWSPAPER_PROJECT = "Newspaper";
    public static final String WINES_PROJECT = "Wines";
    private RemoteServer clientsRemoteServer;

    public void setUp() throws Exception {
        super.setUp();
        try {
            Server_Test.setMetaProject("junit/pprj/policy/metaproject01.pprj");
            Server_Test.startServer();
            this.clientsRemoteServer = (RemoteServer)Naming.lookup("//localhost/" + Server.getBoundName());
        }
        catch (NotBoundException notBoundException) {
            ReadPolicy_Test.fail((String)"Could not bind to server (is rmiregistry running?)");
        }
    }

    public void testNatashaAccess() throws Exception {
        RemoteSession remoteSession = this.clientsRemoteServer.openSession(USER1, SystemUtilities.getMachineIpAddress(), PASSWORD1);
        Collection<String> collection = this.clientsRemoteServer.getAvailableProjectNames(remoteSession);
        ReadPolicy_Test.assertEquals((int)0, (int)collection.size());
        this.checkReadAccess(remoteSession, META_PROJECT, false);
        this.checkReadAccess(remoteSession, NEWSPAPER_PROJECT, true);
        this.checkReadAccess(remoteSession, WINES_PROJECT, false);
    }

    public void testTaniaAccess() throws Exception {
        RemoteSession remoteSession = this.clientsRemoteServer.openSession(USER2, SystemUtilities.getMachineIpAddress(), PASSWORD2);
        Collection<String> collection = this.clientsRemoteServer.getAvailableProjectNames(remoteSession);
        ReadPolicy_Test.assertEquals((int)2, (int)collection.size());
        ReadPolicy_Test.assertTrue((boolean)collection.contains(NEWSPAPER_PROJECT));
        ReadPolicy_Test.assertTrue((boolean)collection.contains(WINES_PROJECT));
        this.checkReadAccess(remoteSession, META_PROJECT, false);
        this.checkReadAccess(remoteSession, NEWSPAPER_PROJECT, true);
        this.checkReadAccess(remoteSession, WINES_PROJECT, true);
    }

    public void testTimothyAccess() throws Exception {
        RemoteSession remoteSession = this.clientsRemoteServer.openSession(USER3, SystemUtilities.getMachineIpAddress(), PASSWORD3);
        Collection<String> collection = this.clientsRemoteServer.getAvailableProjectNames(remoteSession);
        ReadPolicy_Test.assertEquals((int)2, (int)collection.size());
        ReadPolicy_Test.assertTrue((boolean)collection.contains(NEWSPAPER_PROJECT));
        ReadPolicy_Test.assertTrue((boolean)collection.contains(WINES_PROJECT));
        this.checkReadAccess(remoteSession, META_PROJECT, true);
        this.checkReadAccess(remoteSession, NEWSPAPER_PROJECT, true);
        this.checkReadAccess(remoteSession, WINES_PROJECT, true);
    }

    private void checkReadAccess(RemoteSession remoteSession, String string, boolean bl) throws RemoteException {
        remoteSession = this.clientsRemoteServer.cloneSession(remoteSession);
        Project project = RemoteProjectManager.getInstance().connectToProject(this.clientsRemoteServer, remoteSession, string);
        if (!bl) {
            ReadPolicy_Test.assertTrue((project == null ? 1 : 0) != 0);
            return;
        }
        ReadPolicy_Test.assertTrue((project != null ? 1 : 0) != 0);
        KnowledgeBase knowledgeBase = project.getKnowledgeBase();
        if (string.equals(META_PROJECT)) {
            ReadPolicy_Test.assertNotNull((Object)knowledgeBase.getCls("Group"));
        } else if (string.equals(NEWSPAPER_PROJECT)) {
            ReadPolicy_Test.assertNotNull((Object)knowledgeBase.getCls("Article"));
        } else if (string.equals(WINES_PROJECT)) {
            ReadPolicy_Test.assertNotNull((Object)knowledgeBase.getCls("Wine"));
        }
        project.dispose();
    }
}

