/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protege.server.util;

import edu.stanford.smi.protege.model.Cls;
import edu.stanford.smi.protege.model.KnowledgeBase;
import edu.stanford.smi.protege.model.Slot;
import edu.stanford.smi.protege.model.ValueType;
import edu.stanford.smi.protege.server.metaproject.MetaProject;
import edu.stanford.smi.protege.server.metaproject.User;
import edu.stanford.smi.protege.server.metaproject.impl.MetaProjectImpl;
import edu.stanford.smi.protege.server.metaproject.impl.WrappedProtegeInstanceImpl;
import edu.stanford.smi.protege.util.ArchiveManager;
import edu.stanford.smi.protege.util.CollectionUtilities;
import edu.stanford.smi.protege.util.Log;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.logging.Level;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ServerUtil {
    public static void fixMetaProject(MetaProject metaProject) {
        block5: {
            if (!(metaProject instanceof MetaProjectImpl)) {
                return;
            }
            boolean bl = false;
            MetaProjectImpl metaProjectImpl = (MetaProjectImpl)metaProject;
            try {
                Object object;
                bl = ServerUtil.addPolicyControlledObjectClass(metaProjectImpl);
                bl = ServerUtil.addAccessSlots(metaProjectImpl) || bl;
                bl = ServerUtil.changeGroup(metaProjectImpl) || bl;
                bl = ServerUtil.addEmail(metaProjectImpl) || bl;
                bl = ServerUtil.addSalt(metaProjectImpl) || bl;
                boolean bl2 = bl = ServerUtil.addPropertyValues(metaProjectImpl) || bl;
                if (!bl) break block5;
                try {
                    object = ArchiveManager.getArchiveManager();
                    ((ArchiveManager)object).archive(metaProjectImpl.getKnowledgeBase().getProject(), "Version before the update of the metaproject format from " + new Date());
                    Log.getLogger().info("Archived original metaproject to archive subfolder.");
                }
                catch (Exception exception) {
                    Log.getLogger().log(Level.WARNING, "Failed at creating backup of metaproject", exception);
                }
                object = new ArrayList();
                metaProjectImpl.save((Collection)object);
                Log.getLogger().info("The metaproject was updated to a new version. Saved the updated metaproject on " + new Date());
                Log.handleErrors(Log.getLogger(), Level.WARNING, (Collection)object);
            }
            catch (Throwable throwable) {
                Log.getLogger().log(Level.WARNING, "Failed to fix up metaproject to new version.", throwable);
            }
        }
    }

    private static boolean addPropertyValues(MetaProjectImpl metaProjectImpl) {
        Cls cls;
        Cls cls2;
        boolean bl = false;
        KnowledgeBase knowledgeBase = metaProjectImpl.getKnowledgeBase();
        bl = ServerUtil.addTemplateSlot(knowledgeBase, cls2 = ServerUtil.createCls(knowledgeBase, MetaProjectImpl.ClsEnum.PropertyValue.name(), knowledgeBase.getRootClses()), MetaProjectImpl.SlotEnum.propertyName) || bl;
        bl = ServerUtil.addTemplateSlot(knowledgeBase, cls2, MetaProjectImpl.SlotEnum.propertyValue) || bl;
        Slot slot = knowledgeBase.getSlot(MetaProjectImpl.SlotEnum.properties.name());
        if (slot == null) {
            slot = knowledgeBase.createSlot(MetaProjectImpl.SlotEnum.properties.name());
            slot.setValueType(ValueType.INSTANCE);
            slot.setAllowsMultipleValues(true);
            slot.setAllowedClses(CollectionUtilities.createCollection(cls2));
            bl = true;
        }
        bl = ServerUtil.addTemplateSlot(knowledgeBase, cls = metaProjectImpl.getCls(MetaProjectImpl.ClsEnum.User), MetaProjectImpl.SlotEnum.properties) || bl;
        Cls cls3 = metaProjectImpl.getCls(MetaProjectImpl.ClsEnum.PolicyControlledObject);
        bl = ServerUtil.addTemplateSlot(knowledgeBase, cls3, MetaProjectImpl.SlotEnum.properties) || bl;
        Cls cls4 = metaProjectImpl.getCls(MetaProjectImpl.ClsEnum.GroupOperation);
        bl = ServerUtil.addTemplateSlot(knowledgeBase, cls4, MetaProjectImpl.SlotEnum.properties) || bl;
        Cls cls5 = metaProjectImpl.getCls(MetaProjectImpl.ClsEnum.Operation);
        bl = ServerUtil.addTemplateSlot(knowledgeBase, cls5, MetaProjectImpl.SlotEnum.properties) || bl;
        return bl;
    }

    private static boolean addEmail(MetaProjectImpl metaProjectImpl) {
        boolean bl = false;
        KnowledgeBase knowledgeBase = metaProjectImpl.getKnowledgeBase();
        Slot slot = knowledgeBase.getSlot(MetaProjectImpl.SlotEnum.email.name());
        if (slot == null) {
            slot = knowledgeBase.createSlot(MetaProjectImpl.SlotEnum.email.name());
            Cls cls = metaProjectImpl.getCls(MetaProjectImpl.ClsEnum.User);
            cls.addDirectTemplateSlot(slot);
            bl = true;
        }
        return bl;
    }

    private static boolean addSalt(MetaProjectImpl metaProjectImpl) {
        boolean bl = false;
        KnowledgeBase knowledgeBase = metaProjectImpl.getKnowledgeBase();
        Slot slot = knowledgeBase.getSlot(MetaProjectImpl.SlotEnum.salt.name());
        if (slot == null) {
            slot = knowledgeBase.createSlot(MetaProjectImpl.SlotEnum.salt.name());
            Cls cls = metaProjectImpl.getCls(MetaProjectImpl.ClsEnum.User);
            cls.addDirectTemplateSlot(slot);
            Slot slot2 = metaProjectImpl.getSlot(MetaProjectImpl.SlotEnum.password);
            for (User user : metaProjectImpl.getUsers()) {
                WrappedProtegeInstanceImpl wrappedProtegeInstanceImpl = (WrappedProtegeInstanceImpl)((Object)user);
                String string = (String)wrappedProtegeInstanceImpl.getProtegeInstance().getOwnSlotValue(slot2);
                user.setPassword(string);
            }
            bl = true;
            Log.getLogger().info("\tEncoded all user passwords as part of the metaproject upgrade. Please adjust the User class forms to use the DigestedPassword slot widget for password field.");
        }
        return bl;
    }

    private static boolean addPolicyControlledObjectClass(MetaProjectImpl metaProjectImpl) {
        Cls cls;
        boolean bl = false;
        KnowledgeBase knowledgeBase = metaProjectImpl.getKnowledgeBase();
        Cls cls2 = knowledgeBase.getCls(MetaProjectImpl.ClsEnum.PolicyControlledObject.name());
        if (cls2 == null) {
            Log.getLogger().info("Fixing up the metaproject to new version. No information will be lost.");
            cls2 = knowledgeBase.createCls(MetaProjectImpl.ClsEnum.PolicyControlledObject.name(), knowledgeBase.getRootClses());
            bl = true;
        }
        ServerUtil.addTemplateSlot(cls2, metaProjectImpl.getSlot(MetaProjectImpl.SlotEnum.name));
        ServerUtil.addTemplateSlot(cls2, metaProjectImpl.getSlot(MetaProjectImpl.SlotEnum.description));
        ServerUtil.addTemplateSlot(cls2, metaProjectImpl.getSlot(MetaProjectImpl.SlotEnum.allowedGroupOperation));
        Slot slot = knowledgeBase.getSlot(MetaProjectImpl.SlotEnum.hostName.name());
        if (slot == null) {
            slot = knowledgeBase.createSlot(MetaProjectImpl.SlotEnum.hostName.name());
            bl = true;
        }
        if ((cls = knowledgeBase.getCls(MetaProjectImpl.ClsEnum.Server.name())) == null) {
            cls = knowledgeBase.createCls(MetaProjectImpl.ClsEnum.Server.name(), CollectionUtilities.createCollection(cls2));
            bl = true;
        }
        ServerUtil.addTemplateSlot(cls, slot);
        Cls cls3 = metaProjectImpl.getCls(MetaProjectImpl.ClsEnum.Project);
        if (!cls3.hasSuperclass(cls2)) {
            cls3.addDirectSuperclass(cls2);
            cls3.removeDirectSuperclass(knowledgeBase.getRootCls());
            bl = true;
        }
        return bl;
    }

    private static boolean addAccessSlots(MetaProjectImpl metaProjectImpl) {
        Cls cls;
        boolean bl = false;
        KnowledgeBase knowledgeBase = metaProjectImpl.getKnowledgeBase();
        bl = ServerUtil.addTemplateSlot(knowledgeBase, cls = knowledgeBase.getCls(MetaProjectImpl.ClsEnum.User.toString()), MetaProjectImpl.SlotEnum.lastLogin) || bl;
        bl = ServerUtil.addTemplateSlot(knowledgeBase, cls, MetaProjectImpl.SlotEnum.lastAccess) || bl;
        return bl;
    }

    private static boolean changeGroup(MetaProjectImpl metaProjectImpl) {
        boolean bl = false;
        KnowledgeBase knowledgeBase = metaProjectImpl.getKnowledgeBase();
        Cls cls = knowledgeBase.getCls(MetaProjectImpl.ClsEnum.PolicyControlledObject.name());
        Cls cls2 = knowledgeBase.getCls(MetaProjectImpl.ClsEnum.Group.name());
        if (!cls2.hasSuperclass(cls)) {
            cls2.addDirectSuperclass(cls);
            cls2.removeDirectSuperclass(knowledgeBase.getRootCls());
            Cls cls3 = knowledgeBase.getCls(MetaProjectImpl.ClsEnum.Operation.name());
            Collection<Cls> collection = CollectionUtilities.createCollection(cls3);
            ServerUtil.createCls(knowledgeBase, "GroupAppliedOperation", collection);
            ServerUtil.createCls(knowledgeBase, "ProjectAppliedOperation", collection);
            ServerUtil.createCls(knowledgeBase, "ServerAppliedOperation", collection);
            bl = true;
        }
        return bl;
    }

    private static boolean addTemplateSlot(KnowledgeBase knowledgeBase, Cls cls, MetaProjectImpl.SlotEnum slotEnum) {
        String string = slotEnum.toString();
        boolean bl = false;
        Slot slot = knowledgeBase.getSlot(string);
        if (slot == null) {
            slot = knowledgeBase.createSlot(string);
            bl = true;
        }
        return ServerUtil.addTemplateSlot(cls, slot) || bl;
    }

    private static boolean addTemplateSlot(Cls cls, Slot slot) {
        if (!cls.hasTemplateSlot(slot)) {
            cls.addDirectTemplateSlot(slot);
            return true;
        }
        return false;
    }

    private static Cls createCls(KnowledgeBase knowledgeBase, String string, Collection<Cls> collection) {
        Cls cls = knowledgeBase.getCls(string);
        if (cls == null) {
            cls = knowledgeBase.createCls(string, collection);
        }
        return cls;
    }
}

