/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protege.storage.clips;

import edu.stanford.smi.protege.util.Log;
import edu.stanford.smi.protege.util.MessageError;
import java.awt.BorderLayout;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.Collection;
import java.util.logging.Level;
import javax.swing.JComponent;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;

public class ParseErrorPanel
extends JComponent {
    public ParseErrorPanel(Collection collection) {
        this.setLayout(new BorderLayout());
        JTextArea jTextArea = new JTextArea();
        this.add(new JScrollPane(jTextArea));
        jTextArea.setText(ParseErrorPanel.getText(collection));
        jTextArea.setEditable(false);
        this.setPreferredSize(new Dimension(500, 400));
    }

    private static String getText(Collection collection) {
        if (collection.size() == 0) {
            return new String();
        }
        StringBuffer stringBuffer = new StringBuffer();
        ArrayList arrayList = new ArrayList(collection);
        stringBuffer.append("Errors found performing operation.\n\n");
        for (int i = 0; i < arrayList.size(); ++i) {
            Object e = arrayList.get(i);
            String string = i + 1 + ". ";
            if (e instanceof MessageError) {
                string = string + ParseErrorPanel.getMessageErrorText((MessageError)e);
            } else if (e instanceof Exception) {
                Exception exception = (Exception)e;
                string = string + "Exception " + exception.getClass().toString() + (exception.getMessage() == null ? "" : ". \nMessage: " + exception.getMessage());
                Log.getLogger().log(Level.WARNING, "Exception caught", exception);
            } else {
                string = string + (e == null ? "missing message" : e.toString());
            }
            stringBuffer.append(string);
            stringBuffer.append("\n\n");
        }
        stringBuffer.append("See console and log for more details.");
        return stringBuffer.toString();
    }

    private static String getMessageErrorText(MessageError messageError) {
        Throwable throwable;
        String string = new String();
        if (messageError.getMessage() != null) {
            string = string + messageError.getMessage() + "\n";
        }
        if ((throwable = messageError.getException()) != null) {
            string = string + "    " + "Exception " + throwable.getClass().toString() + (throwable.getMessage() == null ? "" : ".  Message: " + throwable.getMessage());
        }
        return string;
    }
}

