/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protege.storage.database;

import edu.stanford.smi.protege.storage.database.DatabaseKnowledgeBaseSourcesEditor;
import edu.stanford.smi.protege.util.ApplicationProperties;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum DatabaseProperty {
    DRIVER_PROPERTY("driver", "com.mysql.jdbc.Driver", "JDBC Driver Class Name"),
    TABLENAME_PROPERTY("table", "ProtegeTable", "Table"),
    URL_PROPERTY("url", "jdbc:mysql://localhost/protege", "JDBC URL"),
    USERNAME_PROPERTY("username", null, "Username"),
    PASSWORD_PROPERTY("password", null, "Password");

    private String name;
    private String defaultValue;
    private String title;

    private DatabaseProperty(String string2, String string3, String string4) {
        this.name = string2;
        this.defaultValue = string3;
        this.title = string4;
    }

    public String getName() {
        return this.name;
    }

    public String getDefaultValue() {
        return this.defaultValue;
    }

    public String getTitle() {
        return this.title;
    }

    public static String getProperty(DatabaseProperty databaseProperty) {
        return ApplicationProperties.getString(DatabaseProperty.getPropertyName(databaseProperty.getName()), databaseProperty.getDefaultValue());
    }

    public static void setProperty(DatabaseProperty databaseProperty, String string) {
        ApplicationProperties.setString(DatabaseProperty.getPropertyName(databaseProperty.getName()), string);
    }

    private static String getPropertyName(String string) {
        return DatabaseKnowledgeBaseSourcesEditor.class.getName() + "." + string;
    }
}

