/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protege.widget;

import edu.stanford.smi.protege.model.Cls;
import edu.stanford.smi.protege.model.Instance;
import edu.stanford.smi.protege.resource.Icons;
import edu.stanford.smi.protege.resource.LocalizedText;
import edu.stanford.smi.protege.resource.ResourceKey;
import edu.stanford.smi.protege.ui.ClsInverseRelationshipPanel;
import edu.stanford.smi.protege.ui.ClsesPanel;
import edu.stanford.smi.protege.ui.InstanceDisplay;
import edu.stanford.smi.protege.util.CollectionUtilities;
import edu.stanford.smi.protege.util.LabeledComponent;
import edu.stanford.smi.protege.util.SelectionEvent;
import edu.stanford.smi.protege.util.SelectionListener;
import edu.stanford.smi.protege.widget.AbstractTabWidget;
import java.util.Collection;
import javax.swing.JComponent;
import javax.swing.JSplitPane;

public class ClsesTab
extends AbstractTabWidget {
    private ClsesPanel _clsesPanel;
    private ClsInverseRelationshipPanel _inverseRelationshipPanel;
    private InstanceDisplay _instanceDisplay;

    protected JComponent createClsDisplay() {
        this._instanceDisplay = new InstanceDisplay(this.getProject());
        return this._instanceDisplay;
    }

    protected ClsesPanel createClsesPanel() {
        ClsesPanel clsesPanel = new ClsesPanel(this.getProject());
        clsesPanel.addSelectionListener(new SelectionListener(){

            public void selectionChanged(SelectionEvent selectionEvent) {
                ClsesTab.this.transmitSelection();
            }
        });
        return clsesPanel;
    }

    protected JComponent createClsesSplitter() {
        JSplitPane jSplitPane = this.createTopBottomSplitPane("ClsesTab.left.top_bottom", 400);
        this._clsesPanel = this.createClsesPanel();
        jSplitPane.setTopComponent(this._clsesPanel);
        this._inverseRelationshipPanel = this.createInverseRelationshipPanel();
        jSplitPane.setBottomComponent(this._inverseRelationshipPanel);
        return jSplitPane;
    }

    protected ClsInverseRelationshipPanel createInverseRelationshipPanel() {
        ClsInverseRelationshipPanel clsInverseRelationshipPanel = new ClsInverseRelationshipPanel(this.getProject());
        this.initInverseRelationshipPanelListener(clsInverseRelationshipPanel);
        return clsInverseRelationshipPanel;
    }

    protected void initInverseRelationshipPanelListener(final ClsInverseRelationshipPanel clsInverseRelationshipPanel) {
        clsInverseRelationshipPanel.addSelectionListener(new SelectionListener(){

            public void selectionChanged(SelectionEvent selectionEvent) {
                Collection collection = clsInverseRelationshipPanel.getSelection();
                if (collection.size() == 1) {
                    Cls cls = (Cls)CollectionUtilities.getFirstItem(collection);
                    ClsesTab.this._clsesPanel.setDisplayParent(cls);
                }
            }
        });
    }

    protected JComponent createMainSplitter() {
        JSplitPane jSplitPane = this.createLeftRightSplitPane("ClsesTab.left_right", 250);
        jSplitPane.setLeftComponent(this.createClsesSplitter());
        jSplitPane.setRightComponent(this.createClsDisplay());
        return jSplitPane;
    }

    public void initialize() {
        this.setIcon(Icons.getClsIcon());
        this.setLabel(LocalizedText.getText(ResourceKey.CLASSES_VIEW_TITLE));
        this.setShortDescription("Domain Ontology");
        this.add(this.createMainSplitter());
        this.setInitialSelection();
        this.setClsTree(this._clsesPanel.getClsesTree());
    }

    public LabeledComponent getLabeledComponent() {
        return this._clsesPanel.getLabeledComponent();
    }

    public void setFinderComponent(JComponent jComponent) {
        this._clsesPanel.setFinderComponent(jComponent);
    }

    private void setInitialSelection() {
        if (this._clsesPanel != null) {
            this.transmitSelection();
        }
    }

    protected void transmitSelection() {
        Collection collection = this._clsesPanel.getSelection();
        Instance instance = null;
        Cls cls = null;
        Cls cls2 = null;
        if (collection.size() == 1 && (instance = (Instance)CollectionUtilities.getFirstItem(collection)) instanceof Cls) {
            cls = (Cls)instance;
            cls2 = this._clsesPanel.getDisplayParent();
        }
        this._inverseRelationshipPanel.setCls(cls, cls2);
        this._instanceDisplay.setInstance(instance);
    }
}

