/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protege.widget;

import edu.stanford.smi.protege.model.Cls;
import edu.stanford.smi.protege.model.Facet;
import edu.stanford.smi.protege.model.Slot;
import edu.stanford.smi.protege.model.ValueType;
import edu.stanford.smi.protege.server.metaproject.impl.MetaProjectImpl;
import edu.stanford.smi.protege.ui.ProjectManager;
import edu.stanford.smi.protege.util.CollectionUtilities;
import edu.stanford.smi.protege.util.DigestAndSalt;
import edu.stanford.smi.protege.util.LabeledComponent;
import edu.stanford.smi.protege.util.Log;
import edu.stanford.smi.protege.util.ModalDialog;
import edu.stanford.smi.protege.util.StringUtilities;
import edu.stanford.smi.protege.widget.TextComponentWidget;
import edu.stanford.smi.protege.widget.TextFieldWidget;
import java.awt.Component;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JTextField;
import javax.swing.text.JTextComponent;

public class DigestedPasswordWidget
extends TextFieldWidget {
    private static final long serialVersionUID = 7208216346180195394L;
    public static final String SALT_SLOT_NAME = MetaProjectImpl.SlotEnum.salt.name();

    public JComponent createCenterComponent(JTextComponent jTextComponent) {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 2));
        jTextComponent.setEditable(false);
        jTextComponent.setEnabled(false);
        jPanel.add(jTextComponent);
        jPanel.add(Box.createHorizontalStrut(10));
        JButton jButton = new JButton(this.createEditPasswordAction());
        jButton.setText("Change password");
        jPanel.add(jButton);
        return jPanel;
    }

    public void initialize() {
        super.initialize(false, 4, 1);
    }

    protected Action createEditPasswordAction() {
        return new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                final PasswordPanel passwordPanel = new PasswordPanel();
                int n = ModalDialog.showDialog(ProjectManager.getProjectManager().getCurrentProjectView(), passwordPanel, "Change password", 11, new ModalDialog.CloseCallback(){

                    public boolean canClose(int n) {
                        boolean bl = passwordPanel.validatePasswords();
                        if (!bl) {
                            ModalDialog.showMessageDialog((Component)passwordPanel, "Passwords do not match. Please enter them again.", "Error");
                            passwordPanel.clear();
                        }
                        return bl;
                    }
                });
                if (n == 1) {
                    DigestAndSalt digestAndSalt = DigestedPasswordWidget.this.generateDigestAndSalt(passwordPanel.getPassword());
                    DigestedPasswordWidget.this.setDigestAndSalt(digestAndSalt);
                }
            }
        };
    }

    protected DigestAndSalt generateDigestAndSalt(String string) {
        return StringUtilities.makeDigest(string);
    }

    protected void setDigestAndSalt(DigestAndSalt digestAndSalt) {
        this.setValues(CollectionUtilities.createCollection(digestAndSalt.getDigest()));
        Slot slot = this.getKnowledgeBase().getSlot(SALT_SLOT_NAME);
        if (slot == null) {
            Log.getLogger().severe("Could not find salt slot associated to class : " + this.getCls() + " and instance: " + this.getInstance());
        } else {
            this.getInstance().setOwnSlotValue(slot, digestAndSalt.getSalt());
            this.valueChanged();
        }
    }

    public static boolean isSuitable(Cls cls, Slot slot, Facet facet) {
        boolean bl = TextComponentWidget.isSuitable(cls, slot, facet);
        if (cls == null) {
            return false;
        }
        Slot slot2 = cls.getKnowledgeBase().getSlot(SALT_SLOT_NAME);
        bl = bl && slot2 != null;
        bl = bl && cls.hasTemplateSlot(slot2) && !cls.getTemplateSlotAllowsMultipleValues(slot2) && slot2.getValueType() == ValueType.STRING;
        return bl;
    }

    private class PasswordPanel
    extends JPanel {
        private JTextField pass1;
        private JTextField pass2;

        public PasswordPanel() {
            this.setLayout(new BoxLayout(this, 3));
            this.pass1 = new JPasswordField(20);
            this.pass2 = new JPasswordField(20);
            this.add(new LabeledComponent("New password", this.pass1));
            this.add(new LabeledComponent("Retype password", this.pass2));
        }

        public boolean validatePasswords() {
            return this.pass1.getText().equals(this.pass2.getText());
        }

        public void clear() {
            this.pass1.setText("");
            this.pass2.setText("");
        }

        public String getPassword() {
            return this.pass1.getText();
        }
    }
}

