/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protege.widget;

import edu.stanford.smi.protege.util.ApplicationProperties;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.Properties;
import javax.swing.table.AbstractTableModel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PropertiesTableModel
extends AbstractTableModel {
    private static String COL_PROP = "Property";
    private static String COL_VAL = "Value";
    private static final int COL_PROP_COLNO = 0;
    private static final int COL_VAL_COLNO = 1;
    private Properties properties;
    private List<String> propertyList;
    private String[] columnNames = new String[]{COL_PROP, COL_VAL};
    private boolean changed = false;

    public PropertiesTableModel() {
        this(null);
    }

    public PropertiesTableModel(Properties properties) {
        this.setProperties(properties);
    }

    private ArrayList<String> fillPropertyList() {
        ArrayList<String> arrayList = new ArrayList<String>();
        Enumeration<?> enumeration = this.properties.propertyNames();
        while (enumeration.hasMoreElements()) {
            arrayList.add((String)enumeration.nextElement());
        }
        Collections.sort(arrayList);
        return arrayList;
    }

    @Override
    public int getColumnCount() {
        return this.columnNames.length;
    }

    @Override
    public String getColumnName(int n) {
        return this.columnNames[n];
    }

    @Override
    public int getRowCount() {
        return this.properties.size();
    }

    public Class getColumnClass(int n) {
        switch (n) {
            case 0: {
                return String.class;
            }
            case 1: {
                return String.class;
            }
        }
        return String.class;
    }

    @Override
    public boolean isCellEditable(int n, int n2) {
        return true;
    }

    @Override
    public Object getValueAt(int n, int n2) {
        switch (n2) {
            case 0: {
                return this.propertyList.get(n);
            }
            case 1: {
                String string = this.properties.getProperty(this.propertyList.get(n));
                return string;
            }
        }
        return new String("??");
    }

    public void addRow(String string, String string2) {
        this.properties.setProperty(string, string2);
        this.propertyList = this.fillPropertyList();
        this.changed = true;
        this.fireTableDataChanged();
    }

    public void deleteRow(int n) {
        String string = this.propertyList.get(n);
        this.properties.remove(string);
        this.propertyList = this.fillPropertyList();
        this.changed = true;
        this.fireTableRowsDeleted(n, n);
    }

    @Override
    public void setValueAt(Object object, int n, int n2) {
        switch (n2) {
            case 0: {
                String string = this.propertyList.get(n);
                String string2 = this.properties.getProperty(string, "");
                String string3 = (String)object;
                if (string.equals(string3)) {
                    return;
                }
                this.properties.setProperty(string3, string2);
                this.properties.remove(string);
                this.propertyList = this.fillPropertyList();
                break;
            }
            case 1: {
                String string = this.propertyList.get(n);
                String string4 = this.properties.getProperty(string, "");
                String string5 = (String)object;
                if (string4.equals(string5)) {
                    return;
                }
                string5 = string5.trim();
                this.properties.setProperty(string, string5);
                break;
            }
        }
        this.changed = true;
        this.fireTableCellUpdated(n, n2);
    }

    public Properties getProperties() {
        return this.properties;
    }

    public int getRowOfProperty(String string) {
        return this.propertyList.indexOf(string);
    }

    public int getRowOfPropertyValue(String string) {
        int n = -1;
        for (int i = 0; i < this.propertyList.size(); ++i) {
            if (!this.properties.getProperty(this.propertyList.get(i)).equals(string)) continue;
            return i;
        }
        return -1;
    }

    public static int getValueColumnIndex() {
        return 1;
    }

    public static int getPropertyColumnIndex() {
        return 0;
    }

    public void setProperties(Properties properties) {
        if (properties == null) {
            properties = ApplicationProperties.getApplicationProperties();
        }
        this.properties = properties;
        this.propertyList = this.fillPropertyList();
        this.changed = false;
        this.fireTableDataChanged();
    }

    public boolean isChanged() {
        return this.changed;
    }

    protected void setChanged(boolean bl) {
        this.changed = bl;
    }
}

