/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protege.widget;

import edu.stanford.smi.protege.resource.Icons;
import edu.stanford.smi.protege.resource.ResourceKey;
import edu.stanford.smi.protege.util.ComponentFactory;
import edu.stanford.smi.protege.util.Log;
import edu.stanford.smi.protege.util.SystemUtilities;
import edu.stanford.smi.protege.util.URIUtilities;
import edu.stanford.smi.protege.util.ViewAction;
import edu.stanford.smi.protege.widget.Hyperactive;
import edu.stanford.smi.protege.widget.TextComponentWidget;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.logging.Level;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import javax.swing.text.JTextComponent;

public class URLWidget
extends TextComponentWidget {
    private JEditorPane urlDisplay;

    public void initialize() {
        this.initialize(true, 2, 2);
    }

    protected JTextComponent createTextComponent() {
        return ComponentFactory.createTextField();
    }

    protected void onCommit() {
        super.onCommit();
        this.updateURLDisplay();
    }

    protected JComponent createCenterComponent(JTextComponent jTextComponent) {
        this.urlDisplay = ComponentFactory.createEditorPane();
        this.urlDisplay.setEditable(false);
        this.urlDisplay.addHyperlinkListener(new Hyperactive());
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.add((Component)jTextComponent, "North");
        jPanel.add((Component)new JScrollPane(this.urlDisplay), "Center");
        return jPanel;
    }

    protected Action createHomeAction() {
        return new AbstractAction("Home", Icons.getHomeIcon()){

            public void actionPerformed(ActionEvent actionEvent) {
                URLWidget.this.updateURLDisplay();
            }
        };
    }

    protected Action createViewAction() {
        return new ViewAction(ResourceKey.URL_VIEW_IN_BROWSER, null){

            public void onView() {
                URL uRL = URLWidget.this.getCurrentURL();
                if (uRL != null) {
                    SystemUtilities.showHTML(uRL.toString());
                }
            }
        };
    }

    protected Collection createActions() {
        ArrayList<Action> arrayList = new ArrayList<Action>();
        arrayList.add(this.createViewAction());
        arrayList.add(this.createHomeAction());
        return arrayList;
    }

    private URL getCurrentURL() {
        String string = this.getText();
        return URIUtilities.toURL(string, this.getProject().getProjectURI());
    }

    private void updateURLDisplay() {
        URL uRL = this.getCurrentURL();
        if (uRL == null) {
            this.clearUrlDisplay();
        } else {
            if (uRL.equals(this.urlDisplay.getPage())) {
                this.clearUrlDisplay();
            }
            this.setPage(uRL);
        }
    }

    private void setPage(URL uRL) {
        if (URLWidget.isImage(uRL)) {
            this.urlDisplay.setContentType("text/html");
            this.urlDisplay.setText("<HTML><BODY><IMG src=\"" + uRL + "\"></BODY></HTML>");
        } else {
            this.urlDisplay.setContentType("text/html");
            this.urlDisplay.setText("<HTML><BODY><H3>Loading...</H3></HTML>");
            this.asyncLoadURL(uRL);
        }
    }

    private void asyncLoadURL(final URL uRL) {
        Thread thread = new Thread(){

            public void run() {
                try {
                    URLWidget.this.getText(uRL);
                    SwingUtilities.invokeLater(new Runnable(){

                        public void run() {
                            try {
                                URLWidget.this.urlDisplay.setPage(uRL);
                            }
                            catch (IOException iOException) {
                                URLWidget.this.urlDisplay.setText("<HTML><BODY><H3>Cannot Find This Webpage</H3></HTML>");
                            }
                            catch (Throwable throwable) {
                                Log.getLogger().log(Level.INFO, "Exception caught", throwable);
                            }
                        }
                    });
                }
                catch (Throwable throwable) {
                    Log.getLogger().log(Level.INFO, "Exception caught", throwable);
                }
            }
        };
        thread.start();
    }

    private String getText(URL uRL) {
        StringBuffer stringBuffer = new StringBuffer();
        try {
            int n;
            char[] cArray = new char[100000];
            InputStream inputStream = uRL.openStream();
            InputStreamReader inputStreamReader = new InputStreamReader(inputStream);
            while ((n = inputStreamReader.read(cArray)) != -1) {
                stringBuffer.append(cArray, 0, n);
            }
        }
        catch (IOException iOException) {
            stringBuffer.append("*** Load failed ***");
        }
        return stringBuffer.toString();
    }

    private static boolean isImage(URL uRL) {
        String string = uRL.toString().toLowerCase();
        return string.endsWith(".gif") || string.endsWith(".png") || string.endsWith(".jpeg") || string.endsWith(".jpg");
    }

    private void clearUrlDisplay() {
        this.urlDisplay.setText(null);
        this.urlDisplay.getDocument().putProperty("stream", null);
    }

    protected void onSetText(String string) {
        this.updateURLDisplay();
    }
}

