/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protege.server;

import edu.stanford.smi.protege.server.RemoteSession;
import java.io.Serializable;
import java.util.UUID;

public class Session
implements RemoteSession,
Serializable {
    private static int nextPrettyId = 0;
    private int prettyId;
    private UUID id;
    private boolean allowDelegation;
    private String userName;
    private String delegateUserName;
    private String userIpAddress;
    private long startTime;

    public Session(String string, String string2) {
        this(string, string2, false);
    }

    public Session(String string, String string2, boolean bl) {
        this.prettyId = nextPrettyId++;
        this.id = UUID.randomUUID();
        this.allowDelegation = bl;
        this.userName = string;
        this.delegateUserName = null;
        this.userIpAddress = string2;
        this.startTime = Session.currentTime();
    }

    public Session() {
    }

    public int getId() {
        return this.prettyId;
    }

    public boolean allowDelegation() {
        return this.allowDelegation;
    }

    public void setDelegate(String string) {
        if (!this.allowDelegation) {
            throw new IllegalAccessError("Not allowed to delegate");
        }
        this.delegateUserName = string;
    }

    public String getUserName() {
        if (this.allowDelegation && this.delegateUserName != null) {
            return this.delegateUserName;
        }
        return this.userName;
    }

    public String getRealUserName() {
        return this.userName;
    }

    public String getUserIpAddress() {
        return this.userIpAddress;
    }

    public long getStartTime() {
        return this.startTime;
    }

    private static long currentTime() {
        return System.currentTimeMillis();
    }

    public boolean equals(Object object) {
        if (object == null || !(object instanceof Session)) {
            return false;
        }
        Session session = (Session)object;
        return this.id.equals(session.id) && this.userName.equals(session.userName) && this.allowDelegation == session.allowDelegation;
    }

    public int hashCode() {
        return this.id.hashCode();
    }

    public String toString() {
        return "Session(id=" + this.prettyId + ", user=" + this.userName + ")";
    }
}

