/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protege.widget;

import edu.stanford.smi.protege.util.ComponentFactory;
import edu.stanford.smi.protege.util.ComponentUtilities;
import edu.stanford.smi.protege.util.LabeledComponent;
import edu.stanford.smi.protege.util.LazyTreeModel;
import edu.stanford.smi.protege.util.LazyTreeRoot;
import edu.stanford.smi.protege.util.SuperclassTraverser;
import edu.stanford.smi.protege.util.TreePopupMenuMouseListener;
import edu.stanford.smi.protege.util.TreeSelectionListenerAdapter;
import edu.stanford.smi.protege.widget.AbstractSlotWidget;
import java.util.Collection;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JPopupMenu;
import javax.swing.JTree;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public abstract class AbstractTreeWidget
extends AbstractSlotWidget {
    private JTree _tree;
    private LabeledComponent _labeledComponent;

    public AbstractTreeWidget() {
        this.setPreferredColumns(2);
        this.setPreferredRows(6);
    }

    public void addButton(Action action) {
        this._labeledComponent.addHeaderButton(action);
    }

    private JComponent createMainComponent() {
        this._labeledComponent = new LabeledComponent(this.getLabel(), ComponentFactory.createScrollPane(this.createTree()));
        return this._labeledComponent;
    }

    public abstract LazyTreeRoot createRoot();

    private JComponent createTree() {
        this._tree = ComponentFactory.createTree(null);
        this._tree.addTreeSelectionListener(new TreeSelectionListenerAdapter(this));
        this._tree.addMouseListener(new TreePopupMenuMouseListener(this._tree){

            public JPopupMenu getPopupMenu() {
                return AbstractTreeWidget.this.getPopupMenu();
            }
        });
        return this._tree;
    }

    public void dispose() {
        super.dispose();
        LazyTreeModel lazyTreeModel = (LazyTreeModel)this._tree.getModel();
        lazyTreeModel.dispose();
    }

    public void expandAll() {
    }

    public void expandRoot() {
        TreeNode treeNode = (TreeNode)this._tree.getModel().getRoot();
        if (treeNode.getChildCount() == 1) {
            TreeNode treeNode2 = treeNode.getChildAt(0);
            TreePath treePath = new TreePath(new Object[]{treeNode, treeNode2});
            this._tree.expandPath(treePath);
        }
    }

    public Object getFirstSelectionParent() {
        return ComponentUtilities.getFirstSelectionParent(this._tree);
    }

    protected JPopupMenu getPopupMenu() {
        return null;
    }

    public Collection getSelection() {
        return ComponentUtilities.getSelection(this._tree);
    }

    public JTree getTree() {
        return this._tree;
    }

    public void initialize() {
        this.add(this.createMainComponent());
        this.reload();
    }

    public void reload() {
        LazyTreeModel lazyTreeModel = new LazyTreeModel(this.createRoot());
        this._tree.setModel(lazyTreeModel);
        this._tree.setSelectionRow(0);
        this.notifySelectionListeners();
        this.expandRoot();
    }

    public static void setDisplayParent(JTree jTree, Object object) {
        ComponentUtilities.setDisplayParent(jTree, object, new SuperclassTraverser());
    }

    public static void setDisplayParent(JTree jTree, Object object, Object object2) {
        ComponentUtilities.setDisplayParent(jTree, object, object2, new SuperclassTraverser());
    }

    public void setFooter(JComponent jComponent) {
        this._labeledComponent.setFooterComponent(jComponent);
    }

    public void setHeaderComponent(JComponent jComponent) {
        this._labeledComponent.setHeaderComponent(jComponent);
    }

    public void setRenderer(TreeCellRenderer treeCellRenderer) {
        this._tree.setCellRenderer(treeCellRenderer);
    }

    public void setSelectedObjectPath(Collection collection) {
        ComponentUtilities.setSelectedObjectPath(this._tree, collection);
        this.notifySelectionListeners();
    }
}

