/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protege.model.framestore;

import edu.stanford.smi.protege.model.Cls;
import edu.stanford.smi.protege.model.Facet;
import edu.stanford.smi.protege.model.Frame;
import edu.stanford.smi.protege.model.FrameID;
import edu.stanford.smi.protege.model.Instance;
import edu.stanford.smi.protege.model.Model;
import edu.stanford.smi.protege.model.Reference;
import edu.stanford.smi.protege.model.SimpleInstance;
import edu.stanford.smi.protege.model.Slot;
import edu.stanford.smi.protege.model.framestore.FrameStoreAdapter;
import edu.stanford.smi.protege.util.StringUtilities;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

public class DeleteSimplificationFrameStore
extends FrameStoreAdapter {
    private final Set<FrameID> fixedIds = new HashSet<FrameID>();

    public DeleteSimplificationFrameStore() {
        this.fixedIds.add(Model.SlotID.NAME);
        this.fixedIds.add(Model.SlotID.DIRECT_SUPERCLASSES);
        this.fixedIds.add(Model.SlotID.DIRECT_SUBCLASSES);
        this.fixedIds.add(Model.SlotID.DIRECT_SUPERSLOTS);
        this.fixedIds.add(Model.SlotID.DIRECT_SUBSLOTS);
        this.fixedIds.add(Model.SlotID.DIRECT_TYPES);
        this.fixedIds.add(Model.SlotID.DIRECT_INSTANCES);
    }

    public void removeDirectTemplateSlot(Cls cls, Slot slot) {
        try {
            this.beginTransaction("Remove template slot " + StringUtilities.getFriendlyName(slot) + " from class " + StringUtilities.getFriendlyName(cls), cls.getName());
            this.internalRemoveDirectTemplateSlot(cls, slot);
            this.commitTransaction();
        }
        catch (Throwable throwable) {
            this.rollbackTransaction();
            throw new RuntimeException(throwable);
        }
    }

    private void internalRemoveDirectTemplateSlot(Cls cls, Slot slot) {
        Collection collection = this.getInstancesOfClsWithSlotValue(cls, slot);
        this.getDelegate().removeDirectTemplateSlot(cls, slot);
        this.removeSlotValues(slot, collection);
    }

    private Collection getInstancesOfClsWithSlotValue(Cls cls, Slot slot) {
        ArrayList<Frame> arrayList = new ArrayList<Frame>(this.getFramesWithAnyDirectOwnSlotValue(slot));
        Iterator iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            Instance instance = (Instance)iterator.next();
            if (this.hasType(instance, cls)) continue;
            iterator.remove();
        }
        return arrayList;
    }

    private void removeSlotValues(Slot slot, Collection collection) {
        for (Instance instance : collection) {
            List list = instance.getDirectOwnSlotValues(slot);
            if (list.isEmpty() || instance.hasOwnSlot(slot)) continue;
            this.setDirectOwnSlotValues(instance, slot, Collections.EMPTY_LIST);
        }
    }

    private boolean hasType(Instance instance, Cls cls) {
        return this.getTypes(instance).contains(cls);
    }

    public void removeDirectSuperclass(Cls cls, Cls cls2) {
        try {
            this.beginTransaction("Remove superclass " + StringUtilities.getFriendlyName(cls2) + " from " + StringUtilities.getFriendlyName(cls), cls.getName());
            this.internalRemoveDirectSuperclass(cls, cls2);
            this.commitTransaction();
        }
        catch (Throwable throwable) {
            this.rollbackTransaction();
            throw new RuntimeException(throwable);
        }
    }

    private static Collection getSlotsToRemoveOnSuperclassRemove(Cls cls, Cls cls2) {
        HashSet<Slot> hashSet = new HashSet<Slot>(cls.getTemplateSlots());
        hashSet.removeAll(cls.getDirectTemplateSlots());
        for (Cls cls3 : cls.getDirectSuperclasses()) {
            if (cls3.equals(cls2)) continue;
            hashSet.removeAll(cls3.getTemplateSlots());
        }
        return hashSet;
    }

    private void internalRemoveDirectSuperclass(Cls cls, Cls cls2) {
        Collection collection = DeleteSimplificationFrameStore.getSlotsToRemoveOnSuperclassRemove(cls, cls2);
        for (Slot slot : collection) {
            this.removeDirectTemplateSlot(cls, slot);
        }
        this.getDelegate().removeDirectSuperclass(cls, cls2);
    }

    public void removeDirectSuperslot(Slot slot, Slot slot2) {
        try {
            this.beginTransaction("Remove superslot " + StringUtilities.getFriendlyName(slot2) + " from " + StringUtilities.getFriendlyName(slot), slot.getName());
            super.removeDirectSuperslot(slot, slot2);
            this.commitTransaction();
        }
        catch (Throwable throwable) {
            this.rollbackTransaction();
            throw new RuntimeException(throwable);
        }
    }

    public void deleteCls(Cls cls) {
        try {
            this.beginTransaction("Delete class " + StringUtilities.getFriendlyName(cls), cls.getName());
            cls.markDeleting();
            this.internalDeleteCls(cls);
            this.commitTransaction();
        }
        catch (Throwable throwable) {
            this.rollbackTransaction();
            throw new RuntimeException(throwable);
        }
    }

    public void deleteSlot(Slot slot) {
        try {
            this.beginTransaction("Delete slot " + StringUtilities.getFriendlyName(slot));
            slot.markDeleting();
            this.internalDeleteSlot(slot);
            this.commitTransaction();
        }
        catch (Throwable throwable) {
            this.rollbackTransaction();
            throw new RuntimeException(throwable);
        }
    }

    public void deleteFacet(Facet facet) {
        try {
            this.beginTransaction("Delete facet " + StringUtilities.getFriendlyName(facet));
            facet.markDeleting();
            this.internalDeleteFacet(facet);
            this.commitTransaction();
        }
        catch (Throwable throwable) {
            this.rollbackTransaction();
            throw new RuntimeException(throwable);
        }
    }

    public void deleteSimpleInstance(SimpleInstance simpleInstance) {
        try {
            this.beginTransaction("Delete simple instance " + StringUtilities.getFriendlyName(simpleInstance));
            simpleInstance.markDeleting();
            this.internalDeleteSimpleInstance(simpleInstance);
            this.commitTransaction();
        }
        catch (Throwable throwable) {
            this.rollbackTransaction();
            throw new RuntimeException(throwable);
        }
    }

    public Collection getClsesToDelete(Cls cls) {
        Set<Cls> set = this.getSubclasses(cls);
        HashSet<Cls> hashSet = new HashSet<Cls>(set);
        hashSet.add(cls);
        for (Cls cls2 : set) {
            if (cls2.equals(cls) || !this.reachableByAnotherRoute(cls2, hashSet)) continue;
            hashSet.remove(cls2);
            HashSet<Cls> hashSet2 = new HashSet<Cls>(this.getSubclasses(cls2));
            hashSet2.remove(cls);
            hashSet.removeAll(hashSet2);
        }
        return hashSet;
    }

    private boolean reachableByAnotherRoute(Cls cls, Collection collection) {
        boolean bl = false;
        List<Cls> list = this.getDirectSuperclasses(cls);
        if (list.size() > 1) {
            for (Cls cls2 : list) {
                if (collection.contains(cls2)) continue;
                bl = true;
                break;
            }
        }
        return bl;
    }

    public Collection getSlotsToDelete(Slot slot) {
        HashSet<Slot> hashSet = new HashSet<Slot>(this.getSubslots(slot));
        hashSet.add(slot);
        return hashSet;
    }

    private void internalDeleteCls(Cls cls) {
        for (Cls cls2 : this.getClsesToDelete(cls)) {
            this.deleteValuesOfTemplateSlots(cls);
            this.internalDeleteInstance(cls2);
        }
    }

    private void internalDeleteSlot(Slot slot) {
        for (Slot slot2 : this.getSlotsToDelete(slot)) {
            this.removeSlotFromClses(slot2);
            this.internalDeleteInstance(slot2);
        }
    }

    private void internalDeleteSimpleInstance(Instance instance) {
        this.internalDeleteInstance(instance);
    }

    private void internalDeleteFacet(Facet facet) {
        this.deleteFacetValues(facet);
        this.internalDeleteInstance(facet);
    }

    private void internalDeleteInstance(Instance instance) {
        this.internalDeleteFrame(instance);
    }

    private void internalDeleteFrame(Frame frame) {
        this.deleteReferences(frame);
        this.deleteValuesOfOwnSlots(frame);
        this.deleteFrame(frame);
    }

    private void deleteFrame(Frame frame) {
        if (frame instanceof Cls) {
            this.getDelegate().deleteCls((Cls)frame);
        } else if (frame instanceof Slot) {
            this.getDelegate().deleteSlot((Slot)frame);
        } else if (frame instanceof Facet) {
            this.getDelegate().deleteFacet((Facet)frame);
        } else if (frame instanceof SimpleInstance) {
            this.getDelegate().deleteSimpleInstance((SimpleInstance)frame);
        }
    }

    private void deleteReferences(Frame frame) {
        for (Reference reference : new ArrayList<Reference>(this.getReferences(frame))) {
            if (reference.getFacet() == null) {
                if (reference.isTemplate()) {
                    this.removeTemplateSlotValue((Cls)reference.getFrame(), reference.getSlot(), frame);
                    continue;
                }
                this.removeOwnSlotValue(reference.getFrame(), reference.getSlot(), frame);
                continue;
            }
            this.removeTemplateFacetValue((Cls)reference.getFrame(), reference.getSlot(), reference.getFacet(), frame);
        }
    }

    private void deleteValuesOfOwnSlots(Frame frame) {
        for (Slot slot : this.getOwnSlots(frame)) {
            List list;
            if (!this.isDeletableOwnSlot(slot) || (list = this.getDirectOwnSlotValues(frame, slot)).isEmpty()) continue;
            this.setDirectOwnSlotValues(frame, slot, Collections.EMPTY_LIST);
        }
    }

    private boolean isDeletableOwnSlot(Slot slot) {
        boolean bl = true;
        if (this.fixedIds.contains(slot.getFrameID())) {
            bl = false;
        }
        return bl;
    }

    private void deleteValuesOfTemplateSlots(Cls cls) {
        for (Slot slot : this.getTemplateSlots(cls)) {
            List list = this.getDirectTemplateSlotValues(cls, slot);
            if (!list.isEmpty()) {
                this.setDirectTemplateSlotValues(cls, slot, Collections.EMPTY_LIST);
            }
            this.deleteValuesOfFacets(cls, slot);
        }
    }

    private void deleteValuesOfFacets(Cls cls, Slot slot) {
        for (Facet facet : this.getTemplateFacets(cls, slot)) {
            List list = this.getDirectTemplateFacetValues(cls, slot, facet);
            if (list.isEmpty()) continue;
            this.setDirectTemplateFacetValues(cls, slot, facet, Collections.EMPTY_LIST);
        }
    }

    private void removeSlotFromClses(Slot slot) {
        for (Cls cls : new ArrayList(this.getDirectDomain(slot))) {
            this.removeDirectTemplateSlot(cls, slot);
        }
    }

    private void deleteFacetValues(Facet facet) {
    }

    private void removeTemplateSlotValue(Cls cls, Slot slot, Frame frame) {
        ArrayList arrayList = new ArrayList(this.getDirectTemplateSlotValues(cls, slot));
        arrayList.remove(frame);
        this.setDirectTemplateSlotValues(cls, slot, arrayList);
    }

    private void removeOwnSlotValue(Frame frame, Slot slot, Frame frame2) {
        if (this.isDeletableOwnSlot(slot)) {
            ArrayList arrayList = new ArrayList(this.getDirectOwnSlotValues(frame, slot));
            arrayList.remove(frame2);
            this.setDirectOwnSlotValues(frame, slot, arrayList);
        }
    }

    private void removeTemplateFacetValue(Cls cls, Slot slot, Facet facet, Frame frame) {
        ArrayList arrayList = new ArrayList(this.getDirectTemplateFacetValues(cls, slot, facet));
        arrayList.remove(frame);
        this.setDirectTemplateFacetValues(cls, slot, facet, arrayList);
    }
}

