/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protege.ui;

import edu.stanford.smi.protege.event.ClsAdapter;
import edu.stanford.smi.protege.event.ClsEvent;
import edu.stanford.smi.protege.event.ClsListener;
import edu.stanford.smi.protege.model.Cls;
import edu.stanford.smi.protege.model.KnowledgeBase;
import edu.stanford.smi.protege.model.Project;
import edu.stanford.smi.protege.model.Slot;
import edu.stanford.smi.protege.resource.LocalizedText;
import edu.stanford.smi.protege.resource.ResourceKey;
import edu.stanford.smi.protege.ui.DisplayUtilities;
import edu.stanford.smi.protege.ui.FrameRenderer;
import edu.stanford.smi.protege.util.AddAction;
import edu.stanford.smi.protege.util.AllowableAction;
import edu.stanford.smi.protege.util.CollectionUtilities;
import edu.stanford.smi.protege.util.ComponentFactory;
import edu.stanford.smi.protege.util.ComponentUtilities;
import edu.stanford.smi.protege.util.LabeledComponent;
import edu.stanford.smi.protege.util.ModalDialog;
import edu.stanford.smi.protege.util.RemoveAction;
import edu.stanford.smi.protege.util.Selectable;
import edu.stanford.smi.protege.util.SelectableContainer;
import edu.stanford.smi.protege.util.SelectableList;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import javax.swing.Action;

public class ClsInverseRelationshipPanel
extends SelectableContainer {
    private static final long serialVersionUID = -2313695350432734056L;
    private AllowableAction _addAction;
    private AllowableAction _removeAction;
    private Project _project;
    private SelectableList _list;
    private Cls _viewedCls;
    private ClsListener _clsListener = new ClsAdapter(){

        public void directSuperclassAdded(ClsEvent clsEvent) {
            ComponentUtilities.addListValue(ClsInverseRelationshipPanel.this._list, clsEvent.getSuperclass());
        }

        public void directSuperclassRemoved(ClsEvent clsEvent) {
            boolean bl = ClsInverseRelationshipPanel.this.setNotificationsEnabled(false);
            ComponentUtilities.removeListValue(ClsInverseRelationshipPanel.this._list, clsEvent.getSuperclass());
            ClsInverseRelationshipPanel.this.setNotificationsEnabled(bl);
        }
    };

    public ClsInverseRelationshipPanel(Project project) {
        this._project = project;
        this.setLayout(new BorderLayout());
        this._list = ClsInverseRelationshipPanel.createList();
        String string = LocalizedText.getText(ResourceKey.CLASS_BROWSER_SUPERCLASSES_LABEL);
        LabeledComponent labeledComponent = new LabeledComponent(string, ComponentFactory.createScrollPane(this._list));
        this.addHeaderButtons(labeledComponent);
        this.add(labeledComponent);
        this.setSelectable(this._list);
        this.setPreferredSize(new Dimension(0, 100));
    }

    protected void addHeaderButtons(LabeledComponent labeledComponent) {
        labeledComponent.addHeaderButton(this.getAddParentAction());
        labeledComponent.addHeaderButton(this.getRemoveParentAction());
    }

    private boolean canBeSuperclass(Cls cls) {
        boolean bl = true;
        if (cls == this._viewedCls || cls.hasSuperclass(this._viewedCls) || this._viewedCls.hasSuperclass(cls)) {
            bl = false;
            ModalDialog.showMessageDialog(this, cls.getName() + " can not be a superclass of " + this._viewedCls.getName());
        }
        return bl;
    }

    private static SelectableList createList() {
        SelectableList selectableList = ComponentFactory.createSelectableList(null);
        selectableList.setCellRenderer(FrameRenderer.createInstance());
        return selectableList;
    }

    private void doRemoveSuperclasses(Collection collection) {
        for (Cls cls : collection) {
            this._viewedCls.removeDirectSuperclass(cls);
        }
    }

    private Action getAddParentAction() {
        this._addAction = new AddAction(ResourceKey.CLASS_ADD_SUPERCLASS){
            private static final long serialVersionUID = -3168791335270944513L;

            public void onAdd() {
                if (ClsInverseRelationshipPanel.this._viewedCls != null) {
                    ClsInverseRelationshipPanel.this.addSuperclass();
                }
            }
        };
        return this._addAction;
    }

    private void addSuperclass() {
        KnowledgeBase knowledgeBase = this.getKnowledgeBase();
        Slot slot = knowledgeBase.getSystemFrames().getDirectSuperclassesSlot();
        Cls cls = this._viewedCls.getDirectType();
        Collection collection = cls.getTemplateSlotAllowedParents(slot);
        for (Cls cls2 : DisplayUtilities.pickClses((Component)this, knowledgeBase, collection)) {
            if (!this.canBeSuperclass(cls2)) continue;
            this._viewedCls.addDirectSuperclass(cls2);
        }
    }

    private KnowledgeBase getKnowledgeBase() {
        return this._project.getKnowledgeBase();
    }

    protected Project getProject() {
        return this._project;
    }

    private Action getRemoveParentAction() {
        this._removeAction = new RemoveAction(ResourceKey.CLASS_REMOVE_SUPERCLASS, (Selectable)this){
            private static final long serialVersionUID = -1774220070697400829L;

            public void onRemove(Collection collection) {
                if (ClsInverseRelationshipPanel.this._viewedCls != null) {
                    ClsInverseRelationshipPanel.this.removeSuperclasses(collection);
                }
            }
        };
        return this._removeAction;
    }

    protected Cls getViewedCls() {
        return this._viewedCls;
    }

    public void onSelectionChange() {
        this.updateButtons();
    }

    private void reload() {
        List list = this._viewedCls == null ? Collections.EMPTY_LIST : this._viewedCls.getDirectSuperclasses();
        ComponentUtilities.setListValues(this._list, list);
    }

    private void removeSuperclasses(Collection collection) {
        HashSet<Cls> hashSet = new HashSet<Cls>(this._viewedCls.getDirectSuperclasses());
        if (collection.size() != hashSet.size()) {
            hashSet.removeAll(collection);
            Cls cls = CollectionUtilities.getFirstItem(hashSet);
            this.setSelection(cls);
            this.doRemoveSuperclasses(collection);
        }
    }

    public void setCls(Cls cls, Cls cls2) {
        if (!ClsInverseRelationshipPanel.equals(cls, this._viewedCls)) {
            if (this._viewedCls != null) {
                this._viewedCls.removeClsListener(this._clsListener);
            }
            this._viewedCls = cls;
            if (this._viewedCls != null) {
                this._viewedCls.addClsListener(this._clsListener);
            }
            this.reload();
        }
        boolean bl = this.setNotificationsEnabled(false);
        this.setSelection(cls2);
        this.setNotificationsEnabled(bl);
        this.updateButtons();
    }

    protected void setSelection(Cls cls) {
        this._list.setSelectedValue(cls, true);
    }

    protected void updateButtons() {
        boolean bl = this._viewedCls != null && this._viewedCls.isEditable();
        this._addAction.setEnabled(bl);
        boolean bl2 = bl && this.getSelection().size() < this._viewedCls.getDirectSuperclassCount();
        this._removeAction.setAllowed(bl2);
    }
}

