/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protege.ui;

import edu.stanford.smi.protege.action.ArchiveProject;
import edu.stanford.smi.protege.action.AutosynchronizeTrees;
import edu.stanford.smi.protege.action.CascadeWindows;
import edu.stanford.smi.protege.action.ChangeProjectStorageFormat;
import edu.stanford.smi.protege.action.Clear;
import edu.stanford.smi.protege.action.CloseAllWindows;
import edu.stanford.smi.protege.action.CloseCurrentView;
import edu.stanford.smi.protege.action.CloseProject;
import edu.stanford.smi.protege.action.ConfigureProject;
import edu.stanford.smi.protege.action.Copy;
import edu.stanford.smi.protege.action.CreateProject;
import edu.stanford.smi.protege.action.Cut;
import edu.stanford.smi.protege.action.DecreaseFontSize;
import edu.stanford.smi.protege.action.DetachCurrentView;
import edu.stanford.smi.protege.action.DisplayHtml;
import edu.stanford.smi.protege.action.ExitApplication;
import edu.stanford.smi.protege.action.ExportPluginAction;
import edu.stanford.smi.protege.action.IncreaseFontSize;
import edu.stanford.smi.protege.action.InsertUnicodeCharacterAction;
import edu.stanford.smi.protege.action.JFrameToFront;
import edu.stanford.smi.protege.action.LookAndFeelAction;
import edu.stanford.smi.protege.action.ManageIncludedProjectsAction;
import edu.stanford.smi.protege.action.MergeIncludedProjects;
import edu.stanford.smi.protege.action.OpenProject;
import edu.stanford.smi.protege.action.Paste;
import edu.stanford.smi.protege.action.PlasticLookAndFeelAction;
import edu.stanford.smi.protege.action.RedoAction;
import edu.stanford.smi.protege.action.RevertProject;
import edu.stanford.smi.protege.action.SaveProject;
import edu.stanford.smi.protege.action.SaveProjectAs;
import edu.stanford.smi.protege.action.SaveProjectToFormat;
import edu.stanford.smi.protege.action.SetPreferences;
import edu.stanford.smi.protege.action.ShowAboutBox;
import edu.stanford.smi.protege.action.ShowAboutPluginsBox;
import edu.stanford.smi.protege.action.ShowCommandHistoryAction;
import edu.stanford.smi.protege.action.ShowEncodingAndLocales;
import edu.stanford.smi.protege.action.ShowIconDialog;
import edu.stanford.smi.protege.action.ShowMetrics;
import edu.stanford.smi.protege.action.SynchronizeTrees;
import edu.stanford.smi.protege.action.UndoAction;
import edu.stanford.smi.protege.model.Project;
import edu.stanford.smi.protege.plugin.ExportPlugin;
import edu.stanford.smi.protege.plugin.Plugin;
import edu.stanford.smi.protege.plugin.PluginUtilities;
import edu.stanford.smi.protege.resource.ResourceKey;
import edu.stanford.smi.protege.ui.PluginComparator;
import edu.stanford.smi.protege.ui.ProjectManager;
import edu.stanford.smi.protege.util.ApplicationProperties;
import edu.stanford.smi.protege.util.ComponentFactory;
import edu.stanford.smi.protege.util.ComponentUtilities;
import edu.stanford.smi.protege.util.StringUtilities;
import edu.stanford.smi.protege.util.SystemUtilities;
import edu.stanford.smi.protege.widget.WidgetUtilities;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.Serializable;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.ButtonGroup;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.UIManager;
import javax.swing.event.MenuEvent;
import javax.swing.event.MenuListener;

public class ProjectMenuBar
extends JMenuBar {
    private static final long serialVersionUID = 4169911089158397522L;
    private ButtonGroup _group = new ButtonGroup();
    private Map uris = new HashMap();
    private static final int MAX_LENGTH = 50;
    private JMenu helpMenu;

    public ProjectMenuBar() {
        this.createFileMenu();
        this.createEditMenu();
        this.createProjectMenu();
        this.createWindowMenu();
        this.createHelpMenu();
    }

    private void createEditMenu() {
        JMenu jMenu = ComponentFactory.createMenu(ResourceKey.MENUBAR_EDIT);
        ProjectMenuBar.createItem(jMenu, new UndoAction(false));
        ProjectMenuBar.createItem(jMenu, new RedoAction(false));
        ProjectMenuBar.createItem(jMenu, new ShowCommandHistoryAction());
        jMenu.addSeparator();
        ProjectMenuBar.createItem(jMenu, new Cut(false));
        ProjectMenuBar.createItem(jMenu, new Copy(false));
        ProjectMenuBar.createItem(jMenu, new Paste(false));
        ProjectMenuBar.createItem(jMenu, new Clear(false));
        jMenu.addSeparator();
        ProjectMenuBar.createItem(jMenu, new InsertUnicodeCharacterAction());
        this.add(jMenu);
    }

    public JMenu add(JMenu jMenu) {
        if (this.helpMenu == null) {
            super.add(jMenu);
        } else {
            int n = this.getComponentCount() - 1;
            this.add((Component)jMenu, n);
        }
        return jMenu;
    }

    private void createHelpMenu() {
        JMenu jMenu = ComponentFactory.createMenu(ResourceKey.MENUBAR_HELP);
        this.add(jMenu);
        this.helpMenu = jMenu;
        ComponentFactory.addMenuItemNoIcon(jMenu, new DisplayHtml(ResourceKey.HELP_MENU_GETTING_STARTED, ApplicationProperties.getGettingStartedURLString()));
        ComponentFactory.addMenuItemNoIcon(jMenu, new DisplayHtml(ResourceKey.HELP_MENU_FAQ, ApplicationProperties.getFAQURLString()));
        ComponentFactory.addMenuItemNoIcon(jMenu, new DisplayHtml(ResourceKey.HELP_MENU_USERS_GUIDE, ApplicationProperties.getUsersGuideURLString()));
        ComponentFactory.addMenuItemNoIcon(jMenu, new DisplayHtml(ResourceKey.HELP_MENU_ONTOLOGIES_101, ApplicationProperties.getOntology101URLString()));
        this.addPluginDocSubmenu();
        jMenu.addSeparator();
        ComponentFactory.addMenuItemNoIcon(jMenu, new ShowIconDialog());
        jMenu.addSeparator();
        ComponentFactory.addMenuItemNoIcon(jMenu, new ShowAboutBox());
        ComponentFactory.addMenuItemNoIcon(jMenu, new ShowAboutPluginsBox());
        ComponentFactory.addMenuItemNoIcon(jMenu, new DisplayHtml(ResourceKey.HELP_MENU_CITE_PROTEGE, ApplicationProperties.getHowToCiteProtegeURLString()));
    }

    private void addPluginDocSubmenu() {
        JMenu jMenu = ComponentFactory.createMenu(ResourceKey.HELP_MENU_PLUGINS);
        ComponentFactory.addSubmenu(this.helpMenu, jMenu);
        for (String string : PluginUtilities.getPluginComponentNames()) {
            URL uRL = PluginUtilities.getPluginComponentDocURL(string);
            if (uRL == null) continue;
            ComponentFactory.addMenuItemNoIcon(jMenu, new DisplayHtml(string, uRL.toString()));
        }
        if (jMenu.getItemCount() == 0) {
            jMenu.setEnabled(false);
        }
    }

    private static void createItem(JMenu jMenu, Action action) {
        ComponentFactory.addMenuItem(jMenu, action);
    }

    private static void createCheckBoxItem(JMenu jMenu, Action action, boolean bl) {
        ComponentFactory.addCheckBoxMenuItem(jMenu, action, bl);
    }

    private void addLookAndFeel(JMenu jMenu, LookAndFeelAction lookAndFeelAction) {
        JRadioButtonMenuItem jRadioButtonMenuItem = ComponentFactory.createRadioButtonMenuItem(lookAndFeelAction);
        this._group.add(jRadioButtonMenuItem);
        if (lookAndFeelAction.isCurrent()) {
            this._group.setSelected(jRadioButtonMenuItem.getModel(), true);
        }
        jMenu.add(jRadioButtonMenuItem);
    }

    private JMenu createLAFMenu() {
        JMenu jMenu = ComponentFactory.createMenu(ResourceKey.LOOK_AND_FEEL);
        this.addLookAndFeel(jMenu, new PlasticLookAndFeelAction());
        UIManager.LookAndFeelInfo[] lookAndFeelInfoArray = UIManager.getInstalledLookAndFeels();
        for (int i = 0; i < lookAndFeelInfoArray.length; ++i) {
            String string = lookAndFeelInfoArray[i].getName();
            String string2 = lookAndFeelInfoArray[i].getClassName();
            this.addLookAndFeel(jMenu, new LookAndFeelAction(string, string2));
        }
        return jMenu;
    }

    private void createProjectMenu() {
        JMenu jMenu = ComponentFactory.createMenu(ResourceKey.MENUBAR_PROJECT);
        ProjectMenuBar.loadProjectMenu(jMenu);
        this.add(jMenu);
    }

    private void createFileMenu() {
        JMenu jMenu = ComponentFactory.createMenu(ResourceKey.MENUBAR_FILE);
        this.loadFileMenu(jMenu);
        this.add(jMenu);
    }

    private void loadFileMenu(JMenu jMenu) {
        ProjectMenuBar.createItem(jMenu, new CreateProject(false));
        ProjectMenuBar.createItem(jMenu, new OpenProject(false));
        this.loadOpenRecent(jMenu);
        ProjectMenuBar.createItem(jMenu, new CloseProject());
        jMenu.addSeparator();
        ProjectMenuBar.createItem(jMenu, new SaveProject(false));
        ProjectMenuBar.createItem(jMenu, new SaveProjectAs());
        if (SystemUtilities.showAlphaFeatures()) {
            ProjectMenuBar.createItem(jMenu, new SaveProjectToFormat());
        } else {
            jMenu.addSeparator();
            ComponentFactory.addSubmenu(jMenu, ProjectMenuBar.createExportSubmenu());
            ProjectMenuBar.createItem(jMenu, new ChangeProjectStorageFormat());
        }
        jMenu.addSeparator();
        ProjectMenuBar.createItem(jMenu, new SetPreferences());
        jMenu.addSeparator();
        ProjectMenuBar.createItem(jMenu, new ExitApplication());
    }

    private static void loadProjectMenu(JMenu jMenu) {
        ProjectMenuBar.createItem(jMenu, new ArchiveProject(false));
        ProjectMenuBar.createItem(jMenu, new RevertProject(false));
        jMenu.addSeparator();
        ProjectMenuBar.createItem(jMenu, new ManageIncludedProjectsAction());
        ProjectMenuBar.createItem(jMenu, new MergeIncludedProjects());
        jMenu.addSeparator();
        ProjectMenuBar.createItem(jMenu, new ConfigureProject());
        ProjectMenuBar.createItem(jMenu, new ShowMetrics());
        jMenu.addSeparator();
        ComponentFactory.addMenuItemNoIcon(jMenu, new ShowEncodingAndLocales());
    }

    private static JMenu createExportSubmenu() {
        JMenu jMenu = ComponentFactory.createMenu(ResourceKey.PROJECT_EXPORT_TO_FORMAT);
        Project project = ProjectManager.getProjectManager().getCurrentProject();
        jMenu.setEnabled(project != null);
        Collection<String> collection = PluginUtilities.getAvailableExportPluginClassNames();
        for (ExportPlugin exportPlugin : ProjectMenuBar.getSortedPlugins(collection)) {
            ExportPluginAction exportPluginAction = new ExportPluginAction(exportPlugin);
            exportPluginAction.setEnabled(WidgetUtilities.isSuitableExport(project, exportPlugin));
            ProjectMenuBar.createItem(jMenu, exportPluginAction);
        }
        if (jMenu.getItemCount() == 0) {
            jMenu.setEnabled(false);
        }
        return jMenu;
    }

    private static List getSortedPlugins(Collection collection) {
        List list = ProjectMenuBar.getPlugins(collection);
        Collections.sort(list, new PluginComparator());
        return list;
    }

    private static List getPlugins(Collection collection) {
        ArrayList<Plugin> arrayList = new ArrayList<Plugin>();
        for (String string : collection) {
            Plugin plugin = (Plugin)SystemUtilities.newInstance(string);
            if (plugin == null) continue;
            arrayList.add(plugin);
        }
        return arrayList;
    }

    private static boolean exists(URI uRI) {
        return true;
    }

    private void loadOpenRecent(JMenu jMenu) {
        JMenu jMenu2 = ComponentFactory.createMenu(ResourceKey.PROJECT_OPEN_RECENT);
        this.uris.clear();
        List list = ApplicationProperties.getMRUProjectList();
        jMenu2.setEnabled(!list.isEmpty());
        for (int i = 0; i < list.size(); ++i) {
            Serializable serializable;
            URI uRI = (URI)list.get(i);
            boolean bl = ProjectMenuBar.exists(uRI);
            if (!bl) continue;
            String string = uRI.toString();
            if (string.length() > 50) {
                serializable = ProjectMenuBar.buildList(string);
                serializable = this.reduce((ArrayList)serializable);
                string = ProjectMenuBar.rebuildPath((ArrayList)serializable);
            }
            this.uris.put(string, uRI);
            serializable = ComponentFactory.createMenuItem(string);
            ((AbstractButton)serializable).addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    JMenuItem jMenuItem = (JMenuItem)actionEvent.getSource();
                    String string = jMenuItem.getText();
                    boolean bl = ProjectManager.getProjectManager().closeProjectRequest();
                    if (bl) {
                        URI uRI = (URI)ProjectMenuBar.this.uris.get(string);
                        ProjectManager.getProjectManager().loadProject(uRI);
                        ApplicationProperties.addProjectToMRUList(uRI);
                    }
                }
            });
            jMenu2.add((JMenuItem)serializable);
        }
        ComponentFactory.addSubmenu(jMenu, jMenu2);
    }

    private static ArrayList buildList(String string) {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        StringTokenizer stringTokenizer = new StringTokenizer(string, "/");
        int n = 0;
        while (stringTokenizer.hasMoreElements()) {
            arrayList.add(n, stringTokenizer.nextElement());
            ++n;
        }
        return arrayList;
    }

    private ArrayList reduce(ArrayList arrayList) {
        if (arrayList == null) {
            return null;
        }
        if (arrayList.size() == 0) {
            return arrayList;
        }
        if (ProjectMenuBar.getLength(arrayList) <= 50) {
            return arrayList;
        }
        if (arrayList.size() == 1) {
            String string = (String)arrayList.get(0);
            string = string.substring(0, 47) + "...";
            arrayList.set(0, string);
        } else if (arrayList.size() == 2) {
            if (arrayList.get(0).equals("...")) {
                arrayList.remove(0);
            } else {
                arrayList.set(0, "...");
            }
        } else if (!arrayList.contains("...")) {
            int n = arrayList.size() / 2;
            arrayList.set(n, "...");
        } else {
            int n;
            int n2 = arrayList.indexOf("...");
            int n3 = n2;
            if (n3 > (n = arrayList.size() - 2 - n2)) {
                arrayList.remove(n2 - 1);
            } else {
                arrayList.remove(n2 + 1);
            }
        }
        if (ProjectMenuBar.getLength(arrayList) <= 50) {
            return arrayList;
        }
        return this.reduce(arrayList);
    }

    private static int getLength(ArrayList arrayList) {
        String string = "";
        String string2 = "/";
        for (int i = 0; i < arrayList.size(); ++i) {
            string = string + arrayList.get(i) + string2;
        }
        return string.length() - 1;
    }

    private static String rebuildPath(ArrayList arrayList) {
        String string = "";
        String string2 = "/";
        for (int i = 0; i < arrayList.size(); ++i) {
            string = string + arrayList.get(i) + string2;
        }
        string = string.substring(0, string.length() - 1);
        return string;
    }

    private void createWindowMenu() {
        final JMenu jMenu = ComponentFactory.createMenu(ResourceKey.MENUBAR_WINDOW);
        jMenu.addMenuListener(new MenuListener(){

            public void menuSelected(MenuEvent menuEvent) {
                ProjectMenuBar.this.loadWindowMenu(jMenu);
            }

            public void menuCanceled(MenuEvent menuEvent) {
            }

            public void menuDeselected(MenuEvent menuEvent) {
            }
        });
        this.add(jMenu);
    }

    private void loadWindowMenu(JMenu jMenu) {
        Collection<JFrame> collection;
        jMenu.removeAll();
        ProjectMenuBar.createItem(jMenu, new IncreaseFontSize());
        ProjectMenuBar.createItem(jMenu, new DecreaseFontSize());
        jMenu.addSeparator();
        ProjectMenuBar.createItem(jMenu, new CascadeWindows(false));
        ProjectMenuBar.createItem(jMenu, new CloseAllWindows(false));
        jMenu.addSeparator();
        ProjectMenuBar.createItem(jMenu, new SynchronizeTrees());
        boolean bl = ApplicationProperties.isAutosynchronizingClsTrees();
        ProjectMenuBar.createCheckBoxItem(jMenu, new AutosynchronizeTrees(), bl);
        jMenu.addSeparator();
        ProjectMenuBar.createItem(jMenu, new DetachCurrentView());
        ProjectMenuBar.createItem(jMenu, new CloseCurrentView());
        jMenu.addSeparator();
        ComponentFactory.addSubmenu(jMenu, this.createLAFMenu());
        Project project = ProjectManager.getProjectManager().getCurrentProject();
        if (project != null && !(collection = project.getOpenWindows()).isEmpty()) {
            jMenu.addSeparator();
            for (JFrame jFrame : collection) {
                ProjectMenuBar.createItem(jMenu, new JFrameToFront(jFrame));
            }
        }
    }

    public String toString() {
        return StringUtilities.getClassName(this);
    }

    public void paint(Graphics graphics) {
        ComponentUtilities.enableTextAntialiasing(graphics);
        super.paint(graphics);
    }
}

