/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protege.ui;

import edu.stanford.smi.protege.model.Cls;
import edu.stanford.smi.protege.model.Project;
import edu.stanford.smi.protege.model.Slot;
import edu.stanford.smi.protege.ui.FrameRenderer;
import edu.stanford.smi.protege.util.ComponentFactory;
import edu.stanford.smi.protege.util.ComponentUtilities;
import edu.stanford.smi.protege.util.LabeledComponent;
import edu.stanford.smi.protege.util.ModalDialog;
import java.awt.BorderLayout;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import javax.swing.JComponent;
import javax.swing.JList;

public class SlotClsesPanel
extends JComponent {
    private static final long serialVersionUID = 3204543839780790235L;
    private JList _list;

    public SlotClsesPanel(Project project) {
        this.setLayout(new BorderLayout());
        this._list = this.createList();
        LabeledComponent labeledComponent = new LabeledComponent("Classes", ComponentFactory.createScrollPane(this._list));
        this.add(labeledComponent);
    }

    private JList createList() {
        JList jList = ComponentFactory.createList(ModalDialog.getCloseAction(this));
        jList.setCellRenderer(FrameRenderer.createInstance());
        return jList;
    }

    public void setSlot(Slot slot) {
        if (slot == null) {
            ComponentUtilities.setListValues(this._list, Collections.EMPTY_LIST);
        } else {
            Collection collection = slot.getDirectDomain();
            if (slot.getKnowledgeBase().getProject().getDisplayHiddenClasses()) {
                ComponentUtilities.setListValues(this._list, collection);
            } else {
                ArrayList<Cls> arrayList = new ArrayList<Cls>();
                for (Cls cls : collection) {
                    if (!cls.isVisible()) continue;
                    arrayList.add(cls);
                }
                ComponentUtilities.setListValues(this._list, arrayList);
            }
        }
    }
}

