/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protege.util;

import edu.stanford.smi.protege.model.Project;
import edu.stanford.smi.protege.storage.database.DatabaseKnowledgeBaseFactory;
import edu.stanford.smi.protege.util.ArchiveRecord;
import edu.stanford.smi.protege.util.FileUtilities;
import edu.stanford.smi.protege.util.Log;
import edu.stanford.smi.protege.util.MessageError;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.net.URI;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.logging.Level;

public class ArchiveManager {
    private static final ArchiveManager THE_INSTANCE = new ArchiveManager();
    private static final DateFormat THE_FORMAT = new SimpleDateFormat("yyyy.MM.dd_HH.mm.ss");
    private static final String TMP_TABLE_NAME = "prtgeTmp";
    private int tableNameIndex = 0;

    public static ArchiveManager getArchiveManager() {
        return THE_INSTANCE;
    }

    public static DateFormat getDateFormat() {
        return THE_FORMAT;
    }

    private ArchiveManager() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void archive(Project project, String string) {
        String string2 = project.getProjectName();
        File file = ArchiveManager.getProjectDirectoryFile(project);
        File file2 = ArchiveManager.createArchiveDir(string2, file, new Date());
        File file3 = ArchiveManager.getEmptyTempDir(string2, file2);
        ArchiveManager.moveProject(string2, file, file3);
        try {
            ArrayList arrayList = new ArrayList();
            this.saveProject(project, arrayList);
            this.logErrors(arrayList);
            ArchiveManager.moveProject(string2, file, file2);
            ArchiveManager.createComment(file2, string);
        }
        finally {
            ArchiveManager.moveProject(string2, file3, file);
            file3.delete();
        }
    }

    private void saveProject(Project project, Collection collection) {
        if (project.getKnowledgeBaseFactory() instanceof DatabaseKnowledgeBaseFactory) {
            String string = DatabaseKnowledgeBaseFactory.getTableName(project.getSources());
            String string2 = "ProtegeTable";
            Connection connection = null;
            try {
                connection = ArchiveManager.getDBConnection(project);
                string2 = this.getNextTableNameIndex(connection, string);
                connection.close();
            }
            catch (SQLException sQLException) {
                collection.add(sQLException);
                throw new RuntimeException("Archive error", sQLException);
            }
            this.copyDBProjectInNewTable(project, collection, string2);
        } else {
            project.save(collection);
        }
    }

    private void copyDBProjectInNewTable(Project project, Collection collection, String string) {
        String string2 = DatabaseKnowledgeBaseFactory.getTableName(project.getSources());
        DatabaseKnowledgeBaseFactory.setTablename(project.getSources(), string);
        try {
            project.save(collection);
        }
        catch (Exception exception) {
            collection.add(exception);
            throw new RuntimeException(exception);
        }
        finally {
            DatabaseKnowledgeBaseFactory.setTablename(project.getSources(), string2);
        }
    }

    private static File getProjectDirectoryFile(Project project) {
        URI uRI = project.getProjectURI();
        return uRI == null ? null : new File(uRI).getParentFile();
    }

    private static File createArchiveDir(String string, File file, Date date) {
        File file2 = ArchiveManager.getArchiveDir(string, file, date);
        file2.mkdirs();
        return file2;
    }

    private static File getArchiveDir(String string, File file, Date date) {
        File file2 = ArchiveManager.getMainArchiveDir(string, file);
        return new File(file2, ArchiveManager.getTimestamp(date));
    }

    private static File getMainArchiveDir(String string, File file) {
        File file2 = new File(file, string + ".parc");
        file2.mkdir();
        return file2;
    }

    private static void moveProject(String string, File file, File file2) {
        File[] fileArray = file.listFiles();
        if (fileArray != null) {
            for (int i = 0; i < fileArray.length; ++i) {
                String string2;
                File file3 = fileArray[i];
                if (!file3.isFile() || !(string2 = file3.getName()).startsWith(string)) continue;
                File file4 = new File(file2, string2);
                file3.renameTo(file4);
            }
        }
    }

    private static void copyProject(String string, File file, File file2) {
        File[] fileArray = file.listFiles();
        if (fileArray != null) {
            for (int i = 0; i < fileArray.length; ++i) {
                String string2;
                File file3 = fileArray[i];
                if (!file3.isFile() || !(string2 = file3.getName()).startsWith(string)) continue;
                File file4 = new File(file2, string2);
                ArchiveManager.copyFile(file3, file4);
            }
        }
    }

    private static File getEmptyTempDir(String string, File file) {
        File[] fileArray;
        File file2 = new File(file, "temp");
        boolean bl = file2.mkdir();
        if (!bl && (fileArray = file2.listFiles()) != null) {
            for (int i = 0; i < fileArray.length; ++i) {
                fileArray[i].delete();
            }
        }
        return file2;
    }

    public Collection getArchiveRecords(Project project) {
        ArrayList<ArchiveRecord> arrayList = new ArrayList<ArchiveRecord>();
        File[] fileArray = ArchiveManager.getMainArchiveDir(project.getProjectName(), ArchiveManager.getProjectDirectoryFile(project)).listFiles();
        for (int i = 0; i < fileArray.length; ++i) {
            arrayList.add(new ArchiveRecord(fileArray[i], ArchiveManager.getComment(fileArray[i])));
        }
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Project revertToVersion(Project project, Date date) {
        Project project2 = null;
        String string = project.getProjectName();
        File file = ArchiveManager.getProjectDirectoryFile(project);
        File file2 = ArchiveManager.getArchiveDir(string, file, date);
        File file3 = ArchiveManager.getEmptyTempDir(string, file2);
        ArrayList arrayList = new ArrayList();
        if (project.getKnowledgeBaseFactory() instanceof DatabaseKnowledgeBaseFactory) {
            project2 = this.revertToDBVersion(project, file, file2, file3, arrayList);
        } else {
            ArchiveManager.moveProject(string, file, file3);
            ArchiveManager.moveProject(string, file2, file);
            try {
                project2 = Project.loadProjectFromURI(project.getProjectURI(), arrayList);
            }
            finally {
                ArchiveManager.moveProject(string, file, file2);
                ArchiveManager.moveProject(string, file3, file);
                file3.delete();
            }
        }
        this.logErrors(arrayList);
        return project2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Project revertToDBVersion(Project project, File file, File file2, File file3, Collection collection) {
        Project project2 = null;
        String string = project.getProjectName();
        String string2 = DatabaseKnowledgeBaseFactory.getTableName(project.getSources());
        ArchiveManager.moveProject(string, file, file3);
        try {
            ArchiveManager.renameTable(project, string2, TMP_TABLE_NAME);
        }
        catch (SQLException sQLException) {
            collection.add(sQLException);
            ArchiveManager.moveProject(string, file3, file);
            return null;
        }
        ArchiveManager.copyProject(string + ".pprj", file2, file);
        try {
            project2 = this.loadAndMoveDBProject(project, collection);
        }
        catch (Exception exception) {
            collection.add(exception);
            try {
                ArchiveManager.renameTable(project, TMP_TABLE_NAME, string2);
                ArchiveManager.moveProject(string, file3, file);
            }
            catch (SQLException sQLException) {
                collection.add(exception);
                Project project3 = null;
                return project3;
            }
        }
        finally {
            ArchiveManager.moveProject(string, file3, file);
            file3.delete();
        }
        return project2;
    }

    private Project loadAndMoveDBProject(Project project, Collection collection) {
        String string = DatabaseKnowledgeBaseFactory.getTableName(project.getSources());
        Project project2 = null;
        try {
            project2 = Project.loadProjectFromURI(project.getProjectURI(), collection);
        }
        catch (Exception exception) {
            collection.add(exception);
            throw new RuntimeException(exception);
        }
        DatabaseKnowledgeBaseFactory.setTablename(project2.getSources(), string);
        project2.save(collection);
        project2 = Project.loadProjectFromURI(project.getProjectURI(), collection);
        return project2;
    }

    private static String getTimestamp(Date date) {
        return THE_FORMAT.format(date);
    }

    private static String getComment(File file) {
        String string = null;
        File file2 = ArchiveManager.getCommentFile(file);
        if (file2 != null) {
            try {
                BufferedReader bufferedReader = FileUtilities.createBufferedReader(file2);
                string = bufferedReader.readLine();
                bufferedReader.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return string;
    }

    private static File getCommentFile(File file) {
        return new File(file, "comment.txt");
    }

    private static void createComment(File file, String string) {
        if (string != null && string.length() > 0) {
            File file2 = ArchiveManager.getCommentFile(file);
            try {
                PrintWriter printWriter = FileUtilities.createPrintWriter(file2, false);
                printWriter.println(string);
                printWriter.close();
            }
            catch (Exception exception) {
                Log.getLogger().warning(exception.toString());
            }
        }
    }

    private void logErrors(Collection collection) {
        if (collection == null || collection.size() == 0) {
            return;
        }
        Log.getLogger().severe("There were errors at archiving/reverting project");
        for (Object e : collection) {
            if (e instanceof Throwable) {
                Log.getLogger().log(Level.SEVERE, ((Throwable)e).getMessage(), e);
                continue;
            }
            if (e instanceof MessageError) {
                MessageError messageError = (MessageError)e;
                Log.getLogger().log(Level.SEVERE, messageError.getMessage(), messageError.getException());
                continue;
            }
            Log.getLogger().severe(e.toString());
        }
    }

    private static void copyFile(File file, File file2) {
        try {
            int n;
            FileReader fileReader = new FileReader(file);
            FileWriter fileWriter = new FileWriter(file2);
            while ((n = fileReader.read()) != -1) {
                fileWriter.write(n);
            }
            fileReader.close();
            fileWriter.close();
        }
        catch (FileNotFoundException fileNotFoundException) {
            Log.getLogger().log(Level.WARNING, "Error at copying file " + file + " to " + file2, fileNotFoundException);
        }
        catch (IOException iOException) {
            Log.getLogger().log(Level.WARNING, "Error at copying file " + file + " to " + file2, iOException);
        }
    }

    private static Connection getDBConnection(Project project) throws SQLException {
        String string = DatabaseKnowledgeBaseFactory.getURL(project.getSources());
        String string2 = DatabaseKnowledgeBaseFactory.getUsername(project.getSources());
        String string3 = DatabaseKnowledgeBaseFactory.getPassword(project.getSources());
        Connection connection = null;
        connection = DriverManager.getConnection(string, string2, string3);
        return connection;
    }

    private String getNextTableNameIndex(Connection connection, String string) {
        String string2 = string + Integer.toString(this.tableNameIndex);
        while (ArchiveManager.tableExists(connection, string2)) {
            ++this.tableNameIndex;
            string2 = string + Integer.toString(this.tableNameIndex);
        }
        return string2;
    }

    private static boolean tableExists(Connection connection, String string) {
        boolean bl = false;
        try {
            Statement statement = connection.createStatement();
            String string2 = "SELECT COUNT(*) FROM " + string;
            ResultSet resultSet = statement.executeQuery(string2);
            resultSet.close();
            statement.close();
            bl = true;
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        return bl;
    }

    private static void renameTable(Project project, String string, String string2) throws SQLException {
        Connection connection = ArchiveManager.getDBConnection(project);
        ArchiveManager.renameTable(connection, string, string2);
        connection.close();
    }

    private static void renameTable(Connection connection, String string, String string2) throws SQLException {
        boolean bl;
        String string3;
        Statement statement;
        try {
            statement = connection.createStatement();
            string3 = "DROP TABLE " + string2;
            bl = statement.execute(string3);
            statement.close();
        }
        catch (SQLException sQLException) {
            sQLException.printStackTrace();
        }
        statement = connection.createStatement();
        string3 = "RENAME TABLE " + string + " TO " + string2;
        bl = statement.execute(string3);
        statement.close();
    }

    private static void deleteTable(Project project, String string) {
        try {
            Connection connection = ArchiveManager.getDBConnection(project);
            Statement statement = connection.createStatement();
            String string2 = "DROP " + string;
            ResultSet resultSet = statement.executeQuery(string2);
            resultSet.close();
            statement.close();
            connection.close();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }
}

