/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protege.widget;

import edu.stanford.smi.protege.event.SlotAdapter;
import edu.stanford.smi.protege.event.SlotEvent;
import edu.stanford.smi.protege.event.SlotListener;
import edu.stanford.smi.protege.model.Project;
import edu.stanford.smi.protege.model.Slot;
import edu.stanford.smi.protege.resource.LocalizedText;
import edu.stanford.smi.protege.resource.ResourceKey;
import edu.stanford.smi.protege.ui.DisplayUtilities;
import edu.stanford.smi.protege.ui.FrameRenderer;
import edu.stanford.smi.protege.util.AddAction;
import edu.stanford.smi.protege.util.ComponentFactory;
import edu.stanford.smi.protege.util.ComponentUtilities;
import edu.stanford.smi.protege.util.LabeledComponent;
import edu.stanford.smi.protege.util.RemoveAction;
import edu.stanford.smi.protege.util.Selectable;
import edu.stanford.smi.protege.util.SelectableContainer;
import edu.stanford.smi.protege.util.SelectableList;
import edu.stanford.smi.protege.util.SimpleListModel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.JScrollPane;

public class SuperslotsPanel
extends SelectableContainer {
    private static final long serialVersionUID = -8861214720299721320L;
    private Project project;
    private Slot slot;
    private SelectableList list;
    private AbstractAction addAction;
    private AbstractAction removeAction;
    private SlotListener slotListener = new SlotAdapter(){

        public void directSuperslotAdded(SlotEvent slotEvent) {
            ComponentUtilities.addListValue(SuperslotsPanel.this.list, slotEvent.getSuperslot());
        }

        public void directSuperslotRemoved(SlotEvent slotEvent) {
            boolean bl = SuperslotsPanel.this.setNotificationsEnabled(false);
            ComponentUtilities.removeListValue(SuperslotsPanel.this.list, slotEvent.getSuperslot());
            SuperslotsPanel.this.setNotificationsEnabled(bl);
        }
    };

    public SuperslotsPanel(Project project) {
        this.project = project;
        this.createComponents();
        this.layoutComponents();
        this.setSelectable(this.list);
        this.setPreferredSize(new Dimension(0, 100));
    }

    private void createComponents() {
        this.list = ComponentFactory.createSelectableList(null);
        this.list.setCellRenderer(new FrameRenderer());
        this.addAction = this.createAddAction();
        this.removeAction = this.createRemoveAction();
    }

    private AbstractAction createAddAction() {
        return new AddAction(ResourceKey.SLOT_ADD_SUPERSLOT){
            private static final long serialVersionUID = -1324800378677177673L;

            public void onAdd() {
                if (SuperslotsPanel.this.slot != null) {
                    SuperslotsPanel.this.addSlots();
                }
            }
        };
    }

    private void addSlots() {
        ArrayList arrayList = new ArrayList(this.project.getKnowledgeBase().getSlots());
        arrayList.remove(this.slot);
        arrayList.removeAll(this.slot.getSubslots());
        arrayList.removeAll(this.slot.getSuperslots());
        Collection collection = this.selectSlots(arrayList);
        for (Slot slot : collection) {
            this.slot.addDirectSuperslot(slot);
        }
        this.updateModel();
    }

    protected Collection selectSlots(Collection collection) {
        return DisplayUtilities.pickSlots(this, collection);
    }

    private AbstractAction createRemoveAction() {
        return new RemoveAction(ResourceKey.SLOT_REMOVE_SUPERSLOT, (Selectable)this.list){
            private static final long serialVersionUID = 3522248994702422099L;

            public void onRemove(Collection collection) {
                SuperslotsPanel.this.removeSlots(collection);
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeSlots(Collection collection) {
        for (Slot slot : collection) {
            this.slot.removeDirectSuperslot(slot);
        }
        this.updateModel();
    }

    private void layoutComponents() {
        JScrollPane jScrollPane = ComponentFactory.createScrollPane(this.list);
        String string = LocalizedText.getText(ResourceKey.SLOT_BROWSER_SUPERSLOTS_LABEL);
        LabeledComponent labeledComponent = new LabeledComponent(string, jScrollPane);
        labeledComponent.addHeaderButton(this.addAction);
        labeledComponent.addHeaderButton(this.removeAction);
        this.setLayout(new BorderLayout());
        this.add((Component)labeledComponent, "Center");
    }

    public void setSlot(Slot slot, Slot slot2) {
        if (this.slot != null) {
            this.slot.removeSlotListener(this.slotListener);
        }
        this.slot = slot;
        if (this.slot != null) {
            this.slot.addSlotListener(this.slotListener);
        }
        this.updateModel();
        this.addAction.setEnabled(slot != null && slot.isEditable());
        this.list.setSelectedValue(slot2, true);
    }

    public void setDisplayParent(Slot slot) {
        this.list.setSelectedValue(slot, true);
    }

    private void updateModel() {
        List list = this.slot == null ? Collections.EMPTY_LIST : this.slot.getDirectSuperslots();
        SimpleListModel simpleListModel = new SimpleListModel(list);
        this.list.setModel(simpleListModel);
        this.repaint();
    }
}

