/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protege.server.socket;

import edu.stanford.smi.protege.util.Log;
import java.io.IOException;
import java.io.OutputStream;
import java.util.logging.Level;
import java.util.logging.Logger;

public class MonitoringOutputStream
extends OutputStream {
    static Logger log = Log.getLogger(MonitoringOutputStream.class);
    private static int KB = 1024;
    private static int counter = 0;
    private OutputStream os;
    private int id;
    private int bytesWritten = 0;
    private int bytesToBeFlushed = 0;
    private boolean writingNotified = false;

    public MonitoringOutputStream(OutputStream outputStream) {
        this.os = outputStream;
        this.id = counter++;
        if (log.isLoggable(Level.FINER)) {
            log.finer(this.logPrefix() + "opened.");
        }
    }

    public void write(int n) throws IOException {
        try {
            this.os.write(n);
            this.showByte(n);
            this.countWritten(1);
        }
        catch (Throwable throwable) {
            this.rethrow(throwable);
        }
    }

    public void write(byte[] byArray, int n, int n2) throws IOException {
        try {
            this.os.write(byArray, n, n2);
            this.showBytes(byArray, n, n2);
            this.countWritten(n2);
        }
        catch (Throwable throwable) {
            this.rethrow(throwable);
        }
    }

    public void flush() throws IOException {
        try {
            if (log.isLoggable(Level.FINER)) {
                log.finer(this.logPrefix() + "flushing " + this.bytesToBeFlushed + " bytes");
            }
            this.bytesToBeFlushed = 0;
            this.writingNotified = false;
            this.os.flush();
        }
        catch (Throwable throwable) {
            this.rethrow(throwable);
        }
    }

    public void close() throws IOException {
        try {
            if (log.isLoggable(Level.FINER)) {
                log.finer(this.logPrefix() + "closing");
            }
            this.writingNotified = false;
            this.os.close();
        }
        catch (Throwable throwable) {
            this.rethrow(throwable);
        }
    }

    private void showBytes(byte[] byArray, int n, int n2) {
        if (log.isLoggable(Level.FINE) && n2 == 0) {
            log.fine(this.logPrefix() + "writing zero bytes");
        }
        if (log.isLoggable(Level.FINEST) && log.isLoggable(Level.FINEST)) {
            StringBuffer stringBuffer = new StringBuffer(this.logPrefix());
            stringBuffer.append("bytes written: ");
            for (int i = n; i < n + n2; ++i) {
                stringBuffer.append(byArray[i]);
                stringBuffer.append(" ");
            }
            log.finest(stringBuffer.toString());
        }
    }

    private void showByte(int n) {
        if (log.isLoggable(Level.FINEST)) {
            log.finest(this.logPrefix() + "writing " + n);
        }
    }

    private synchronized void countWritten(int n) {
        int n2;
        if (log.isLoggable(Level.FINER) && !this.writingNotified) {
            log.finer(this.logPrefix() + "writing");
            this.writingNotified = true;
        }
        int n3 = this.bytesWritten / (KB * KB);
        this.bytesWritten += n;
        this.bytesToBeFlushed += n;
        if (log.isLoggable(Level.FINE) && (n2 = this.bytesWritten / (KB * KB)) > n3) {
            log.fine(this.logPrefix() + n2 + " megabytes written");
        }
    }

    private String logPrefix() {
        return "OutputStream " + this.id + ": ";
    }

    private void rethrow(Throwable throwable) throws IOException {
        if (log.isLoggable(Level.FINE)) {
            log.log(Level.FINE, "Exception caught", throwable);
        }
        if (throwable instanceof IOException) {
            throw (IOException)throwable;
        }
        IOException iOException = new IOException(throwable.getMessage());
        iOException.initCause(throwable);
        throw iOException;
    }
}

