/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protege.storage.database;

import edu.stanford.smi.protege.server.RemoteSession;
import edu.stanford.smi.protege.server.ServerProperties;
import edu.stanford.smi.protege.server.framestore.ServerFrameStore;
import edu.stanford.smi.protege.storage.database.KnownDatabase;
import edu.stanford.smi.protege.storage.database.pool.ConnectionPool;
import edu.stanford.smi.protege.util.ApplicationProperties;
import edu.stanford.smi.protege.util.Log;
import edu.stanford.smi.protege.util.SystemUtilities;
import edu.stanford.smi.protege.util.transaction.TransactionIsolationLevel;
import edu.stanford.smi.protege.util.transaction.TransactionMonitor;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.logging.Level;
import java.util.logging.Logger;

public class RobustConnection {
    private static final transient Logger log = Log.getLogger(RobustConnection.class);
    public static final String OLD_PROPERTY_LONGVARCHAR_TYPE_NAME = "SimpleJdbcDatabaseManager.longvarcharname";
    public static final String PROPERTY_LONGVARCHAR_TYPE_NAME = "Database.typename.longvarchar";
    public static final String PROPERTY_FRAME_NAME_TYPE_NAME = "Database.typename.frame.name.type";
    public static final String PROPERTY_SHORT_VALUE_TYPE_NAME = "Database.typename.short.value.type";
    public static final String PROPERTY_VARCHAR_TYPE_SIZE = "Database.type.varchar.maxsize";
    public static final int DEFAULT_MAX_STRING_SIZE = 255;
    public static final String PROPERTY_INTEGER_TYPE_NAME = "Database.typename.integer";
    public static final String PROPERTY_SMALL_INTEGER_TYPE_NAME = "Database.typename.small_integer";
    public static final String PROPERTY_BIT_TYPE_NAME = "Database.typename.bit";
    private static int idCounter = 0;
    private int id = idCounter++;
    private Connection connection;
    private ConnectionPool pool;
    private boolean idleFlag = true;
    private KnownDatabase dbType;
    private boolean _supportsBatch;
    private char _escapeChar;
    private String _escapeClause;
    private boolean _supportsTransactions;
    private RemoteSession session;
    private TransactionMonitor transactionMonitor;
    private String driver;
    private String _driverLongvarcharTypeName;
    private String _driverTinyIntTypeName;
    private String _driverBitTypeName;
    private String _driverSmallIntTypeName;
    private String _driverIntegerTypeName;
    private String _driverVarcharTypeName;
    private String _driverVarBinaryTypeName;
    private String _driverCharTypeName;
    private Integer transactionIsolationLevel = null;

    public RobustConnection(String string, String string2, String string3, String string4, TransactionMonitor transactionMonitor, RemoteSession remoteSession) throws SQLException {
        this.driver = string;
        this.pool = ConnectionPool.getConnectionPool(string, string2, string3, string4);
        this.transactionMonitor = transactionMonitor;
        this.session = remoteSession;
        this.initializeDatabaseType();
        this.initializeSupportsBatch();
        this.initializeSupportsEscapeSyntax();
        this.initializeDriverTypeNames();
        this.initializeSupportsTransactions();
    }

    private void initializeDatabaseType() throws SQLException {
        String string = this.getDatabaseProductName();
        this.dbType = string.equalsIgnoreCase("mysql") ? KnownDatabase.MYSQL : (string.equalsIgnoreCase("PostgreSQL") ? KnownDatabase.POSTGRESQL : (string.equalsIgnoreCase("Microsoft SQL Server") ? KnownDatabase.SQLSERVER : (string.equalsIgnoreCase("oracle") ? KnownDatabase.ORACLE : (string.equalsIgnoreCase("apache derby") ? KnownDatabase.DERBY : null))));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setAutoCommit(boolean bl) throws SQLException {
        try {
            this.getConnection().setAutoCommit(bl);
        }
        finally {
            this.setIdle(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void commit() throws SQLException {
        try {
            this.getConnection().commit();
        }
        finally {
            this.setIdle(true);
        }
    }

    private void setupConnection() throws SQLException {
        if (log.isLoggable(Level.FINE)) {
            log.fine("Opening connection for robust connection manager #" + this.id);
        }
        this.connection = this.pool.getConnection();
        TransactionIsolationLevel transactionIsolationLevel = ServerProperties.getDefaultTransactionIsolationLevel();
        if (transactionIsolationLevel != null) {
            this.connection.setTransactionIsolation(transactionIsolationLevel.getJdbcLevel());
        }
    }

    public void dispose() throws SQLException {
        if (this.connection != null) {
            this.pool.ungetConnection(this.connection);
        }
        this.pool.dereference();
    }

    public void closeStatements() throws SQLException {
        this.pool.closeStatements(this.getConnection());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initializeSupportsBatch() throws SQLException {
        try {
            this._supportsBatch = this.getConnection().getMetaData().supportsBatchUpdates();
            if (!this._supportsBatch) {
                String string = "This JDBC driver does not support batch update.";
                string = string + " For much better performance try using a newer driver";
                Log.getLogger().warning(string);
            }
        }
        finally {
            this.setIdle(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initializeSupportsTransactions() throws SQLException {
        try {
            this._supportsTransactions = this.getConnection().getMetaData().supportsTransactions();
            if (!this._supportsTransactions) {
                Log.getLogger().warning("This database does not support transactions");
            }
        }
        finally {
            this.setIdle(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initializeSupportsEscapeSyntax() throws SQLException {
        try {
            this._escapeChar = '\u0000';
            this._escapeClause = "";
            boolean bl = this.getConnection().getMetaData().supportsLikeEscapeClause();
            if (bl) {
                if (this.isMySql()) {
                    this._escapeChar = (char)92;
                } else {
                    this._escapeChar = (char)124;
                    this._escapeClause = "{ESCAPE '" + this._escapeChar + "'}";
                }
            } else {
                Log.getLogger().warning("This driver does not support SQL Escape processing.");
            }
        }
        finally {
            this.setIdle(true);
        }
    }

    public char getEscapeCharacter() {
        return this._escapeChar;
    }

    public String getEscapeClause() {
        return this._escapeClause;
    }

    public boolean supportsBatch() {
        return this._supportsBatch;
    }

    public PreparedStatement getPreparedStatement(String string) throws SQLException {
        return this.pool.getPreparedStatement(this.getConnection(), string);
    }

    public Statement getStatement() throws SQLException {
        return this.pool.getStatement(this.getConnection());
    }

    public synchronized void checkConnection() throws SQLException {
        if (this.connection == null) {
            this.setupConnection();
        } else if (this.connection.isClosed()) {
            Log.getLogger().warning("Found closed connection, reinitializing...");
            this.pool.reportProblem(this.connection);
            this.connection = null;
        }
    }

    public KnownDatabase getKnownDatabaseType() {
        return this.dbType;
    }

    public boolean isOracle() throws SQLException {
        return this.dbType == KnownDatabase.ORACLE;
    }

    public boolean isSqlServer() throws SQLException {
        return this.dbType == KnownDatabase.SQLSERVER;
    }

    public boolean isMsAccess() throws SQLException {
        return this.getDatabaseProductName().equalsIgnoreCase("access");
    }

    public boolean isMySql() throws SQLException {
        return this.dbType == KnownDatabase.MYSQL;
    }

    public boolean isPostgres() throws SQLException {
        return this.dbType == KnownDatabase.POSTGRESQL;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getDatabaseProductName() throws SQLException {
        try {
            String string = this.getConnection().getMetaData().getDatabaseProductName();
            return string;
        }
        finally {
            this.setIdle(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getDatabaseMajorVersion() throws SQLException {
        try {
            int n = this.getConnection().getMetaData().getDatabaseMajorVersion();
            return n;
        }
        finally {
            this.setIdle(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getDatabaseMinorVersion() throws SQLException {
        try {
            int n = this.getConnection().getMetaData().getDatabaseMinorVersion();
            return n;
        }
        finally {
            this.setIdle(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initializeDriverTypeNames() throws SQLException {
        try {
            String string = null;
            String string2 = null;
            String string3 = null;
            DatabaseMetaData databaseMetaData = this.getConnection().getMetaData();
            if (log.isLoggable(Level.FINE)) {
                log.fine(" ----------------------- type information for " + databaseMetaData.getDatabaseProductName());
                log.fine("See http://java.sun.com/j2se/1.5.0/docs/api/java/sql/Types.html for a list of the sql types");
            }
            ResultSet resultSet = databaseMetaData.getTypeInfo();
            while (resultSet.next()) {
                if (log.isLoggable(Level.FINE)) {
                    log.fine("Info for type " + resultSet.getString("TYPE_NAME"));
                    log.fine("\tsql data type = " + resultSet.getInt("DATA_TYPE"));
                    short s = resultSet.getShort("NULLABLE");
                    log.fine("\tnullable = " + (s == 0 ? "false" : (s == 1 ? "true" : "maybe")));
                    log.fine("\tcase sensitive = " + resultSet.getBoolean("CASE_SENSITIVE"));
                }
                String string4 = resultSet.getString("TYPE_NAME");
                int n = resultSet.getInt("DATA_TYPE");
                if (string4.length() == 0) continue;
                switch (n) {
                    case -1: {
                        if (this._driverLongvarcharTypeName != null) break;
                        this._driverLongvarcharTypeName = string4;
                        break;
                    }
                    case -4: {
                        if (string != null) break;
                        string = string4;
                        break;
                    }
                    case 2005: {
                        if (string3 != null) break;
                        string3 = string4;
                        break;
                    }
                    case 2004: {
                        if (string2 != null) break;
                        string2 = string4;
                        break;
                    }
                    case -6: {
                        if (this._driverTinyIntTypeName != null) break;
                        this._driverTinyIntTypeName = string4;
                        break;
                    }
                    case -7: {
                        if (this._driverBitTypeName != null) break;
                        this._driverBitTypeName = string4;
                        break;
                    }
                    case 5: {
                        if (this._driverSmallIntTypeName != null) break;
                        this._driverSmallIntTypeName = string4;
                        break;
                    }
                    case 4: {
                        if (this._driverIntegerTypeName != null) break;
                        this._driverIntegerTypeName = string4;
                        break;
                    }
                    case 12: {
                        if (this._driverVarcharTypeName != null) break;
                        this._driverVarcharTypeName = string4;
                        break;
                    }
                    case -3: {
                        if (this._driverVarBinaryTypeName != null) break;
                        this._driverVarBinaryTypeName = string4;
                        break;
                    }
                    case 1: {
                        if (this._driverCharTypeName != null) break;
                        this._driverCharTypeName = string4;
                        break;
                    }
                }
            }
            if (log.isLoggable(Level.FINE)) {
                log.fine(" ----------------------- end of type information for " + databaseMetaData.getDatabaseProductName());
            }
            resultSet.close();
            if (this._driverLongvarcharTypeName == null) {
                this._driverLongvarcharTypeName = string == null ? (string3 == null ? string2 : string3) : string;
                if (this._driverLongvarcharTypeName == null && this.isPostgres()) {
                    this._driverLongvarcharTypeName = "TEXT";
                }
            }
            if (this._driverIntegerTypeName == null) {
                this._driverIntegerTypeName = "INTEGER";
            }
            if (this._driverSmallIntTypeName == null) {
                this._driverSmallIntTypeName = this._driverIntegerTypeName;
            }
            if (this._driverTinyIntTypeName == null) {
                this._driverTinyIntTypeName = this._driverSmallIntTypeName;
            }
            if (this._driverBitTypeName == null) {
                this._driverBitTypeName = this._driverTinyIntTypeName;
            }
            if (this._driverVarcharTypeName == null || this.isPostgres() || this.isSqlServer()) {
                this._driverVarcharTypeName = "VARCHAR";
            }
            if (this._driverVarBinaryTypeName == null) {
                this._driverVarBinaryTypeName = "VARCHAR";
            }
            if (this.isOracle()) {
                this._driverLongvarcharTypeName = "CLOB";
            }
        }
        finally {
            this.setIdle(true);
        }
    }

    private String getName(String string, String string2) {
        String string3 = ApplicationProperties.getApplicationOrSystemProperty(string + "." + this.driver);
        return string3 == null || string3.length() == 0 ? string2 : string3;
    }

    public String getBitTypeName() {
        String string = this.dbType != null ? this.dbType.getBitType() : this._driverBitTypeName;
        return this.getName(PROPERTY_BIT_TYPE_NAME, string);
    }

    public String getSmallIntTypeName() {
        String string = this.dbType != null ? this.dbType.getSmallIntType() : this._driverSmallIntTypeName;
        return this.getName(PROPERTY_SMALL_INTEGER_TYPE_NAME, string);
    }

    public String getIntegerTypeName() {
        String string = this.dbType != null ? this.dbType.getIntType() : this._driverIntegerTypeName;
        return this.getName(PROPERTY_INTEGER_TYPE_NAME, string);
    }

    public String getFrameNameType() {
        String string = this.dbType != null ? this.dbType.getFrameNameType() : this._driverVarcharTypeName;
        return this.getName(PROPERTY_FRAME_NAME_TYPE_NAME, string);
    }

    public String getShortValueType() {
        String string = this.dbType != null ? this.dbType.getShortValueType() : this._driverVarcharTypeName;
        return this.getName(PROPERTY_SHORT_VALUE_TYPE_NAME, string);
    }

    public int getMaxVarcharSize() {
        String string = ApplicationProperties.getApplicationOrSystemProperty("Database.type.varchar.maxsize." + this.driver);
        if (string != null) {
            try {
                return Integer.parseInt(string);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        if (this.dbType != null) {
            return this.dbType.getMaxShortValueSize();
        }
        return 255;
    }

    public String getLongvarcharTypeName() {
        String string;
        if (this.dbType != null) {
            string = this.dbType.getLongStringType();
        } else {
            string = SystemUtilities.getSystemProperty("SimpleJdbcDatabaseManager.longvarcharname." + this.driver);
            if (string == null || string.length() == 0) {
                string = this._driverLongvarcharTypeName;
            }
            if (string == null) {
                string = this.getShortValueType();
                Log.getLogger().warning("Using VARCHAR in place of LONGVARCHAR, long strings will be truncated.");
            }
        }
        return this.getName(PROPERTY_LONGVARCHAR_TYPE_NAME, string);
    }

    public boolean supportsCaseInsensitiveMatches() throws SQLException {
        return !this.isOracle() && !this.isPostgres();
    }

    public boolean supportsIndexOnFunction() throws SQLException {
        return this.isOracle() || this.isPostgres();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean beginTransaction() {
        if (!this.sessionOk()) {
            return false;
        }
        boolean bl = false;
        try {
            if (this._supportsTransactions) {
                if (this.transactionMonitor.getNesting() == 0) {
                    if (this.isMsAccess()) {
                        this.pool.closeStatements(this.getConnection());
                    }
                    this.getConnection().setAutoCommit(false);
                }
                this.transactionMonitor.beginTransaction();
            }
            bl = true;
            if (log.isLoggable(Level.FINE)) {
                log.fine("Thead " + Thread.currentThread() + " locking connection " + this.pool.getId(this.getConnection()));
            }
        }
        catch (SQLException sQLException) {
            Log.getLogger().warning(sQLException.toString());
        }
        finally {
            this.setIdle(true);
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean commitTransaction() {
        if (!this.sessionOk()) {
            return false;
        }
        boolean bl = false;
        try {
            if (this._supportsTransactions && this.transactionMonitor.getNesting() > 0) {
                this.transactionMonitor.commitTransaction();
                if (this.transactionMonitor.getNesting() == 0) {
                    this.getConnection().commit();
                    this.getConnection().setAutoCommit(true);
                }
            }
            bl = true;
        }
        catch (SQLException sQLException) {
            Log.getLogger().warning(sQLException.toString());
        }
        finally {
            this.setIdle(true);
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean rollbackTransaction() {
        if (!this.sessionOk()) {
            return false;
        }
        boolean bl = false;
        try {
            if (this._supportsTransactions && this.transactionMonitor.getNesting() > 0) {
                this.transactionMonitor.rollbackTransaction();
                if (this.transactionMonitor.getNesting() == 0) {
                    this.getConnection().rollback();
                    this.getConnection().setAutoCommit(true);
                }
            }
            bl = true;
        }
        catch (SQLException sQLException) {
            Log.getLogger().warning(sQLException.toString());
        }
        finally {
            this.setIdle(true);
        }
        return bl;
    }

    private boolean sessionOk() {
        if (ServerFrameStore.getCurrentSession() == null) {
            return this.session == null;
        }
        return ServerFrameStore.getCurrentSession().equals(this.session);
    }

    public boolean supportsTransactions() {
        return this._supportsTransactions;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getTransactionIsolationLevel() throws SQLException {
        if (this.transactionIsolationLevel != null) {
            return this.transactionIsolationLevel;
        }
        try {
            this.transactionIsolationLevel = this.getConnection().getTransactionIsolation();
            int n = this.transactionIsolationLevel;
            return n;
        }
        finally {
            this.setIdle(true);
        }
    }

    public void setTransactionIsolationLevel(int n) throws SQLException {
        this.transactionIsolationLevel = null;
        try {
            this.getConnection().setTransactionIsolation(n);
        }
        catch (SQLException sQLException) {
            Log.getLogger().log(Level.WARNING, "Problem setting the transaction isolation level", sQLException);
            this.transactionIsolationLevel = null;
            throw sQLException;
        }
        finally {
            this.setIdle(true);
        }
    }

    private synchronized Connection getConnection() throws SQLException {
        if (this.connection == null) {
            this.setupConnection();
        }
        this.setIdle(false);
        return this.connection;
    }

    public void setIdle(boolean bl) {
        this.idleFlag = bl;
        if (this.getIdle() && this.connection != null) {
            this.pool.ungetConnection(this.connection);
            this.connection = null;
        }
    }

    public boolean getIdle() {
        if (this._supportsTransactions && this.transactionMonitor != null && this.transactionMonitor.getNesting() > 0) {
            return false;
        }
        return this.idleFlag;
    }

    public static void main(String[] stringArray) throws SQLException {
        RobustConnection robustConnection = new RobustConnection(stringArray[0], stringArray[1], stringArray[2], stringArray[3], null, null);
        ResultSet resultSet = robustConnection.connection.getMetaData().getTypeInfo();
        while (resultSet.next()) {
            System.out.println("TYPE_NAME: " + resultSet.getString(1));
            System.out.println("\tDATA_TYPE: " + resultSet.getInt(2));
            System.out.println("\tPRECISION: " + resultSet.getLong(3));
            System.out.println("\tLITERAL_PREFIX: " + resultSet.getString(4));
            System.out.println("\tLITERAL_SUFFIX: " + resultSet.getString(5));
            System.out.println("\tCREATE_PARAMS: " + resultSet.getString(6));
            System.out.println("\tNULLABLE: " + resultSet.getShort(7));
            System.out.println("\tCASE_SENSITIVE: " + resultSet.getBoolean(8));
            System.out.println("\tSEARCHABLE: " + resultSet.getShort(9));
            System.out.println("\tUNSIGNED_ATTRIBUTE: " + resultSet.getBoolean(10));
            System.out.println("\tFIXED_PREC_SCALE: " + resultSet.getBoolean(11));
            System.out.println("\tAUTO_INCREMENT: " + resultSet.getBoolean(12));
            System.out.println("\tLOCAL_TYPE_NAME: " + resultSet.getString(13));
            System.out.println("\tMINIMUM_SCALE: " + resultSet.getShort(14));
            System.out.println("\tMAXIMUM_SCALE: " + resultSet.getShort(15));
            System.out.println("\tSQL_DATA_TYPE: " + resultSet.getShort(16));
            System.out.println("\tSQL_DATETIME_SUB: " + resultSet.getShort(17));
            System.out.println("\tNUM_PREC_RADIX: " + resultSet.getInt(18));
        }
        resultSet.close();
    }
}

