/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protege.ui;

import edu.stanford.smi.protege.model.Cls;
import edu.stanford.smi.protege.model.Instance;
import edu.stanford.smi.protege.model.KnowledgeBase;
import edu.stanford.smi.protege.model.Project;
import edu.stanford.smi.protege.model.Slot;
import edu.stanford.smi.protege.ui.EditStringPanel;
import edu.stanford.smi.protege.ui.FormRenderer;
import edu.stanford.smi.protege.ui.PickSymbolPanel;
import edu.stanford.smi.protege.ui.ProjectManager;
import edu.stanford.smi.protege.ui.SelectClsesPanel;
import edu.stanford.smi.protege.ui.SelectInstanceFromCollectionPanel;
import edu.stanford.smi.protege.ui.SelectInstancesFromCollectionPanel;
import edu.stanford.smi.protege.ui.SelectInstancesPanel;
import edu.stanford.smi.protege.util.Assert;
import edu.stanford.smi.protege.util.CollectionUtilities;
import edu.stanford.smi.protege.util.ModalDialog;
import edu.stanford.smi.protege.util.Validator;
import java.awt.Component;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import javax.swing.ListCellRenderer;

public class DisplayUtilities {
    public static String editString(final Component component, String string, Object object, final Validator validator) {
        final EditStringPanel editStringPanel = new EditStringPanel(object, string);
        ModalDialog.CloseCallback closeCallback = new ModalDialog.CloseCallback(){

            public boolean canClose(int n) {
                boolean bl;
                if (n == 1 && validator != null) {
                    String string = editStringPanel.getText();
                    bl = validator.isValid(string);
                    if (!bl) {
                        ModalDialog.showMessageDialog(component, validator.getErrorMessage(string));
                    }
                } else {
                    bl = true;
                }
                return bl;
            }
        };
        String string2 = object == null ? null : object.toString();
        int n = ModalDialog.showDialog(component, editStringPanel, string, 11, closeCallback);
        if (n == 1) {
            string2 = editStringPanel.getText();
        }
        return string2;
    }

    private static Collection getFirstTwoConcreteClses(KnowledgeBase knowledgeBase, Collection collection) {
        HashSet hashSet = new HashSet();
        if (collection.isEmpty()) {
            collection = knowledgeBase.getRootClses();
        }
        DisplayUtilities.getFirstTwoConcreteClses(collection, hashSet);
        return hashSet;
    }

    private static void getFirstTwoConcreteClses(Collection collection, Collection collection2) {
        Iterator iterator = collection.iterator();
        while (iterator.hasNext() && collection2.size() != 2) {
            Cls cls = (Cls)iterator.next();
            if (cls.isConcrete()) {
                collection2.add(cls);
                if (collection2.size() == 2) break;
            }
            DisplayUtilities.getFirstTwoConcreteClses(cls.getDirectSubclasses(), collection2);
        }
    }

    public static boolean hasMultipleConcreteClses(KnowledgeBase knowledgeBase, Collection collection) {
        return collection.isEmpty() || DisplayUtilities.getFirstTwoConcreteClses(knowledgeBase, collection).size() == 2;
    }

    private static boolean hasOneClass(Collection collection) {
        Cls cls;
        boolean bl = collection.size() == 1 ? (cls = (Cls)CollectionUtilities.getFirstItem(collection)).getDirectSubclassCount() == 0 : false;
        return bl;
    }

    public static Cls pickCls(Component component, Collection collection) {
        return DisplayUtilities.pickCls(component, DisplayUtilities.getKnowledgeBase(collection), collection, "Select Class");
    }

    public static Cls pickCls(Component component, KnowledgeBase knowledgeBase, Collection collection) {
        return DisplayUtilities.pickCls(component, knowledgeBase, collection, "Select Class");
    }

    public static Cls pickCls(Component component, Collection collection, String string) {
        return DisplayUtilities.pickCls(component, DisplayUtilities.getKnowledgeBase(collection), collection, string);
    }

    public static Cls pickCls(Component component, KnowledgeBase knowledgeBase, Collection collection, String string) {
        return (Cls)CollectionUtilities.getFirstItem(DisplayUtilities.pickClses(component, knowledgeBase, collection, string, false));
    }

    public static Collection pickClses(Component component, KnowledgeBase knowledgeBase) {
        return DisplayUtilities.pickClses(component, knowledgeBase, "Select Classes");
    }

    public static Collection pickClses(Component component, KnowledgeBase knowledgeBase, String string) {
        Collection<Cls> collection = CollectionUtilities.createCollection(knowledgeBase.getRootCls());
        return DisplayUtilities.pickClses(component, knowledgeBase, collection, string);
    }

    public static Collection pickClses(Component component, Collection collection) {
        return DisplayUtilities.pickClses(component, DisplayUtilities.getKnowledgeBase(collection), collection);
    }

    public static Collection pickClses(Component component, KnowledgeBase knowledgeBase, Collection collection) {
        return DisplayUtilities.pickClses(component, knowledgeBase, collection, "Select Classes");
    }

    public static Collection pickClses(Component component, KnowledgeBase knowledgeBase, Collection collection, String string) {
        return DisplayUtilities.pickClses(component, knowledgeBase, collection, string, true);
    }

    private static Collection pickClses(Component component, KnowledgeBase knowledgeBase, Collection collection, String string, boolean bl) {
        SelectClsesPanel selectClsesPanel;
        int n;
        Collection collection2 = collection.isEmpty() ? Collections.EMPTY_LIST : (DisplayUtilities.hasOneClass(collection) ? collection : ((n = ModalDialog.showDialog(component, selectClsesPanel = new SelectClsesPanel(knowledgeBase, collection, bl), string, 11)) == 1 ? selectClsesPanel.getSelection() : Collections.EMPTY_LIST));
        return collection2;
    }

    public static Cls pickConcreteCls(Component component, KnowledgeBase knowledgeBase, String string) {
        Collection<Cls> collection = CollectionUtilities.createCollection(knowledgeBase.getRootCls());
        return DisplayUtilities.pickConcreteCls(component, knowledgeBase, collection, string);
    }

    public static Cls pickConcreteCls(Component component, Collection collection) {
        return DisplayUtilities.pickConcreteCls(component, collection, "Select Concrete Cls");
    }

    public static Cls pickConcreteCls(Component component, KnowledgeBase knowledgeBase, Collection collection) {
        return DisplayUtilities.pickConcreteCls(component, knowledgeBase, collection, "Select Concrete Cls");
    }

    public static Cls pickConcreteCls(Component component, Collection collection, String string) {
        return DisplayUtilities.pickConcreteCls(component, DisplayUtilities.getKnowledgeBase(collection), collection, string);
    }

    public static Cls pickConcreteCls(Component component, KnowledgeBase knowledgeBase, Collection collection, String string) {
        Cls cls;
        Collection collection2 = DisplayUtilities.getFirstTwoConcreteClses(knowledgeBase, collection);
        switch (collection2.size()) {
            case 0: {
                ModalDialog.showMessageDialog(component, "There are no concrete allowed classes");
                cls = null;
                break;
            }
            case 1: {
                cls = (Cls)CollectionUtilities.getFirstItem(collection2);
                break;
            }
            case 2: {
                cls = DisplayUtilities.promptForConcreteCls(component, knowledgeBase, collection, string);
                break;
            }
            default: {
                Assert.fail("bad size: " + collection2.size());
                cls = null;
            }
        }
        return cls;
    }

    public static Cls pickForm(Component component, Project project) {
        return DisplayUtilities.pickForm(component, project, "Select Prototype Form");
    }

    public static Cls pickForm(Component component, Project project, String string) {
        SelectClsesPanel selectClsesPanel = new SelectClsesPanel(project.getKnowledgeBase(), new FormRenderer(project));
        int n = ModalDialog.showDialog(component, selectClsesPanel, string, 11);
        Cls cls = n == 1 ? (Cls)CollectionUtilities.getFirstItem(selectClsesPanel.getSelection()) : null;
        return cls;
    }

    public static Instance pickInstance(Component component, KnowledgeBase knowledgeBase) {
        Set<Cls> set = Collections.singleton(knowledgeBase.getRootCls());
        return DisplayUtilities.pickInstance(component, set, "Select Instance");
    }

    public static Instance pickInstance(Component component, Collection collection) {
        return DisplayUtilities.pickInstance(component, collection, "Select Instance");
    }

    public static Instance pickInstance(Component component, Collection collection, String string) {
        return (Instance)CollectionUtilities.getFirstItem(DisplayUtilities.pickInstances(component, collection, string));
    }

    public static Instance pickInstanceFromCollection(Component component, Collection collection, int n, String string) {
        return DisplayUtilities.pickInstanceFromCollection(component, collection, n, string, null);
    }

    public static Instance pickInstanceFromCollection(Component component, Collection collection, int n, String string, ListCellRenderer listCellRenderer) {
        int n2;
        SelectInstanceFromCollectionPanel selectInstanceFromCollectionPanel = new SelectInstanceFromCollectionPanel(collection, n);
        if (listCellRenderer != null) {
            selectInstanceFromCollectionPanel.setCellRenderer(listCellRenderer);
        }
        Instance instance = (n2 = ModalDialog.showDialog(component, selectInstanceFromCollectionPanel, string, 11)) == 1 ? selectInstanceFromCollectionPanel.getSelection() : null;
        return instance;
    }

    public static Collection pickInstances(Component component, Collection collection) {
        return DisplayUtilities.pickInstances(component, collection, "Select Instances");
    }

    public static Collection pickInstances(Component component, KnowledgeBase knowledgeBase, Collection collection) {
        return DisplayUtilities.pickInstances(component, knowledgeBase, collection, "Select Instances");
    }

    public static Collection pickInstances(Component component, Collection collection, String string) {
        KnowledgeBase knowledgeBase = DisplayUtilities.getKnowledgeBase(collection);
        return DisplayUtilities.pickInstances(component, knowledgeBase, collection, string);
    }

    private static KnowledgeBase getKnowledgeBase(Collection collection) {
        Cls cls = (Cls)CollectionUtilities.getFirstItem(collection);
        KnowledgeBase knowledgeBase = cls == null ? ProjectManager.getProjectManager().getCurrentProject().getKnowledgeBase() : cls.getKnowledgeBase();
        return knowledgeBase;
    }

    public static Collection pickInstances(Component component, KnowledgeBase knowledgeBase, Collection collection, String string) {
        Collection collection2 = Collections.EMPTY_LIST;
        SelectInstancesPanel selectInstancesPanel = new SelectInstancesPanel(knowledgeBase, collection);
        int n = ModalDialog.showDialog(component, selectInstancesPanel, string, 11);
        if (n == 1) {
            collection2 = selectInstancesPanel.getSelection();
        }
        return collection2;
    }

    public static Collection pickInstancesFromCollection(Component component, Collection collection, String string) {
        Collection collection2 = Collections.EMPTY_LIST;
        SelectInstancesFromCollectionPanel selectInstancesFromCollectionPanel = new SelectInstancesFromCollectionPanel(collection);
        int n = ModalDialog.showDialog(component, selectInstancesFromCollectionPanel, string, 11);
        switch (n) {
            case 1: {
                collection2 = selectInstancesFromCollectionPanel.getSelection();
                break;
            }
            case 4: {
                break;
            }
            default: {
                Assert.fail("bad result: " + n);
            }
        }
        return collection2;
    }

    public static Slot pickSlot(Component component, Collection collection) {
        return DisplayUtilities.pickSlot(component, collection, "Select Slot");
    }

    public static Slot pickSlot(Component component, Collection collection, String string) {
        return (Slot)CollectionUtilities.getFirstItem(DisplayUtilities.pickInstancesFromCollection(component, collection, string));
    }

    public static Collection pickSlots(Component component, Collection collection) {
        return DisplayUtilities.pickInstancesFromCollection(component, collection, "Select Slots");
    }

    public static Collection pickSlots(Component component, Collection collection, String string) {
        return DisplayUtilities.pickInstancesFromCollection(component, collection, string);
    }

    public static Object pickSymbol(Component component, String string, Object object, Collection collection) {
        Object object2 = object;
        PickSymbolPanel pickSymbolPanel = new PickSymbolPanel(string, object, collection);
        int n = ModalDialog.showDialog(component, pickSymbolPanel, string, 11);
        if (n == 1) {
            object2 = pickSymbolPanel.getSelectedValue();
        }
        return object2;
    }

    private static Cls promptForConcreteCls(final Component component, KnowledgeBase knowledgeBase, Collection collection, final String string) {
        final SelectClsesPanel selectClsesPanel = new SelectClsesPanel(knowledgeBase, collection);
        ModalDialog.CloseCallback closeCallback = new ModalDialog.CloseCallback(){

            public boolean canClose(int n) {
                boolean bl;
                if (n == 1) {
                    Cls cls = (Cls)CollectionUtilities.getFirstItem(selectClsesPanel.getSelection());
                    boolean bl2 = bl = cls != null && cls.isConcrete();
                    if (!bl) {
                        ModalDialog.showMessageDialog(component, string);
                    }
                } else {
                    bl = true;
                }
                return bl;
            }
        };
        int n = ModalDialog.showDialog(component, selectClsesPanel, string, 11, closeCallback);
        Cls cls = n == 1 ? (Cls)CollectionUtilities.getFirstItem(selectClsesPanel.getSelection()) : null;
        return cls;
    }
}

