/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protege.ui;

import edu.stanford.smi.protege.model.FrameCounts;
import edu.stanford.smi.protege.model.Project;
import edu.stanford.smi.protege.util.ComponentFactory;
import edu.stanford.smi.protege.util.LabeledComponent;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableColumn;

public class MetricsPanel
extends JComponent {
    private static final long serialVersionUID = 2991659380230833251L;
    private FrameCounts _frameCounts;
    private DefaultTableModel _summaryModel;

    public MetricsPanel(Project project) {
        this._frameCounts = project.getKnowledgeBase().getFrameCounts();
        this.setLayout(new BorderLayout());
        this.add(this.createSummaryPanel());
    }

    private Object[] createClsSummary() {
        return new Object[]{"Classes", new Integer(this._frameCounts.getSystemClsCount()), new Integer(this._frameCounts.getIncludedClsCount()), new Integer(this._frameCounts.getDirectClsCount()), new Integer(this._frameCounts.getTotalClsCount())};
    }

    private Object[] createFacetSummary() {
        return new Object[]{"Facets", new Integer(this._frameCounts.getSystemFacetCount()), new Integer(this._frameCounts.getIncludedFacetCount()), new Integer(this._frameCounts.getDirectFacetCount()), new Integer(this._frameCounts.getTotalFacetCount())};
    }

    private Object[] createFrameSummary() {
        return new Object[]{"Frames", new Integer(this._frameCounts.getSystemFrameCount()), new Integer(this._frameCounts.getIncludedFrameCount()), new Integer(this._frameCounts.getDirectFrameCount()), new Integer(this._frameCounts.getTotalFrameCount())};
    }

    private Object[] createInstanceSummary() {
        return new Object[]{"Instances", new Integer(this._frameCounts.getSystemSimpleInstanceCount()), new Integer(this._frameCounts.getIncludedSimpleInstanceCount()), new Integer(this._frameCounts.getDirectSimpleInstanceCount()), new Integer(this._frameCounts.getTotalSimpleInstanceCount())};
    }

    private Object[] createSlotSummary() {
        return new Object[]{"Slots", new Integer(this._frameCounts.getSystemSlotCount()), new Integer(this._frameCounts.getIncludedSlotCount()), new Integer(this._frameCounts.getDirectSlotCount()), new Integer(this._frameCounts.getTotalSlotCount())};
    }

    private JComponent createSummaryPanel() {
        this._summaryModel = new DefaultTableModel();
        this._summaryModel.addColumn("");
        this._summaryModel.addColumn("System");
        this._summaryModel.addColumn("Included");
        this._summaryModel.addColumn("Direct");
        this._summaryModel.addColumn("Total");
        return this.createTable(this._summaryModel, "Summary");
    }

    private void updateSummaryModel() {
        this._summaryModel.addRow(this.createClsSummary());
        this._summaryModel.addRow(this.createSlotSummary());
        this._summaryModel.addRow(this.createFacetSummary());
        this._summaryModel.addRow(this.createInstanceSummary());
        this._summaryModel.addRow(this.createFrameSummary());
    }

    private JComponent createTable(DefaultTableModel defaultTableModel, String string) {
        JTable jTable = ComponentFactory.createTable(null);
        jTable.setModel(defaultTableModel);
        this.updateSummaryModel();
        jTable.createDefaultColumnsFromModel();
        ((JLabel)((Object)jTable.getDefaultRenderer(Object.class))).setHorizontalAlignment(4);
        TableColumn tableColumn = jTable.getColumnModel().getColumn(0);
        tableColumn.setPreferredWidth(95);
        DefaultTableCellRenderer defaultTableCellRenderer = new DefaultTableCellRenderer();
        defaultTableCellRenderer.setHorizontalAlignment(2);
        tableColumn.setCellRenderer(defaultTableCellRenderer);
        DefaultTableCellRenderer defaultTableCellRenderer2 = new DefaultTableCellRenderer();
        jTable.setDefaultRenderer(Double.class, defaultTableCellRenderer2);
        jTable.setEnabled(false);
        JPanel jPanel = new JPanel(new BorderLayout());
        JTableHeader jTableHeader = jTable.getTableHeader();
        jPanel.add((Component)jTable, "Center");
        jPanel.add((Component)jTableHeader, "North");
        MetricsPanel.headerSizeFix(jTableHeader);
        return new LabeledComponent(string, jPanel);
    }

    private static void headerSizeFix(JTableHeader jTableHeader) {
        int n = jTableHeader.getPreferredSize().height;
        if (n < 16) {
            jTableHeader.setPreferredSize(new Dimension(0, 16));
        }
    }
}

