/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protege.widget;

import edu.stanford.smi.protege.event.ClsAdapter;
import edu.stanford.smi.protege.event.ClsEvent;
import edu.stanford.smi.protege.event.ClsListener;
import edu.stanford.smi.protege.event.FrameAdapter;
import edu.stanford.smi.protege.event.FrameEvent;
import edu.stanford.smi.protege.event.FrameListener;
import edu.stanford.smi.protege.event.KnowledgeBaseAdapter;
import edu.stanford.smi.protege.event.KnowledgeBaseEvent;
import edu.stanford.smi.protege.event.KnowledgeBaseListener;
import edu.stanford.smi.protege.model.Cls;
import edu.stanford.smi.protege.model.Facet;
import edu.stanford.smi.protege.model.FrameSlotCombination;
import edu.stanford.smi.protege.model.Instance;
import edu.stanford.smi.protege.model.KnowledgeBase;
import edu.stanford.smi.protege.model.Slot;
import edu.stanford.smi.protege.resource.Icons;
import edu.stanford.smi.protege.resource.ResourceKey;
import edu.stanford.smi.protege.ui.CardinalityFacetRenderer;
import edu.stanford.smi.protege.ui.DisplayUtilities;
import edu.stanford.smi.protege.ui.OtherFacetsRenderer;
import edu.stanford.smi.protege.ui.SlotPairRenderer;
import edu.stanford.smi.protege.ui.TypeFacetRenderer;
import edu.stanford.smi.protege.util.AddAction;
import edu.stanford.smi.protege.util.AllowableAction;
import edu.stanford.smi.protege.util.CollectionUtilities;
import edu.stanford.smi.protege.util.CreateAction;
import edu.stanford.smi.protege.util.Log;
import edu.stanford.smi.protege.util.ModalDialog;
import edu.stanford.smi.protege.util.RemoveAction;
import edu.stanford.smi.protege.util.RowTableModel;
import edu.stanford.smi.protege.util.Selectable;
import edu.stanford.smi.protege.util.TransferableCollection;
import edu.stanford.smi.protege.util.ViewAction;
import edu.stanford.smi.protege.widget.AbstractTableWidget;
import edu.stanford.smi.protege.widget.SlotViewPanel;
import java.awt.Component;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JPopupMenu;
import javax.swing.TransferHandler;
import javax.swing.table.TableModel;

public class TemplateSlotsWidget
extends AbstractTableWidget {
    private static final long serialVersionUID = 2572403293207051303L;
    private AllowableAction _viewAction;
    private AllowableAction _viewAtClsAction;
    protected AllowableAction _createAction;
    private AllowableAction _addAction;
    private AllowableAction _removeAction;
    private AllowableAction _removeOverrideAction;
    private Collection _currentClsTemplateSlots;
    private ClsListener _clsListener = new ClsAdapter(){

        public void templateSlotAdded(ClsEvent clsEvent) {
            Slot slot = clsEvent.getSlot();
            slot.addFrameListener(TemplateSlotsWidget.this._slotListener);
            TemplateSlotsWidget.this._currentClsTemplateSlots.add(slot);
            TemplateSlotsWidget.this.reload();
        }

        public void templateSlotRemoved(ClsEvent clsEvent) {
            Slot slot = clsEvent.getSlot();
            slot.removeFrameListener(TemplateSlotsWidget.this._slotListener);
            TemplateSlotsWidget.this._currentClsTemplateSlots.remove(slot);
            TemplateSlotsWidget.this.reload();
        }

        public void templateFacetValueChanged(ClsEvent clsEvent) {
            TemplateSlotsWidget.this.repaint();
        }

        public void directSuperclassAdded(ClsEvent clsEvent) {
            TemplateSlotsWidget.this.reload();
        }

        public void directSuperclassRemoved(ClsEvent clsEvent) {
            TemplateSlotsWidget.this.reload();
        }
    };
    private FrameListener _slotListener = new FrameAdapter(){

        public void ownSlotValueChanged(FrameEvent frameEvent) {
            super.ownSlotValueChanged(frameEvent);
            TemplateSlotsWidget.this.repaint();
        }
    };
    private KnowledgeBaseListener _knowledgeBaseListener = new KnowledgeBaseAdapter(){

        public void frameReplaced(KnowledgeBaseEvent knowledgeBaseEvent) {
            TemplateSlotsWidget.this.reload();
        }
    };

    protected void addInheritedTemplateSlots(Collection collection, Cls cls) {
        for (Cls cls2 : cls.getSuperclasses()) {
            TemplateSlotsWidget.addDirectTemplateSlots(collection, cls2);
        }
    }

    private void addSlots(Collection collection) {
        Cls cls = this.getBoundCls();
        for (Slot slot : collection) {
            this.addDirectTemplateSlot(cls, slot);
        }
    }

    private void addDirectTemplateSlot(Cls cls, Slot slot) {
        cls.addDirectTemplateSlot(slot);
        if (cls.isSlotMetaCls() && slot.getAssociatedFacet() == null) {
            Facet facet = this.getKnowledgeBase().createFacet(null);
            slot.setAssociatedFacet(facet);
        }
    }

    private boolean isSorting() {
        return !this.hasButton(Icons.getUpIcon());
    }

    protected void addTemplateSlots(Collection collection, Cls cls) {
        ArrayList arrayList = new ArrayList(cls.getVisibleTemplateSlots());
        if (this.isSorting()) {
            Collections.sort(arrayList);
        }
        collection.addAll(arrayList);
    }

    private static void addDirectTemplateSlots(Collection collection, Cls cls) {
        for (Slot slot : TemplateSlotsWidget.getDirectTemplateSlots(cls)) {
            if (collection.contains(slot)) continue;
            collection.add(slot);
        }
    }

    private static Collection getDirectTemplateSlots(Cls cls) {
        return cls.getDirectTemplateSlots();
    }

    private void changeSlotIndex(Slot slot, int n) {
        List list = (List)this.getBoundCls().getDirectTemplateSlots();
        int n2 = list.indexOf(slot);
        int n3 = n2 + n;
        if (0 <= n3 && n3 < list.size()) {
            this.getBoundCls().moveDirectTemplateSlot(slot, n3);
            this.reload();
        }
    }

    private Action createMoveDownAction() {
        return new AbstractAction("Move down", Icons.getDownIcon()){
            private static final long serialVersionUID = -2706470541341140481L;
            {
                this.putValue("ShortDescription", "Move selected slot down");
            }

            public void actionPerformed(ActionEvent actionEvent) {
                TemplateSlotsWidget.this.handleMoveDownAction();
            }
        };
    }

    private Action createMoveUpAction() {
        return new AbstractAction("Move up", Icons.getUpIcon()){
            private static final long serialVersionUID = -5564065775845561448L;
            {
                this.putValue("ShortDescription", "Move selected slot up");
            }

            public void actionPerformed(ActionEvent actionEvent) {
                TemplateSlotsWidget.this.handleMoveUpAction();
            }
        };
    }

    public TableModel createTableModel() {
        Cls cls = (Cls)this.getInstance();
        List list = cls == null ? Collections.EMPTY_LIST : this.getSlots(cls);
        RowTableModel rowTableModel = new RowTableModel(this.getTable());
        for (Slot slot : list) {
            FrameSlotCombination frameSlotCombination = new FrameSlotCombination(cls, slot);
            rowTableModel.addRow(frameSlotCombination);
        }
        return rowTableModel;
    }

    public void dispose() {
        super.dispose();
        this.getKnowledgeBase().removeKnowledgeBaseListener(this._knowledgeBaseListener);
        Cls cls = (Cls)this.getInstance();
        if (cls != null) {
            cls.removeClsListener(this._clsListener);
        }
    }

    public Action getAddSlotsAction() {
        this._addAction = new AddAction(ResourceKey.SLOT_ADD){
            private static final long serialVersionUID = 1413481816474864898L;

            public void onAdd() {
                Cls cls = TemplateSlotsWidget.this.getBaseAllowedSlotMetaCls();
                ArrayList<Instance> arrayList = new ArrayList<Instance>(TemplateSlotsWidget.this.getKnowledgeBase().getInstances(cls));
                arrayList.removeAll(TemplateSlotsWidget.this.getBoundCls().getTemplateSlots());
                String string = "Select " + TemplateSlotsWidget.this.getLabel();
                TemplateSlotsWidget.this.addSlots(DisplayUtilities.pickSlots(TemplateSlotsWidget.this, arrayList, string));
            }
        };
        return this._addAction;
    }

    private Cls getBaseAllowedSlotMetaCls() {
        Collection collection = this.getBoundCls().getDirectType().getTemplateSlotAllowedClses(this.getSlot());
        return (Cls)CollectionUtilities.getFirstItem(collection);
    }

    protected Cls getBaseSlotMetaCls() {
        Cls cls;
        Cls cls2 = this.getKnowledgeBase().getDefaultSlotMetaCls();
        Cls cls3 = cls2.hasSuperclass(cls = this.getBaseAllowedSlotMetaCls()) ? cls2 : cls;
        return cls3;
    }

    private Cls getBoundCls() {
        return (Cls)this.getInstance();
    }

    protected Action getCreateSlotAction() {
        this._createAction = new CreateAction(ResourceKey.SLOT_CREATE){
            private static final long serialVersionUID = 2685200630532658984L;

            public void onCreate() {
                Cls cls = TemplateSlotsWidget.this.getBoundCls();
                if (cls.isEditable()) {
                    Object object;
                    KnowledgeBase knowledgeBase = TemplateSlotsWidget.this.getKnowledgeBase();
                    Cls cls2 = knowledgeBase.getDefaultSlotMetaCls();
                    if (cls2 == null || !TemplateSlotsWidget.this.getBaseSlotMetaCls().equals(cls2)) {
                        object = cls.getDirectType().getTemplateSlotAllowedClses(TemplateSlotsWidget.this.getSlot());
                        cls2 = DisplayUtilities.pickConcreteCls((Component)TemplateSlotsWidget.this, TemplateSlotsWidget.this.getKnowledgeBase(), (Collection)object);
                    }
                    if (cls2 != null) {
                        object = TemplateSlotsWidget.this.getKnowledgeBase().createSlot(null, cls2);
                        TemplateSlotsWidget.this.addDirectTemplateSlot(cls, (Slot)object);
                        TemplateSlotsWidget.this.showInstance((Instance)object);
                    }
                }
            }
        };
        return this._createAction;
    }

    public Action getDoubleClickAction() {
        return new AbstractAction(){
            private static final long serialVersionUID = 940934952598817850L;

            public void actionPerformed(ActionEvent actionEvent) {
                SlotViewPanel slotViewPanel;
                int n;
                FrameSlotCombination frameSlotCombination = (FrameSlotCombination)CollectionUtilities.getFirstItem(TemplateSlotsWidget.this.getSelection());
                if (frameSlotCombination != null && (n = ModalDialog.showDialog(TemplateSlotsWidget.this, slotViewPanel = new SlotViewPanel(), "Select Slot View", 11)) == 1) {
                    if (slotViewPanel.viewTopLevelSlot()) {
                        TemplateSlotsWidget.this._viewAction.actionPerformed(actionEvent);
                    } else {
                        TemplateSlotsWidget.this._viewAtClsAction.actionPerformed(actionEvent);
                    }
                }
            }
        };
    }

    public JPopupMenu getPopupMenu() {
        JPopupMenu jPopupMenu = new JPopupMenu();
        jPopupMenu.add(this._viewAction);
        jPopupMenu.add(this._viewAtClsAction);
        jPopupMenu.add(this._createAction);
        jPopupMenu.add(this._addAction);
        jPopupMenu.add(this._removeAction);
        return jPopupMenu;
    }

    public Action getRemoveOverrideAction() {
        this._removeOverrideAction = new AllowableAction(ResourceKey.SLOT_REMOVE_FACET_OVERRIDES, (Selectable)this){
            private static final long serialVersionUID = -4145394593794210979L;

            public void actionPerformed(ActionEvent actionEvent) {
                for (FrameSlotCombination frameSlotCombination : this.getSelection()) {
                    ((Cls)frameSlotCombination.getFrame()).removeTemplateFacetOverrides(frameSlotCombination.getSlot());
                }
            }
        };
        return this._removeOverrideAction;
    }

    public Action getRemoveSlotsAction() {
        this._removeAction = new RemoveAction(ResourceKey.SLOT_REMOVE, (Selectable)this){
            private static final long serialVersionUID = -5482243741134967499L;

            public void onRemove(Collection collection) {
                TemplateSlotsWidget.this.handleRemoveCombinations(collection);
            }

            public void onSelectionChange() {
                Object x = CollectionUtilities.getFirstItem(this.getSelection());
                FrameSlotCombination frameSlotCombination = (FrameSlotCombination)x;
                Slot slot = frameSlotCombination == null ? (Slot)null : frameSlotCombination.getSlot();
                this.setAllowed(slot != null && TemplateSlotsWidget.this.getBoundCls().hasDirectTemplateSlot(slot));
            }
        };
        return this._removeAction;
    }

    protected void handleRemoveCombinations(Collection collection) {
        try {
            Cls cls = this.getCls();
            this.beginTransaction("Remove slots from " + cls, cls == null ? null : cls.getName());
            for (FrameSlotCombination frameSlotCombination : collection) {
                TemplateSlotsWidget.handleRemoveCombination(frameSlotCombination);
            }
            this.commitTransaction();
        }
        catch (Exception exception) {
            this.rollbackTransaction();
            Log.getLogger().warning("Problem at removing slots from " + this.getCls());
        }
    }

    private static void handleRemoveCombination(FrameSlotCombination frameSlotCombination) {
        Cls cls = (Cls)frameSlotCombination.getFrame();
        Slot slot = frameSlotCombination.getSlot();
        cls.removeDirectTemplateSlot(slot);
    }

    private Slot getSelectedDirectSlot() {
        Slot slot = this.getSelectedSlot();
        boolean bl = this.getBoundCls().hasDirectTemplateSlot(slot);
        return bl ? slot : null;
    }

    private Slot getSelectedSlot() {
        Slot slot = null;
        Collection collection = this.getSelection();
        if (collection.size() == 1) {
            FrameSlotCombination frameSlotCombination = (FrameSlotCombination)CollectionUtilities.getFirstItem(collection);
            slot = frameSlotCombination.getSlot();
        }
        return slot;
    }

    protected List getSlots(Cls cls) {
        ArrayList arrayList = new ArrayList();
        this.addTemplateSlots(arrayList, cls);
        return arrayList;
    }

    private Action getViewSlotAction() {
        this._viewAction = new ViewAction(ResourceKey.SLOT_VIEW_TOP_LEVEL, (Selectable)this){
            private static final long serialVersionUID = 7903942567777207326L;

            public void onView(Object object) {
                FrameSlotCombination frameSlotCombination = (FrameSlotCombination)object;
                TemplateSlotsWidget.this.showInstance(frameSlotCombination.getSlot());
            }
        };
        return this._viewAction;
    }

    private Action getViewSlotAtClassAction() {
        this._viewAtClsAction = new ViewAction(ResourceKey.SLOT_VIEW_FACET_OVERRIDES, (Selectable)this){
            private static final long serialVersionUID = -309920053960064704L;

            public void onView(Object object) {
                FrameSlotCombination frameSlotCombination = (FrameSlotCombination)object;
                TemplateSlotsWidget.this.show((Cls)frameSlotCombination.getFrame(), frameSlotCombination.getSlot());
            }
        };
        return this._viewAtClsAction;
    }

    protected void handleMoveDownAction() {
        Slot slot = this.getSelectedDirectSlot();
        if (slot != null) {
            this.changeSlotIndex(slot, 1);
        }
    }

    protected void handleMoveUpAction() {
        Slot slot = this.getSelectedDirectSlot();
        if (slot != null) {
            this.changeSlotIndex(slot, -1);
        }
    }

    public void initialize() {
        Action action = this.getViewSlotAction();
        super.initialize(this.getDoubleClickAction());
        this.addButton(action);
        this.addButton(this.getViewSlotAtClassAction());
        this.addButton(this.getCreateSlotAction());
        this.addButton(this.getRemoveOverrideAction());
        this.addButton(this.getAddSlotsAction());
        this.addButton(this.getRemoveSlotsAction());
        this.addButton(this.createMoveUpAction(), false);
        this.addButton(this.createMoveDownAction(), false);
        this.addColumn(200, ResourceKey.TEMPLATE_SLOTS_SLOT_WIDGET_NAME, SlotPairRenderer.createInstance());
        this.addColumn(80, ResourceKey.TEMPLATE_SLOTS_SLOT_WIDGET_CARDINALITY, new CardinalityFacetRenderer(this.getKnowledgeBase()));
        this.addColumn(200, ResourceKey.TEMPLATE_SLOTS_SLOT_WIDGET_TYPE, new TypeFacetRenderer());
        this.addColumn(400, ResourceKey.TEMPLATE_SLOTS_SLOT_WIDGET_OTHER_FACETS, new OtherFacetsRenderer());
        this.getTable().setAutoCreateColumnsFromModel(false);
        this.getKnowledgeBase().addKnowledgeBaseListener(this._knowledgeBaseListener);
        this.setupDragAndDrop();
    }

    private void setupDragAndDrop() {
        this.getTable().setDragEnabled(true);
        this.getTable().setTransferHandler(new MyTransferHandler());
    }

    public static boolean isSuitable(Cls cls, Slot slot, Facet facet) {
        boolean bl = cls.isClsMetaCls();
        Slot slot2 = slot.getKnowledgeBase().getSlot(":DIRECT-TEMPLATE-SLOTS");
        return bl && (slot.equals(slot2) || slot.hasSuperslot(slot2));
    }

    public void setEditable(boolean bl) {
        this._createAction.setAllowed(bl);
        this._addAction.setAllowed(bl);
        this._removeAction.setAllowed(bl);
        this._removeOverrideAction.setAllowed(bl);
    }

    public void setInstance(Instance instance) {
        Cls cls = (Cls)this.getInstance();
        if (cls != null) {
            cls.removeClsListener(this._clsListener);
            for (Object object : this._currentClsTemplateSlots) {
                object.removeFrameListener(this._slotListener);
            }
        }
        super.setInstance(instance);
        if (instance != null) {
            Cls cls2 = (Cls)instance;
            cls2.addClsListener(this._clsListener);
            this._currentClsTemplateSlots = new ArrayList<Slot>(cls2.getTemplateSlots());
            for (Slot slot : this._currentClsTemplateSlots) {
                slot.addFrameListener(this._slotListener);
            }
        }
    }

    public String getLabel() {
        return this.localizeStandardLabel(super.getLabel(), "Template Slots", ResourceKey.TEMPLATE_SLOTS_SLOT_WIDGET_LABEL);
    }

    public String toString() {
        return "TemplateSlotsWidget";
    }

    private class MyTransferHandler
    extends TransferHandler {
        private static final long serialVersionUID = -3916638445633449129L;

        private MyTransferHandler() {
        }

        private Collection getTransferableCombinations() {
            ArrayList arrayList = new ArrayList(TemplateSlotsWidget.this.getSelection());
            for (FrameSlotCombination frameSlotCombination : arrayList) {
                Slot slot;
                Cls cls = (Cls)frameSlotCombination.getFrame();
                if (cls.hasDirectTemplateSlot(slot = frameSlotCombination.getSlot())) continue;
                arrayList.clear();
                break;
            }
            return arrayList;
        }

        protected Transferable createTransferable(JComponent jComponent) {
            Collection collection = this.getTransferableCombinations();
            return collection.isEmpty() ? null : new TransferableCollection(collection);
        }

        protected void exportDone(JComponent jComponent, Transferable transferable, int n) {
            if (n == 2) {
                for (FrameSlotCombination frameSlotCombination : this.getTransferableCombinations()) {
                    ((Cls)frameSlotCombination.getFrame()).removeDirectTemplateSlot(frameSlotCombination.getSlot());
                }
            }
        }

        public int getSourceActions(JComponent jComponent) {
            return 3;
        }
    }
}

