/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protege.server.update;

import edu.stanford.smi.protege.model.Frame;
import edu.stanford.smi.protege.model.KnowledgeBase;
import edu.stanford.smi.protege.model.Localizable;
import edu.stanford.smi.protege.model.framestore.Sft;
import edu.stanford.smi.protege.server.RemoteSession;
import edu.stanford.smi.protege.util.LocalizeUtils;
import edu.stanford.smi.protege.util.transaction.cache.serialize.CacheModify;
import edu.stanford.smi.protege.util.transaction.cache.serialize.CacheRead;
import edu.stanford.smi.protege.util.transaction.cache.serialize.SerializedCacheUpdate;
import java.io.Serializable;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ValueUpdate
implements Serializable,
Localizable {
    private static final long serialVersionUID = -7753881900765528485L;
    private Frame frame;
    private SerializedCacheUpdate<RemoteSession, Sft, List> update;

    public ValueUpdate(Frame frame, SerializedCacheUpdate<RemoteSession, Sft, List> serializedCacheUpdate) {
        this.frame = frame;
        this.update = serializedCacheUpdate;
    }

    public Frame getFrame() {
        return this.frame;
    }

    public SerializedCacheUpdate<RemoteSession, Sft, List> getUpdate() {
        return this.update;
    }

    @Override
    public void localize(KnowledgeBase knowledgeBase) {
        LocalizeUtils.localize(this.frame, knowledgeBase);
        if (this.update instanceof CacheRead) {
            CacheRead cacheRead = (CacheRead)this.update;
            ((Sft)cacheRead.getVar()).localize(knowledgeBase);
            LocalizeUtils.localize(cacheRead.getValue().getResult(), knowledgeBase);
        } else if (this.update instanceof CacheModify) {
            CacheModify cacheModify = (CacheModify)this.update;
            ((Sft)cacheModify.getVar()).localize(knowledgeBase);
            LocalizeUtils.localize(cacheModify.getNewValue().getResult(), knowledgeBase);
        }
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer("{");
        stringBuffer.append(this.update);
        stringBuffer.append(" applied to ");
        if (this.frame != null) {
            stringBuffer.append(this.frame.getFrameID().getName());
            stringBuffer.append(" cache}");
        } else {
            stringBuffer.append("all frame caches");
        }
        return stringBuffer.toString();
    }
}

