/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protege.model;

import edu.stanford.smi.protege.event.KnowledgeBaseAdapter;
import edu.stanford.smi.protege.event.KnowledgeBaseEvent;
import edu.stanford.smi.protege.model.Cls;
import edu.stanford.smi.protege.model.DefaultKnowledgeBase;
import edu.stanford.smi.protege.model.Instance;
import edu.stanford.smi.protege.model.Slot;
import edu.stanford.smi.protege.model.ValueType;
import edu.stanford.smi.protege.model.framestore.SimpleTestCase;
import junit.framework.Assert;

public class DefaultKnowledgeBase_SimpleTest
extends SimpleTestCase {
    public void testCreateKB() {
        DefaultKnowledgeBase defaultKnowledgeBase = new DefaultKnowledgeBase();
        Cls cls = defaultKnowledgeBase.getRootCls();
        Cls cls2 = defaultKnowledgeBase.getCls(":THING");
        DefaultKnowledgeBase_SimpleTest.assertEquals((Object)cls, (Object)cls2);
    }

    public void testCreateCls() {
        DefaultKnowledgeBase defaultKnowledgeBase = new DefaultKnowledgeBase();
        Cls cls = defaultKnowledgeBase.createCls(null, defaultKnowledgeBase.getRootClses());
        Cls cls2 = defaultKnowledgeBase.getCls(cls.getName());
        DefaultKnowledgeBase_SimpleTest.assertEquals((Object)cls, (Object)cls2);
    }

    public void testCreateInstanceWithNoType() {
        DefaultKnowledgeBase defaultKnowledgeBase = new DefaultKnowledgeBase();
        Instance instance = defaultKnowledgeBase.createInstance(null, (Cls)null);
        DefaultKnowledgeBase_SimpleTest.assertNotNull((Object)instance);
        String string = instance.getName();
        Instance instance2 = defaultKnowledgeBase.getInstance(string);
        DefaultKnowledgeBase_SimpleTest.assertEquals((Object)instance, (Object)instance2);
    }

    public void testGetClses() {
        DefaultKnowledgeBase defaultKnowledgeBase = new DefaultKnowledgeBase();
        Cls cls = defaultKnowledgeBase.createCls(null, defaultKnowledgeBase.getRootClses());
        DefaultKnowledgeBase_SimpleTest.assertTrue((boolean)defaultKnowledgeBase.getClses().contains(cls));
        DefaultKnowledgeBase_SimpleTest.assertTrue((boolean)defaultKnowledgeBase.getClses().contains(defaultKnowledgeBase.getRootCls()));
    }

    public void testGetValueType() {
        DefaultKnowledgeBase defaultKnowledgeBase = new DefaultKnowledgeBase();
        Slot slot = defaultKnowledgeBase.createSlot(null);
        Cls cls = defaultKnowledgeBase.createCls(null, defaultKnowledgeBase.getRootClses());
        DefaultKnowledgeBase_SimpleTest.assertEquals((boolean)false, (boolean)cls.isAbstract());
        DefaultKnowledgeBase_SimpleTest.assertEquals((Object)ValueType.STRING, (Object)slot.getValueType());
        slot.setValueType(ValueType.INSTANCE);
        DefaultKnowledgeBase_SimpleTest.assertEquals((Object)ValueType.INSTANCE, (Object)slot.getValueType());
        cls.setAbstract(true);
        DefaultKnowledgeBase_SimpleTest.assertEquals((boolean)true, (boolean)cls.isAbstract());
        DefaultKnowledgeBase_SimpleTest.assertEqualsSet(DefaultKnowledgeBase_SimpleTest.makeList(), slot.getDirectDomain());
        DefaultKnowledgeBase_SimpleTest.assertEqualsSet(DefaultKnowledgeBase_SimpleTest.makeList(), cls.getDirectTemplateSlots());
        cls.addDirectTemplateSlot(slot);
        DefaultKnowledgeBase_SimpleTest.assertEqualsSet(DefaultKnowledgeBase_SimpleTest.makeList(slot), cls.getDirectTemplateSlots());
        DefaultKnowledgeBase_SimpleTest.assertEqualsSet(DefaultKnowledgeBase_SimpleTest.makeList(cls), slot.getDirectDomain());
    }

    public void testDeleteCls() {
        final Boolean[] booleanArray = new Boolean[]{Boolean.FALSE};
        DefaultKnowledgeBase defaultKnowledgeBase = new DefaultKnowledgeBase();
        Cls cls = defaultKnowledgeBase.createCls(null, defaultKnowledgeBase.getRootClses());
        defaultKnowledgeBase.addKnowledgeBaseListener(new KnowledgeBaseAdapter(){

            public void clsDeleted(KnowledgeBaseEvent knowledgeBaseEvent) {
                Assert.assertTrue((knowledgeBaseEvent.getCls() != null ? 1 : 0) != 0);
                booleanArray[0] = Boolean.TRUE;
            }
        });
        DefaultKnowledgeBase_SimpleTest.assertTrue((booleanArray[0] == Boolean.FALSE ? 1 : 0) != 0);
        defaultKnowledgeBase.deleteCls(cls);
        DefaultKnowledgeBase_SimpleTest.assertTrue((booleanArray[0] == Boolean.TRUE ? 1 : 0) != 0);
    }
}

