/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protege.test;

import edu.stanford.smi.protege.model.Cls;
import edu.stanford.smi.protege.model.Facet;
import edu.stanford.smi.protege.model.Frame;
import edu.stanford.smi.protege.model.Instance;
import edu.stanford.smi.protege.model.KnowledgeBase;
import edu.stanford.smi.protege.model.Project;
import edu.stanford.smi.protege.model.Slot;
import edu.stanford.smi.protege.model.ValueType;
import edu.stanford.smi.protege.util.CollectionUtilities;
import edu.stanford.smi.protege.util.FileUtilities;
import edu.stanford.smi.protege.util.Log;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;
import junit.framework.TestCase;

public abstract class AbstractTestCase
extends TestCase {
    private static final File tempDirectory = AbstractTestCase.createTempDirectory();

    private static File createTempDirectory() {
        File file = null;
        try {
            File file2 = File.createTempFile("test", "tmp");
            File file3 = file2.getParentFile();
            file2.delete();
            file = new File(file3, "test" + File.separator);
            FileUtilities.deleteDirectory(file);
            file.mkdirs();
        }
        catch (IOException iOException) {
            Log.getLogger().severe(Log.toString(iOException));
        }
        return file;
    }

    protected static File getTempDirectory() {
        return tempDirectory;
    }

    protected static File getTempSubdirectory(String string) {
        File file = new File(tempDirectory, string + File.separator);
        file.mkdirs();
        return file;
    }

    protected static void deleteTempSubdirectory(String string) {
        File file = new File(tempDirectory, string);
        FileUtilities.deleteDirectory(file);
    }

    protected static void checkErrors(Collection collection) {
        if (!collection.isEmpty()) {
            for (Object e : collection) {
                if (e instanceof Throwable) {
                    Log.getLogger().log(Level.WARNING, "Exception found", (Throwable)e);
                    continue;
                }
                Log.getLogger().warning(e.toString());
            }
            AbstractTestCase.fail();
        }
    }

    protected abstract Project getProject();

    protected KnowledgeBase getDomainKB() {
        return this.getProject().getKnowledgeBase();
    }

    protected static List makeList() {
        return new ArrayList();
    }

    public static List makeList(Object object) {
        AbstractTestCase.assertNotNull((Object)object);
        List list = AbstractTestCase.makeList();
        list.add(object);
        return list;
    }

    public static List makeList(Object object, Object object2) {
        AbstractTestCase.assertNotNull((Object)object2);
        List list = AbstractTestCase.makeList(object);
        list.add(object2);
        return list;
    }

    public static List makeList(Object object, Object object2, Object object3) {
        AbstractTestCase.assertNotNull((Object)object3);
        List list = AbstractTestCase.makeList(object, object2);
        list.add(object3);
        return list;
    }

    public static List makeList(Object object, Object object2, Object object3, Object object4) {
        AbstractTestCase.assertNotNull((Object)object4);
        List list = AbstractTestCase.makeList(object, object2, object3);
        list.add(object4);
        return list;
    }

    public static void assertEqualsList(Collection collection, Collection collection2) {
        AbstractTestCase.assertEquals((int)collection.size(), (int)collection2.size());
        Iterator iterator = collection.iterator();
        Iterator iterator2 = collection2.iterator();
        while (iterator.hasNext()) {
            Object e = iterator.next();
            Object e2 = iterator2.next();
            AbstractTestCase.assertEquals(e, e2);
        }
    }

    public static void assertEqualsSet(Collection collection, Collection collection2) {
        AbstractTestCase.assertEquals((int)collection.size(), (int)collection2.size());
        HashSet hashSet = new HashSet(collection);
        hashSet.removeAll(collection2);
        AbstractTestCase.assertEquals((int)0, (int)hashSet.size());
    }

    protected Cls createCls() {
        return this.createCls(null);
    }

    protected Cls createCls(String string) {
        return this.createCls(string, this.getDomainKB().getRootCls());
    }

    protected Cls createCls(String string, Cls cls) {
        return this.getDomainKB().createCls(string, CollectionUtilities.createCollection(cls));
    }

    protected Cls createClsWithType(Cls cls) {
        return this.getDomainKB().createCls(null, this.getDomainKB().getRootClses(), cls);
    }

    protected Cls createSubClsWithType(Cls cls, Cls cls2) {
        return this.getDomainKB().createCls(null, AbstractTestCase.makeList(cls), cls2);
    }

    protected Facet createFacet() {
        return this.getDomainKB().createFacet(null);
    }

    protected Frame createFrame() {
        return this.createCls();
    }

    protected void delete(Frame frame) {
        this.getDomainKB().deleteFrame(frame);
    }

    protected Instance createInstance(Cls cls) {
        return this.createInstance(null, cls);
    }

    protected Instance createInstance(String string, Cls cls) {
        Instance instance = this.getDomainKB().createInstance(string, cls);
        if (instance instanceof Cls) {
            ((Cls)instance).addDirectSuperclass(this.getDomainKB().getRootCls());
        }
        return instance;
    }

    protected Slot createSlot() {
        return this.getDomainKB().createSlot(null);
    }

    protected Slot createSlotOnCls(Cls cls) {
        Slot slot = this.createSlot();
        cls.addDirectTemplateSlot(slot);
        return slot;
    }

    protected Slot createMultiValuedSlot(ValueType valueType) {
        Slot slot = this.getDomainKB().createSlot(null);
        slot.setValueType(valueType);
        slot.setAllowsMultipleValues(true);
        return slot;
    }

    protected Slot createMultiValuedSlot(ValueType valueType, Cls cls) {
        Slot slot = this.createMultiValuedSlot(valueType);
        AbstractTestCase.setCompleteValueType(cls, slot, valueType);
        return slot;
    }

    protected Slot createSingleValuedSlot(ValueType valueType) {
        Slot slot = this.getDomainKB().createSlot(null);
        slot.setValueType(valueType);
        slot.setAllowsMultipleValues(false);
        return slot;
    }

    protected Slot createSingleValuedSlot(ValueType valueType, Cls cls) {
        Slot slot = this.createSingleValuedSlot(valueType);
        AbstractTestCase.setCompleteValueType(cls, slot, valueType);
        return slot;
    }

    protected Cls createSubCls(Cls cls) {
        return this.createCls(null, cls);
    }

    protected Slot createSubSlot(Slot slot) {
        return this.getDomainKB().createSlot(null, slot.getDirectType(), Collections.singleton(slot), true);
    }

    protected void deleteFrame(Frame frame) {
        this.getDomainKB().deleteFrame(frame);
    }

    protected Cls getCls(String string) {
        return this.getDomainKB().getCls(string);
    }

    protected Facet getFacet(String string) {
        return this.getDomainKB().getFacet(string);
    }

    public Frame getFrame(String string) {
        return this.getDomainKB().getFrame(string);
    }

    protected int getFrameCount() {
        return this.getDomainKB().getFrameCount();
    }

    protected Instance getInstance(String string) {
        return this.getDomainKB().getInstance(string);
    }

    protected static void setCompleteValueType(Cls cls, Slot slot, ValueType valueType) {
        if (valueType == ValueType.INSTANCE) {
            slot.setAllowedClses(Collections.singleton(cls));
        } else if (valueType == ValueType.CLS) {
            slot.setAllowedParents(Collections.singleton(cls));
        } else {
            AbstractTestCase.fail((String)("bad type: " + valueType));
        }
    }

    public static void assertEqualsArray(Object[] objectArray, Object[] objectArray2) {
        AbstractTestCase.assertEqualsList(Arrays.asList(objectArray), Arrays.asList(objectArray2));
    }
}

