/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protege.util;

import edu.stanford.smi.protege.resource.Icons;
import edu.stanford.smi.protege.resource.LocalizedText;
import edu.stanford.smi.protege.resource.ResourceKey;
import edu.stanford.smi.protege.util.StringUtilities;
import edu.stanford.smi.protege.util.SystemUtilities;
import java.awt.Toolkit;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.KeyStroke;

public abstract class StandardAction
extends AbstractAction {
    private static final long serialVersionUID = 3832046476795272130L;
    public static final String DISABLED_ICON = "DisabledSmallIcon";

    protected StandardAction(String string) {
        super(string);
    }

    protected StandardAction(String string, Icon icon) {
        super(string, icon);
    }

    protected StandardAction(ResourceKey resourceKey) {
        this(resourceKey, false);
    }

    protected StandardAction(ResourceKey resourceKey, boolean bl) {
        StandardAction.initialize(this, resourceKey, bl);
    }

    public void substituteIntoName(String string) {
        String string2 = this.getName();
        String string3 = StringUtilities.replace(string2, "{0}", string);
        this.setName(string3);
    }

    public static void initialize(Action action, ResourceKey resourceKey, boolean bl) {
        StandardAction.setName(action, LocalizedText.getText(resourceKey));
        StandardAction.setIcon(action, Icons.lookupActionIcon(resourceKey, false, false));
        StandardAction.setShortcut(action, LocalizedText.getShortcut(resourceKey));
        StandardAction.setMnemonic(action, LocalizedText.getMnemonic(resourceKey));
    }

    public static boolean equals(Object object, Object object2) {
        return SystemUtilities.equals(object, object2);
    }

    public String getName() {
        return StandardAction.getName(this);
    }

    public static String getName(Action action) {
        return (String)action.getValue("Name");
    }

    public void setName(String string) {
        StandardAction.setName(this, string);
    }

    public void setDescription(String string) {
        StandardAction.setDescription(this, string);
    }

    public static void setName(Action action, String string) {
        action.putValue("Name", string);
    }

    public static void setDescription(Action action, String string) {
        action.putValue("ShortDescription", string);
    }

    public Icon getIcon() {
        return (Icon)this.getValue("SmallIcon");
    }

    public void setIcon(Icon icon) {
        StandardAction.setIcon(this, icon);
    }

    public static void setIcon(Action action, Icon icon) {
        action.putValue("SmallIcon", icon);
    }

    public void setDisabledIcon(Icon icon) {
        StandardAction.setDisabledIcon(this, icon);
    }

    public static void setDisabledIcon(Action action, Icon icon) {
        action.putValue(DISABLED_ICON, icon);
    }

    public void setShortcut(int n) {
        StandardAction.setShortcut(this, n);
    }

    public static void setShortcut(Action action, int n) {
        int n2 = Toolkit.getDefaultToolkit().getMenuShortcutKeyMask();
        KeyStroke keyStroke = n == 0 ? null : KeyStroke.getKeyStroke(n, n2);
        action.putValue("AcceleratorKey", keyStroke);
    }

    public void setMnemonic(int n) {
        StandardAction.setMnemonic(this, n);
    }

    public static void setMnemonic(Action action, int n) {
        Integer n2 = n == 0 ? null : new Integer(n);
        action.putValue("MnemonicKey", n2);
    }
}

