/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protege.model.framestore;

import edu.stanford.smi.protege.model.DefaultSlot;
import edu.stanford.smi.protege.model.Facet;
import edu.stanford.smi.protege.model.Frame;
import edu.stanford.smi.protege.model.FrameID;
import edu.stanford.smi.protege.model.KnowledgeBase;
import edu.stanford.smi.protege.model.Model;
import edu.stanford.smi.protege.model.Reference;
import edu.stanford.smi.protege.model.Slot;
import edu.stanford.smi.protege.model.framestore.NarrowFrameStore;
import edu.stanford.smi.protege.model.query.Query;
import edu.stanford.smi.protege.model.query.QueryCallback;
import edu.stanford.smi.protege.server.RemoteSession;
import edu.stanford.smi.protege.util.transaction.TransactionMonitor;
import java.util.Collection;
import java.util.List;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ImmutableNamesNarrowFrameStore
implements NarrowFrameStore {
    private String name;
    private NarrowFrameStore delegate;
    private final Slot nameSlot;

    public ImmutableNamesNarrowFrameStore(KnowledgeBase knowledgeBase, NarrowFrameStore narrowFrameStore) {
        this.delegate = narrowFrameStore;
        this.nameSlot = new DefaultSlot(knowledgeBase, Model.SlotID.NAME);
    }

    private boolean isNameSlot(Slot slot) {
        return slot != null && slot.getFrameID().equals(Model.SlotID.NAME);
    }

    private boolean isNameSft(Slot slot, Facet facet, boolean bl) {
        return this.isNameSlot(slot) && facet == null && !bl;
    }

    private void checkNotNameSft(Slot slot, Facet facet, boolean bl) {
        if (this.isNameSft(slot, facet, bl)) {
            throw new IllegalArgumentException("Should not be modifying name slot values");
        }
    }

    @Override
    public void addValues(Frame frame, Slot slot, Facet facet, boolean bl, Collection collection) {
        this.checkNotNameSft(slot, facet, bl);
        this.delegate.addValues(frame, slot, facet, bl, collection);
    }

    @Override
    public boolean beginTransaction(String string) {
        return this.delegate.beginTransaction(string);
    }

    @Override
    public void close() {
        this.delegate.close();
        this.delegate = null;
    }

    @Override
    public boolean commitTransaction() {
        return this.delegate.commitTransaction();
    }

    @Override
    public void deleteFrame(Frame frame) {
        this.delegate.deleteFrame(frame);
    }

    @Override
    public void executeQuery(Query query, QueryCallback queryCallback) {
        this.delegate.executeQuery(query, queryCallback);
    }

    @Override
    public Set getClosure(Frame frame, Slot slot, Facet facet, boolean bl) {
        return this.delegate.getClosure(frame, slot, facet, bl);
    }

    @Override
    public int getClsCount() {
        return this.delegate.getClsCount();
    }

    @Override
    public NarrowFrameStore getDelegate() {
        return this.delegate;
    }

    @Override
    public int getFacetCount() {
        return this.delegate.getFacetCount();
    }

    @Override
    public Frame getFrame(FrameID frameID) {
        return this.delegate.getFrame(frameID);
    }

    @Override
    public int getFrameCount() {
        return this.delegate.getFrameCount();
    }

    @Override
    public Set<Frame> getFrames() {
        return this.delegate.getFrames();
    }

    @Override
    public Set<Frame> getFrames(Slot slot, Facet facet, boolean bl, Object object) {
        return this.delegate.getFrames(slot, facet, bl, object);
    }

    @Override
    public Set<Frame> getFramesWithAnyValue(Slot slot, Facet facet, boolean bl) {
        return this.delegate.getFramesWithAnyValue(slot, facet, bl);
    }

    @Override
    public Set<Frame> getMatchingFrames(Slot slot, Facet facet, boolean bl, String string, int n) {
        return this.delegate.getMatchingFrames(slot, facet, bl, string, n);
    }

    @Override
    public Set<Reference> getMatchingReferences(String string, int n) {
        return this.delegate.getMatchingReferences(string, n);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public Set<Reference> getReferences(Object object) {
        return this.delegate.getReferences(object);
    }

    @Override
    public int getSimpleInstanceCount() {
        return this.delegate.getSimpleInstanceCount();
    }

    @Override
    public int getSlotCount() {
        return this.delegate.getSlotCount();
    }

    @Override
    public TransactionMonitor getTransactionStatusMonitor() {
        return this.delegate.getTransactionStatusMonitor();
    }

    @Override
    public List getValues(Frame frame, Slot slot, Facet facet, boolean bl) {
        return this.delegate.getValues(frame, slot, facet, bl);
    }

    @Override
    public int getValuesCount(Frame frame, Slot slot, Facet facet, boolean bl) {
        return this.delegate.getValuesCount(frame, slot, facet, bl);
    }

    @Override
    public void moveValue(Frame frame, Slot slot, Facet facet, boolean bl, int n, int n2) {
        this.checkNotNameSft(slot, facet, bl);
        this.delegate.moveValue(frame, slot, facet, bl, n, n2);
    }

    @Override
    public void reinitialize() {
        this.delegate.reinitialize();
    }

    @Override
    public boolean setCaching(RemoteSession remoteSession, boolean bl) {
        return this.delegate.setCaching(remoteSession, bl);
    }

    @Override
    public void removeValue(Frame frame, Slot slot, Facet facet, boolean bl, Object object) {
        this.checkNotNameSft(slot, facet, bl);
        this.delegate.removeValue(frame, slot, facet, bl, object);
    }

    @Override
    public void replaceFrame(Frame frame) {
        this.delegate.replaceFrame(frame);
    }

    @Override
    public void replaceFrame(Frame frame, Frame frame2) {
        this.delegate.replaceFrame(frame, frame2);
    }

    @Override
    public boolean rollbackTransaction() {
        return this.delegate.rollbackTransaction();
    }

    @Override
    public void setName(String string) {
        this.name = string;
    }

    @Override
    public void setValues(Frame frame, Slot slot, Facet facet, boolean bl, Collection collection) {
        if (this.isNameSft(slot, facet, bl) && (collection == null || collection.size() != 1 || !frame.getName().equals(collection.iterator().next()))) {
            throw new IllegalArgumentException("Attempt to change the name of a frame");
        }
        this.delegate.setValues(frame, slot, facet, bl, collection);
    }
}

