/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protege.model.framestore.undo;

import edu.stanford.smi.protege.model.FrameID;
import edu.stanford.smi.protege.model.SimpleInstance;
import edu.stanford.smi.protege.model.framestore.FrameStore;
import edu.stanford.smi.protege.model.framestore.undo.SimpleCommand;
import java.util.ArrayList;
import java.util.Collection;

class DeleteSimpleInstanceCommand
extends SimpleCommand {
    private SimpleInstance simpleInstance;
    private FrameID id;
    private Collection directTypes;

    DeleteSimpleInstanceCommand(FrameStore frameStore, SimpleInstance simpleInstance) {
        super(frameStore);
        this.simpleInstance = simpleInstance;
        this.id = simpleInstance.getFrameID();
        this.directTypes = new ArrayList(simpleInstance.getDirectTypes());
        this.setDescription("Delete instance " + DeleteSimpleInstanceCommand.getText(simpleInstance));
    }

    public Object doIt() {
        this.getDelegate().deleteSimpleInstance(this.simpleInstance);
        this.simpleInstance.markDeleted(true);
        return null;
    }

    public void undoIt() {
        this.getDelegate().createSimpleInstance(this.id, this.directTypes, false);
        this.simpleInstance.markDeleted(false);
    }
}

