/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protege.util;

import edu.stanford.smi.protege.util.ApplicationProperties;
import edu.stanford.smi.protege.util.FileFormatter;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.LogRecord;

public class FileHandler
extends java.util.logging.FileHandler {
    public static final String ROTATION_COUNT_PROPERTY = "edu.stanford.smi.protege.util.Log.RotationCount";
    public static final Integer ROTATION_COUNT = ApplicationProperties.getIntegerProperty("edu.stanford.smi.protege.util.Log.RotationCount", 10);
    public static final String PREFIX = "protege_";
    public static final String SUFFIX = ".log";
    private static File directory = ApplicationProperties.getLogFileDirectory();
    static String path;

    public FileHandler() throws IOException {
        super(FileHandler.getNextLogFile());
        this.setFormatter(new FileFormatter());
        this.publish(new LogRecord(Level.INFO, "*** SYSTEM START ***"));
    }

    private static String getNextLogFile() {
        HashMap<Integer, File> hashMap = new HashMap<Integer, File>();
        int n = -1;
        for (File file : directory.getAbsoluteFile().listFiles()) {
            Integer n2 = FileHandler.matchingFile(file);
            if (n2 == null) continue;
            hashMap.put(n2, file);
            if (n >= n2) continue;
            n = n2;
        }
        for (Map.Entry entry : hashMap.entrySet()) {
            if ((Integer)entry.getKey() > n - ROTATION_COUNT + 1) continue;
            ((File)entry.getValue()).delete();
            File file = new File(((File)entry.getValue()).getAbsolutePath() + ".lck");
            if (!file.exists()) continue;
            file.delete();
        }
        return new File(directory, PREFIX + (n + 1) + SUFFIX).getAbsolutePath();
    }

    private static Integer matchingFile(File file) {
        String string = file.getName();
        if (!string.startsWith(PREFIX) || !string.endsWith(SUFFIX) || string.length() < PREFIX.length() + SUFFIX.length()) {
            return null;
        }
        String string2 = string.substring(PREFIX.length(), string.length() - SUFFIX.length());
        try {
            return Integer.parseInt(string2);
        }
        catch (NumberFormatException numberFormatException) {
            return null;
        }
    }

    static {
        if (directory == null) {
            directory = new File(System.getProperty("java.io.tmpdir"));
        }
    }
}

