/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protege.widget;

import edu.stanford.smi.protege.action.DeleteInstancesAction;
import edu.stanford.smi.protege.action.ReferencersAction;
import edu.stanford.smi.protege.event.FrameAdapter;
import edu.stanford.smi.protege.event.FrameEvent;
import edu.stanford.smi.protege.event.FrameListener;
import edu.stanford.smi.protege.model.Cls;
import edu.stanford.smi.protege.model.Facet;
import edu.stanford.smi.protege.model.Instance;
import edu.stanford.smi.protege.model.Slot;
import edu.stanford.smi.protege.model.ValueType;
import edu.stanford.smi.protege.resource.ResourceKey;
import edu.stanford.smi.protege.ui.DisplayUtilities;
import edu.stanford.smi.protege.ui.FrameRenderer;
import edu.stanford.smi.protege.util.AddAction;
import edu.stanford.smi.protege.util.AllowableAction;
import edu.stanford.smi.protege.util.CollectionUtilities;
import edu.stanford.smi.protege.util.CreateAction;
import edu.stanford.smi.protege.util.LabeledComponent;
import edu.stanford.smi.protege.util.RemoveAction;
import edu.stanford.smi.protege.util.Selectable;
import edu.stanford.smi.protege.util.ViewAction;
import edu.stanford.smi.protege.widget.AbstractListWidget;
import java.awt.Component;
import java.util.Collection;
import javax.swing.Action;

public class InstanceListWidget
extends AbstractListWidget {
    private AllowableAction _createInstanceAction;
    private AllowableAction _addInstancesAction;
    private AllowableAction _removeInstancesAction;
    private AllowableAction _deleteInstancesAction;
    private AllowableAction _viewInstanceAction;
    private boolean _showNewInstances = true;
    private FrameListener _instanceListener = new FrameAdapter(){

        public void browserTextChanged(FrameEvent frameEvent) {
            super.browserTextChanged(frameEvent);
            InstanceListWidget.this.repaint();
        }
    };

    protected void addButtons(LabeledComponent labeledComponent) {
        this.addButton(this.getViewInstanceAction());
        this.addButton(this.getCreateInstanceAction());
        this.addButton(new ReferencersAction(this), false);
        this.addButton(this.getAddInstancesAction());
        this.addButton(this.getRemoveInstancesAction());
        this.addButton(this.getDeleteInstancesAction(), false);
    }

    public void addItem(Object object) {
        super.addItem(object);
        this.addListener(CollectionUtilities.createCollection(object));
    }

    public void addItems(Collection collection) {
        super.addItems(collection);
        this.addListener(collection);
    }

    protected void addListener(Collection collection) {
        for (Instance instance : collection) {
            instance.addFrameListener(this._instanceListener);
        }
    }

    public void dispose() {
        this.removeListener(this.getValues());
        super.dispose();
    }

    protected Action getAddInstancesAction() {
        this._addInstancesAction = new AddAction(ResourceKey.INSTANCE_ADD){

            public void onAdd() {
                InstanceListWidget.this.handleAddAction();
            }
        };
        return this._addInstancesAction;
    }

    public Action getCreateInstanceAction() {
        this._createInstanceAction = new CreateAction(ResourceKey.INSTANCE_CREATE){

            public void onCreate() {
                InstanceListWidget.this.handleCreateAction();
            }
        };
        return this._createInstanceAction;
    }

    protected Action getDeleteInstancesAction() {
        this._deleteInstancesAction = new DeleteInstancesAction(this);
        return this._deleteInstancesAction;
    }

    protected Action getRemoveInstancesAction() {
        this._removeInstancesAction = new RemoveAction(ResourceKey.INSTANCE_REMOVE, (Selectable)this){

            public void onRemove(Collection collection) {
                InstanceListWidget.this.handleRemoveAction(collection);
            }
        };
        return this._removeInstancesAction;
    }

    protected Action getViewInstanceAction() {
        this._viewInstanceAction = new ViewAction(ResourceKey.INSTANCE_VIEW, (Selectable)this){

            public void onView(Object object) {
                InstanceListWidget.this.handleViewAction((Instance)object);
            }
        };
        return this._viewInstanceAction;
    }

    protected void handleAddAction() {
        Collection collection = this.getCls().getTemplateSlotAllowedClses(this.getSlot());
        String string = (String)this._addInstancesAction.getValue("Name");
        this.addItems(DisplayUtilities.pickInstances((Component)this, collection, string));
    }

    protected void handleCreateAction() {
        Collection collection = this.getCls().getTemplateSlotAllowedClses(this.getSlot());
        Cls cls = DisplayUtilities.pickConcreteCls((Component)this, this.getKnowledgeBase(), collection);
        if (cls != null) {
            Cls cls2;
            Instance instance = this.getKnowledgeBase().createInstance(null, cls);
            if (instance instanceof Cls && (cls2 = (Cls)instance).getDirectSuperclassCount() == 0) {
                cls2.addDirectSuperclass(this.getKnowledgeBase().getRootCls());
            }
            if (this._showNewInstances) {
                this.showInstance(instance);
            }
            this.addItem(instance);
        }
    }

    protected void handleRemoveAction(Collection collection) {
        this.removeItems(collection);
    }

    protected void handleViewAction(Instance instance) {
        this.showInstance(instance);
    }

    public void initialize() {
        super.initialize();
        this.addButtons(this.getLabeledComponent());
        this.setRenderer(FrameRenderer.createInstance());
    }

    public static boolean isSuitable(Cls cls, Slot slot, Facet facet) {
        boolean bl;
        if (cls == null || slot == null) {
            bl = false;
        } else {
            boolean bl2 = InstanceListWidget.equals(cls.getTemplateSlotValueType(slot), ValueType.INSTANCE);
            boolean bl3 = cls.getTemplateSlotAllowsMultipleValues(slot);
            bl = bl2 && bl3;
        }
        return bl;
    }

    protected void removeListener(Collection collection) {
        for (Instance instance : collection) {
            instance.removeFrameListener(this._instanceListener);
        }
    }

    public void setEditable(boolean bl) {
        bl = bl && !this.isReadOnlyConfiguredWidget();
        InstanceListWidget.setAllowed(this._createInstanceAction, bl);
        InstanceListWidget.setAllowed(this._addInstancesAction, bl);
        InstanceListWidget.setAllowed(this._removeInstancesAction, bl);
        InstanceListWidget.setAllowed(this._deleteInstancesAction, bl);
    }

    public void setValues(Collection collection) {
        this.removeListener(this.getValues());
        this.addListener(collection);
        super.setValues(collection);
    }

    public boolean getShowNewInstances() {
        return this._showNewInstances;
    }

    public void setShowNewInstances(boolean bl) {
        this._showNewInstances = bl;
    }
}

