/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protege.model.framestore;

import edu.stanford.smi.protege.model.Cls;
import edu.stanford.smi.protege.model.Facet;
import edu.stanford.smi.protege.model.Frame;
import edu.stanford.smi.protege.model.FrameID;
import edu.stanford.smi.protege.model.Instance;
import edu.stanford.smi.protege.model.SimpleInstance;
import edu.stanford.smi.protege.model.Slot;
import edu.stanford.smi.protege.model.framestore.FrameStore;
import edu.stanford.smi.protege.model.framestore.ModificationFrameStore;
import edu.stanford.smi.protege.util.ApplicationProperties;
import edu.stanford.smi.protege.util.StandardDateFormat;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.Set;

public class ModificationRecordFrameStore
extends ModificationFrameStore {
    private Collection _authors = Collections.singleton(ApplicationProperties.getUserName());
    private Slot _creationAuthorSlot;
    private Slot _creationTimestampSlot;
    private Slot _modificationAuthorSlot;
    private Slot _modificationTimestampSlot;

    public void setAuthor(String string) {
        this._authors = Collections.singleton(string);
    }

    public void reinitialize() {
    }

    public void close() {
        this._authors = null;
        this._creationAuthorSlot = null;
        this._creationTimestampSlot = null;
        this._modificationAuthorSlot = null;
        this._modificationTimestampSlot = null;
    }

    public void onSetDelegate() {
        FrameStore frameStore = this.getDelegate();
        if (frameStore != null) {
            this._creationAuthorSlot = (Slot)frameStore.getFrame(":CREATOR");
            this._creationTimestampSlot = (Slot)frameStore.getFrame(":CREATION-TIMESTAMP");
            this._modificationAuthorSlot = (Slot)frameStore.getFrame(":MODIFIER");
            this._modificationTimestampSlot = (Slot)frameStore.getFrame(":MODIFICATION-TIMESTAMP");
        }
    }

    private void updateCreationRecord(Frame frame) {
        this.updateFrameRecord(frame, this._creationAuthorSlot, this._creationTimestampSlot);
    }

    private void updateModificationRecord(Frame frame) {
        this.updateFrameRecord(frame, this._modificationAuthorSlot, this._modificationTimestampSlot);
    }

    private void updateDeletionRecord(Frame frame) {
    }

    private void updateFrameRecord(Frame frame, Slot slot, Slot slot2) {
        if (frame.hasOwnSlot(slot)) {
            this.getDelegate().setDirectOwnSlotValues(frame, slot, this._authors);
        }
        if (frame.hasOwnSlot(slot2)) {
            String string = new StandardDateFormat().format(new Date());
            Set<String> set = Collections.singleton(string);
            this.getDelegate().setDirectOwnSlotValues(frame, slot2, set);
        }
    }

    public Cls createCls(FrameID frameID, Collection collection, Collection collection2, boolean bl) {
        Cls cls = this.getDelegate().createCls(frameID, collection, collection2, bl);
        this.updateCreationRecord(cls);
        return cls;
    }

    public Slot createSlot(FrameID frameID, Collection collection, Collection collection2, boolean bl) {
        Slot slot = this.getDelegate().createSlot(frameID, collection, collection2, bl);
        this.updateCreationRecord(slot);
        return slot;
    }

    public Facet createFacet(FrameID frameID, Collection collection, boolean bl) {
        Facet facet = this.getDelegate().createFacet(frameID, collection, bl);
        this.updateCreationRecord(facet);
        return facet;
    }

    public SimpleInstance createSimpleInstance(FrameID frameID, Collection collection, boolean bl) {
        SimpleInstance simpleInstance = this.getDelegate().createSimpleInstance(frameID, collection, bl);
        this.updateCreationRecord(simpleInstance);
        return simpleInstance;
    }

    public void deleteCls(Cls cls) {
        this.updateDeletionRecord(cls);
        this.getDelegate().deleteCls(cls);
    }

    public void deleteSlot(Slot slot) {
        this.updateDeletionRecord(slot);
        this.getDelegate().deleteSlot(slot);
    }

    public void deleteFacet(Facet facet) {
        this.updateDeletionRecord(facet);
        this.getDelegate().deleteFacet(facet);
    }

    public void deleteSimpleInstance(SimpleInstance simpleInstance) {
        this.updateDeletionRecord(simpleInstance);
        this.getDelegate().deleteSimpleInstance(simpleInstance);
    }

    public void moveDirectOwnSlotValue(Frame frame, Slot slot, int n, int n2) {
        this.getDelegate().moveDirectOwnSlotValue(frame, slot, n, n2);
        this.updateModificationRecord(frame);
    }

    public void setDirectOwnSlotValues(Frame frame, Slot slot, Collection collection) {
        this.getDelegate().setDirectOwnSlotValues(frame, slot, collection);
        this.updateModificationRecord(frame);
    }

    public void addDirectTemplateSlot(Cls cls, Slot slot) {
        this.getDelegate().addDirectTemplateSlot(cls, slot);
        this.updateModificationRecord(cls);
    }

    public void removeDirectTemplateSlot(Cls cls, Slot slot) {
        this.getDelegate().removeDirectTemplateSlot(cls, slot);
        this.updateModificationRecord(cls);
    }

    public void moveDirectTemplateSlot(Cls cls, Slot slot, int n) {
        this.getDelegate().moveDirectTemplateSlot(cls, slot, n);
        this.updateModificationRecord(cls);
    }

    public void setDirectTemplateSlotValues(Cls cls, Slot slot, Collection collection) {
        this.getDelegate().setDirectTemplateSlotValues(cls, slot, collection);
        this.updateModificationRecord(cls);
    }

    public void removeDirectTemplateFacetOverrides(Cls cls, Slot slot) {
        this.getDelegate().removeDirectTemplateFacetOverrides(cls, slot);
        this.updateModificationRecord(cls);
    }

    public void setDirectTemplateFacetValues(Cls cls, Slot slot, Facet facet, Collection collection) {
        this.getDelegate().setDirectTemplateFacetValues(cls, slot, facet, collection);
        this.updateModificationRecord(cls);
    }

    public void addDirectSuperclass(Cls cls, Cls cls2) {
        this.getDelegate().addDirectSuperclass(cls, cls2);
        this.updateModificationRecord(cls);
    }

    public void removeDirectSuperclass(Cls cls, Cls cls2) {
        this.getDelegate().removeDirectSuperclass(cls, cls2);
        this.updateModificationRecord(cls);
    }

    public void moveDirectSubclass(Cls cls, Cls cls2, int n) {
        this.getDelegate().moveDirectSubclass(cls, cls2, n);
        this.updateModificationRecord(cls);
    }

    public void moveDirectSubslot(Slot slot, Slot slot2, int n) {
        this.getDelegate().moveDirectSubslot(slot, slot2, n);
        this.updateModificationRecord(slot);
    }

    public void addDirectSuperslot(Slot slot, Slot slot2) {
        this.getDelegate().addDirectSuperslot(slot, slot2);
        this.updateModificationRecord(slot);
    }

    public void removeDirectSuperslot(Slot slot, Slot slot2) {
        this.getDelegate().removeDirectSuperslot(slot, slot2);
        this.updateModificationRecord(slot);
    }

    public void addDirectType(Instance instance, Cls cls) {
        this.getDelegate().addDirectType(instance, cls);
        this.updateModificationRecord(instance);
    }

    public void removeDirectType(Instance instance, Cls cls) {
        this.getDelegate().removeDirectType(instance, cls);
        this.updateModificationRecord(instance);
    }

    public void moveDirectType(Instance instance, Cls cls, int n) {
        this.getDelegate().moveDirectType(instance, cls, n);
        this.updateModificationRecord(instance);
    }

    public boolean beginTransaction(String string) {
        return this.getDelegate().beginTransaction(string);
    }

    public boolean commitTransaction() {
        return this.getDelegate().commitTransaction();
    }

    public boolean rollbackTransaction() {
        return this.getDelegate().rollbackTransaction();
    }

    public void replaceFrame(Frame frame, Frame frame2) {
        this.getDelegate().replaceFrame(frame, frame2);
        this.updateDeletionRecord(frame);
        this.updateCreationRecord(frame2);
    }
}

