/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protege.server.admin;

import edu.stanford.smi.protege.resource.Icons;
import edu.stanford.smi.protege.server.RemoteServer;
import edu.stanford.smi.protege.server.RemoteSession;
import edu.stanford.smi.protege.server.Session;
import edu.stanford.smi.protege.server.admin.AbstractRefreshableServerPanel;
import edu.stanford.smi.protege.server.job.GetProjectsForSessionJob;
import edu.stanford.smi.protege.server.job.GetSessionsJob;
import edu.stanford.smi.protege.server.metaproject.MetaProjectConstants;
import edu.stanford.smi.protege.server.util.RemoteProjectUtil;
import edu.stanford.smi.protege.util.AllowableAction;
import edu.stanford.smi.protege.util.ComponentFactory;
import edu.stanford.smi.protege.util.LabeledComponent;
import edu.stanford.smi.protege.util.Log;
import edu.stanford.smi.protege.util.ModalDialog;
import edu.stanford.smi.protege.util.Selectable;
import edu.stanford.smi.protege.util.SelectableTable;
import edu.stanford.smi.protege.util.ViewAction;
import java.awt.event.ActionEvent;
import java.rmi.RemoteException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.logging.Level;
import javax.swing.JComponent;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableModel;

public class SessionServerPanel
extends AbstractRefreshableServerPanel {
    private static final long serialVersionUID = 8567269732489128636L;
    private static final String UNKNOWN_ENTRY = "(unknown)";
    private static final String NO_PROJECT = "(none)";
    private static SimpleDateFormat dateFormat = new SimpleDateFormat("HH:mm:ss, yyyy.MM.dd");
    private DefaultTableModel tableModel;
    private List<RemoteSession> remoteSessions;
    private AllowableAction killSessionAction;

    public SessionServerPanel(RemoteServer remoteServer, RemoteSession remoteSession) {
        super(remoteServer, remoteSession);
    }

    protected JComponent createCenterComponent() {
        this.remoteSessions = new ArrayList<RemoteSession>();
        SelectableTable selectableTable = ComponentFactory.createSelectableTable(null);
        selectableTable.setAutoCreateColumnsFromModel(true);
        selectableTable.setModel(this.createTableModel());
        LabeledComponent labeledComponent = new LabeledComponent("Live sessions", new JScrollPane(selectableTable), true);
        labeledComponent.addHeaderButton(this.getViewAction(selectableTable));
        labeledComponent.addHeaderButton(this.getKillSessionAction(selectableTable));
        return labeledComponent;
    }

    private TableModel createTableModel() {
        this.tableModel = new DefaultTableModel();
        this.tableModel.addColumn("Id");
        this.tableModel.addColumn("User name");
        this.tableModel.addColumn("User IP");
        this.tableModel.addColumn("Project");
        this.tableModel.addColumn("Login time");
        this.fillTableModel();
        return this.tableModel;
    }

    private void fillTableModel() {
        this.tableModel.setRowCount(0);
        this.remoteSessions.clear();
        RemoteSession remoteSession = this.getSession();
        try {
            Collection collection = (Collection)new GetSessionsJob(this.getServer(), remoteSession).execute();
            for (RemoteSession remoteSession2 : collection) {
                this.remoteSessions.add(remoteSession2);
                ArrayList<String> arrayList = (ArrayList<String>)new GetProjectsForSessionJob(this.getServer(), remoteSession, remoteSession2).execute();
                if (arrayList.size() == 0) {
                    arrayList = new ArrayList<String>();
                    arrayList.add(NO_PROJECT);
                }
                String string = UNKNOWN_ENTRY;
                String string2 = UNKNOWN_ENTRY;
                if (remoteSession2 instanceof Session) {
                    Date date = new Date(((Session)remoteSession2).getStartTime());
                    string = dateFormat.format(date);
                    string2 = Integer.toString(((Session)remoteSession2).getId());
                    if (remoteSession2.equals(remoteSession)) {
                        string2 = "*" + string2;
                    }
                }
                this.tableModel.addRow(new Object[]{string2, remoteSession2.getUserName(), remoteSession2.getUserIpAddress(), arrayList, string});
            }
        }
        catch (Exception exception) {
            Log.getLogger().log(Level.WARNING, "Could not get remote sessions from server.", exception);
            this.treatPossibleConnectionLostException(exception);
        }
    }

    private AllowableAction getKillSessionAction(final SelectableTable selectableTable) {
        this.killSessionAction = new AllowableAction("Kill session(s)", Icons.getCancelIcon(), selectableTable){

            public void actionPerformed(ActionEvent actionEvent) {
                int n = JOptionPane.showConfirmDialog(SessionServerPanel.this, "Kill selected session(s)?\nUsers may lose work as a result of this action.", "Confirm Kill Sessions", 2);
                if (n == 0) {
                    int[] nArray = selectableTable.getSelectedRows();
                    for (int i = 0; i < nArray.length; ++i) {
                        RemoteSession remoteSession = (RemoteSession)SessionServerPanel.this.remoteSessions.get(nArray[i]);
                        try {
                            SessionServerPanel.this.getServer().killOtherUserSession(remoteSession, SessionServerPanel.this.getSession(), 10);
                            continue;
                        }
                        catch (RemoteException remoteException) {
                            Log.getLogger().log(Level.WARNING, "Could not kill session " + remoteSession, remoteException);
                            ModalDialog.showMessageDialog(SessionServerPanel.this, "Could not kill session " + remoteSession + ".\n" + "See console and logs for more information.");
                            SessionServerPanel.this.treatPossibleConnectionLostException(remoteException);
                        }
                    }
                    SessionServerPanel.this.refresh();
                }
            }

            public void onSelectionChange() {
                int[] nArray = selectableTable.getSelectedRows();
                if (nArray == null || nArray.length <= 0) {
                    this.setAllowed(false);
                    return;
                }
                for (int i = 0; i < nArray.length; ++i) {
                    RemoteSession remoteSession = (RemoteSession)SessionServerPanel.this.remoteSessions.get(nArray[i]);
                    if (SessionServerPanel.this.isKillAllowed(remoteSession)) continue;
                    this.setAllowed(false);
                    return;
                }
                this.setAllowed(true);
            }
        };
        return this.killSessionAction;
    }

    private AllowableAction getViewAction(final SelectableTable selectableTable) {
        return new ViewAction((Selectable)selectableTable){

            public void onView() {
                int n = selectableTable.getSelectedRow();
                ComponentFactory.showTableRowInDialog(selectableTable.getModel(), n, SessionServerPanel.this);
            }
        };
    }

    public void refresh() {
        try {
            this.fillTableModel();
            this.tableModel.fireTableDataChanged();
        }
        catch (Throwable throwable) {
            this.treatPossibleConnectionLostException(throwable);
        }
    }

    private boolean isKillAllowed(RemoteSession remoteSession) {
        if (remoteSession.equals(this.getSession())) {
            return false;
        }
        int n = this.remoteSessions.indexOf(remoteSession);
        if (n < 0) {
            return false;
        }
        if (RemoteProjectUtil.isServerOperationAllowed(this.getServer(), this.getSession(), MetaProjectConstants.OPERATION_ADMINISTER_SERVER)) {
            return true;
        }
        if (!RemoteProjectUtil.isServerOperationAllowed(this.getServer(), this.getSession(), MetaProjectConstants.OPERATION_KILL_OTHER_USER_SESSION)) {
            return false;
        }
        Collection collection = (Collection)this.tableModel.getValueAt(n, 3);
        for (String string : collection) {
            if (string.equals(NO_PROJECT) || RemoteProjectUtil.isOperationAllowed(this.getServer(), this.getSession(), string, MetaProjectConstants.OPERATION_KILL_OTHER_USER_SESSION)) continue;
            return false;
        }
        return true;
    }
}

