/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protege.server.framestore;

import edu.stanford.smi.protege.util.ApplicationProperties;
import edu.stanford.smi.protege.util.Log;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

public class BandWidthPolicy {
    private static transient Logger log = Log.getLogger(BandWidthPolicy.class);
    public static final String BANDWIDTH_CAP_PROPERTY = "edu.stanford.smi.protege.server.max_value_update_rate";
    private long samplingInterval = 1000L;
    private int surgeCap;
    private int bandwidthCap;
    private int itemsWaitingToSend = 0;
    private List<SentItems> itemsSent = new ArrayList<SentItems>();

    public BandWidthPolicy() {
        this(BandWidthPolicy.getCap(), BandWidthPolicy.getCap());
    }

    public BandWidthPolicy(int n, int n2) {
        this.surgeCap = n;
        this.bandwidthCap = n2;
    }

    public static int getCap() {
        return ApplicationProperties.getIntegerProperty(BANDWIDTH_CAP_PROPERTY, 7000);
    }

    public synchronized void addItemToWaitList() {
        ++this.itemsWaitingToSend;
    }

    public synchronized void addItemsSent(int n) {
        this.itemsSent.add(new SentItems(n));
        this.itemsWaitingToSend = 0;
    }

    public synchronized boolean stopSending() {
        if (this.itemsWaitingToSend > this.surgeCap) {
            if (log.isLoggable(Level.FINE)) {
                log.fine("throttling back because we already have " + this.itemsWaitingToSend + " items to send.");
            }
            return true;
        }
        long l = System.currentTimeMillis();
        ArrayList<SentItems> arrayList = new ArrayList<SentItems>();
        int n = this.itemsWaitingToSend;
        for (SentItems sentItems : this.itemsSent) {
            if (sentItems.whenInMillis < l - this.samplingInterval) {
                arrayList.add(sentItems);
                continue;
            }
            n += sentItems.count;
        }
        this.itemsSent.removeAll(arrayList);
        if (log.isLoggable(Level.FINE) && n > this.bandwidthCap) {
            log.fine("Throttling back because we have " + this.itemsWaitingToSend + " items to send and we have recently sent the follwing");
            for (SentItems sentItems : this.itemsSent) {
                log.fine("\t" + sentItems.count + " items");
            }
        }
        return n > this.bandwidthCap;
    }

    private static class SentItems {
        long whenInMillis;
        int count;

        public SentItems(int n) {
            this.count = n;
            this.whenInMillis = System.currentTimeMillis();
        }
    }
}

